/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.PagesIndex;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.window.PagesWindowIndex;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDoubleSumAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        double sum = 0.0;
        for (int i = start; i < start + length; ++i) {
            sum += (double)i;
        }
        return sum;
    }

    @Override
    protected String getFunctionName() {
        return "sum";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)DoubleType.DOUBLE);
    }

    protected static Block[] getSequenceBlocksForDoubleNaNTest(int start, int length) {
        int i;
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, length);
        for (i = start; i < start + length - 5; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        DoubleType.DOUBLE.writeDouble(blockBuilder, Double.NaN);
        for (i = start + length - 4; i < start + length; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    protected static Block[] getSequenceBlocksForDoubleInfinityTest(int start, int length) {
        int i;
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, length);
        for (i = start; i < start + length - 5; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        DoubleType.DOUBLE.writeDouble(blockBuilder, Double.POSITIVE_INFINITY);
        for (i = start + length - 4; i < start + length; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Test
    public void testSlidingWindowForNaNAndInfinity() {
        int totalPositions = 12;
        int[] windowWidths = new int[totalPositions];
        Object[] expectedValues = new Object[totalPositions];
        Object[] expectedValues2 = new Object[totalPositions];
        for (int i = 0; i < totalPositions; ++i) {
            int windowWidth;
            windowWidths[i] = windowWidth = Integer.min(i, totalPositions - 1 - i);
            if (i >= 4) {
                expectedValues[i] = Double.NaN;
                expectedValues2[i] = Double.POSITIVE_INFINITY;
                continue;
            }
            expectedValues[i] = this.getExpectedValue(i, windowWidth);
            expectedValues2[i] = this.getExpectedValue(i, windowWidth);
        }
        Page inputPage = new Page(totalPositions, TestDoubleSumAggregation.getSequenceBlocksForDoubleNaNTest(0, totalPositions));
        PagesIndex pagesIndex = new PagesIndex.TestingFactory(false).newPagesIndex(this.getFunctionParameterTypes(), totalPositions);
        pagesIndex.addPage(inputPage);
        PagesWindowIndex windowIndex = new PagesWindowIndex(pagesIndex, 0, totalPositions - 1);
        ResolvedFunction resolvedFunction = this.functionResolution.resolveFunction(this.getFunctionName(), TypeSignatureProvider.fromTypes(this.getFunctionParameterTypes()));
        AggregationImplementation aggregationImplementation = this.functionResolution.getPlannerContext().getFunctionManager().getAggregationImplementation(resolvedFunction);
        WindowAccumulator aggregation = TestDoubleSumAggregation.createWindowAccumulator(resolvedFunction, aggregationImplementation);
        Assertions.assertThat((boolean)resolvedFunction.signature().getReturnType().toString().contains("double")).isTrue();
        Assertions.assertThat((boolean)resolvedFunction.signature().getName().toString().contains("sum")).isTrue();
        int oldStart = 0;
        int oldWidth = 0;
        for (int start = 0; start < totalPositions; ++start) {
            int width = windowWidths[start];
            for (int oldi = oldStart; oldi < oldStart + oldWidth; ++oldi) {
                if (oldi >= start && oldi < start + width) continue;
                boolean res = aggregation.removeInput((WindowIndex)windowIndex, oldi, oldi);
                if (oldi >= 4) {
                    Assertions.assertThat((boolean)res).isFalse();
                    continue;
                }
                Assertions.assertThat((boolean)res).isTrue();
            }
            for (int newi = start; newi < start + width; ++newi) {
                if (newi >= oldStart && newi < oldStart + oldWidth) continue;
                aggregation.addInput((WindowIndex)windowIndex, newi, newi);
            }
            oldStart = start;
            oldWidth = width;
            Type outputType = resolvedFunction.signature().getReturnType();
            BlockBuilder blockBuilder = outputType.createBlockBuilder(null, 1000);
            aggregation.output(blockBuilder);
            Block block = blockBuilder.build();
            Assertions.assertThat((Boolean)AggregationTestUtils.makeValidityAssertion(expectedValues[start]).apply(BlockAssertions.getOnlyValue(outputType, block), expectedValues[start])).isTrue();
        }
        Page inputPage2 = new Page(totalPositions, TestDoubleSumAggregation.getSequenceBlocksForDoubleInfinityTest(0, totalPositions));
        PagesIndex pagesIndex2 = new PagesIndex.TestingFactory(false).newPagesIndex(this.getFunctionParameterTypes(), totalPositions);
        pagesIndex2.addPage(inputPage2);
        PagesWindowIndex windowIndex2 = new PagesWindowIndex(pagesIndex2, 0, totalPositions - 1);
        WindowAccumulator aggregation2 = TestDoubleSumAggregation.createWindowAccumulator(resolvedFunction, aggregationImplementation);
        oldStart = 0;
        oldWidth = 0;
        for (int start = 0; start < totalPositions; ++start) {
            int width = windowWidths[start];
            for (int oldi = oldStart; oldi < oldStart + oldWidth; ++oldi) {
                if (oldi >= start && oldi < start + width) continue;
                boolean res = aggregation2.removeInput((WindowIndex)windowIndex2, oldi, oldi);
                if (oldi >= 4) {
                    Assertions.assertThat((boolean)res).isFalse();
                    continue;
                }
                Assertions.assertThat((boolean)res).isTrue();
            }
            for (int newi = start; newi < start + width; ++newi) {
                if (newi >= oldStart && newi < oldStart + oldWidth) continue;
                aggregation2.addInput((WindowIndex)windowIndex2, newi, newi);
            }
            oldStart = start;
            oldWidth = width;
            Type outputType = resolvedFunction.signature().getReturnType();
            BlockBuilder blockBuilder = outputType.createBlockBuilder(null, 1000);
            aggregation2.output(blockBuilder);
            Block block = blockBuilder.build();
            Assertions.assertThat((Boolean)AggregationTestUtils.makeValidityAssertion(expectedValues2[start]).apply(BlockAssertions.getOnlyValue(outputType, block), expectedValues2[start])).isTrue();
        }
    }
}

