/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.testing;

import com.google.inject.Key;
import io.trino.connector.CatalogManagerConfig;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.CoordinatorDynamicCatalogManager;
import io.trino.connector.InMemoryCatalogStore;
import io.trino.connector.StaticCatalogManager;
import io.trino.connector.WorkerDynamicCatalogManager;
import io.trino.metadata.CatalogManager;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.catalog.CatalogStore;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TestTestingTrinoServer {
    TestTestingTrinoServer() {
    }

    @Test
    void testDefaultCatalogManagementForCoordinator() throws IOException {
        try (TestingTrinoServer server = TestingTrinoServer.builder().build();){
            Assertions.assertThat((Object)((CatalogManager)server.getInstance(Key.get(CatalogManager.class)))).isInstanceOf(CoordinatorDynamicCatalogManager.class);
            Assertions.assertThat((Object)((CatalogStore)server.getInstance(Key.get(CatalogStore.class)))).isInstanceOf(InMemoryCatalogStore.class);
        }
    }

    @Test
    void testDefaultCatalogManagementForWorker() throws IOException {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setCoordinator(false).build();){
            Assertions.assertThat((Object)((ConnectorServicesProvider)server.getInstance(Key.get(ConnectorServicesProvider.class)))).isInstanceOf(WorkerDynamicCatalogManager.class);
        }
    }

    @Test
    void testSetCatalogManagementToStatic() throws IOException {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setCatalogMangerKind(CatalogManagerConfig.CatalogMangerKind.STATIC).build();){
            Assertions.assertThat((Object)((CatalogManager)server.getInstance(Key.get(CatalogManager.class)))).isInstanceOf(StaticCatalogManager.class);
        }
    }
}

