/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.optimizer.rule.EvaluateCast;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvaluateCast {
    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, null), (Type)BigintType.BIGINT))).isEqualTo(Optional.of(new Constant((Type)BigintType.BIGINT, null)));
        Assertions.assertThat(this.optimize((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)VarcharType.VARCHAR))).isEqualTo(Optional.of(new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1"))));
        Assertions.assertThat(this.optimize((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)VarcharType.VARCHAR))).isEqualTo(Optional.of(new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1"))));
        Assertions.assertThat(this.optimize((Expression)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc")), (Type)BigintType.BIGINT))).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateCast(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

