/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import io.trino.type.FunctionType;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeterminismEvaluator {
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();

    @Test
    public void testSanity() {
        Assertions.assertThat((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("rand"))).isFalse();
        Assertions.assertThat((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("random"))).isFalse();
        Assertions.assertThat((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("shuffle", (List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Expression>)ImmutableList.of((Object)new Constant((Type)new ArrayType((Type)VarcharType.VARCHAR), null))))).isFalse();
        Assertions.assertThat((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("uuid"))).isFalse();
        Assertions.assertThat((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "symbol"))))).isTrue();
        Assertions.assertThat((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)this.function("rand"))))).isFalse();
        Assertions.assertThat((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "symbol"))))))).isTrue();
        Assertions.assertThat((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("filter", (List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)BooleanType.BOOLEAN)), (List<Expression>)ImmutableList.of((Object)new Constant((Type)new ArrayType((Type)IntegerType.INTEGER), null), (Object)TestDeterminismEvaluator.lambda(new Symbol((Type)IntegerType.INTEGER, "a"), (Expression)TestDeterminismEvaluator.comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))))).isTrue();
        Assertions.assertThat((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("filter", (List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)BooleanType.BOOLEAN)), (List<Expression>)ImmutableList.of((Object)new Constant((Type)new ArrayType((Type)IntegerType.INTEGER), null), (Object)TestDeterminismEvaluator.lambda(new Symbol((Type)IntegerType.INTEGER, "a"), (Expression)TestDeterminismEvaluator.comparison(Comparison.Operator.GREATER_THAN, (Expression)this.function("rand", (List<Type>)ImmutableList.of((Object)IntegerType.INTEGER), (List<Expression>)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))))).isFalse();
    }

    private Call function(String name) {
        return this.function(name, (List<Type>)ImmutableList.of(), (List<Expression>)ImmutableList.of());
    }

    private Call function(String name, List<Type> types, List<Expression> arguments) {
        return this.functionResolution.functionCallBuilder(name).setArguments(types, arguments).build();
    }

    private static Comparison comparison(Comparison.Operator operator, Expression left, Expression right) {
        return new Comparison(operator, left, right);
    }

    private static Lambda lambda(Symbol symbol, Expression body) {
        return new Lambda((List)ImmutableList.of((Object)symbol), body);
    }
}

