/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.execution.TaskManagerConfig;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.AddExchangesBelowPartialAggregationOverGroupIdRuleSet;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.RuleAssert;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestAddExchangesBelowPartialAggregationOverGroupIdRuleSet
extends BaseRuleTest {
    public TestAddExchangesBelowPartialAggregationOverGroupIdRuleSet() {
        super(new Plugin[0]);
    }

    @Test
    public void testAddExchangesWithoutProjection() {
        this.testAddExchangesWithoutProjection(1000.0, 10000.0, 1000000.0, (Set<String>)ImmutableSet.of((Object)"groupingKey3"));
        this.testAddExchangesWithoutProjection(1000.0, 1000.0, 1000.0, (Set<String>)ImmutableSet.of((Object)"groupingKey1"));
        this.testAddExchangesWithoutProjection(1000.0, 10000.0, Double.NaN, (Set<String>)ImmutableSet.of());
        this.testAddExchangesWithoutProjection(1000.0, Double.NaN, 10000.0, (Set<String>)ImmutableSet.of());
        this.testAddExchangesWithoutProjection(1000.0, 10000.0, Double.NaN, (Set<String>)ImmutableSet.of());
    }

    private void testAddExchangesWithoutProjection(double groupingKey1NDV, double groupingKey2NDV, double groupingKey3NDV, Set<String> partitionedBy) {
        RuleTester ruleTester = this.tester();
        String groupIdSourceId = "groupIdSourceId";
        RuleAssert ruleAssert = ruleTester.assertThat((Rule<?>)TestAddExchangesBelowPartialAggregationOverGroupIdRuleSet.belowExchangeRule(ruleTester)).overrideStats(groupIdSourceId, PlanNodeStatsEstimate.builder().setOutputRowCount(1.0E8).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "groupingKey1"), (Object)SymbolStatsEstimate.builder().setDistinctValuesCount(groupingKey1NDV).build(), (Object)new Symbol((Type)BigintType.BIGINT, "groupingKey2"), (Object)SymbolStatsEstimate.builder().setDistinctValuesCount(groupingKey2NDV).build(), (Object)new Symbol((Type)BigintType.BIGINT, "groupingKey3"), (Object)SymbolStatsEstimate.builder().setDistinctValuesCount(groupingKey3NDV).build())).build()).on(p -> {
            Symbol groupingKey1 = p.symbol("groupingKey1", (Type)BigintType.BIGINT);
            Symbol groupingKey2 = p.symbol("groupingKey2", (Type)BigintType.BIGINT);
            Symbol groupingKey3 = p.symbol("groupingKey3", (Type)BigintType.BIGINT);
            Symbol groupId = p.symbol("groupId", (Type)BigintType.BIGINT);
            return p.exchange(exchangeBuilder -> exchangeBuilder.scope(ExchangeNode.Scope.REMOTE).fixedArbitraryDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)groupingKey1, (Object)groupingKey2, (Object)groupingKey3, (Object)groupId), 2).addInputsSet(groupingKey1, groupingKey2, groupingKey3, groupId).addSource((PlanNode)p.aggregation(builder -> builder.singleGroupingSet(groupingKey1, groupingKey2, groupingKey3, groupId).step(AggregationNode.Step.PARTIAL).source((PlanNode)p.groupId((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)groupingKey1, (Object)groupingKey2), (Object)ImmutableList.of((Object)groupingKey1, (Object)groupingKey3)), (List<Symbol>)ImmutableList.of(), groupId, (PlanNode)p.values(new PlanNodeId(groupIdSourceId), groupingKey1, groupingKey2, groupingKey3))))));
        });
        if (partitionedBy.isEmpty()) {
            ruleAssert.doesNotFire();
        } else {
            ruleAssert.matches(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet((List<String>)ImmutableList.of((Object)"groupingKey1", (Object)"groupingKey2", (Object)"groupingKey3", (Object)"groupId")), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"groupingKey1", (Object)"groupingKey3")), "groupId", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), partitionedBy, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), partitionedBy, PlanMatchPattern.values("groupingKey1", "groupingKey2", "groupingKey3")))))));
        }
    }

    private static AddExchangesBelowPartialAggregationOverGroupIdRuleSet.AddExchangesBelowExchangePartialAggregationGroupId belowExchangeRule(RuleTester ruleTester) {
        return new AddExchangesBelowPartialAggregationOverGroupIdRuleSet(ruleTester.getPlannerContext(), ruleTester.getPlanTester().getTaskCountEstimator(), new TaskManagerConfig()).belowExchangeRule();
    }
}

