/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushFilterThroughBoolOrAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushFilterThroughBoolOrAggregation
extends BaseRuleTest {
    public TestPushFilterThroughBoolOrAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireWithNonGroupedAggregation() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)aggrBool.toSymbolReference(), (Expression)Booleans.TRUE), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), bool).source((PlanNode)p.values(g, bool))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithMultipleAggregations() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            Symbol avg = p.symbol("avg", (Type)BigintType.BIGINT);
            return p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)aggrBool.toSymbolReference(), (Expression)Booleans.TRUE), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), bool).addAggregation(avg, PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)g.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(g, bool))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoAggregations() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)Booleans.TRUE, (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).source((PlanNode)p.values(g, bool))));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            return p.filter((Expression)Booleans.TRUE, (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).source((PlanNode)p.values(g))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoBoolOrAggregation() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol avg = p.symbol("avg", (Type)DoubleType.DOUBLE);
            return p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)avg.toSymbolReference(), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(avg, PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)g.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(g, bool))));
        }).doesNotFire();
    }

    @Test
    public void testFilterPredicateFalse() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)aggrBool.toSymbolReference(), (Expression)Booleans.TRUE), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)aggrBool.toSymbolReference(), (Expression)Booleans.FALSE))), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool))));
        }).matches(PlanMatchPattern.values("g", "aggrbool"));
    }

    @Test
    public void testDoesNotFireWhenFilterPredicateTrue() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)Booleans.TRUE, (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenFilterPredicateCoalesceWithOtherSymbol() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol other = p.symbol("other", (Type)BooleanType.BOOLEAN);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Coalesce((Expression)other.toSymbolReference(), (Expression)Booleans.TRUE, new Expression[]{Booleans.FALSE}), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenFilterPredicateNotCoalesce() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter(IrExpressions.not((Metadata)this.tester().getMetadata(), (Expression)new Coalesce((Expression)aggrBool.toSymbolReference(), (Expression)Booleans.TRUE, new Expression[0])), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool))));
        }).doesNotFire();
    }

    @Test
    public void testPushDownSymbolAndRemoveFilter() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Coalesce((Expression)aggrBool.toSymbolReference(), (Expression)Booleans.TRUE, new Expression[0]), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g, bool).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool))));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Coalesce((Expression)aggrBool.toSymbolReference(), (Expression)Booleans.FALSE, new Expression[0]), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g, bool).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"g", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "g")), (Object)"bool", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool")), (Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("g", "bool"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool"), PlanMatchPattern.values("g", "bool")))));
    }

    @Test
    public void testPushDownSymbolAndSimplifyFilter() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)aggrBool.toSymbolReference(), (Expression)Booleans.TRUE), (Object)new Coalesce((Expression)aggrBool.toSymbolReference(), (Expression)Booleans.FALSE, new Expression[0]))), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g, bool).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"g", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "g")), (Object)"bool", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool")), (Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("g", "bool"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool"), PlanMatchPattern.values("g", "bool")))));
    }

    @Test
    public void testPushDownSymbolAndRetainFilter() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)g.toSymbolReference(), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Object)new Coalesce((Expression)aggrBool.toSymbolReference(), (Expression)Booleans.FALSE, new Expression[0]))), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g, bool).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool))));
        }).matches(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "g"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"g", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "g")), (Object)"bool", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool")), (Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("g", "bool"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool"), PlanMatchPattern.values("g", "bool"))))));
    }

    @Test
    public void testWithProject() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)aggrBool.toSymbolReference(), (Expression)Booleans.TRUE), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{aggrBool}), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool)))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BooleanType.BOOLEAN, "aggrbool"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"g", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "g")), (Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool"), PlanMatchPattern.values("g", "bool"))))));
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)aggrBool.toSymbolReference(), (Expression)Booleans.TRUE), (Object)new Coalesce((Expression)aggrBool.toSymbolReference(), (Expression)Booleans.FALSE, new Expression[0]))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{aggrBool, g}), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool)))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BooleanType.BOOLEAN, "aggrbool"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"g", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "g")), (Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool"), PlanMatchPattern.values("g", "bool"))))));
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)g.toSymbolReference(), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Object)new Coalesce((Expression)aggrBool.toSymbolReference(), (Expression)Booleans.FALSE, new Expression[0]))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{aggrBool, g}), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool)))));
        }).matches(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "g"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BooleanType.BOOLEAN, "aggrbool")), (Object)"g", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "g"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"g", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "g")), (Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool"), PlanMatchPattern.values("g", "bool")))))));
    }

    @Test
    public void testFilterAggregation() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughBoolOrAggregation.PushFilterThroughBoolOrAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g", (Type)BigintType.BIGINT);
            Symbol bool = p.symbol("bool", (Type)BooleanType.BOOLEAN);
            Symbol aggrBool = p.symbol("aggrbool", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)aggrBool.toSymbolReference(), (Expression)Booleans.TRUE), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(aggrBool, PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)bool.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).source((PlanNode)p.values(g, bool))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"g", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "g")), (Object)"aggrbool", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("g"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "bool"), PlanMatchPattern.values("g", "bool")))));
    }
}

