/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.type.AbstractTestType;
import io.trino.type.InternalTypeManager;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSmallintArrayType
extends AbstractTestType {
    public TestSmallintArrayType() {
        super(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)SmallintType.SMALLINT.getTypeSignature())), List.class, TestSmallintArrayType.createTestBlock(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)SmallintType.SMALLINT.getTypeSignature()))));
    }

    public static ValueBlock createTestBlock(Type arrayType) {
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 4);
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)SmallintType.SMALLINT, 1, 2));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)SmallintType.SMALLINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)SmallintType.SMALLINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)SmallintType.SMALLINT, 100, 200, 300));
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Block block = (Block)value;
        BlockBuilder blockBuilder = SmallintType.SMALLINT.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            SmallintType.SMALLINT.appendTo(block, i, blockBuilder);
        }
        SmallintType.SMALLINT.writeLong(blockBuilder, 1L);
        return blockBuilder.buildValueBlock();
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

