/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.OperatorContext;
import io.trino.operator.PageUtils;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorSourceOperator;
import io.trino.operator.WorkProcessorSourceOperatorAdapter;
import io.trino.operator.WorkProcessorSourceOperatorFactory;
import io.trino.operator.project.CursorProcessor;
import io.trino.operator.project.CursorProcessorOutput;
import io.trino.operator.project.MergePages;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.PageProcessorMetrics;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.type.Type;
import io.trino.split.EmptySplit;
import io.trino.split.PageSourceProvider;
import io.trino.split.PageSourceProviderFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ScanFilterAndProjectOperator
implements WorkProcessorSourceOperator {
    private final WorkProcessor<Page> pages;
    private final PageProcessorMetrics pageProcessorMetrics = new PageProcessorMetrics();
    @Nullable
    private RecordCursor cursor;
    @Nullable
    private ConnectorPageSource pageSource;
    private long processedPositions;
    private long processedBytes;
    private long physicalBytes;
    private long physicalPositions;
    private long readTimeNanos;
    private long dynamicFilterSplitsProcessed;
    private Metrics metrics = Metrics.EMPTY;

    private ScanFilterAndProjectOperator(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Split> split, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, DynamicFilter dynamicFilter, Iterable<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount) {
        this.pages = split.flatTransform(new SplitToPages(session, yieldSignal, pageSourceProvider, cursorProcessor, pageProcessor, table, columns, dynamicFilter, types, memoryTrackingContext.aggregateUserMemoryContext(), minOutputPageSize, minOutputPageRowCount));
    }

    @Override
    public DataSize getPhysicalInputDataSize() {
        return DataSize.ofBytes((long)this.physicalBytes);
    }

    @Override
    public long getPhysicalInputPositions() {
        return this.physicalPositions;
    }

    @Override
    public DataSize getInputDataSize() {
        return DataSize.ofBytes((long)this.processedBytes);
    }

    @Override
    public long getInputPositions() {
        return this.processedPositions;
    }

    @Override
    public Duration getReadTime() {
        return new Duration((double)this.readTimeNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getDynamicFilterSplitsProcessed() {
        return this.dynamicFilterSplitsProcessed;
    }

    @Override
    public Metrics getConnectorMetrics() {
        return this.metrics;
    }

    @Override
    public Metrics getMetrics() {
        if (this.cursor != null) {
            return Metrics.EMPTY;
        }
        return this.pageProcessorMetrics.getMetrics();
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public void close() {
        if (this.pageSource != null) {
            try {
                this.pageSource.close();
                this.metrics = this.pageSource.getMetrics();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else if (this.cursor != null) {
            this.cursor.close();
        }
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    private class SplitToPages
    implements WorkProcessor.Transformation<Split, WorkProcessor<Page>> {
        final Session session;
        final DriverYieldSignal yieldSignal;
        final PageSourceProvider pageSourceProvider;
        final CursorProcessor cursorProcessor;
        final PageProcessor pageProcessor;
        final TableHandle table;
        final List<ColumnHandle> columns;
        final DynamicFilter dynamicFilter;
        final List<Type> types;
        final LocalMemoryContext memoryContext;
        final AggregatedMemoryContext localAggregatedMemoryContext;
        final LocalMemoryContext pageSourceMemoryContext;
        final LocalMemoryContext outputMemoryContext;
        final DataSize minOutputPageSize;
        final int minOutputPageRowCount;

        SplitToPages(Session session, DriverYieldSignal yieldSignal, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, DynamicFilter dynamicFilter, Iterable<Type> types, AggregatedMemoryContext aggregatedMemoryContext, DataSize minOutputPageSize, int minOutputPageRowCount) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.yieldSignal = Objects.requireNonNull(yieldSignal, "yieldSignal is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
            this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
            this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
            this.memoryContext = aggregatedMemoryContext.newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
            this.localAggregatedMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            this.pageSourceMemoryContext = this.localAggregatedMemoryContext.newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
            this.outputMemoryContext = this.localAggregatedMemoryContext.newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
            this.minOutputPageSize = Objects.requireNonNull(minOutputPageSize, "minOutputPageSize is null");
            this.minOutputPageRowCount = minOutputPageRowCount;
        }

        @Override
        public WorkProcessor.TransformationState<WorkProcessor<Page>> process(Split split) {
            Object source;
            if (split == null) {
                this.memoryContext.close();
                return WorkProcessor.TransformationState.finished();
            }
            Preconditions.checkState((ScanFilterAndProjectOperator.this.cursor == null && ScanFilterAndProjectOperator.this.pageSource == null ? 1 : 0) != 0, (Object)"Table scan split already set");
            if (!this.dynamicFilter.getCurrentPredicate().isAll()) {
                ++ScanFilterAndProjectOperator.this.dynamicFilterSplitsProcessed;
            }
            if ((source = split.getConnectorSplit() instanceof EmptySplit ? new EmptyPageSource() : this.pageSourceProvider.createPageSource(this.session, split, this.table, this.columns, this.dynamicFilter)) instanceof RecordPageSource) {
                ScanFilterAndProjectOperator.this.cursor = ((RecordPageSource)source).getCursor();
                return WorkProcessor.TransformationState.ofResult(this.processColumnSource());
            }
            ScanFilterAndProjectOperator.this.pageSource = source;
            return WorkProcessor.TransformationState.ofResult(this.processPageSource());
        }

        WorkProcessor<Page> processColumnSource() {
            return WorkProcessor.create(new RecordCursorToPages(this.session, this.yieldSignal, this.cursorProcessor, this.types, this.pageSourceMemoryContext, this.outputMemoryContext)).yielding(this.yieldSignal::isSet).blocking(() -> this.memoryContext.setBytes(this.localAggregatedMemoryContext.getBytes()));
        }

        WorkProcessor<Page> processPageSource() {
            ConnectorSession connectorSession = this.session.toConnectorSession();
            return WorkProcessor.create(new ConnectorPageSourceToPages(this.pageSourceMemoryContext)).yielding(this.yieldSignal::isSet).flatMap(page -> this.pageProcessor.createWorkProcessor(connectorSession, this.yieldSignal, this.outputMemoryContext, ScanFilterAndProjectOperator.this.pageProcessorMetrics, (Page)page)).transformProcessor(processor -> MergePages.mergePages(this.types, this.minOutputPageSize.toBytes(), this.minOutputPageRowCount, processor, this.localAggregatedMemoryContext)).blocking(() -> this.memoryContext.setBytes(this.localAggregatedMemoryContext.getBytes()));
        }
    }

    public static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory,
    WorkProcessorSourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Supplier<CursorProcessor> cursorProcessor;
        private final Supplier<PageProcessor> pageProcessor;
        private final PlanNodeId sourceId;
        private final PageSourceProvider pageSourceProvider;
        private final TableHandle table;
        private final List<ColumnHandle> columns;
        private final DynamicFilter dynamicFilter;
        private final List<Type> types;
        private final DataSize minOutputPageSize;
        private final int minOutputPageRowCount;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(int operatorId, PlanNodeId planNodeId, PlanNodeId sourceId, PageSourceProviderFactory pageSourceProvider, Supplier<CursorProcessor> cursorProcessor, Supplier<PageProcessor> pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, DynamicFilter dynamicFilter, List<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
            this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.dynamicFilter = dynamicFilter;
            this.types = Objects.requireNonNull(types, "types is null");
            this.minOutputPageSize = Objects.requireNonNull(minOutputPageSize, "minOutputPageSize is null");
            this.minOutputPageRowCount = minOutputPageRowCount;
            this.pageSourceProvider = pageSourceProvider.createPageSourceProvider(table.catalogHandle());
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return ScanFilterAndProjectOperator.class.getSimpleName();
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, this.getOperatorType());
            return new WorkProcessorSourceOperatorAdapter(operatorContext, this);
        }

        @Override
        public WorkProcessorSourceOperator create(OperatorContext operatorContext, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Split> split) {
            return new ScanFilterAndProjectOperator(operatorContext.getSession(), memoryTrackingContext, yieldSignal, split, this.pageSourceProvider, this.cursorProcessor.get(), this.pageProcessor.get(), this.table, this.columns, this.dynamicFilter, this.types, this.minOutputPageSize, this.minOutputPageRowCount);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }

    private class ConnectorPageSourceToPages
    implements WorkProcessor.Process<Page> {
        final LocalMemoryContext pageSourceMemoryContext;

        ConnectorPageSourceToPages(LocalMemoryContext pageSourceMemoryContext) {
            this.pageSourceMemoryContext = pageSourceMemoryContext;
        }

        @Override
        public WorkProcessor.ProcessState<Page> process() {
            if (ScanFilterAndProjectOperator.this.pageSource.isFinished()) {
                return WorkProcessor.ProcessState.finished();
            }
            CompletableFuture isBlocked = ScanFilterAndProjectOperator.this.pageSource.isBlocked();
            if (!isBlocked.isDone()) {
                return WorkProcessor.ProcessState.blocked(ScanFilterAndProjectOperator.asVoid(MoreFutures.toListenableFuture((CompletableFuture)isBlocked)));
            }
            Page page = ScanFilterAndProjectOperator.this.pageSource.getNextPage();
            this.pageSourceMemoryContext.setBytes(ScanFilterAndProjectOperator.this.pageSource.getMemoryUsage());
            if (page == null) {
                if (ScanFilterAndProjectOperator.this.pageSource.isFinished()) {
                    return WorkProcessor.ProcessState.finished();
                }
                return WorkProcessor.ProcessState.yielded();
            }
            PageUtils.recordMaterializedBytes(page, sizeInBytes -> ScanFilterAndProjectOperator.this.processedBytes += sizeInBytes);
            ScanFilterAndProjectOperator.this.processedPositions += (long)page.getPositionCount();
            ScanFilterAndProjectOperator.this.physicalBytes = ScanFilterAndProjectOperator.this.pageSource.getCompletedBytes();
            ScanFilterAndProjectOperator.this.physicalPositions = ScanFilterAndProjectOperator.this.pageSource.getCompletedPositions().orElse(ScanFilterAndProjectOperator.this.processedPositions);
            ScanFilterAndProjectOperator.this.readTimeNanos = ScanFilterAndProjectOperator.this.pageSource.getReadTimeNanos();
            ScanFilterAndProjectOperator.this.metrics = ScanFilterAndProjectOperator.this.pageSource.getMetrics();
            return WorkProcessor.ProcessState.ofResult(page);
        }
    }

    private class RecordCursorToPages
    implements WorkProcessor.Process<Page> {
        final ConnectorSession session;
        final DriverYieldSignal yieldSignal;
        final CursorProcessor cursorProcessor;
        final PageBuilder pageBuilder;
        final LocalMemoryContext pageSourceMemoryContext;
        final LocalMemoryContext outputMemoryContext;
        boolean finished;

        RecordCursorToPages(Session session, DriverYieldSignal yieldSignal, CursorProcessor cursorProcessor, List<Type> types, LocalMemoryContext pageSourceMemoryContext, LocalMemoryContext outputMemoryContext) {
            this.session = session.toConnectorSession();
            this.yieldSignal = yieldSignal;
            this.cursorProcessor = cursorProcessor;
            this.pageBuilder = new PageBuilder(types);
            this.pageSourceMemoryContext = pageSourceMemoryContext;
            this.outputMemoryContext = outputMemoryContext;
        }

        @Override
        public WorkProcessor.ProcessState<Page> process() {
            if (!this.finished) {
                CursorProcessorOutput output = this.cursorProcessor.process(this.session, this.yieldSignal, ScanFilterAndProjectOperator.this.cursor, this.pageBuilder);
                this.pageSourceMemoryContext.setBytes(ScanFilterAndProjectOperator.this.cursor.getMemoryUsage());
                ScanFilterAndProjectOperator.this.processedPositions += (long)output.getProcessedRows();
                ScanFilterAndProjectOperator.this.processedBytes = ScanFilterAndProjectOperator.this.cursor.getCompletedBytes();
                ScanFilterAndProjectOperator.this.physicalBytes = ScanFilterAndProjectOperator.this.cursor.getCompletedBytes();
                ScanFilterAndProjectOperator.this.physicalPositions = ScanFilterAndProjectOperator.this.processedPositions;
                ScanFilterAndProjectOperator.this.readTimeNanos = ScanFilterAndProjectOperator.this.cursor.getReadTimeNanos();
                if (output.isNoMoreRows()) {
                    this.finished = true;
                }
            }
            if (this.pageBuilder.isFull() || this.finished && !this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                this.outputMemoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
                return WorkProcessor.ProcessState.ofResult(page);
            }
            if (this.finished) {
                Preconditions.checkState((boolean)this.pageBuilder.isEmpty());
                return WorkProcessor.ProcessState.finished();
            }
            this.outputMemoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
            return WorkProcessor.ProcessState.yielded();
        }
    }
}

