/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.SizeOf;
import io.trino.operator.VariableWidthData;
import io.trino.operator.aggregation.MapAggregationState;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;

public abstract class AbstractMapAggregationState
implements MapAggregationState {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(AbstractMapAggregationState.class);
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int INITIAL_CAPACITY = 16;
    private static final long HASH_COMBINE_PRIME = 4999L;
    private static final int RECORDS_PER_GROUP_SHIFT = 10;
    private static final int RECORDS_PER_GROUP = 1024;
    private static final int RECORDS_PER_GROUP_MASK = 1023;
    private static final int VECTOR_LENGTH = 8;
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private final Type keyType;
    private final MethodHandle keyReadFlat;
    private final MethodHandle keyWriteFlat;
    private final MethodHandle keyHashFlat;
    private final MethodHandle keyIdenticalFlatBlock;
    private final MethodHandle keyHashBlock;
    private final Type valueType;
    private final MethodHandle valueReadFlat;
    private final MethodHandle valueWriteFlat;
    private final int recordSize;
    private final int recordGroupIdOffset;
    private final int recordNextIndexOffset;
    private final int recordKeyOffset;
    private final int recordValueNullOffset;
    private final int recordValueOffset;
    private int capacity;
    private int mask;
    private byte[] control;
    private byte[][] recordGroups;
    private final VariableWidthData variableWidthData;
    @Nullable
    private int[] groupRecordIndex;
    private int size;
    private int maxFill;

    private static int calculateMaxFill(int capacity) {
        return capacity / 16 * 15;
    }

    public AbstractMapAggregationState(Type keyType, MethodHandle keyReadFlat, MethodHandle keyWriteFlat, MethodHandle hashFlat, MethodHandle identicalFlatBlock, MethodHandle keyHashBlock, Type valueType, MethodHandle valueReadFlat, MethodHandle valueWriteFlat, boolean grouped) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.keyReadFlat = Objects.requireNonNull(keyReadFlat, "keyReadFlat is null");
        this.keyWriteFlat = Objects.requireNonNull(keyWriteFlat, "keyWriteFlat is null");
        this.keyHashFlat = Objects.requireNonNull(hashFlat, "hashFlat is null");
        this.keyIdenticalFlatBlock = Objects.requireNonNull(identicalFlatBlock, "identicalFlatBlock is null");
        this.keyHashBlock = Objects.requireNonNull(keyHashBlock, "keyHashBlock is null");
        this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        this.valueReadFlat = Objects.requireNonNull(valueReadFlat, "valueReadFlat is null");
        this.valueWriteFlat = Objects.requireNonNull(valueWriteFlat, "valueWriteFlat is null");
        this.capacity = 16;
        this.maxFill = AbstractMapAggregationState.calculateMaxFill(this.capacity);
        this.mask = this.capacity - 1;
        this.control = new byte[this.capacity + 8];
        this.groupRecordIndex = grouped ? new int[]{} : null;
        boolean variableWidth = keyType.isFlatVariableWidth() || valueType.isFlatVariableWidth();
        VariableWidthData variableWidthData = this.variableWidthData = variableWidth ? new VariableWidthData() : null;
        if (grouped) {
            this.recordGroupIdOffset = variableWidth ? 12 : 0;
            this.recordNextIndexOffset = this.recordGroupIdOffset + 4;
            this.recordKeyOffset = this.recordNextIndexOffset + 4;
        } else {
            this.recordGroupIdOffset = Integer.MIN_VALUE;
            this.recordNextIndexOffset = Integer.MIN_VALUE;
            this.recordKeyOffset = variableWidth ? 12 : 0;
        }
        this.recordValueNullOffset = this.recordKeyOffset + keyType.getFlatFixedSize();
        this.recordValueOffset = this.recordValueNullOffset + 1;
        this.recordSize = this.recordValueOffset + valueType.getFlatFixedSize();
        this.recordGroups = AbstractMapAggregationState.createRecordGroups(this.capacity, this.recordSize);
    }

    public AbstractMapAggregationState(AbstractMapAggregationState state) {
        this.keyType = state.keyType;
        this.keyReadFlat = state.keyReadFlat;
        this.keyWriteFlat = state.keyWriteFlat;
        this.keyHashFlat = state.keyHashFlat;
        this.keyIdenticalFlatBlock = state.keyIdenticalFlatBlock;
        this.keyHashBlock = state.keyHashBlock;
        this.valueType = state.valueType;
        this.valueReadFlat = state.valueReadFlat;
        this.valueWriteFlat = state.valueWriteFlat;
        this.recordSize = state.recordSize;
        this.recordGroupIdOffset = state.recordGroupIdOffset;
        this.recordNextIndexOffset = state.recordNextIndexOffset;
        this.recordKeyOffset = state.recordKeyOffset;
        this.recordValueNullOffset = state.recordValueNullOffset;
        this.recordValueOffset = state.recordValueOffset;
        this.capacity = state.capacity;
        this.mask = state.mask;
        this.control = Arrays.copyOf(state.control, state.control.length);
        this.recordGroups = (byte[][])Arrays.stream(state.recordGroups).map(records -> Arrays.copyOf(records, ((byte[])records).length)).toArray(x$0 -> new byte[x$0][]);
        this.variableWidthData = state.variableWidthData == null ? null : new VariableWidthData(state.variableWidthData);
        this.groupRecordIndex = state.groupRecordIndex == null ? null : Arrays.copyOf(state.groupRecordIndex, state.groupRecordIndex.length);
        this.size = state.size;
        this.maxFill = state.maxFill;
    }

    private static byte[][] createRecordGroups(int capacity, int recordSize) {
        if (capacity < 1024) {
            return new byte[][]{new byte[Math.multiplyExact(capacity, recordSize)]};
        }
        byte[][] groups = new byte[capacity + 1 >> 10][];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = new byte[Math.multiplyExact(1024, recordSize)];
        }
        return groups;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.control) + SizeOf.sizeOf((byte[])this.recordGroups[0]) * (long)this.recordGroups.length + (this.variableWidthData == null ? 0L : this.variableWidthData.getRetainedSizeBytes()) + SizeOf.sizeOf((int[])this.groupRecordIndex);
    }

    public void setMaxGroupId(int maxGroupId) {
        Preconditions.checkState((this.groupRecordIndex != null ? 1 : 0) != 0, (Object)"grouping is not enabled");
        int requiredSize = maxGroupId + 1;
        Objects.checkIndex(requiredSize, 0x7FFFFFF7);
        int currentSize = this.groupRecordIndex.length;
        if (requiredSize > currentSize) {
            this.groupRecordIndex = Arrays.copyOf(this.groupRecordIndex, Math.clamp((long)requiredSize * 2L, 1024, 0x7FFFFFF7));
            Arrays.fill(this.groupRecordIndex, currentSize, this.groupRecordIndex.length, -1);
        }
    }

    protected void serialize(int groupId, MapBlockBuilder out) {
        if (this.size == 0) {
            out.appendNull();
            return;
        }
        if (this.groupRecordIndex == null) {
            Preconditions.checkArgument((groupId == 0 ? 1 : 0) != 0, (Object)"groupId must be zero when grouping is not enabled");
            out.buildEntry((keyBuilder, valueBuilder) -> {
                for (int i = 0; i < this.capacity; ++i) {
                    if (this.control[i] == 0) continue;
                    byte[] records = this.getRecords(i);
                    int recordOffset = this.getRecordOffset(i);
                    this.serializeEntry(keyBuilder, valueBuilder, records, recordOffset);
                }
            });
            return;
        }
        int index = this.groupRecordIndex[groupId];
        if (index == -1) {
            out.appendNull();
            return;
        }
        out.buildEntry((keyBuilder, valueBuilder) -> {
            int nextIndex = index;
            while (nextIndex >= 0) {
                byte[] records = this.getRecords(nextIndex);
                int recordOffset = this.getRecordOffset(nextIndex);
                this.serializeEntry(keyBuilder, valueBuilder, records, recordOffset);
                nextIndex = INT_HANDLE.get(records, recordOffset + this.recordNextIndexOffset);
            }
        });
    }

    private void serializeEntry(BlockBuilder keyBuilder, BlockBuilder valueBuilder, byte[] records, int recordOffset) {
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            variableWidthChunk = this.variableWidthData.getChunk(records, recordOffset);
        }
        try {
            this.keyReadFlat.invokeExact(records, recordOffset + this.recordKeyOffset, variableWidthChunk, keyBuilder);
            if (records[recordOffset + this.recordValueNullOffset] != 0) {
                valueBuilder.appendNull();
            } else {
                this.valueReadFlat.invokeExact(records, recordOffset + this.recordValueOffset, variableWidthChunk, valueBuilder);
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    protected void add(int groupId, ValueBlock keyBlock, int keyPosition, ValueBlock valueBlock, int valuePosition) {
        Preconditions.checkArgument((!keyBlock.isNull(keyPosition) ? 1 : 0) != 0, (Object)"key must not be null");
        Preconditions.checkArgument((groupId == 0 || this.groupRecordIndex != null ? 1 : 0) != 0, (Object)"groupId must be zero when grouping is not enabled");
        long hash = this.keyHashCode(groupId, keyBlock, keyPosition);
        byte hashPrefix = (byte)(hash & 0x7FL | 0x80L);
        int bucket = this.bucket((int)(hash >> 7));
        int step = 1;
        long repeated = AbstractMapAggregationState.repeat(hashPrefix);
        long controlVector;
        int matchBucket;
        while ((matchBucket = this.matchInVector(groupId, keyBlock, keyPosition, bucket, repeated, controlVector = LONG_HANDLE.get(this.control, bucket))) < 0) {
            int emptyIndex = this.findEmptyInVector(controlVector, bucket);
            if (emptyIndex >= 0) {
                this.insert(emptyIndex, groupId, keyBlock, keyPosition, valueBlock, valuePosition, hashPrefix);
                ++this.size;
                if (this.size >= this.maxFill) {
                    this.rehash();
                }
                return;
            }
            bucket = this.bucket(bucket + step);
            step += 8;
        }
        return;
    }

    private int matchInVector(int groupId, ValueBlock block, int position, int vectorStartBucket, long repeated, long controlVector) {
        for (long controlMatches = AbstractMapAggregationState.match(controlVector, repeated); controlMatches != 0L; controlMatches &= controlMatches - 1L) {
            int bucket = this.bucket(vectorStartBucket + (Long.numberOfTrailingZeros(controlMatches) >>> 3));
            if (!this.keyIdentical(bucket, block, position, groupId)) continue;
            return bucket;
        }
        return -1;
    }

    private int findEmptyInVector(long vector, int vectorStartBucket) {
        long controlMatches = AbstractMapAggregationState.match(vector, 0L);
        if (controlMatches == 0L) {
            return -1;
        }
        int slot = Long.numberOfTrailingZeros(controlMatches) >>> 3;
        return this.bucket(vectorStartBucket + slot);
    }

    private void insert(int index, int groupId, ValueBlock keyBlock, int keyPosition, ValueBlock valueBlock, int valuePosition, byte hashPrefix) {
        this.setControl(index, hashPrefix);
        byte[] records = this.getRecords(index);
        int recordOffset = this.getRecordOffset(index);
        if (this.groupRecordIndex != null) {
            INT_HANDLE.set(records, recordOffset + this.recordGroupIdOffset, groupId);
            int nextRecordIndex = this.groupRecordIndex[groupId];
            this.groupRecordIndex[groupId] = index;
            INT_HANDLE.set(records, recordOffset + this.recordNextIndexOffset, nextRecordIndex);
        }
        int keyVariableWidthSize = 0;
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        int variableWidthChunkOffset = 0;
        if (this.variableWidthData != null) {
            keyVariableWidthSize = this.keyType.getFlatVariableWidthSize((Block)keyBlock, keyPosition);
            int valueVariableWidthSize = valueBlock.isNull(valuePosition) ? 0 : this.valueType.getFlatVariableWidthSize((Block)valueBlock, valuePosition);
            variableWidthChunk = this.variableWidthData.allocate(records, recordOffset, keyVariableWidthSize + valueVariableWidthSize);
            variableWidthChunkOffset = VariableWidthData.getChunkOffset(records, recordOffset);
        }
        try {
            this.keyWriteFlat.invokeExact(keyBlock, keyPosition, records, recordOffset + this.recordKeyOffset, variableWidthChunk, variableWidthChunkOffset);
            if (valueBlock.isNull(valuePosition)) {
                records[recordOffset + this.recordValueNullOffset] = 1;
            } else {
                this.valueWriteFlat.invokeExact(valueBlock, valuePosition, records, recordOffset + this.recordValueOffset, variableWidthChunk, variableWidthChunkOffset + keyVariableWidthSize);
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private void setControl(int index, byte hashPrefix) {
        this.control[index] = hashPrefix;
        if (index < 8) {
            this.control[index + this.capacity] = hashPrefix;
        }
    }

    private void rehash() {
        int oldCapacity = this.capacity;
        byte[] oldControl = this.control;
        byte[][] oldRecordGroups = this.recordGroups;
        long newCapacityLong = (long)this.capacity * 2L;
        if (newCapacityLong > 0x7FFFFFF7L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        this.capacity = (int)newCapacityLong;
        this.maxFill = AbstractMapAggregationState.calculateMaxFill(this.capacity);
        this.mask = this.capacity - 1;
        this.control = new byte[this.capacity + 8];
        this.recordGroups = AbstractMapAggregationState.createRecordGroups(this.capacity, this.recordSize);
        if (this.groupRecordIndex != null) {
            Arrays.fill(this.groupRecordIndex, -1);
        }
        block0: for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
            if (oldControl[oldIndex] == 0) continue;
            byte[] oldRecords = oldRecordGroups[oldIndex >> 10];
            int oldRecordOffset = this.getRecordOffset(oldIndex);
            int groupId = 0;
            if (this.groupRecordIndex != null) {
                groupId = INT_HANDLE.get(oldRecords, oldRecordOffset + this.recordGroupIdOffset);
            }
            long hash = this.keyHashCode(groupId, oldRecords, oldIndex);
            byte hashPrefix = (byte)(hash & 0x7FL | 0x80L);
            int bucket = this.bucket((int)(hash >> 7));
            int step = 1;
            while (true) {
                long controlVector;
                int emptyIndex;
                if ((emptyIndex = this.findEmptyInVector(controlVector = LONG_HANDLE.get(this.control, bucket), bucket)) >= 0) {
                    this.setControl(emptyIndex, hashPrefix);
                    byte[] records = this.getRecords(emptyIndex);
                    int recordOffset = this.getRecordOffset(emptyIndex);
                    System.arraycopy(oldRecords, oldRecordOffset, records, recordOffset, this.recordSize);
                    if (this.groupRecordIndex == null) continue block0;
                    INT_HANDLE.set(records, recordOffset + this.recordNextIndexOffset, this.groupRecordIndex[groupId]);
                    this.groupRecordIndex[groupId] = emptyIndex;
                    continue block0;
                }
                bucket = this.bucket(bucket + step);
                step += 8;
            }
        }
    }

    private int bucket(int hash) {
        return hash & this.mask;
    }

    private byte[] getRecords(int index) {
        return this.recordGroups[index >> 10];
    }

    private int getRecordOffset(int index) {
        return (index & 0x3FF) * this.recordSize;
    }

    private long keyHashCode(int groupId, byte[] records, int index) {
        int recordOffset = this.getRecordOffset(index);
        try {
            byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
            if (this.variableWidthData != null) {
                variableWidthChunk = this.variableWidthData.getChunk(records, recordOffset);
            }
            long valueHash = this.keyHashFlat.invokeExact(records, recordOffset + this.recordKeyOffset, variableWidthChunk);
            return (long)groupId * 4999L + valueHash;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private long keyHashCode(int groupId, ValueBlock right, int rightPosition) {
        try {
            long valueHash = this.keyHashBlock.invokeExact(right, rightPosition);
            return (long)groupId * 4999L + valueHash;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private boolean keyIdentical(int leftPosition, ValueBlock right, int rightPosition, int rightGroupId) {
        long leftGroupId;
        byte[] leftRecords = this.getRecords(leftPosition);
        int leftRecordOffset = this.getRecordOffset(leftPosition);
        if (this.groupRecordIndex != null && (leftGroupId = (long)INT_HANDLE.get(leftRecords, leftRecordOffset + this.recordGroupIdOffset)) != (long)rightGroupId) {
            return false;
        }
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            leftVariableWidthChunk = this.variableWidthData.getChunk(leftRecords, leftRecordOffset);
        }
        try {
            return this.keyIdenticalFlatBlock.invokeExact(leftRecords, leftRecordOffset + this.recordKeyOffset, leftVariableWidthChunk, right, rightPosition);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private static long repeat(byte value) {
        return (long)(value & 0xFF) * 0x101010101010101L;
    }

    private static long match(long vector, long repeatedValue) {
        long comparison = vector ^ repeatedValue;
        return comparison - 0x101010101010101L & (comparison ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
    }
}

