/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.ApproximateMostFrequentHistogram;
import io.trino.operator.aggregation.BigintApproximateMostFrequent;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;

public class LongApproximateMostFrequentStateFactory
implements AccumulatorStateFactory<BigintApproximateMostFrequent.State> {
    public BigintApproximateMostFrequent.State createSingleState() {
        return new SingleLongApproximateMostFrequentState();
    }

    public BigintApproximateMostFrequent.State createGroupedState() {
        return new GroupedLongApproximateMostFrequentState();
    }

    public static class SingleLongApproximateMostFrequentState
    implements BigintApproximateMostFrequent.State {
        private ApproximateMostFrequentHistogram<Long> histogram;
        private long size;

        @Override
        public ApproximateMostFrequentHistogram<Long> get() {
            return this.histogram;
        }

        @Override
        public void set(ApproximateMostFrequentHistogram<Long> histogram) {
            this.histogram = histogram;
            this.size = histogram.estimatedInMemorySize();
        }

        public long getEstimatedSize() {
            return this.size;
        }
    }

    public static class GroupedLongApproximateMostFrequentState
    extends AbstractGroupedAccumulatorState
    implements BigintApproximateMostFrequent.State {
        private final ObjectBigArray<ApproximateMostFrequentHistogram<Long>> histograms = new ObjectBigArray();
        private long size;

        @Override
        public ApproximateMostFrequentHistogram<Long> get() {
            return (ApproximateMostFrequentHistogram)this.histograms.get((long)this.getGroupId());
        }

        @Override
        public void set(ApproximateMostFrequentHistogram<Long> histogram) {
            ApproximateMostFrequentHistogram<Long> previous = this.get();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
            this.histograms.set((long)this.getGroupId(), histogram);
            this.size += histogram.estimatedInMemorySize();
        }

        public void ensureCapacity(int size) {
            this.histograms.ensureCapacity((long)size);
        }

        public long getEstimatedSize() {
            return this.size + this.histograms.sizeOf();
        }
    }
}

