/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.Framing;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.WindowFrameType;
import java.util.Objects;
import java.util.function.Function;

public class GroupsFraming
implements Framing {
    private final FrameInfo frameInfo;
    private final int partitionStart;
    private final int partitionEnd;
    private final PagesIndex pagesIndex;
    private final Function<Integer, Integer> seekGroupStart;
    private final Function<Integer, Integer> seekGroupEnd;
    private GroupsFrame recentFrame;
    private int lastPeerGroup = Integer.MAX_VALUE;

    public GroupsFraming(FrameInfo frameInfo, int partitionStart, int partitionEnd, PagesIndex pagesIndex, PagesHashStrategy peerGroupHashStrategy, int initialEnd) {
        Preconditions.checkArgument((frameInfo.getType() == WindowFrameType.GROUPS ? 1 : 0) != 0, (String)"Frame must be of type GROUPS, actual: %s", (Object)((Object)frameInfo.getType()));
        this.frameInfo = frameInfo;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.pagesIndex = pagesIndex;
        this.recentFrame = new GroupsFrame(0, 0, initialEnd, 0);
        this.seekGroupStart = position -> {
            Objects.requireNonNull(position, "position is null");
            while (position > 0 && pagesIndex.positionIdenticalToPosition(peerGroupHashStrategy, partitionStart + position, partitionStart + position - 1)) {
                Integer n = position;
                position = position - 1;
            }
            return position;
        };
        this.seekGroupEnd = position -> {
            Objects.requireNonNull(position, "position is null");
            while (position < partitionEnd - 1 - partitionStart && pagesIndex.positionIdenticalToPosition(peerGroupHashStrategy, partitionStart + position, partitionStart + position + 1)) {
                Integer n = position;
                position = position + 1;
            }
            return position;
        };
    }

    @Override
    public Framing.Range getRange(int currentPosition, int currentGroup, int peerGroupStart, int peerGroupEnd) {
        GroupsFrame frame = this.getFrameRange(currentPosition, currentGroup, peerGroupStart, peerGroupEnd);
        if (this.emptyFrame(frame.getRange())) {
            this.recentFrame = this.nearestValidFrame(frame);
            return new Framing.Range(-1, -1);
        }
        this.recentFrame = frame;
        return frame.getRange();
    }

    private GroupsFrame getFrameRange(int currentPosition, int currentGroup, int peerGroupStart, int peerGroupEnd) {
        int end;
        int start;
        FrameBoundType startType = this.frameInfo.getStartType();
        FrameBoundType endType = this.frameInfo.getEndType();
        int startGroupIndex = GroupsFrame.ignoreIndex();
        int endGroupIndex = GroupsFrame.ignoreIndex();
        switch (startType) {
            case UNBOUNDED_PRECEDING: {
                start = 0;
                break;
            }
            case CURRENT_ROW: {
                start = peerGroupStart - this.partitionStart;
                break;
            }
            case PRECEDING: {
                PositionAndGroup frameStart = this.seek(currentGroup, -this.getValue(this.frameInfo.getStartChannel(), currentPosition), this.recentFrame.getStart(), this.recentFrame.getStartGroupIndex(), this.seekGroupStart, lastGroup -> new PositionAndGroup(0, 0));
                start = frameStart.getPosition();
                startGroupIndex = frameStart.getGroup();
                break;
            }
            case FOLLOWING: {
                PositionAndGroup frameStart = this.seek(currentGroup, this.getValue(this.frameInfo.getStartChannel(), currentPosition), this.recentFrame.getStart(), this.recentFrame.getStartGroupIndex(), this.seekGroupStart, lastGroup -> new PositionAndGroup(this.partitionEnd - this.partitionStart, GroupsFrame.ignoreIndex()));
                start = frameStart.getPosition();
                startGroupIndex = frameStart.getGroup();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported frame start type: " + String.valueOf((Object)startType));
            }
        }
        switch (endType) {
            case UNBOUNDED_FOLLOWING: {
                end = this.partitionEnd - this.partitionStart - 1;
                break;
            }
            case CURRENT_ROW: {
                end = peerGroupEnd - this.partitionStart - 1;
                break;
            }
            case PRECEDING: {
                PositionAndGroup frameEnd = this.seek(currentGroup, -this.getValue(this.frameInfo.getEndChannel(), currentPosition), this.recentFrame.getEnd(), this.recentFrame.getEndGroupIndex(), this.seekGroupEnd, lastGroup -> new PositionAndGroup(-1, GroupsFrame.ignoreIndex()));
                end = frameEnd.getPosition();
                endGroupIndex = frameEnd.getGroup();
                break;
            }
            case FOLLOWING: {
                PositionAndGroup frameEnd = this.seek(currentGroup, this.getValue(this.frameInfo.getEndChannel(), currentPosition), this.recentFrame.getEnd(), this.recentFrame.getEndGroupIndex(), this.seekGroupEnd, lastGroup -> new PositionAndGroup(this.partitionEnd - this.partitionStart - 1, this.lastPeerGroup));
                end = frameEnd.getPosition();
                endGroupIndex = frameEnd.getGroup();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported frame end type: " + String.valueOf((Object)endType));
            }
        }
        return new GroupsFrame(start, startGroupIndex, end, endGroupIndex);
    }

    private boolean emptyFrame(Framing.Range range) {
        return range.getStart() > range.getEnd() || range.getStart() >= this.partitionEnd - this.partitionStart || range.getEnd() < 0;
    }

    private GroupsFrame nearestValidFrame(GroupsFrame frame) {
        if (frame.getStart() > this.partitionEnd - this.partitionStart - 1) {
            return frame.withStart(this.partitionEnd - this.partitionStart - 1, this.lastPeerGroup);
        }
        if (frame.getEnd() < 0) {
            return frame.withEnd(0, 0);
        }
        return frame;
    }

    private PositionAndGroup seek(int currentGroupIndex, long offset, int recentPosition, int recentGroupIndex, Function<Integer, Integer> seekPositionWithinGroup, EdgeResultProvider edgeResult) {
        long searchedIndex = (long)currentGroupIndex + offset;
        if (searchedIndex < 0L || searchedIndex > (long)this.lastPeerGroup) {
            return edgeResult.get(this.lastPeerGroup);
        }
        int groupIndex = Math.toIntExact(searchedIndex);
        while (recentGroupIndex > groupIndex) {
            recentPosition = this.seekGroupStart.apply(recentPosition);
            --recentPosition;
            --recentGroupIndex;
        }
        while (recentGroupIndex < groupIndex) {
            if ((recentPosition = this.seekGroupEnd.apply(recentPosition).intValue()) == this.partitionEnd - this.partitionStart - 1) {
                this.lastPeerGroup = recentGroupIndex;
                return edgeResult.get(this.lastPeerGroup);
            }
            ++recentPosition;
            ++recentGroupIndex;
        }
        if ((recentPosition = seekPositionWithinGroup.apply(recentPosition).intValue()) == this.partitionEnd - this.partitionStart - 1) {
            this.lastPeerGroup = recentGroupIndex;
        }
        return new PositionAndGroup(recentPosition, recentGroupIndex);
    }

    private long getValue(int channel, int currentPosition) {
        Preconditions.checkState((!this.pagesIndex.isNull(channel, currentPosition) ? 1 : 0) != 0, (Object)"Window frame offset must not be null");
        long value = this.pagesIndex.getLong(channel, currentPosition);
        Preconditions.checkState((value >= 0L ? 1 : 0) != 0, (Object)"Window frame offset must not be negative");
        return value;
    }

    private static class GroupsFrame {
        private static final int IGNORE_GROUP_INDEX = -1;
        private final int start;
        private final int startGroupIndex;
        private final int end;
        private final int endGroupIndex;

        public GroupsFrame(int start, int startGroupIndex, int end, int endGroupIndex) {
            this.start = start;
            this.startGroupIndex = startGroupIndex;
            this.end = end;
            this.endGroupIndex = endGroupIndex;
        }

        public static int ignoreIndex() {
            return -1;
        }

        public GroupsFrame withStart(int start, int startGroupIndex) {
            return new GroupsFrame(start, startGroupIndex, this.end, this.endGroupIndex);
        }

        public GroupsFrame withEnd(int end, int endGroupIndex) {
            return new GroupsFrame(this.start, this.startGroupIndex, end, endGroupIndex);
        }

        public int getStart() {
            return this.start;
        }

        public int getStartGroupIndex() {
            Preconditions.checkState((this.startGroupIndex != -1 ? 1 : 0) != 0, (Object)"accessing ignored group index");
            return this.startGroupIndex;
        }

        public int getEnd() {
            return this.end;
        }

        public int getEndGroupIndex() {
            Preconditions.checkState((this.endGroupIndex != -1 ? 1 : 0) != 0, (Object)"accessing ignored group index");
            return this.endGroupIndex;
        }

        public Framing.Range getRange() {
            return new Framing.Range(this.start, this.end);
        }
    }

    private static interface EdgeResultProvider {
        public PositionAndGroup get(int var1);
    }

    private static class PositionAndGroup {
        private final int position;
        private final int group;

        public PositionAndGroup(int position, int group) {
            this.position = position;
            this.group = group;
        }

        public int getPosition() {
            return this.position;
        }

        public int getGroup() {
            return this.group;
        }
    }
}

