/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.eventlistener.EventListenerManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.plugin.base.security.DefaultSystemAccessControl;
import io.trino.plugin.base.security.FileBasedSystemAccessControl;
import io.trino.plugin.base.security.ForwardingSystemAccessControl;
import io.trino.plugin.base.security.ReadOnlySystemAccessControl;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.DefaultSystemAccessControlName;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.EntityPrivilege;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class AccessControlManager
implements AccessControl {
    private static final Logger log = Logger.get(AccessControlManager.class);
    private static final File CONFIG_FILE = new File("etc/access-control.properties");
    private static final String NAME_PROPERTY = "access-control.name";
    private final NodeVersion nodeVersion;
    private final TransactionManager transactionManager;
    private final EventListenerManager eventListenerManager;
    private final List<File> configFiles;
    private final OpenTelemetry openTelemetry;
    private final String defaultAccessControlName;
    private final Map<String, SystemAccessControlFactory> systemAccessControlFactories = new ConcurrentHashMap<String, SystemAccessControlFactory>();
    private final AtomicReference<CatalogServiceProvider<Optional<ConnectorAccessControl>>> connectorAccessControlProvider = new AtomicReference();
    private final AtomicReference<List<SystemAccessControl>> systemAccessControls = new AtomicReference();
    private final CounterStat authorizationSuccess = new CounterStat();
    private final CounterStat authorizationFail = new CounterStat();

    @Inject
    public AccessControlManager(NodeVersion nodeVersion, TransactionManager transactionManager, EventListenerManager eventListenerManager, AccessControlConfig config, OpenTelemetry openTelemetry, @DefaultSystemAccessControlName String defaultAccessControlName) {
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.configFiles = ImmutableList.copyOf(config.getAccessControlFiles());
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
        this.defaultAccessControlName = Objects.requireNonNull(defaultAccessControlName, "defaultAccessControl is null");
        this.addSystemAccessControlFactory((SystemAccessControlFactory)new DefaultSystemAccessControl.Factory());
        this.addSystemAccessControlFactory((SystemAccessControlFactory)new AllowAllSystemAccessControl.Factory());
        this.addSystemAccessControlFactory((SystemAccessControlFactory)new ReadOnlySystemAccessControl.Factory());
        this.addSystemAccessControlFactory((SystemAccessControlFactory)new FileBasedSystemAccessControl.Factory());
    }

    public final void addSystemAccessControlFactory(SystemAccessControlFactory accessControlFactory) {
        Objects.requireNonNull(accessControlFactory, "accessControlFactory is null");
        if (this.systemAccessControlFactories.putIfAbsent(accessControlFactory.getName(), accessControlFactory) != null) {
            throw new IllegalArgumentException(String.format("Access control '%s' is already registered", accessControlFactory.getName()));
        }
    }

    public void setConnectorAccessControlProvider(CatalogServiceProvider<Optional<ConnectorAccessControl>> connectorAccessControlProvider) {
        if (!this.connectorAccessControlProvider.compareAndSet(null, connectorAccessControlProvider)) {
            throw new IllegalStateException("connectorAccessControlProvider already set");
        }
    }

    public void loadSystemAccessControl() {
        ImmutableList configFiles = this.configFiles;
        if (configFiles.isEmpty()) {
            if (!CONFIG_FILE.exists()) {
                this.loadSystemAccessControl(this.defaultAccessControlName, (Map<String, String>)ImmutableMap.of());
                log.info("Using system access control: %s", new Object[]{this.defaultAccessControlName});
                return;
            }
            configFiles = ImmutableList.of((Object)CONFIG_FILE);
        }
        List systemAccessControls = (List)configFiles.stream().map(this::createSystemAccessControl).collect(ImmutableList.toImmutableList());
        systemAccessControls.stream().map(SystemAccessControl::getEventListeners).flatMap(listeners -> ImmutableSet.copyOf((Iterable)listeners).stream()).forEach(this.eventListenerManager::addEventListener);
        this.setSystemAccessControls(systemAccessControls);
    }

    @PreDestroy
    public void destroy() {
        try (AutoCloseableCloser closer = AutoCloseableCloser.create();){
            for (SystemAccessControl systemAccessControl : this.systemAccessControls.get()) {
                closer.register(() -> ((SystemAccessControl)systemAccessControl).shutdown());
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private SystemAccessControl createSystemAccessControl(File configFile) {
        SystemAccessControl systemAccessControl;
        HashMap properties;
        log.info("-- Loading system access control %s --", new Object[]{configFile});
        configFile = configFile.getAbsoluteFile();
        try {
            properties = new HashMap(ConfigurationLoader.loadPropertiesFrom((String)configFile.getPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read configuration file: " + String.valueOf(configFile), e);
        }
        String name = (String)properties.remove(NAME_PROPERTY);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Access control configuration does not contain '%s' property: %s", (Object)NAME_PROPERTY, (Object)configFile);
        SystemAccessControlFactory factory = this.systemAccessControlFactories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Access control '%s' is not registered: %s", (Object)name, (Object)configFile);
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            systemAccessControl = factory.create((Map)ImmutableMap.copyOf(properties), this.createContext(name));
        }
        log.info("-- Loaded system access control %s --", new Object[]{name});
        return systemAccessControl;
    }

    @VisibleForTesting
    public void loadSystemAccessControl(String name, Map<String, String> properties) {
        SystemAccessControl systemAccessControl;
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        SystemAccessControlFactory factory = this.systemAccessControlFactories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Access control '%s' is not registered", (Object)name);
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            systemAccessControl = factory.create((Map)ImmutableMap.copyOf(properties), this.createContext(name));
        }
        systemAccessControl.getEventListeners().forEach(this.eventListenerManager::addEventListener);
        this.setSystemAccessControls((List<SystemAccessControl>)ImmutableList.of((Object)systemAccessControl));
    }

    private SystemAccessControlFactory.SystemAccessControlContext createContext(final String systemAccessControlName) {
        return new SystemAccessControlFactory.SystemAccessControlContext(){
            private final Tracer tracer;
            private final String version;
            final /* synthetic */ AccessControlManager this$0;
            {
                this.this$0 = this$0;
                this.tracer = this.this$0.openTelemetry.getTracer("trino.system-access-control." + systemAccessControlName);
                this.version = this.this$0.nodeVersion.getVersion();
            }

            public String getVersion() {
                return this.version;
            }

            public OpenTelemetry getOpenTelemetry() {
                return this.this$0.openTelemetry;
            }

            public Tracer getTracer() {
                return this.tracer;
            }
        };
    }

    public void setSystemAccessControls(List<SystemAccessControl> systemAccessControls) {
        systemAccessControls.forEach(AccessControlManager::verifySystemAccessControl);
        Preconditions.checkState((boolean)this.systemAccessControls.compareAndSet(null, systemAccessControls), (Object)"System access control already initialized");
    }

    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(userName, "userName is null");
        this.systemAuthorizationCheck(control -> control.checkCanImpersonateUser(identity, userName));
    }

    @Override
    @Deprecated
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(userName, "userName is null");
        this.systemAuthorizationCheck(control -> control.checkCanSetUser(principal, userName));
    }

    @Override
    public void checkCanReadSystemInformation(Identity identity) {
        Objects.requireNonNull(identity, "identity is null");
        this.systemAuthorizationCheck(control -> control.checkCanReadSystemInformation(identity));
    }

    @Override
    public void checkCanWriteSystemInformation(Identity identity) {
        Objects.requireNonNull(identity, "identity is null");
        this.systemAuthorizationCheck(control -> control.checkCanWriteSystemInformation(identity));
    }

    @Override
    public void checkCanExecuteQuery(Identity identity, QueryId queryId) {
        Objects.requireNonNull(identity, "identity is null");
        this.systemAuthorizationCheck(control -> control.checkCanExecuteQuery(identity, queryId));
    }

    @Override
    public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
        Objects.requireNonNull(identity, "identity is null");
        this.systemAuthorizationCheck(control -> control.checkCanViewQueryOwnedBy(identity, queryOwner));
    }

    @Override
    public Collection<Identity> filterQueriesOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        if (queryOwners.isEmpty()) {
            return ImmutableSet.of();
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            queryOwners = systemAccessControl.filterViewQueryOwnedBy(identity, queryOwners);
        }
        return queryOwners;
    }

    @Override
    public void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(queryOwner, "queryOwner is null");
        this.systemAuthorizationCheck(control -> control.checkCanKillQueryOwnedBy(identity, queryOwner));
    }

    @Override
    public void checkCanCreateCatalog(SecurityContext securityContext, String catalog) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalog, "catalog is null");
        this.systemAuthorizationCheck(control -> control.checkCanCreateCatalog(securityContext.toSystemSecurityContext(), catalog));
    }

    @Override
    public void checkCanDropCatalog(SecurityContext securityContext, String catalog) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalog, "catalog is null");
        this.systemAuthorizationCheck(control -> control.checkCanDropCatalog(securityContext.toSystemSecurityContext(), catalog));
    }

    @Override
    public Set<String> filterCatalogs(SecurityContext securityContext, Set<String> catalogs) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogs, "catalogs is null");
        if (catalogs.isEmpty()) {
            return ImmutableSet.of();
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            catalogs = systemAccessControl.filterCatalogs(securityContext.toSystemSecurityContext(), catalogs);
        }
        return catalogs;
    }

    @Override
    public void checkCanCreateSchema(SecurityContext securityContext, CatalogSchemaName schemaName, Map<String, Object> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateSchema(securityContext.toSystemSecurityContext(), schemaName, properties));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanCreateSchema(context, schemaName.getSchemaName(), properties));
    }

    @Override
    public void checkCanDropSchema(SecurityContext securityContext, CatalogSchemaName schemaName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropSchema(securityContext.toSystemSecurityContext(), schemaName));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanDropSchema(context, schemaName.getSchemaName()));
    }

    @Override
    public void checkCanRenameSchema(SecurityContext securityContext, CatalogSchemaName schemaName, String newSchemaName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameSchema(securityContext.toSystemSecurityContext(), schemaName, newSchemaName));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanRenameSchema(context, schemaName.getSchemaName(), newSchemaName));
    }

    @Override
    public void checkCanSetSchemaAuthorization(SecurityContext securityContext, CatalogSchemaName schemaName, TrinoPrincipal principal) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetSchemaAuthorization(securityContext.toSystemSecurityContext(), schemaName, principal));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanSetSchemaAuthorization(context, schemaName.getSchemaName(), principal));
    }

    @Override
    public void checkCanShowSchemas(SecurityContext securityContext, String catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.checkCanAccessCatalog(securityContext, catalogName);
        this.systemAuthorizationCheck(control -> control.checkCanShowSchemas(securityContext.toSystemSecurityContext(), catalogName));
        this.catalogAuthorizationCheck(catalogName, securityContext, ConnectorAccessControl::checkCanShowSchemas);
    }

    @Override
    public Set<String> filterSchemas(SecurityContext securityContext, String catalogName, Set<String> schemaNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(schemaNames, "schemaNames is null");
        if (schemaNames.isEmpty()) {
            return ImmutableSet.of();
        }
        if (this.filterCatalogs(securityContext, (Set<String>)ImmutableSet.of((Object)catalogName)).isEmpty()) {
            return ImmutableSet.of();
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            schemaNames = systemAccessControl.filterSchemas(securityContext.toSystemSecurityContext(), catalogName, schemaNames);
        }
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl != null) {
            schemaNames = connectorAccessControl.filterSchemas(this.toConnectorSecurityContext(catalogName, securityContext), schemaNames);
        }
        return schemaNames;
    }

    @Override
    public void checkCanShowCreateSchema(SecurityContext securityContext, CatalogSchemaName schemaName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowCreateSchema(securityContext.toSystemSecurityContext(), schemaName));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanShowCreateSchema(context, schemaName.getSchemaName()));
    }

    @Override
    public void checkCanShowCreateTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowCreateTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanShowCreateTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanCreateTable(SecurityContext securityContext, QualifiedObjectName tableName, Map<String, Object> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), properties));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanCreateTable(context, tableName.asSchemaTableName(), properties));
    }

    @Override
    public void checkCanDropTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanDropTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanRenameTable(SecurityContext securityContext, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(newTableName, "newTableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), newTableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanRenameTable(context, tableName.asSchemaTableName(), newTableName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetTableProperties(SecurityContext securityContext, QualifiedObjectName tableName, Map<String, Optional<Object>> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(properties, "nonNullProperties is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetTableProperties(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), properties));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanSetTableProperties(context, tableName.asSchemaTableName(), properties));
    }

    @Override
    public void checkCanSetTableComment(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetTableComment(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanSetTableComment(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetViewComment(SecurityContext securityContext, QualifiedObjectName viewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetViewComment(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.catalogName(), securityContext, (control, context) -> control.checkCanSetViewComment(context, viewName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetColumnComment(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetColumnComment(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanSetColumnComment(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanShowTables(SecurityContext securityContext, CatalogSchemaName schema) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schema, "schema is null");
        this.checkCanAccessCatalog(securityContext, schema.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowTables(securityContext.toSystemSecurityContext(), schema));
        this.catalogAuthorizationCheck(schema.getCatalogName(), securityContext, (control, context) -> control.checkCanShowTables(context, schema.getSchemaName()));
    }

    @Override
    public Set<SchemaTableName> filterTables(SecurityContext securityContext, String catalogName, Set<SchemaTableName> tableNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(tableNames, "tableNames is null");
        if (tableNames.isEmpty()) {
            return ImmutableSet.of();
        }
        if (this.filterCatalogs(securityContext, (Set<String>)ImmutableSet.of((Object)catalogName)).isEmpty()) {
            return ImmutableSet.of();
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            tableNames = systemAccessControl.filterTables(securityContext.toSystemSecurityContext(), catalogName, tableNames);
        }
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl != null) {
            tableNames = connectorAccessControl.filterTables(this.toConnectorSecurityContext(catalogName, securityContext), tableNames);
        }
        return tableNames;
    }

    @Override
    public void checkCanShowColumns(SecurityContext securityContext, CatalogSchemaTableName table) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(table, "table is null");
        this.checkCanAccessCatalog(securityContext, table.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowColumns(securityContext.toSystemSecurityContext(), table));
        this.catalogAuthorizationCheck(table.getCatalogName(), securityContext, (control, context) -> control.checkCanShowColumns(context, table.getSchemaTableName()));
    }

    @Override
    public Map<SchemaTableName, Set<String>> filterColumns(SecurityContext securityContext, String catalogName, Map<SchemaTableName, Set<String>> tableColumns) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(tableColumns, "tableColumns is null");
        Set<SchemaTableName> filteredTables = this.filterTables(securityContext, catalogName, tableColumns.keySet());
        if (!filteredTables.equals(tableColumns.keySet())) {
            tableColumns = Maps.filterKeys(tableColumns, filteredTables::contains);
        }
        if (tableColumns.isEmpty()) {
            return ImmutableMap.of();
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            tableColumns = systemAccessControl.filterColumns(securityContext.toSystemSecurityContext(), catalogName, tableColumns);
        }
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl != null) {
            tableColumns = connectorAccessControl.filterColumns(this.toConnectorSecurityContext(catalogName, securityContext), tableColumns);
        }
        return tableColumns;
    }

    @Override
    public void checkCanAddColumns(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanAddColumn(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanAddColumn(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanAlterColumn(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanAlterColumn(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanAlterColumn(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanDropColumn(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropColumn(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanDropColumn(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanRenameColumn(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameColumn(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanRenameColumn(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetTableAuthorization(SecurityContext securityContext, QualifiedObjectName tableName, TrinoPrincipal principal) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(principal, "principal is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetTableAuthorization(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), principal));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanSetTableAuthorization(context, tableName.asSchemaTableName(), principal));
    }

    @Override
    public void checkCanInsertIntoTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanInsertIntoTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanInsertIntoTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanDeleteFromTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDeleteFromTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanDeleteFromTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanTruncateTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanTruncateTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanTruncateTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanUpdateTableColumns(SecurityContext securityContext, QualifiedObjectName tableName, Set<String> updatedColumnNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanUpdateTableColumns(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), updatedColumnNames));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanUpdateTableColumns(context, tableName.asSchemaTableName(), updatedColumnNames));
    }

    @Override
    public void checkCanCreateView(SecurityContext securityContext, QualifiedObjectName viewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateView(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.catalogName(), securityContext, (control, context) -> control.checkCanCreateView(context, viewName.asSchemaTableName()));
    }

    @Override
    public void checkCanRenameView(SecurityContext securityContext, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        Objects.requireNonNull(newViewName, "newViewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameView(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName(), newViewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.catalogName(), securityContext, (control, context) -> control.checkCanRenameView(context, viewName.asSchemaTableName(), newViewName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetViewAuthorization(SecurityContext securityContext, QualifiedObjectName viewName, TrinoPrincipal principal) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        Objects.requireNonNull(principal, "principal is null");
        this.checkCanAccessCatalog(securityContext, viewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetViewAuthorization(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName(), principal));
        this.catalogAuthorizationCheck(viewName.catalogName(), securityContext, (control, context) -> control.checkCanSetViewAuthorization(context, viewName.asSchemaTableName(), principal));
    }

    @Override
    public void checkCanDropView(SecurityContext securityContext, QualifiedObjectName viewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropView(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.catalogName(), securityContext, (control, context) -> control.checkCanDropView(context, viewName.asSchemaTableName()));
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext securityContext, QualifiedObjectName tableName, Set<String> columnNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateViewWithSelectFromColumns(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), columnNames));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanCreateViewWithSelectFromColumns(context, tableName.asSchemaTableName(), columnNames));
    }

    @Override
    public void checkCanCreateMaterializedView(SecurityContext securityContext, QualifiedObjectName materializedViewName, Map<String, Object> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(materializedViewName, "materializedViewName is null");
        Objects.requireNonNull(properties, "properties is null");
        this.checkCanAccessCatalog(securityContext, materializedViewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateMaterializedView(securityContext.toSystemSecurityContext(), materializedViewName.asCatalogSchemaTableName(), properties));
        this.catalogAuthorizationCheck(materializedViewName.catalogName(), securityContext, (control, context) -> control.checkCanCreateMaterializedView(context, materializedViewName.asSchemaTableName(), properties));
    }

    @Override
    public void checkCanRefreshMaterializedView(SecurityContext securityContext, QualifiedObjectName materializedViewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(materializedViewName, "materializedViewName is null");
        this.checkCanAccessCatalog(securityContext, materializedViewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRefreshMaterializedView(securityContext.toSystemSecurityContext(), materializedViewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(materializedViewName.catalogName(), securityContext, (control, context) -> control.checkCanRefreshMaterializedView(context, materializedViewName.asSchemaTableName()));
    }

    @Override
    public void checkCanDropMaterializedView(SecurityContext securityContext, QualifiedObjectName materializedViewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(materializedViewName, "materializedViewName is null");
        this.checkCanAccessCatalog(securityContext, materializedViewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropMaterializedView(securityContext.toSystemSecurityContext(), materializedViewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(materializedViewName.catalogName(), securityContext, (control, context) -> control.checkCanDropMaterializedView(context, materializedViewName.asSchemaTableName()));
    }

    @Override
    public void checkCanRenameMaterializedView(SecurityContext securityContext, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        Objects.requireNonNull(newViewName, "newViewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameMaterializedView(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName(), newViewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.catalogName(), securityContext, (control, context) -> control.checkCanRenameMaterializedView(context, viewName.asSchemaTableName(), newViewName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetMaterializedViewProperties(SecurityContext securityContext, QualifiedObjectName materializedViewName, Map<String, Optional<Object>> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(materializedViewName, "materializedViewName is null");
        Objects.requireNonNull(properties, "nonNullProperties is null");
        this.checkCanAccessCatalog(securityContext, materializedViewName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetMaterializedViewProperties(securityContext.toSystemSecurityContext(), materializedViewName.asCatalogSchemaTableName(), properties));
        this.catalogAuthorizationCheck(materializedViewName.catalogName(), securityContext, (control, context) -> control.checkCanSetMaterializedViewProperties(context, materializedViewName.asSchemaTableName(), properties));
    }

    @Override
    public void checkCanGrantSchemaPrivilege(SecurityContext securityContext, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanGrantSchemaPrivilege(securityContext.toSystemSecurityContext(), privilege, schemaName, grantee, grantOption));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanGrantSchemaPrivilege(context, privilege, schemaName.getSchemaName(), grantee, grantOption));
    }

    @Override
    public void checkCanDenySchemaPrivilege(SecurityContext securityContext, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDenySchemaPrivilege(securityContext.toSystemSecurityContext(), privilege, schemaName, grantee));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanDenySchemaPrivilege(context, privilege, schemaName.getSchemaName(), grantee));
    }

    @Override
    public void checkCanRevokeSchemaPrivilege(SecurityContext securityContext, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal revokee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRevokeSchemaPrivilege(securityContext.toSystemSecurityContext(), privilege, schemaName, revokee, grantOption));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanRevokeSchemaPrivilege(context, privilege, schemaName.getSchemaName(), revokee, grantOption));
    }

    @Override
    public void checkCanGrantTablePrivilege(SecurityContext securityContext, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanGrantTablePrivilege(securityContext.toSystemSecurityContext(), privilege, tableName.asCatalogSchemaTableName(), grantee, grantOption));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanGrantTablePrivilege(context, privilege, tableName.asSchemaTableName(), grantee, grantOption));
    }

    @Override
    public void checkCanDenyTablePrivilege(SecurityContext securityContext, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDenyTablePrivilege(securityContext.toSystemSecurityContext(), privilege, tableName.asCatalogSchemaTableName(), grantee));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanDenyTablePrivilege(context, privilege, tableName.asSchemaTableName(), grantee));
    }

    @Override
    public void checkCanRevokeTablePrivilege(SecurityContext securityContext, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal revokee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRevokeTablePrivilege(securityContext.toSystemSecurityContext(), privilege, tableName.asCatalogSchemaTableName(), revokee, grantOption));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanRevokeTablePrivilege(context, privilege, tableName.asSchemaTableName(), revokee, grantOption));
    }

    @Override
    public void checkCanGrantEntityPrivilege(SecurityContext securityContext, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal grantee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(entity, "entity is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.systemAuthorizationCheck(control -> control.checkCanGrantEntityPrivilege(securityContext.toSystemSecurityContext(), privilege, entity, grantee, grantOption));
    }

    @Override
    public void checkCanDenyEntityPrivilege(SecurityContext securityContext, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal grantee) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(entity, "entity is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.systemAuthorizationCheck(control -> control.checkCanDenyEntityPrivilege(securityContext.toSystemSecurityContext(), privilege, entity, grantee));
    }

    @Override
    public void checkCanRevokeEntityPrivilege(SecurityContext securityContext, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal revokee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(entity, "entity is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.systemAuthorizationCheck(control -> control.checkCanRevokeEntityPrivilege(securityContext.toSystemSecurityContext(), privilege, entity, revokee, grantOption));
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, QueryId queryId, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.systemAuthorizationCheck(control -> control.checkCanSetSystemSessionProperty(identity, queryId, propertyName));
    }

    @Override
    public void checkCanSetCatalogSessionProperty(SecurityContext securityContext, String catalogName, String propertyName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.checkCanAccessCatalog(securityContext, catalogName);
        this.systemAuthorizationCheck(control -> control.checkCanSetCatalogSessionProperty(securityContext.toSystemSecurityContext(), catalogName, propertyName));
        this.catalogAuthorizationCheck(catalogName, securityContext, (control, context) -> control.checkCanSetCatalogSessionProperty(context, propertyName));
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext securityContext, QualifiedObjectName tableName, Set<String> columnNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        this.checkCanAccessCatalog(securityContext, tableName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSelectFromColumns(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), columnNames));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanSelectFromColumns(context, tableName.asSchemaTableName(), columnNames));
    }

    @Override
    public void checkCanCreateRole(SecurityContext securityContext, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, (control, context) -> control.checkCanCreateRole(context, role, grantor));
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanCreateRole(securityContext.toSystemSecurityContext(), role, grantor));
        }
    }

    @Override
    public void checkCanDropRole(SecurityContext securityContext, String role, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, (control, context) -> control.checkCanDropRole(context, role));
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanDropRole(securityContext.toSystemSecurityContext(), role));
        }
    }

    @Override
    public void checkCanGrantRoles(SecurityContext securityContext, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(roles, "roles is null");
        Objects.requireNonNull(grantees, "grantees is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, (control, context) -> control.checkCanGrantRoles(context, roles, grantees, adminOption, grantor));
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanGrantRoles(securityContext.toSystemSecurityContext(), roles, grantees, adminOption, grantor));
        }
    }

    @Override
    public void checkCanRevokeRoles(SecurityContext securityContext, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(roles, "roles is null");
        Objects.requireNonNull(grantees, "grantees is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, (control, context) -> control.checkCanRevokeRoles(context, roles, grantees, adminOption, grantor));
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanRevokeRoles(securityContext.toSystemSecurityContext(), roles, grantees, adminOption, grantor));
        }
    }

    @Override
    public void checkCanSetCatalogRole(SecurityContext securityContext, String role, String catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.checkCanAccessCatalog(securityContext, catalogName);
        this.catalogAuthorizationCheck(catalogName, securityContext, (control, context) -> control.checkCanSetRole(context, role));
    }

    @Override
    public void checkCanShowRoles(SecurityContext securityContext, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, ConnectorAccessControl::checkCanShowRoles);
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanShowRoles(securityContext.toSystemSecurityContext()));
        }
    }

    @Override
    public void checkCanShowCurrentRoles(SecurityContext securityContext, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, ConnectorAccessControl::checkCanShowCurrentRoles);
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanShowCurrentRoles(securityContext.toSystemSecurityContext()));
        }
    }

    @Override
    public void checkCanShowRoleGrants(SecurityContext securityContext, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, ConnectorAccessControl::checkCanShowRoleGrants);
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanShowRoleGrants(securityContext.toSystemSecurityContext()));
        }
    }

    @Override
    public void checkCanExecuteProcedure(SecurityContext securityContext, QualifiedObjectName procedureName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(procedureName, "procedureName is null");
        this.checkCanAccessCatalog(securityContext, procedureName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanExecuteProcedure(securityContext.toSystemSecurityContext(), procedureName.asCatalogSchemaRoutineName()));
        this.catalogAuthorizationCheck(procedureName.catalogName(), securityContext, (control, context) -> control.checkCanExecuteProcedure(context, procedureName.asSchemaRoutineName()));
    }

    @Override
    public boolean canExecuteFunction(SecurityContext securityContext, QualifiedObjectName functionName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(functionName, "functionName is null");
        if (!this.canAccessCatalog(securityContext, functionName.catalogName())) {
            return false;
        }
        if (!this.systemAuthorizationTest(control -> control.canExecuteFunction(securityContext.toSystemSecurityContext(), functionName.asCatalogSchemaRoutineName()))) {
            return false;
        }
        return this.catalogAuthorizationTest(functionName.catalogName(), securityContext, (control, context) -> control.canExecuteFunction(context, functionName.asSchemaRoutineName()));
    }

    @Override
    public boolean canCreateViewWithExecuteFunction(SecurityContext securityContext, QualifiedObjectName functionName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(functionName, "functionName is null");
        if (!this.canAccessCatalog(securityContext, functionName.catalogName())) {
            return false;
        }
        if (!this.systemAuthorizationTest(control -> control.canCreateViewWithExecuteFunction(securityContext.toSystemSecurityContext(), functionName.asCatalogSchemaRoutineName()))) {
            return false;
        }
        return this.catalogAuthorizationTest(functionName.catalogName(), securityContext, (control, context) -> control.canCreateViewWithExecuteFunction(context, functionName.asSchemaRoutineName()));
    }

    @Override
    public void checkCanExecuteTableProcedure(SecurityContext securityContext, QualifiedObjectName tableName, String procedureName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(procedureName, "procedureName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.systemAuthorizationCheck(control -> control.checkCanExecuteTableProcedure(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), procedureName));
        this.catalogAuthorizationCheck(tableName.catalogName(), securityContext, (control, context) -> control.checkCanExecuteTableProcedure(context, tableName.asSchemaTableName(), procedureName));
    }

    @Override
    public void checkCanShowFunctions(SecurityContext securityContext, CatalogSchemaName schema) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schema, "schema is null");
        this.checkCanAccessCatalog(securityContext, schema.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowFunctions(securityContext.toSystemSecurityContext(), schema));
        this.catalogAuthorizationCheck(schema.getCatalogName(), securityContext, (control, context) -> control.checkCanShowFunctions(context, schema.getSchemaName()));
    }

    @Override
    public Set<SchemaFunctionName> filterFunctions(SecurityContext securityContext, String catalogName, Set<SchemaFunctionName> functionNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(functionNames, "functionNames is null");
        if (functionNames.isEmpty()) {
            return ImmutableSet.of();
        }
        if (this.filterCatalogs(securityContext, (Set<String>)ImmutableSet.of((Object)catalogName)).isEmpty()) {
            return ImmutableSet.of();
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            functionNames = systemAccessControl.filterFunctions(securityContext.toSystemSecurityContext(), catalogName, functionNames);
        }
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl != null) {
            functionNames = connectorAccessControl.filterFunctions(this.toConnectorSecurityContext(catalogName, securityContext), functionNames);
        }
        return functionNames;
    }

    @Override
    public void checkCanCreateFunction(SecurityContext securityContext, QualifiedObjectName functionName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(functionName, "functionName is null");
        this.checkCanAccessCatalog(securityContext, functionName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateFunction(securityContext.toSystemSecurityContext(), functionName.asCatalogSchemaRoutineName()));
        this.catalogAuthorizationCheck(functionName.catalogName(), securityContext, (control, context) -> control.checkCanCreateFunction(context, functionName.asSchemaRoutineName()));
    }

    @Override
    public void checkCanDropFunction(SecurityContext securityContext, QualifiedObjectName functionName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(functionName, "functionName is null");
        this.checkCanAccessCatalog(securityContext, functionName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropFunction(securityContext.toSystemSecurityContext(), functionName.asCatalogSchemaRoutineName()));
        this.catalogAuthorizationCheck(functionName.catalogName(), securityContext, (control, context) -> control.checkCanDropFunction(context, functionName.asSchemaRoutineName()));
    }

    @Override
    public void checkCanShowCreateFunction(SecurityContext context, QualifiedObjectName functionName) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(functionName, "functionName is null");
        this.checkCanAccessCatalog(context, functionName.catalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowCreateFunction(context.toSystemSecurityContext(), functionName.asCatalogSchemaRoutineName()));
        this.catalogAuthorizationCheck(functionName.catalogName(), context, (control, connectorContext) -> control.checkCanShowCreateFunction(connectorContext, functionName.asSchemaRoutineName()));
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ImmutableList.Builder filters = ImmutableList.builder();
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(context.getTransactionId(), tableName.catalogName());
        if (connectorAccessControl != null) {
            connectorAccessControl.getRowFilters(this.toConnectorSecurityContext(tableName.catalogName(), context), tableName.asSchemaTableName()).forEach(arg_0 -> ((ImmutableList.Builder)filters).add(arg_0));
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            systemAccessControl.getRowFilters(context.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()).forEach(arg_0 -> ((ImmutableList.Builder)filters).add(arg_0));
        }
        return filters.build();
    }

    @Override
    public Map<ColumnSchema, ViewExpression> getColumnMasks(SecurityContext context, QualifiedObjectName tableName, List<ColumnSchema> columns) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columns, "columns is null");
        ImmutableMap.Builder columnMasksBuilder = ImmutableMap.builder();
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(context.getTransactionId(), tableName.catalogName());
        if (connectorAccessControl != null) {
            Map connectorMasks = connectorAccessControl.getColumnMasks(this.toConnectorSecurityContext(tableName.catalogName(), context), tableName.asSchemaTableName(), columns);
            columnMasksBuilder.putAll(connectorMasks);
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            Map systemMasks = systemAccessControl.getColumnMasks(context.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), columns);
            columnMasksBuilder.putAll(systemMasks);
        }
        try {
            return columnMasksBuilder.buildOrThrow();
        }
        catch (IllegalArgumentException exception) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_MASK, "Multiple masks for the same column found", (Throwable)exception);
        }
    }

    private ConnectorAccessControl getConnectorAccessControl(TransactionId transactionId, String catalogName) {
        CatalogServiceProvider<Optional<ConnectorAccessControl>> connectorAccessControlProvider = this.connectorAccessControlProvider.get();
        if (connectorAccessControlProvider == null) {
            return null;
        }
        ConnectorAccessControl connectorAccessControl = this.transactionManager.getCatalogHandle(transactionId, catalogName).flatMap(connectorAccessControlProvider::getService).orElse(null);
        return connectorAccessControl;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationSuccess() {
        return this.authorizationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationFail() {
        return this.authorizationFail;
    }

    private void checkCanAccessCatalog(SecurityContext securityContext, String catalogName) {
        if (!this.canAccessCatalog(securityContext, catalogName)) {
            AccessDeniedException.denyCatalogAccess((String)catalogName);
        }
    }

    private boolean canAccessCatalog(SecurityContext securityContext, String catalogName) {
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            if (systemAccessControl.canAccessCatalog(securityContext.toSystemSecurityContext(), catalogName)) continue;
            this.authorizationFail.update(1L);
            return false;
        }
        this.authorizationSuccess.update(1L);
        return true;
    }

    private boolean systemAuthorizationTest(Predicate<SystemAccessControl> check) {
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            if (check.test(systemAccessControl)) continue;
            this.authorizationFail.update(1L);
            return false;
        }
        this.authorizationSuccess.update(1L);
        return true;
    }

    private void systemAuthorizationCheck(Consumer<SystemAccessControl> check) {
        try {
            for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
                check.accept(systemAccessControl);
            }
            this.authorizationSuccess.update(1L);
        }
        catch (TrinoException e) {
            this.authorizationFail.update(1L);
            throw e;
        }
    }

    private boolean catalogAuthorizationTest(String catalogName, SecurityContext securityContext, BiPredicate<ConnectorAccessControl, ConnectorSecurityContext> check) {
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl == null) {
            return true;
        }
        boolean result = check.test(connectorAccessControl, this.toConnectorSecurityContext(catalogName, securityContext));
        if (result) {
            this.authorizationSuccess.update(1L);
        } else {
            this.authorizationFail.update(1L);
        }
        return result;
    }

    private void catalogAuthorizationCheck(String catalogName, SecurityContext securityContext, BiConsumer<ConnectorAccessControl, ConnectorSecurityContext> check) {
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl == null) {
            return;
        }
        try {
            check.accept(connectorAccessControl, this.toConnectorSecurityContext(catalogName, securityContext));
            this.authorizationSuccess.update(1L);
        }
        catch (TrinoException e) {
            this.authorizationFail.update(1L);
            throw e;
        }
    }

    private void checkCatalogRoles(SecurityContext securityContext, String catalogName) {
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Catalog %s does not support catalog roles", catalogName));
        }
    }

    private List<SystemAccessControl> getSystemAccessControls() {
        List<SystemAccessControl> accessControls = this.systemAccessControls.get();
        if (accessControls != null) {
            return accessControls;
        }
        return ImmutableList.of((Object)((Object)new InitializingSystemAccessControl()));
    }

    private ConnectorSecurityContext toConnectorSecurityContext(String catalogName, SecurityContext securityContext) {
        return this.toConnectorSecurityContext(catalogName, securityContext.getTransactionId(), securityContext.getIdentity(), securityContext.getQueryId());
    }

    private ConnectorSecurityContext toConnectorSecurityContext(String catalogName, TransactionId requiredTransactionId, Identity identity, QueryId queryId) {
        return new ConnectorSecurityContext(this.transactionManager.getRequiredCatalogMetadata(requiredTransactionId, catalogName).getTransactionHandleFor(CatalogHandle.CatalogHandleType.NORMAL), identity.toConnectorIdentity(catalogName), queryId);
    }

    private static void verifySystemAccessControl(SystemAccessControl systemAccessControl) {
        Class clazz = systemAccessControl.getClass();
        AccessControlManager.mustNotDeclareMethod(clazz, "checkCanAccessCatalog", SystemSecurityContext.class, String.class);
        AccessControlManager.mustNotDeclareMethod(clazz, "checkCanGrantExecuteFunctionPrivilege", SystemSecurityContext.class, String.class, TrinoPrincipal.class, Boolean.TYPE);
        AccessControlManager.mustNotDeclareMethod(clazz, "checkCanExecuteFunction", SystemSecurityContext.class, String.class);
        AccessControlManager.mustNotDeclareMethod(clazz, "checkCanExecuteFunction", SystemSecurityContext.class, FunctionKind.class, CatalogSchemaRoutineName.class);
        AccessControlManager.mustNotDeclareMethod(clazz, "checkCanGrantExecuteFunctionPrivilege", SystemSecurityContext.class, FunctionKind.class, CatalogSchemaRoutineName.class, TrinoPrincipal.class, Boolean.TYPE);
    }

    private static void mustNotDeclareMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            clazz.getMethod(name, parameterTypes);
            throw new IllegalArgumentException(String.format("Access control %s must not implement removed method %s(%s)", clazz.getName(), name, Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(", "))));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return;
        }
    }

    private static class InitializingSystemAccessControl
    extends ForwardingSystemAccessControl {
        private InitializingSystemAccessControl() {
        }

        protected SystemAccessControl delegate() {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Trino server is still initializing");
        }
    }
}

