/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;

public class SimplifyContinuousInValues
implements IrOptimizerRule {
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        if (!(expression instanceof In)) {
            return Optional.empty();
        }
        In in = (In)expression;
        if (in.valueList().size() < 2) {
            return Optional.empty();
        }
        Type valueType = in.value().type();
        if (!SimplifyContinuousInValues.isDirectLongComparisonValidType(valueType)) {
            return Optional.empty();
        }
        if (valueType.getJavaType() != Long.TYPE) {
            return Optional.empty();
        }
        boolean nullMatch = false;
        long nonNullsCount = 0L;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (Expression testExpression : in.valueList()) {
            if (!(testExpression instanceof Constant)) {
                return Optional.empty();
            }
            Constant constant = (Constant)testExpression;
            if (constant.value() == null) {
                nullMatch = true;
                continue;
            }
            long longConstant = (Long)constant.value();
            min = Math.min(min, longConstant);
            max = Math.max(max, longConstant);
            ++nonNullsCount;
        }
        if (nonNullsCount >= 2L && SimplifyContinuousInValues.areAllValuesInRangeIncluded(max, min, nonNullsCount)) {
            Between between = new Between(in.value(), new Constant(valueType, min), new Constant(valueType, max));
            if (nullMatch) {
                return Optional.of(IrUtils.or(new IsNull(in.value()), between));
            }
            return Optional.of(between);
        }
        return Optional.empty();
    }

    private static boolean isDirectLongComparisonValidType(Type type) {
        DecimalType decimalType;
        TimestampType timestampType;
        TimeType timeType;
        return type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof TimeType && (timeType = (TimeType)type).getPrecision() == 12 || type instanceof DateType || type instanceof TimestampType && (timestampType = (TimestampType)type).getPrecision() == 6 || type instanceof DecimalType && (decimalType = (DecimalType)type).isShort();
    }

    private static boolean areAllValuesInRangeIncluded(long max, long min, long nonNullsCount) {
        BigInteger range = BigInteger.valueOf(max).subtract(BigInteger.valueOf(min)).add(BigInteger.valueOf(1L));
        try {
            return range.longValueExact() == nonNullsCount;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }
}

