/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.metadata.Metadata;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.DynamicFilters;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.IrExpressionOptimizer;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.EffectivePredicateExtractor;
import io.trino.sql.planner.EqualityInference;
import io.trino.sql.planner.ExpressionSymbolInliner;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import io.trino.sql.planner.iterative.rule.UnwrapCastInComparison;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SimplePlanRewriter;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PredicatePushDown
implements PlanOptimizer {
    private static final Set<Comparison.Operator> DYNAMIC_FILTERING_SUPPORTED_COMPARISONS = ImmutableSet.of((Object)((Object)Comparison.Operator.EQUAL), (Object)((Object)Comparison.Operator.GREATER_THAN), (Object)((Object)Comparison.Operator.GREATER_THAN_OR_EQUAL), (Object)((Object)Comparison.Operator.LESS_THAN), (Object)((Object)Comparison.Operator.LESS_THAN_OR_EQUAL));
    private final PlannerContext plannerContext;
    private final boolean useTableProperties;
    private final boolean dynamicFiltering;

    public PredicatePushDown(PlannerContext plannerContext, boolean useTableProperties, boolean dynamicFiltering) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.useTableProperties = useTableProperties;
        this.dynamicFiltering = dynamicFiltering;
    }

    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        Objects.requireNonNull(plan, "plan is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(context.symbolAllocator(), context.idAllocator(), this.plannerContext, context.session(), this.useTableProperties, this.dynamicFiltering), plan, Booleans.TRUE);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Expression> {
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final PlannerContext plannerContext;
        private final IrExpressionOptimizer optimizer;
        private final Metadata metadata;
        private final Session session;
        private final boolean dynamicFiltering;
        private final EffectivePredicateExtractor effectivePredicateExtractor;

        private Rewriter(SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, PlannerContext plannerContext, Session session, boolean useTableProperties, boolean dynamicFiltering) {
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.metadata = plannerContext.getMetadata();
            this.session = Objects.requireNonNull(session, "session is null");
            this.dynamicFiltering = dynamicFiltering;
            this.effectivePredicateExtractor = new EffectivePredicateExtractor(plannerContext, useTableProperties && SystemSessionProperties.isPredicatePushdownUseTableProperties(session));
            this.optimizer = IrExpressionOptimizer.newOptimizer(plannerContext);
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            PlanNode rewrittenNode = context.defaultRewrite(node, Booleans.TRUE);
            if (!context.get().equals(Booleans.TRUE)) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, context.get());
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                HashMap<Symbol, Reference> outputsToInputs = new HashMap<Symbol, Reference>();
                for (int index = 0; index < node.getInputs().get(i).size(); ++index) {
                    outputsToInputs.put(node.getOutputSymbols().get(index), node.getInputs().get(i).get(index).toSymbolReference());
                }
                Expression sourcePredicate = ExpressionSymbolInliner.inlineSymbols(outputsToInputs, context.get());
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new ExchangeNode(node.getId(), node.getType(), node.getScope(), node.getPartitioningScheme(), (List<PlanNode>)builder.build(), node.getInputs(), node.getOrderingScheme());
            }
            return node;
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            List<Symbol> partitionSymbols = node.getPartitionBy();
            Predicate<Expression> isSupported = conjunct -> DeterminismEvaluator.isDeterministic(conjunct) && partitionSymbols.containsAll(SymbolsExtractor.extractUnique(conjunct));
            Map<Boolean, List<Expression>> conjuncts = IrUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(isSupported));
            PlanNode rewrittenNode = context.defaultRewrite(node, IrUtils.combineConjuncts((Collection<Expression>)conjuncts.get(true)));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, IrUtils.combineConjuncts((Collection<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitTopNRanking(TopNRankingNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            List<Symbol> partitionSymbols = node.getPartitionBy();
            Predicate<Expression> isSupported = conjunct -> DeterminismEvaluator.isDeterministic(conjunct) && partitionSymbols.containsAll(SymbolsExtractor.extractUnique(conjunct));
            Map<Boolean, List<Expression>> conjuncts = IrUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(isSupported));
            PlanNode rewrittenNode = context.defaultRewrite(node, IrUtils.combineConjuncts((Collection<Expression>)conjuncts.get(true)));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, IrUtils.combineConjuncts((Collection<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Set deterministicSymbols = node.getAssignments().entrySet().stream().filter(entry -> DeterminismEvaluator.isDeterministic((Expression)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            Predicate<Expression> deterministic = conjunct -> deterministicSymbols.containsAll(SymbolsExtractor.extractUnique(conjunct));
            Map<Boolean, List<Expression>> conjuncts = IrUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(deterministic));
            List<Expression> deterministicConjuncts = conjuncts.get(true);
            Map<Boolean, List<Expression>> inlineConjuncts = deterministicConjuncts.stream().collect(Collectors.partitioningBy(expression -> this.isInliningCandidate((Expression)expression, node)));
            List<Expression> inlinedDeterministicConjuncts = inlineConjuncts.get(true).stream().map(entry -> ExpressionSymbolInliner.inlineSymbols(node.getAssignments().getMap(), entry)).map(conjunct -> CanonicalizeExpressionRewriter.canonicalizeExpression(conjunct, this.plannerContext)).map(conjunct -> UnwrapCastInComparison.unwrapCasts(this.session, this.plannerContext, conjunct)).collect(Collectors.toList());
            PlanNode rewrittenNode = context.defaultRewrite(node, IrUtils.combineConjuncts(inlinedDeterministicConjuncts));
            List<Expression> nonInliningConjuncts = inlineConjuncts.get(false);
            nonInliningConjuncts.addAll((Collection<Expression>)conjuncts.get(false));
            if (!nonInliningConjuncts.isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, IrUtils.combineConjuncts(nonInliningConjuncts));
            }
            return rewrittenNode;
        }

        private boolean isInliningCandidate(Expression expression, ProjectNode node) {
            ImmutableSet childOutputSet = ImmutableSet.copyOf(node.getOutputSymbols());
            Map dependencies = SymbolsExtractor.extractAll(expression).stream().filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            return dependencies.entrySet().stream().allMatch(entry -> (Long)entry.getValue() == 1L || node.getAssignments().get((Symbol)entry.getKey()) instanceof Constant || node.getAssignments().get((Symbol)entry.getKey()) instanceof Reference);
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Map commonGroupingSymbolMapping = (Map)node.getGroupingColumns().entrySet().stream().filter(entry -> node.getCommonGroupingColumns().contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
            Predicate<Expression> pushdownEligiblePredicate = conjunct -> commonGroupingSymbolMapping.keySet().containsAll(SymbolsExtractor.extractUnique(conjunct));
            Map<Boolean, List<Expression>> conjuncts = IrUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(pushdownEligiblePredicate));
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionSymbolInliner.inlineSymbols(commonGroupingSymbolMapping, IrUtils.combineConjuncts((Collection<Expression>)conjuncts.get(true))));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, IrUtils.combineConjuncts((Collection<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            ImmutableSet pushDownableSymbols = ImmutableSet.copyOf(node.getDistinctSymbols());
            Map<Boolean, List<Expression>> conjuncts = IrUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(arg_0 -> Rewriter.lambda$visitMarkDistinct$12((Set)pushDownableSymbols, arg_0)));
            PlanNode rewrittenNode = context.defaultRewrite(node, IrUtils.combineConjuncts((Collection<Expression>)conjuncts.get(true)));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, IrUtils.combineConjuncts((Collection<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                Expression sourcePredicate = ExpressionSymbolInliner.inlineSymbols(node.sourceSymbolMap(i), context.get());
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new UnionNode(node.getId(), (List<PlanNode>)builder.build(), node.getSymbolMapping(), node.getOutputSymbols());
            }
            return node;
        }

        @Override
        @Deprecated
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            PlanNode rewrittenPlan = context.rewrite(node.getSource(), IrUtils.combineConjuncts(node.getPredicate(), context.get()));
            if (!(rewrittenPlan instanceof FilterNode)) {
                return rewrittenPlan;
            }
            FilterNode rewrittenFilterNode = (FilterNode)rewrittenPlan;
            if (!rewrittenFilterNode.getPredicate().equals(node.getPredicate()) || node.getSource() != rewrittenFilterNode.getSource()) {
                return rewrittenPlan;
            }
            return node;
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            PlanNode rightSource;
            PlanNode leftSource;
            Expression postJoinPredicate;
            Expression rightPredicate;
            Expression leftPredicate;
            Expression inheritedPredicate = context.get();
            node = this.tryNormalizeToOuterToInnerJoin(node, inheritedPredicate);
            Expression leftEffectivePredicate = this.effectivePredicateExtractor.extract(this.session, node.getLeft());
            Expression rightEffectivePredicate = this.effectivePredicateExtractor.extract(this.session, node.getRight());
            Expression joinPredicate = this.extractJoinPredicate(node);
            Expression newJoinPredicate = switch (node.getType()) {
                case JoinType.INNER -> {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    yield innerJoinPushDownResult.getJoinPredicate();
                }
                case JoinType.LEFT -> {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    yield leftOuterJoinPushDownResult.getJoinPredicate();
                }
                case JoinType.RIGHT -> {
                    OuterJoinPushDownResult rightOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, rightEffectivePredicate, leftEffectivePredicate, joinPredicate, node.getRight().getOutputSymbols(), node.getLeft().getOutputSymbols());
                    leftPredicate = rightOuterJoinPushDownResult.getInnerJoinPredicate();
                    rightPredicate = rightOuterJoinPushDownResult.getOuterJoinPredicate();
                    postJoinPredicate = rightOuterJoinPushDownResult.getPostJoinPredicate();
                    yield rightOuterJoinPushDownResult.getJoinPredicate();
                }
                case JoinType.FULL -> {
                    leftPredicate = Booleans.TRUE;
                    rightPredicate = Booleans.TRUE;
                    postJoinPredicate = inheritedPredicate;
                    yield joinPredicate;
                }
                default -> throw new UnsupportedOperationException("Unsupported join type: " + String.valueOf((Object)node.getType()));
            };
            newJoinPredicate = this.simplifyExpression(newJoinPredicate);
            Assignments.Builder leftProjections = Assignments.builder();
            leftProjections.putAll((Map)node.getLeft().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
            Assignments.Builder rightProjections = Assignments.builder();
            rightProjections.putAll((Map)node.getRight().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
            ArrayList<JoinNode.EquiJoinClause> equiJoinClauses = new ArrayList<JoinNode.EquiJoinClause>();
            ImmutableList.Builder joinFilterBuilder = ImmutableList.builder();
            for (Expression conjunct : IrUtils.extractConjuncts(newJoinPredicate)) {
                if (this.joinEqualityExpression(conjunct, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols())) {
                    Comparison equality = (Comparison)conjunct;
                    boolean alignedComparison = node.getLeft().getOutputSymbols().containsAll(SymbolsExtractor.extractUnique(equality.left()));
                    Expression leftExpression = alignedComparison ? equality.left() : equality.right();
                    Expression rightExpression = alignedComparison ? equality.right() : equality.left();
                    Symbol leftSymbol = this.symbolForExpression(leftExpression);
                    if (!node.getLeft().getOutputSymbols().contains(leftSymbol)) {
                        leftProjections.put(leftSymbol, leftExpression);
                    }
                    Symbol rightSymbol = this.symbolForExpression(rightExpression);
                    if (!node.getRight().getOutputSymbols().contains(rightSymbol)) {
                        rightProjections.put(rightSymbol, rightExpression);
                    }
                    equiJoinClauses.add(new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    continue;
                }
                joinFilterBuilder.add((Object)conjunct);
            }
            ImmutableList joinFilter = joinFilterBuilder.build();
            DynamicFiltersResult dynamicFiltersResult = this.createDynamicFilters(node, equiJoinClauses, (List<Expression>)joinFilter, this.session, this.idAllocator);
            Map<DynamicFilterId, Symbol> dynamicFilters = dynamicFiltersResult.getDynamicFilters();
            leftPredicate = IrUtils.combineConjuncts(leftPredicate, IrUtils.combineConjuncts(dynamicFiltersResult.getPredicates()));
            boolean equiJoinClausesUnmodified = ImmutableSet.copyOf(equiJoinClauses).equals((Object)ImmutableSet.copyOf(node.getCriteria()));
            if (!equiJoinClausesUnmodified) {
                leftSource = context.rewrite(new ProjectNode(this.idAllocator.getNextId(), node.getLeft(), leftProjections.build()), leftPredicate);
                rightSource = context.rewrite(new ProjectNode(this.idAllocator.getNextId(), node.getRight(), rightProjections.build()), rightPredicate);
            } else {
                leftSource = context.rewrite(node.getLeft(), leftPredicate);
                rightSource = context.rewrite(node.getRight(), rightPredicate);
            }
            Optional<Expression> newJoinFilter = Optional.of(IrUtils.combineConjuncts((Collection<Expression>)joinFilter));
            if (newJoinFilter.get().equals(Booleans.TRUE)) {
                newJoinFilter = Optional.empty();
            }
            if (node.getType() == JoinType.INNER && newJoinFilter.isPresent() && equiJoinClauses.isEmpty()) {
                postJoinPredicate = IrUtils.combineConjuncts(postJoinPredicate, newJoinFilter.get());
                newJoinFilter = Optional.empty();
            }
            boolean filtersEquivalent = newJoinFilter.isPresent() == node.getFilter().isPresent() && (newJoinFilter.isEmpty() || newJoinFilter.get().equals(node.getFilter().get()));
            PlanNode output = node;
            if (!(leftSource == node.getLeft() && rightSource == node.getRight() && filtersEquivalent && dynamicFilters.equals(node.getDynamicFilters()) && equiJoinClausesUnmodified)) {
                leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, leftProjections.build());
                rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, rightProjections.build());
                output = new JoinNode(node.getId(), node.getType(), leftSource, rightSource, equiJoinClauses, leftSource.getOutputSymbols(), rightSource.getOutputSymbols(), node.isMaySkipOutputDuplicates(), newJoinFilter, node.getLeftHashSymbol(), node.getRightHashSymbol(), node.getDistributionType(), node.isSpillable(), dynamicFilters, node.getReorderJoinStatsAndCost());
            }
            if (!postJoinPredicate.equals(Booleans.TRUE)) {
                output = new FilterNode(this.idAllocator.getNextId(), output, postJoinPredicate);
            }
            if (!node.getOutputSymbols().equals(((PlanNode)output).getOutputSymbols())) {
                output = new ProjectNode(this.idAllocator.getNextId(), output, Assignments.identity(node.getOutputSymbols()));
            }
            return output;
        }

        private DynamicFiltersResult createDynamicFilters(JoinNode node, List<JoinNode.EquiJoinClause> equiJoinClauses, List<Expression> joinFilterClauses, Session session, PlanNodeIdAllocator idAllocator) {
            if (node.getType() != JoinType.INNER && node.getType() != JoinType.RIGHT || !SystemSessionProperties.isEnableDynamicFiltering(session) || !this.dynamicFiltering) {
                return new DynamicFiltersResult((Map<DynamicFilterId, Symbol>)ImmutableMap.of(), (List<Expression>)ImmutableList.of());
            }
            List clauses = (List)Streams.concat((Stream[])new Stream[]{equiJoinClauses.stream().map(clause -> new DynamicFilterExpression(new Comparison(Comparison.Operator.EQUAL, clause.getLeft().toSymbolReference(), clause.getRight().toSymbolReference()))), joinFilterClauses.stream().flatMap(Rewriter::tryConvertBetweenIntoComparisons).filter(clause -> this.joinDynamicFilteringExpression((Expression)clause, (Collection<Symbol>)node.getLeft().getOutputSymbols(), (Collection<Symbol>)node.getRight().getOutputSymbols())).map(expression -> {
                Comparison comparison;
                if (expression instanceof Comparison && (comparison = (Comparison)expression).operator() == Comparison.Operator.IDENTICAL) {
                    return new DynamicFilterExpression(new Comparison(Comparison.Operator.EQUAL, comparison.left(), comparison.right()), true);
                }
                return new DynamicFilterExpression((Comparison)expression);
            }).map(expression -> {
                Comparison comparison = expression.getComparison();
                Expression leftExpression = comparison.left();
                Expression rightExpression = comparison.right();
                boolean alignedComparison = node.getLeft().getOutputSymbols().containsAll(SymbolsExtractor.extractUnique(leftExpression));
                return new DynamicFilterExpression(new Comparison(alignedComparison ? comparison.operator() : comparison.operator().flip(), alignedComparison ? leftExpression : rightExpression, alignedComparison ? rightExpression : leftExpression), expression.isNullAllowed());
            })}).collect(ImmutableList.toImmutableList());
            Set buildSymbols = (Set)clauses.stream().map(DynamicFilterExpression::getComparison).map(Comparison::right).map(Symbol::from).collect(ImmutableSet.toImmutableSet());
            BiMap buildSymbolToDynamicFilter = HashBiMap.create(node.getDynamicFilters()).inverse();
            for (Symbol buildSymbol : buildSymbols) {
                buildSymbolToDynamicFilter.computeIfAbsent((Object)buildSymbol, key -> new DynamicFilterId("df_" + idAllocator.getNextId().toString()));
            }
            List predicates = (List)clauses.stream().map(clause -> {
                Comparison comparison = clause.getComparison();
                Expression probeExpression = comparison.left();
                Symbol buildSymbol = Symbol.from(comparison.right());
                Type type = buildSymbol.type();
                DynamicFilterId id = Objects.requireNonNull((DynamicFilterId)buildSymbolToDynamicFilter.get((Object)buildSymbol), () -> "missing dynamic filter for symbol " + String.valueOf(buildSymbol));
                return DynamicFilters.createDynamicFilterExpression(this.metadata, id, type, probeExpression, comparison.operator(), clause.isNullAllowed());
            }).collect(ImmutableList.toImmutableList());
            return new DynamicFiltersResult((Map<DynamicFilterId, Symbol>)buildSymbolToDynamicFilter.inverse(), predicates);
        }

        private static Stream<Expression> tryConvertBetweenIntoComparisons(Expression clause) {
            if (clause instanceof Between) {
                Between between = (Between)clause;
                return Stream.of(new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, between.value(), between.min()), new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, between.value(), between.max()));
            }
            return Stream.of(clause);
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression postJoinPredicate;
            Expression rightPredicate;
            Expression leftPredicate;
            Expression inheritedPredicate = context.get();
            if (node.getType() == SpatialJoinNode.Type.LEFT && this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate)) {
                node = new SpatialJoinNode(node.getId(), SpatialJoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getOutputSymbols(), node.getFilter(), node.getLeftPartitionSymbol(), node.getRightPartitionSymbol(), node.getKdbTree());
            }
            Expression leftEffectivePredicate = this.effectivePredicateExtractor.extract(this.session, node.getLeft());
            Expression rightEffectivePredicate = this.effectivePredicateExtractor.extract(this.session, node.getRight());
            Expression joinPredicate = node.getFilter();
            Expression newJoinPredicate = switch (node.getType()) {
                case SpatialJoinNode.Type.INNER -> {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    yield innerJoinPushDownResult.getJoinPredicate();
                }
                case SpatialJoinNode.Type.LEFT -> {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    yield leftOuterJoinPushDownResult.getJoinPredicate();
                }
                default -> throw new IllegalArgumentException("Unsupported spatial join type: " + String.valueOf((Object)node.getType()));
            };
            newJoinPredicate = this.simplifyExpression(newJoinPredicate);
            Verify.verify((!newJoinPredicate.equals(Booleans.FALSE) ? 1 : 0) != 0, (String)"Spatial join predicate is missing", (Object[])new Object[0]);
            PlanNode leftSource = context.rewrite(node.getLeft(), leftPredicate);
            PlanNode rightSource = context.rewrite(node.getRight(), rightPredicate);
            PlanNode output = node;
            if (leftSource != node.getLeft() || rightSource != node.getRight() || !newJoinPredicate.equals(joinPredicate)) {
                Assignments.Builder leftProjections = Assignments.builder();
                leftProjections.putAll((Map)node.getLeft().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
                Assignments.Builder rightProjections = Assignments.builder();
                rightProjections.putAll((Map)node.getRight().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
                leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, leftProjections.build());
                rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, rightProjections.build());
                output = new SpatialJoinNode(node.getId(), node.getType(), leftSource, rightSource, node.getOutputSymbols(), newJoinPredicate, node.getLeftPartitionSymbol(), node.getRightPartitionSymbol(), node.getKdbTree());
            }
            if (!postJoinPredicate.equals(Booleans.TRUE)) {
                output = new FilterNode(this.idAllocator.getNextId(), output, postJoinPredicate);
            }
            return output;
        }

        private Symbol symbolForExpression(Expression expression) {
            if (expression instanceof Reference) {
                return Symbol.from(expression);
            }
            return this.symbolAllocator.newSymbol(expression);
        }

        private OuterJoinPushDownResult processLimitedOuterJoin(Expression inheritedPredicate, Expression outerEffectivePredicate, Expression innerEffectivePredicate, Expression joinPredicate, Collection<Symbol> outerSymbols, Collection<Symbol> innerSymbols) {
            Preconditions.checkArgument((boolean)outerSymbols.containsAll(SymbolsExtractor.extractUnique(outerEffectivePredicate)), (Object)"outerEffectivePredicate must only contain symbols from outerSymbols");
            Preconditions.checkArgument((boolean)innerSymbols.containsAll(SymbolsExtractor.extractUnique(innerEffectivePredicate)), (Object)"innerEffectivePredicate must only contain symbols from innerSymbols");
            ImmutableList.Builder outerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder innerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder postJoinConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            IrUtils.extractConjuncts(inheritedPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression)).forEach(arg_0 -> ((ImmutableList.Builder)postJoinConjuncts).add(arg_0));
            inheritedPredicate = IrUtils.filterDeterministicConjuncts(inheritedPredicate);
            outerEffectivePredicate = IrUtils.filterDeterministicConjuncts(outerEffectivePredicate);
            innerEffectivePredicate = IrUtils.filterDeterministicConjuncts(innerEffectivePredicate);
            IrUtils.extractConjuncts(joinPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression)).forEach(arg_0 -> ((ImmutableList.Builder)joinConjuncts).add(arg_0));
            joinPredicate = IrUtils.filterDeterministicConjuncts(joinPredicate);
            EqualityInference inheritedInference = new EqualityInference(inheritedPredicate);
            EqualityInference outerInference = new EqualityInference(inheritedPredicate, outerEffectivePredicate);
            ImmutableSet innerScope = ImmutableSet.copyOf(innerSymbols);
            ImmutableSet outerScope = ImmutableSet.copyOf(outerSymbols);
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((Set<Symbol>)outerScope);
            Expression outerOnlyInheritedEqualities = IrUtils.combineConjuncts(equalityPartition.getScopeEqualities());
            EqualityInference potentialNullSymbolInference = new EqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, innerEffectivePredicate, joinPredicate);
            EqualityInference potentialNullSymbolInferenceWithoutInnerInferred = new EqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, joinPredicate);
            innerPushdownConjuncts.addAll(potentialNullSymbolInferenceWithoutInnerInferred.generateEqualitiesPartitionedBy((Set<Symbol>)innerScope).getScopeEqualities());
            EqualityInference.EqualityPartition joinEqualityPartition = new EqualityInference(joinPredicate).generateEqualitiesPartitionedBy((Set<Symbol>)innerScope);
            innerPushdownConjuncts.addAll(joinEqualityPartition.getScopeEqualities());
            joinConjuncts.addAll(joinEqualityPartition.getScopeComplementEqualities()).addAll(joinEqualityPartition.getScopeStraddlingEqualities());
            outerPushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            EqualityInference.nonInferrableConjuncts(inheritedPredicate).forEach(arg_0 -> Rewriter.lambda$processLimitedOuterJoin$26(outerInference, (Set)outerScope, outerPushdownConjuncts, potentialNullSymbolInference, (Set)innerScope, innerPushdownConjuncts, postJoinConjuncts, arg_0));
            EqualityInference.nonInferrableConjuncts(outerEffectivePredicate).map(arg_0 -> Rewriter.lambda$processLimitedOuterJoin$27(potentialNullSymbolInference, (Set)innerScope, arg_0)).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)innerPushdownConjuncts).add(arg_0));
            EqualityInference.nonInferrableConjuncts(joinPredicate).forEach(arg_0 -> Rewriter.lambda$processLimitedOuterJoin$28(potentialNullSymbolInference, (Set)innerScope, innerPushdownConjuncts, joinConjuncts, arg_0));
            return new OuterJoinPushDownResult(IrUtils.combineConjuncts((Collection<Expression>)outerPushdownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)innerPushdownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)postJoinConjuncts.build()));
        }

        private InnerJoinPushDownResult processInnerJoin(Expression inheritedPredicate, Expression leftEffectivePredicate, Expression rightEffectivePredicate, Expression joinPredicate, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
            Preconditions.checkArgument((boolean)leftSymbols.containsAll(SymbolsExtractor.extractUnique(leftEffectivePredicate)), (Object)"leftEffectivePredicate must only contain symbols from leftSymbols");
            Preconditions.checkArgument((boolean)rightSymbols.containsAll(SymbolsExtractor.extractUnique(rightEffectivePredicate)), (Object)"rightEffectivePredicate must only contain symbols from rightSymbols");
            ArrayList<Expression> nonDeterministic = new ArrayList<Expression>();
            ArrayList<Expression> candidates = new ArrayList<Expression>();
            ArrayList<Expression> residuals = new ArrayList<Expression>();
            ArrayList<Expression> mayFail = new ArrayList<Expression>();
            for (Expression predicate : List.of(joinPredicate, inheritedPredicate)) {
                List<Expression> conjuncts = IrUtils.extractConjuncts(predicate);
                for (Expression conjunct2 : conjuncts) {
                    if (!DeterminismEvaluator.isDeterministic(conjunct2)) {
                        nonDeterministic.add(conjunct2);
                        continue;
                    }
                    if (IrExpressions.mayFail(this.plannerContext, conjunct2)) {
                        mayFail.add(conjunct2);
                        continue;
                    }
                    if (EqualityInference.isInferenceCandidate(conjunct2)) {
                        candidates.add(conjunct2);
                        continue;
                    }
                    residuals.add(conjunct2);
                }
            }
            List<Expression> leftConjuncts = IrUtils.extractConjuncts(leftEffectivePredicate).stream().filter(expression -> !IrExpressions.mayFail(this.plannerContext, expression) && DeterminismEvaluator.isDeterministic(expression)).toList();
            List<Expression> leftCandidates = leftConjuncts.stream().filter(EqualityInference::isInferenceCandidate).toList();
            List<Expression> leftResiduals = leftConjuncts.stream().filter(conjunct -> !EqualityInference.isInferenceCandidate(conjunct)).toList();
            List<Expression> rightConjuncts = IrUtils.extractConjuncts(rightEffectivePredicate).stream().filter(expression -> !IrExpressions.mayFail(this.plannerContext, expression) && DeterminismEvaluator.isDeterministic(expression)).toList();
            List<Expression> rightCandidates = rightConjuncts.stream().filter(EqualityInference::isInferenceCandidate).toList();
            List<Expression> rightResiduals = rightConjuncts.stream().filter(conjunct -> !EqualityInference.isInferenceCandidate(conjunct)).toList();
            ImmutableSet leftScope = ImmutableSet.copyOf(leftSymbols);
            ImmutableSet rightScope = ImmutableSet.copyOf(rightSymbols);
            EqualityInference allInference = new EqualityInference((Collection<Expression>)ImmutableList.builder().addAll(candidates).addAll(leftCandidates).addAll(rightCandidates).build());
            EqualityInference inferenceWithoutLeft = new EqualityInference((Collection<Expression>)ImmutableList.builder().addAll(candidates).addAll(rightCandidates).build());
            EqualityInference inferenceWithoutRight = new EqualityInference((Collection<Expression>)ImmutableList.builder().addAll(candidates).addAll(leftCandidates).build());
            ImmutableList.Builder leftPushDownConjuncts = ImmutableList.builder().addAll(inferenceWithoutLeft.generateEqualitiesPartitionedBy((Set<Symbol>)leftScope).getScopeEqualities()).addAll(rightResiduals.stream().map(conjunct -> allInference.rewrite((Expression)conjunct, (Set<Symbol>)leftScope)).filter(Objects::nonNull).toList());
            ImmutableList.Builder rightPushDownConjuncts = ImmutableList.builder().addAll(inferenceWithoutRight.generateEqualitiesPartitionedBy((Set<Symbol>)rightScope).getScopeEqualities()).addAll(leftResiduals.stream().map(conjunct -> allInference.rewrite((Expression)conjunct, (Set<Symbol>)rightScope)).filter(Objects::nonNull).toList());
            ImmutableList.Builder joinConjuncts = ImmutableList.builder().addAll(allInference.generateEqualitiesPartitionedBy((Set<Symbol>)leftScope).getScopeStraddlingEqualities()).addAll(nonDeterministic);
            residuals.forEach(conjunct -> {
                Expression rightRewrittenConjunct;
                Expression leftRewrittenConjunct = allInference.rewrite((Expression)conjunct, (Set<Symbol>)leftScope);
                if (leftRewrittenConjunct != null) {
                    leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
                }
                if ((rightRewrittenConjunct = allInference.rewrite((Expression)conjunct, (Set<Symbol>)rightScope)) != null) {
                    rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
                }
                if (leftRewrittenConjunct == null && rightRewrittenConjunct == null) {
                    joinConjuncts.add((Object)allInference.rewrite((Expression)conjunct, (Set<Symbol>)Sets.union((Set)leftScope, (Set)rightScope)));
                }
            });
            boolean doNotPush = !IrUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()).equals(Booleans.TRUE);
            for (Expression conjunct3 : mayFail) {
                Expression rightRewrittenConjunct;
                if (doNotPush) {
                    joinConjuncts.add((Object)allInference.rewrite(conjunct3, (Set<Symbol>)Sets.union((Set)leftScope, (Set)rightScope)));
                    continue;
                }
                Expression leftRewrittenConjunct = allInference.rewrite(conjunct3, (Set<Symbol>)leftScope);
                if (leftRewrittenConjunct != null) {
                    leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
                }
                if ((rightRewrittenConjunct = allInference.rewrite(conjunct3, (Set<Symbol>)rightScope)) != null) {
                    rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
                }
                if (leftRewrittenConjunct != null || rightRewrittenConjunct != null) continue;
                joinConjuncts.add((Object)allInference.rewrite(conjunct3, (Set<Symbol>)Sets.union((Set)leftScope, (Set)rightScope)));
                doNotPush = true;
            }
            return new InnerJoinPushDownResult(IrUtils.combineConjuncts((Collection<Expression>)leftPushDownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)rightPushDownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()), Booleans.TRUE);
        }

        private Expression extractJoinPredicate(JoinNode joinNode) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
                builder.add((Object)equiJoinClause.toExpression());
            }
            joinNode.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return IrUtils.combineConjuncts((Collection<Expression>)builder.build());
        }

        private JoinNode tryNormalizeToOuterToInnerJoin(JoinNode node, Expression inheritedPredicate) {
            Preconditions.checkArgument((boolean)EnumSet.of(JoinType.INNER, JoinType.RIGHT, JoinType.LEFT, JoinType.FULL).contains((Object)node.getType()), (String)"Unsupported join type: %s", (Object)((Object)node.getType()));
            if (node.getType() == JoinType.INNER) {
                return node;
            }
            if (node.getType() == JoinType.FULL) {
                boolean canConvertToLeftJoin = this.canConvertOuterToInner(node.getLeft().getOutputSymbols(), inheritedPredicate);
                boolean canConvertToRightJoin = this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate);
                if (!canConvertToLeftJoin && !canConvertToRightJoin) {
                    return node;
                }
                if (canConvertToLeftJoin && canConvertToRightJoin) {
                    return new JoinNode(node.getId(), JoinType.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.isMaySkipOutputDuplicates(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), node.getDistributionType(), node.isSpillable(), node.getDynamicFilters(), node.getReorderJoinStatsAndCost());
                }
                return new JoinNode(node.getId(), canConvertToLeftJoin ? JoinType.LEFT : JoinType.RIGHT, node.getLeft(), node.getRight(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.isMaySkipOutputDuplicates(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), node.getDistributionType(), node.isSpillable(), node.getDynamicFilters(), node.getReorderJoinStatsAndCost());
            }
            if (node.getType() == JoinType.LEFT && !this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate) || node.getType() == JoinType.RIGHT && !this.canConvertOuterToInner(node.getLeft().getOutputSymbols(), inheritedPredicate)) {
                return node;
            }
            return new JoinNode(node.getId(), JoinType.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.isMaySkipOutputDuplicates(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), node.getDistributionType(), node.isSpillable(), node.getDynamicFilters(), node.getReorderJoinStatsAndCost());
        }

        private boolean canConvertOuterToInner(List<Symbol> innerSymbolsForOuterJoin, Expression inheritedPredicate) {
            ImmutableSet innerSymbols = ImmutableSet.copyOf(innerSymbolsForOuterJoin);
            for (Expression conjunct : IrUtils.extractConjuncts(inheritedPredicate)) {
                Constant constant;
                Expression response;
                if (!DeterminismEvaluator.isDeterministic(conjunct) || !((response = this.nullInputEvaluator((Collection<Symbol>)innerSymbols, conjunct)) instanceof Constant) || (constant = (Constant)response).value() != null && !Boolean.FALSE.equals(constant.value())) continue;
                return true;
            }
            return false;
        }

        private Expression simplifyExpression(Expression expression) {
            return this.optimizer.process(expression, this.session, (Map<Symbol, Expression>)ImmutableMap.of()).orElse(expression);
        }

        private Expression nullInputEvaluator(Collection<Symbol> nullSymbols, Expression expression) {
            Map<Symbol, Expression> inputs = nullSymbols.stream().collect(Collectors.toMap(symbol -> symbol, symbol -> new Constant(symbol.type(), null)));
            return this.optimizer.process(expression, this.session, inputs).orElse(expression);
        }

        private boolean joinEqualityExpression(Expression expression, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
            Comparison comparison;
            if (expression instanceof Comparison && (comparison = (Comparison)expression).operator() == Comparison.Operator.EQUAL && DeterminismEvaluator.isDeterministic(expression)) {
                Set<Symbol> symbols1 = SymbolsExtractor.extractUnique(comparison.left());
                Set<Symbol> symbols2 = SymbolsExtractor.extractUnique(comparison.right());
                if (symbols1.isEmpty() || symbols2.isEmpty()) {
                    return false;
                }
                return leftSymbols.containsAll(symbols1) && rightSymbols.containsAll(symbols2) || rightSymbols.containsAll(symbols1) && leftSymbols.containsAll(symbols2);
            }
            return false;
        }

        private boolean joinDynamicFilteringExpression(Expression expression, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
            Object right;
            Object left;
            Comparison.Operator operator;
            block11: {
                block10: {
                    Object object;
                    if (!(expression instanceof Comparison)) break block10;
                    Comparison comparison = (Comparison)expression;
                    try {
                        object = comparison.operator();
                        operator = object;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    left = object = comparison.left();
                    right = object = comparison.right();
                    if (DeterminismEvaluator.isDeterministic(expression)) break block11;
                }
                return false;
            }
            Set<Symbol> symbols1 = SymbolsExtractor.extractUnique((Expression)left);
            Set<Symbol> symbols2 = SymbolsExtractor.extractUnique((Expression)right);
            if (symbols1.isEmpty() || symbols2.isEmpty()) {
                return false;
            }
            if (!(leftSymbols.containsAll(symbols1) && rightSymbols.containsAll(symbols2) || rightSymbols.containsAll(symbols1) && leftSymbols.containsAll(symbols2))) {
                return false;
            }
            if (operator == Comparison.Operator.IDENTICAL ? left.type().equals((Object)RealType.REAL) || right.type().equals((Object)RealType.REAL) || left.type().equals((Object)DoubleType.DOUBLE) || right.type().equals((Object)DoubleType.DOUBLE) : !DYNAMIC_FILTERING_SUPPORTED_COMPARISONS.contains((Object)operator)) {
                return false;
            }
            return right instanceof Reference && rightSymbols.contains(Symbol.from((Expression)right)) || left instanceof Reference && rightSymbols.contains(Symbol.from((Expression)left));
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            if (!IrUtils.extractConjuncts(inheritedPredicate).contains(node.getSemiJoinOutput().toSymbolReference())) {
                return this.visitNonFilteringSemiJoin(node, context);
            }
            return this.visitFilteringSemiJoin(node, context);
        }

        private PlanNode visitNonFilteringSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            ArrayList<Expression> sourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postJoinConjuncts = new ArrayList<Expression>();
            PlanNode rewrittenFilteringSource = context.defaultRewrite(node.getFilteringSource(), Booleans.TRUE);
            ImmutableSet sourceScope = ImmutableSet.copyOf(node.getSource().getOutputSymbols());
            EqualityInference inheritedInference = new EqualityInference(inheritedPredicate);
            EqualityInference.nonInferrableConjuncts(inheritedPredicate).forEach(conjunct -> {
                Expression rewrittenConjunct = inheritedInference.rewrite((Expression)conjunct, (Set<Symbol>)sourceScope);
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                } else {
                    postJoinConjuncts.add((Expression)conjunct);
                }
            });
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((Set<Symbol>)sourceScope);
            sourceConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), IrUtils.combineConjuncts(sourceConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource()) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol(), node.getDistributionType(), Optional.empty());
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, IrUtils.combineConjuncts(postJoinConjuncts));
            }
            return output;
        }

        private PlanNode visitFilteringSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            Expression deterministicInheritedPredicate = IrUtils.filterDeterministicConjuncts(inheritedPredicate);
            Expression sourceEffectivePredicate = IrUtils.filterDeterministicConjuncts(this.effectivePredicateExtractor.extract(this.session, node.getSource()));
            Expression filteringSourceEffectivePredicate = IrUtils.filterDeterministicConjuncts(this.effectivePredicateExtractor.extract(this.session, node.getFilteringSource()));
            Comparison joinExpression = new Comparison(Comparison.Operator.EQUAL, node.getSourceJoinSymbol().toSymbolReference(), node.getFilteringSourceJoinSymbol().toSymbolReference());
            List<Symbol> sourceSymbols = node.getSource().getOutputSymbols();
            List<Symbol> filteringSourceSymbols = node.getFilteringSource().getOutputSymbols();
            ArrayList<Expression> sourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> filteringSourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postJoinConjuncts = new ArrayList<Expression>();
            EqualityInference allInference = new EqualityInference(deterministicInheritedPredicate, sourceEffectivePredicate, filteringSourceEffectivePredicate, joinExpression);
            EqualityInference allInferenceWithoutSourceInferred = new EqualityInference(deterministicInheritedPredicate, filteringSourceEffectivePredicate, joinExpression);
            EqualityInference allInferenceWithoutFilteringSourceInferred = new EqualityInference(deterministicInheritedPredicate, sourceEffectivePredicate, joinExpression);
            ImmutableSet sourceScope = ImmutableSet.copyOf(sourceSymbols);
            EqualityInference.nonInferrableConjuncts(inheritedPredicate).forEach(arg_0 -> Rewriter.lambda$visitFilteringSemiJoin$39(allInference, (Set)sourceScope, sourceConjuncts, postJoinConjuncts, arg_0));
            ImmutableSet filterScope = ImmutableSet.copyOf(filteringSourceSymbols);
            EqualityInference.nonInferrableConjuncts(deterministicInheritedPredicate).forEach(arg_0 -> Rewriter.lambda$visitFilteringSemiJoin$40(allInference, (Set)filterScope, filteringSourceConjuncts, arg_0));
            EqualityInference.nonInferrableConjuncts(filteringSourceEffectivePredicate).map(arg_0 -> Rewriter.lambda$visitFilteringSemiJoin$41(allInference, (Set)sourceScope, arg_0)).filter(Objects::nonNull).forEach(sourceConjuncts::add);
            EqualityInference.nonInferrableConjuncts(sourceEffectivePredicate).map(arg_0 -> Rewriter.lambda$visitFilteringSemiJoin$42(allInference, (Set)filterScope, arg_0)).filter(Objects::nonNull).forEach(filteringSourceConjuncts::add);
            sourceConjuncts.addAll(allInferenceWithoutSourceInferred.generateEqualitiesPartitionedBy((Set<Symbol>)sourceScope).getScopeEqualities());
            filteringSourceConjuncts.addAll(allInferenceWithoutFilteringSourceInferred.generateEqualitiesPartitionedBy((Set<Symbol>)filterScope).getScopeEqualities());
            Optional<DynamicFilterId> dynamicFilterId = node.getDynamicFilterId();
            if (dynamicFilterId.isEmpty() && SystemSessionProperties.isEnableDynamicFiltering(this.session) && this.dynamicFiltering) {
                dynamicFilterId = Optional.of(new DynamicFilterId("df_" + this.idAllocator.getNextId().toString()));
                Symbol sourceSymbol = node.getSourceJoinSymbol();
                sourceConjuncts.add(DynamicFilters.createDynamicFilterExpression(this.metadata, dynamicFilterId.get(), sourceSymbol.type(), sourceSymbol.toSymbolReference(), Comparison.Operator.EQUAL));
            }
            PlanNode rewrittenSource = context.rewrite(node.getSource(), IrUtils.combineConjuncts(sourceConjuncts));
            PlanNode rewrittenFilteringSource = context.rewrite(node.getFilteringSource(), IrUtils.combineConjuncts(filteringSourceConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource() || !dynamicFilterId.equals(node.getDynamicFilterId())) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol(), node.getDistributionType(), dynamicFilterId);
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, IrUtils.combineConjuncts(postJoinConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            if (node.hasEmptyGroupingSet()) {
                return this.visitPlan((PlanNode)node, context);
            }
            Expression inheritedPredicate = context.get();
            EqualityInference equalityInference = new EqualityInference(inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postAggregationConjuncts = new ArrayList<Expression>();
            IrUtils.extractConjuncts(inheritedPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression)).forEach(postAggregationConjuncts::add);
            inheritedPredicate = IrUtils.filterDeterministicConjuncts(inheritedPredicate);
            ImmutableSet groupingKeys = ImmutableSet.copyOf(node.getGroupingKeys());
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((Set<Symbol>)groupingKeys);
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            EqualityInference.nonInferrableConjuncts(inheritedPredicate).forEach(arg_0 -> Rewriter.lambda$visitAggregation$44(node, postAggregationConjuncts, equalityInference, (Set)groupingKeys, pushdownConjuncts, arg_0));
            PlanNode rewrittenSource = context.rewrite(node.getSource(), IrUtils.combineConjuncts(pushdownConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = AggregationNode.builderFrom(node).setSource(rewrittenSource).setPreGroupedSymbols((List<Symbol>)ImmutableList.of()).build();
            }
            if (!postAggregationConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, IrUtils.combineConjuncts(postAggregationConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            if (node.getJoinType() == JoinType.RIGHT || node.getJoinType() == JoinType.FULL) {
                return new FilterNode(this.idAllocator.getNextId(), node, inheritedPredicate);
            }
            EqualityInference equalityInference = new EqualityInference(inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postUnnestConjuncts = new ArrayList<Expression>();
            IrUtils.extractConjuncts(inheritedPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression)).forEach(postUnnestConjuncts::add);
            inheritedPredicate = IrUtils.filterDeterministicConjuncts(inheritedPredicate);
            ImmutableSet replicatedSymbols = ImmutableSet.copyOf(node.getReplicateSymbols());
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((Set<Symbol>)replicatedSymbols);
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            EqualityInference.nonInferrableConjuncts(inheritedPredicate).forEach(arg_0 -> Rewriter.lambda$visitUnnest$46(equalityInference, (Set)replicatedSymbols, pushdownConjuncts, postUnnestConjuncts, arg_0));
            PlanNode rewrittenSource = context.rewrite(node.getSource(), IrUtils.combineConjuncts(pushdownConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new UnnestNode(node.getId(), rewrittenSource, node.getReplicateSymbols(), node.getMappings(), node.getOrdinalitySymbol(), node.getJoinType());
            }
            if (!postUnnestConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, IrUtils.combineConjuncts(postUnnestConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression predicate = this.simplifyExpression(context.get());
            if (!Booleans.TRUE.equals(predicate)) {
                return new FilterNode(this.idAllocator.getNextId(), node, predicate);
            }
            return node;
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Set<Symbol> predicateSymbols = SymbolsExtractor.extractUnique(context.get());
            Preconditions.checkState((!predicateSymbols.contains(node.getIdColumn()) ? 1 : 0) != 0, (Object)"UniqueId in predicate is not yet supported");
            return context.defaultRewrite(node, context.get());
        }

        private static /* synthetic */ void lambda$visitUnnest$46(EqualityInference equalityInference, Set replicatedSymbols, List pushdownConjuncts, List postUnnestConjuncts, Expression conjunct) {
            Expression rewrittenConjunct = equalityInference.rewrite(conjunct, replicatedSymbols);
            if (rewrittenConjunct != null) {
                pushdownConjuncts.add(rewrittenConjunct);
            } else {
                postUnnestConjuncts.add(conjunct);
            }
        }

        private static /* synthetic */ void lambda$visitAggregation$44(AggregationNode node, List postAggregationConjuncts, EqualityInference equalityInference, Set groupingKeys, List pushdownConjuncts, Expression conjunct) {
            if (node.getGroupIdSymbol().isPresent() && SymbolsExtractor.extractUnique(conjunct).contains(node.getGroupIdSymbol().get())) {
                postAggregationConjuncts.add(conjunct);
            } else {
                Expression rewrittenConjunct = equalityInference.rewrite(conjunct, groupingKeys);
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                } else {
                    postAggregationConjuncts.add(conjunct);
                }
            }
        }

        private static /* synthetic */ Expression lambda$visitFilteringSemiJoin$42(EqualityInference allInference, Set filterScope, Expression conjunct) {
            return allInference.rewrite(conjunct, filterScope);
        }

        private static /* synthetic */ Expression lambda$visitFilteringSemiJoin$41(EqualityInference allInference, Set sourceScope, Expression conjunct) {
            return allInference.rewrite(conjunct, sourceScope);
        }

        private static /* synthetic */ void lambda$visitFilteringSemiJoin$40(EqualityInference allInference, Set filterScope, List filteringSourceConjuncts, Expression conjunct) {
            Expression rewrittenConjunct = allInference.rewrite(conjunct, filterScope);
            if (rewrittenConjunct != null) {
                filteringSourceConjuncts.add(rewrittenConjunct);
            }
        }

        private static /* synthetic */ void lambda$visitFilteringSemiJoin$39(EqualityInference allInference, Set sourceScope, List sourceConjuncts, List postJoinConjuncts, Expression conjunct) {
            Expression rewrittenConjunct = allInference.rewrite(conjunct, sourceScope);
            if (rewrittenConjunct != null) {
                sourceConjuncts.add(rewrittenConjunct);
            } else {
                postJoinConjuncts.add(conjunct);
            }
        }

        private static /* synthetic */ void lambda$processLimitedOuterJoin$28(EqualityInference potentialNullSymbolInference, Set innerScope, ImmutableList.Builder innerPushdownConjuncts, ImmutableList.Builder joinConjuncts, Expression conjunct) {
            Expression innerRewritten = potentialNullSymbolInference.rewrite(conjunct, innerScope);
            if (innerRewritten != null) {
                innerPushdownConjuncts.add((Object)innerRewritten);
            } else {
                joinConjuncts.add((Object)conjunct);
            }
        }

        private static /* synthetic */ Expression lambda$processLimitedOuterJoin$27(EqualityInference potentialNullSymbolInference, Set innerScope, Expression conjunct) {
            return potentialNullSymbolInference.rewrite(conjunct, innerScope);
        }

        private static /* synthetic */ void lambda$processLimitedOuterJoin$26(EqualityInference outerInference, Set outerScope, ImmutableList.Builder outerPushdownConjuncts, EqualityInference potentialNullSymbolInference, Set innerScope, ImmutableList.Builder innerPushdownConjuncts, ImmutableList.Builder postJoinConjuncts, Expression conjunct) {
            Expression outerRewritten = outerInference.rewrite(conjunct, outerScope);
            if (outerRewritten != null) {
                outerPushdownConjuncts.add((Object)outerRewritten);
                Expression innerRewritten = potentialNullSymbolInference.rewrite(outerRewritten, innerScope);
                if (innerRewritten != null) {
                    innerPushdownConjuncts.add((Object)innerRewritten);
                }
            } else {
                postJoinConjuncts.add((Object)conjunct);
            }
        }

        private static /* synthetic */ boolean lambda$visitMarkDistinct$12(Set pushDownableSymbols, Expression conjunct) {
            return pushDownableSymbols.containsAll(SymbolsExtractor.extractUnique(conjunct));
        }

        private static class InnerJoinPushDownResult {
            private final Expression leftPredicate;
            private final Expression rightPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private InnerJoinPushDownResult(Expression leftPredicate, Expression rightPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.leftPredicate = leftPredicate;
                this.rightPredicate = rightPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getLeftPredicate() {
                return this.leftPredicate;
            }

            private Expression getRightPredicate() {
                return this.rightPredicate;
            }

            private Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }

        private static class OuterJoinPushDownResult {
            private final Expression outerJoinPredicate;
            private final Expression innerJoinPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private OuterJoinPushDownResult(Expression outerJoinPredicate, Expression innerJoinPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.outerJoinPredicate = outerJoinPredicate;
                this.innerJoinPredicate = innerJoinPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getOuterJoinPredicate() {
                return this.outerJoinPredicate;
            }

            private Expression getInnerJoinPredicate() {
                return this.innerJoinPredicate;
            }

            public Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }

        private static class DynamicFiltersResult {
            private final Map<DynamicFilterId, Symbol> dynamicFilters;
            private final List<Expression> predicates;

            public DynamicFiltersResult(Map<DynamicFilterId, Symbol> dynamicFilters, List<Expression> predicates) {
                this.dynamicFilters = ImmutableMap.copyOf(dynamicFilters);
                this.predicates = ImmutableList.copyOf(predicates);
            }

            public Map<DynamicFilterId, Symbol> getDynamicFilters() {
                return this.dynamicFilters;
            }

            public List<Expression> getPredicates() {
                return this.predicates;
            }
        }

        private static class DynamicFilterExpression {
            private final Comparison comparison;
            private final boolean nullAllowed;

            private DynamicFilterExpression(Comparison comparison) {
                this(comparison, false);
            }

            private DynamicFilterExpression(Comparison comparison, boolean nullAllowed) {
                this.comparison = Objects.requireNonNull(comparison, "comparison is null");
                this.nullAllowed = nullAllowed;
            }

            public Comparison getComparison() {
                return this.comparison;
            }

            public boolean isNullAllowed() {
                return this.nullAllowed;
            }
        }
    }
}

