/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.partial;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.CompletedWork;
import io.trino.operator.Work;
import io.trino.operator.WorkProcessor;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.operator.aggregation.GroupedAggregator;
import io.trino.operator.aggregation.builder.HashAggregationBuilder;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SkipAggregationBuilder
implements HashAggregationBuilder {
    private final LocalMemoryContext memoryContext;
    private final List<AggregatorFactory> aggregatorFactories;
    @Nullable
    private Page currentPage;
    private final int[] hashChannels;

    public SkipAggregationBuilder(List<Integer> groupByChannels, Optional<Integer> inputHashChannel, List<AggregatorFactory> aggregatorFactories, LocalMemoryContext memoryContext) {
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
        this.aggregatorFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(aggregatorFactories, "aggregatorFactories is null"));
        this.hashChannels = new int[groupByChannels.size() + (inputHashChannel.isPresent() ? 1 : 0)];
        for (int i = 0; i < groupByChannels.size(); ++i) {
            this.hashChannels[i] = groupByChannels.get(i);
        }
        inputHashChannel.ifPresent(channelIndex -> {
            this.hashChannels[groupByChannels.size()] = channelIndex;
        });
    }

    @Override
    public Work<?> processPage(Page page) {
        Preconditions.checkArgument((this.currentPage == null ? 1 : 0) != 0);
        this.currentPage = page;
        return new CompletedWork();
    }

    @Override
    public WorkProcessor<Page> buildResult() {
        if (this.currentPage == null) {
            return WorkProcessor.of(new Page[0]);
        }
        Page result = this.buildOutputPage(this.currentPage);
        this.currentPage = null;
        return WorkProcessor.of(result);
    }

    @Override
    public boolean isFull() {
        return this.currentPage != null;
    }

    @Override
    public void updateMemory() {
        if (this.currentPage != null) {
            this.memoryContext.setBytes(this.currentPage.getSizeInBytes());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public ListenableFuture<Void> startMemoryRevoke() {
        throw new UnsupportedOperationException("startMemoryRevoke not supported for SkipAggregationBuilder");
    }

    @Override
    public void finishMemoryRevoke() {
        throw new UnsupportedOperationException("finishMemoryRevoke not supported for SkipAggregationBuilder");
    }

    private Page buildOutputPage(Page page) {
        Block[] outputBlocks = new Block[this.hashChannels.length + this.aggregatorFactories.size()];
        for (int i = 0; i < this.hashChannels.length; ++i) {
            outputBlocks[i] = page.getBlock(this.hashChannels[i]);
        }
        int positionCount = page.getPositionCount();
        int[] groupIds = new int[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            groupIds[position] = position;
        }
        for (int i = 0; i < this.aggregatorFactories.size(); ++i) {
            GroupedAggregator groupedAggregator = this.aggregatorFactories.get(i).createGroupedAggregator();
            groupedAggregator.processPage(positionCount, groupIds, page);
            BlockBuilder outputBuilder = groupedAggregator.getType().createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                groupedAggregator.evaluate(position, outputBuilder);
            }
            groupedAggregator = null;
            outputBlocks[this.hashChannels.length + i] = outputBuilder.build();
        }
        return new Page(positionCount, outputBlocks);
    }
}

