/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.BooleanToBooleanFunction;
import io.trino.operator.scalar.DoubleToBooleanFunction;
import io.trino.operator.scalar.LongToBooleanFunction;
import io.trino.operator.scalar.ObjectToBooleanFunction;
import io.trino.spi.block.Block;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameterSpecialization;
import io.trino.spi.type.Type;

@Description(value="Return array containing elements that match the given predicate")
@ScalarFunction(value="filter")
public final class ArrayFilterFunction {
    private ArrayFilterFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="array(T)")
    public static Block filterLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") LongToBooleanFunction function) {
        int positionCount = arrayBlock.getPositionCount();
        int[] positions = new int[positionCount];
        int length = 0;
        for (int position = 0; position < positionCount; ++position) {
            Long input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getLong(arrayBlock, position);
            }
            Boolean keep = function.apply(input);
            positions[length] = position;
            length += Boolean.TRUE.equals(keep) ? 1 : 0;
        }
        if (positions.length == length) {
            return arrayBlock;
        }
        return arrayBlock.copyPositions(positions, 0, length);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="array(T)")
    public static Block filterDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") DoubleToBooleanFunction function) {
        int positionCount = arrayBlock.getPositionCount();
        int[] positions = new int[positionCount];
        int length = 0;
        for (int position = 0; position < positionCount; ++position) {
            Double input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getDouble(arrayBlock, position);
            }
            Boolean keep = function.apply(input);
            positions[length] = position;
            length += Boolean.TRUE.equals(keep) ? 1 : 0;
        }
        if (positions.length == length) {
            return arrayBlock;
        }
        return arrayBlock.copyPositions(positions, 0, length);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="array(T)")
    public static Block filterBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BooleanToBooleanFunction function) {
        int positionCount = arrayBlock.getPositionCount();
        int[] positions = new int[positionCount];
        int length = 0;
        for (int position = 0; position < positionCount; ++position) {
            Boolean input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getBoolean(arrayBlock, position);
            }
            Boolean keep = function.apply(input);
            positions[length] = position;
            length += Boolean.TRUE.equals(keep) ? 1 : 0;
        }
        if (positions.length == length) {
            return arrayBlock;
        }
        return arrayBlock.copyPositions(positions, 0, length);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Object.class)
    @SqlType(value="array(T)")
    public static Block filterObject(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") ObjectToBooleanFunction function) {
        int positionCount = arrayBlock.getPositionCount();
        int[] positions = new int[positionCount];
        int length = 0;
        for (int position = 0; position < positionCount; ++position) {
            Object input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getObject(arrayBlock, position);
            }
            Boolean keep = function.apply(input);
            positions[length] = position;
            length += Boolean.TRUE.equals(keep) ? 1 : 0;
        }
        if (positions.length == length) {
            return arrayBlock;
        }
        return arrayBlock.copyPositions(positions, 0, length);
    }
}

