/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonSerialize
public record Coalesce(List<Expression> operands) implements Expression
{
    public Coalesce(Expression first, Expression second, Expression ... additional) {
        this((List<Expression>)ImmutableList.builder().add((Object[])new Expression[]{first, second}).add((Object[])additional).build());
    }

    public Coalesce {
        Preconditions.checkArgument((operands.size() >= 2 ? 1 : 0) != 0, (Object)"must have at least two operands");
        operands = ImmutableList.copyOf(operands);
        for (int i = 1; i < operands.size(); ++i) {
            IrUtils.validateType(((Expression)operands.getFirst()).type(), (Expression)operands.get(i));
        }
    }

    @Override
    public Type type() {
        return this.operands.getFirst().type();
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitCoalesce(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return this.operands;
    }

    @Override
    public String toString() {
        return "Coalesce(" + this.operands.stream().map((Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/trino/sql/ir/Expression;)Ljava/lang/String;)()).collect(Collectors.joining(", ")) + ")";
    }
}

