/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SpecializeTransformWithJsonParse
implements IrOptimizerRule {
    private final Metadata metadata;

    public SpecializeTransformWithJsonParse(PlannerContext context) {
        this.metadata = context.getMetadata();
    }

    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Call call;
        if (expression instanceof Call && (call = (Call)expression).function().name().getFunctionName().equals("transform")) {
            Call transformLambdaCall;
            Lambda transform;
            Call transformArrayCall;
            Expression expression2 = call.arguments().getFirst();
            if (!(expression2 instanceof Call) || !(transformArrayCall = (Call)expression2).function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("$internal$json_string_to_array_cast"))) {
                return Optional.empty();
            }
            Expression expression3 = call.arguments().getLast();
            if (expression3 instanceof Lambda && (expression3 = (transform = (Lambda)expression3).body()) instanceof Call && (transformLambdaCall = (Call)expression3).function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("json_extract_scalar"))) {
                Expression jsonData = transformArrayCall.arguments().getFirst();
                Constant jsonPath = (Constant)transformLambdaCall.arguments().getLast();
                Call newCall = new Call(this.metadata.resolveBuiltinFunction("$internal$json_string_array_extract_scalar", TypeSignatureProvider.fromTypes((List<? extends Type>)ImmutableList.of((Object)jsonData.type(), (Object)jsonPath.type()))), (List<Expression>)ImmutableList.of((Object)jsonData, (Object)jsonPath));
                return Optional.of(newCall);
            }
        }
        return Optional.empty();
    }
}

