/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import com.google.common.collect.ImmutableList;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.planner.rowpattern.ir.IrAlternation;
import io.trino.sql.planner.rowpattern.ir.IrAnchor;
import io.trino.sql.planner.rowpattern.ir.IrConcatenation;
import io.trino.sql.planner.rowpattern.ir.IrEmpty;
import io.trino.sql.planner.rowpattern.ir.IrExclusion;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrPermutation;
import io.trino.sql.planner.rowpattern.ir.IrQuantified;
import io.trino.sql.planner.rowpattern.ir.IrQuantifier;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.AnchorPattern;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.EmptyPattern;
import io.trino.sql.tree.ExcludedPattern;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.OneOrMoreQuantifier;
import io.trino.sql.tree.PatternAlternation;
import io.trino.sql.tree.PatternConcatenation;
import io.trino.sql.tree.PatternPermutation;
import io.trino.sql.tree.PatternQuantifier;
import io.trino.sql.tree.PatternVariable;
import io.trino.sql.tree.QuantifiedPattern;
import io.trino.sql.tree.RangeQuantifier;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.ZeroOrMoreQuantifier;
import io.trino.sql.tree.ZeroOrOneQuantifier;
import java.util.List;
import java.util.Objects;

public class RowPatternToIrRewriter
extends AstVisitor<IrRowPattern, Void> {
    private final Analysis analysis;

    public RowPatternToIrRewriter(Analysis analysis) {
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
    }

    public static IrRowPattern rewrite(RowPattern node, Analysis analysis) {
        return (IrRowPattern)new RowPatternToIrRewriter(analysis).process((Node)node);
    }

    protected IrRowPattern visitPatternAlternation(PatternAlternation node, Void context) {
        List patterns = (List)node.getPatterns().stream().map(arg_0 -> ((RowPatternToIrRewriter)this).process(arg_0)).collect(ImmutableList.toImmutableList());
        return new IrAlternation(patterns);
    }

    protected IrRowPattern visitPatternConcatenation(PatternConcatenation node, Void context) {
        List patterns = (List)node.getPatterns().stream().map(arg_0 -> ((RowPatternToIrRewriter)this).process(arg_0)).collect(ImmutableList.toImmutableList());
        return new IrConcatenation(patterns);
    }

    protected IrRowPattern visitQuantifiedPattern(QuantifiedPattern node, Void context) {
        IrRowPattern pattern = (IrRowPattern)this.process((Node)node.getPattern());
        IrQuantifier quantifier = this.rewritePatternQuantifier(node.getPatternQuantifier());
        return new IrQuantified(pattern, quantifier);
    }

    private IrQuantifier rewritePatternQuantifier(PatternQuantifier quantifier) {
        if (quantifier instanceof ZeroOrMoreQuantifier) {
            return IrQuantifier.zeroOrMore(quantifier.isGreedy());
        }
        if (quantifier instanceof OneOrMoreQuantifier) {
            return IrQuantifier.oneOrMore(quantifier.isGreedy());
        }
        if (quantifier instanceof ZeroOrOneQuantifier) {
            return IrQuantifier.zeroOrOne(quantifier.isGreedy());
        }
        if (quantifier instanceof RangeQuantifier) {
            Analysis.Range range = this.analysis.getRange((RangeQuantifier)quantifier);
            return IrQuantifier.range(range.getAtLeast(), range.getAtMost(), quantifier.isGreedy());
        }
        throw new IllegalStateException("unsupported pattern quantifier type: " + quantifier.getClass().getSimpleName());
    }

    protected IrRowPattern visitAnchorPattern(AnchorPattern node, Void context) {
        IrAnchor.Type type = switch (node.getType()) {
            default -> throw new MatchException(null, null);
            case AnchorPattern.Type.PARTITION_START -> IrAnchor.Type.PARTITION_START;
            case AnchorPattern.Type.PARTITION_END -> IrAnchor.Type.PARTITION_END;
        };
        return new IrAnchor(type);
    }

    protected IrRowPattern visitEmptyPattern(EmptyPattern node, Void context) {
        return new IrEmpty();
    }

    protected IrRowPattern visitExcludedPattern(ExcludedPattern node, Void context) {
        IrRowPattern pattern = (IrRowPattern)this.process((Node)node.getPattern());
        return new IrExclusion(pattern);
    }

    protected IrRowPattern visitPatternPermutation(PatternPermutation node, Void context) {
        List patterns = (List)node.getPatterns().stream().map(arg_0 -> ((RowPatternToIrRewriter)this).process(arg_0)).collect(ImmutableList.toImmutableList());
        return new IrPermutation(patterns);
    }

    protected IrRowPattern visitPatternVariable(PatternVariable node, Void context) {
        return new IrLabel(node.getName().getCanonicalValue());
    }
}

