/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.Int128ArrayBlockBuilder;
import io.trino.spi.block.IntArrayBlockBuilder;
import io.trino.spi.type.Int128;
import java.util.Optional;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInt128ArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Int128[] expectedValues = TestInt128ArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestInt128ArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Int128[] expectedValues = TestInt128ArrayBlock.alternatingNullValues(TestInt128ArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestInt128ArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Int128[] expectedValues = TestInt128ArrayBlock.createTestValue(100);
        Int128ArrayBlockBuilder emptyBlockBuilder = new Int128ArrayBlockBuilder(null, 0);
        Int128ArrayBlockBuilder blockBuilder = new Int128ArrayBlockBuilder(null, expectedValues.length);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
        TestInt128ArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assertions.assertThat((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        BlockBuilder blockBuilder = TestInt128ArrayBlock.createBlockBuilderWithValues(TestInt128ArrayBlock.createTestValue(100));
        Block block = blockBuilder.build();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            Assertions.assertThat((long)block.getEstimatedDataSizeForStats(i)).isEqualTo(16L);
        }
        Assertions.assertThat((long)new IntArrayBlockBuilder(null, 22).appendNull().build().getEstimatedDataSizeForStats(0)).isEqualTo(0L);
    }

    @Test
    public void testCompactBlock() {
        long[] longArray = new long[]{0L, 0L, 0L, 0L, 0L, 1L, 0L, 2L, 0L, 3L, 0L, 4L};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestInt128ArrayBlock.testCompactBlock((Block)new Int128ArrayBlock(0, Optional.empty(), new long[0]));
        TestInt128ArrayBlock.testCompactBlock((Block)new Int128ArrayBlock(valueIsNull.length, Optional.of(valueIsNull), longArray));
        TestInt128ArrayBlock.testNotCompactBlock((Block)new Int128ArrayBlock(valueIsNull.length - 2, Optional.of(valueIsNull), longArray));
    }

    private void assertFixedWithValues(Int128[] expectedValues) {
        Block block = TestInt128ArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Int128[] expectedValues) {
        Int128ArrayBlockBuilder blockBuilder = new Int128ArrayBlockBuilder(null, expectedValues.length);
        TestInt128ArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Int128[] expectedValues, BlockBuilder blockBuilder) {
        for (Int128 expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(expectedValue.getHigh(), expectedValue.getLow());
        }
    }

    private static Int128[] createTestValue(int positionCount) {
        Int128[] expectedValues = new Int128[positionCount];
        Random random = new Random(0L);
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = Int128.valueOf((long)random.nextLong(), (long)random.nextLong());
        }
        return expectedValues;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Assertions.assertThat((boolean)block.isNull(position)).isFalse();
        Assertions.assertThat((Comparable)((Int128ArrayBlock)block).getInt128(position)).isEqualTo(expectedValue);
    }
}

