/*
 * Decompiled with CFR 0.152.
 */
package io.trino.eventlistener;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.secrets.SecretsResolver;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestEventListenerManager {
    TestEventListenerManager() {
    }

    @Test
    public void testShutdownIsForwardedToListeners() {
        EventListenerManager eventListenerManager = new EventListenerManager(new EventListenerConfig(), new SecretsResolver((Map)ImmutableMap.of()));
        final AtomicBoolean wasCalled = new AtomicBoolean(false);
        EventListener listener = new EventListener(){

            public void shutdown() {
                wasCalled.set(true);
            }
        };
        eventListenerManager.addEventListener(listener);
        eventListenerManager.loadEventListeners();
        eventListenerManager.shutdown();
        Assertions.assertThat((boolean)wasCalled.get()).isTrue();
    }

    private static final class BlockingEventListener
    implements EventListener {
        private BlockingEventListener() {
        }

        public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
            try {
                Thread.sleep(100000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

