/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import io.trino.execution.buffer.PageCodecMarker;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPageCodecMarker {
    @Test
    public void testCompressionAndEncryptionMarkers() {
        byte compressed = PageCodecMarker.COMPRESSED.set(PageCodecMarker.none());
        byte encrypted = PageCodecMarker.ENCRYPTED.set(PageCodecMarker.none());
        byte compressedAndEncrypted = PageCodecMarker.ENCRYPTED.set(PageCodecMarker.COMPRESSED.set(PageCodecMarker.none()));
        Assertions.assertThat((boolean)PageCodecMarker.COMPRESSED.isSet(PageCodecMarker.none())).isFalse();
        Assertions.assertThat((boolean)PageCodecMarker.ENCRYPTED.isSet(PageCodecMarker.none())).isFalse();
        Assertions.assertThat((boolean)PageCodecMarker.COMPRESSED.isSet(compressed)).isTrue();
        Assertions.assertThat((boolean)PageCodecMarker.COMPRESSED.isSet(compressedAndEncrypted)).isTrue();
        Assertions.assertThat((boolean)PageCodecMarker.ENCRYPTED.isSet(encrypted)).isTrue();
        Assertions.assertThat((boolean)PageCodecMarker.ENCRYPTED.isSet(compressedAndEncrypted)).isTrue();
        Assertions.assertThat((byte)PageCodecMarker.COMPRESSED.unset(compressed)).isEqualTo(PageCodecMarker.none());
        Assertions.assertThat((byte)PageCodecMarker.ENCRYPTED.unset(encrypted)).isEqualTo(PageCodecMarker.none());
        Assertions.assertThat((boolean)PageCodecMarker.COMPRESSED.isSet(PageCodecMarker.COMPRESSED.unset(compressedAndEncrypted))).isFalse();
        Assertions.assertThat((boolean)PageCodecMarker.ENCRYPTED.isSet(PageCodecMarker.ENCRYPTED.unset(compressedAndEncrypted))).isFalse();
        Assertions.assertThat((String)PageCodecMarker.toSummaryString((byte)PageCodecMarker.none())).isEqualTo("NONE");
        Assertions.assertThat((String)PageCodecMarker.toSummaryString((byte)encrypted)).isEqualTo("ENCRYPTED");
        Assertions.assertThat((String)PageCodecMarker.toSummaryString((byte)compressed)).isEqualTo("COMPRESSED");
        Assertions.assertThat((String)PageCodecMarker.toSummaryString((byte)compressedAndEncrypted)).isEqualTo("COMPRESSED, ENCRYPTED");
    }

    @Test
    public void testIsSet() {
        Assertions.assertThat((byte)0).isEqualTo(PageCodecMarker.none());
        PageCodecMarker.MarkerSet markerSet = PageCodecMarker.MarkerSet.empty();
        for (PageCodecMarker marker : PageCodecMarker.values()) {
            Assertions.assertThat((boolean)marker.isSet(PageCodecMarker.none())).isFalse();
            Assertions.assertThat((boolean)markerSet.contains(marker)).isFalse();
            markerSet.add(marker);
            Assertions.assertThat((boolean)markerSet.contains(marker)).isTrue();
            Assertions.assertThat((boolean)marker.isSet(marker.set(PageCodecMarker.none()))).isTrue();
            markerSet.remove(marker);
            Assertions.assertThat((boolean)markerSet.contains(marker)).isFalse();
            Assertions.assertThat((boolean)marker.isSet(marker.unset(marker.set(PageCodecMarker.none())))).isFalse();
            for (PageCodecMarker other : PageCodecMarker.values()) {
                Assertions.assertThat((other == marker ? 1 : 0) != 0).isEqualTo(PageCodecMarker.MarkerSet.of((PageCodecMarker)marker).contains(other));
                Assertions.assertThat((other == marker ? 1 : 0) != 0).isEqualTo(other.isSet(marker.set(PageCodecMarker.none())));
            }
        }
    }

    @Test
    public void testMarkerSetEquivalenceToByteMask() {
        byte markers = PageCodecMarker.none();
        PageCodecMarker.MarkerSet markerSet = PageCodecMarker.MarkerSet.empty();
        for (PageCodecMarker m : PageCodecMarker.values()) {
            markers = m.set(markers);
            markerSet.add(m);
        }
    }

    @Test
    public void testSummaryString() {
        byte allMarkers = PageCodecMarker.none();
        Assertions.assertThat((String)PageCodecMarker.toSummaryString((byte)PageCodecMarker.none())).isEqualTo("NONE");
        for (PageCodecMarker marker : PageCodecMarker.values()) {
            Assertions.assertThat((String)PageCodecMarker.toSummaryString((byte)marker.set(PageCodecMarker.none()))).isEqualTo(marker.name());
            Assertions.assertThat((boolean)PageCodecMarker.MarkerSet.of((PageCodecMarker)marker).toString().contains(marker.name())).isTrue();
            allMarkers = marker.set(allMarkers);
        }
        PageCodecMarker.MarkerSet allInSet = PageCodecMarker.MarkerSet.fromByteValue((byte)allMarkers);
        String allMarkersSummary = PageCodecMarker.toSummaryString((byte)allMarkers);
        Assertions.assertThat((boolean)allInSet.toString().contains(allMarkersSummary)).isTrue();
        for (PageCodecMarker marker : PageCodecMarker.values()) {
            Assertions.assertThat((boolean)allMarkersSummary.contains(marker.name())).isTrue();
            Assertions.assertThat((boolean)allInSet.contains(marker)).isTrue();
        }
    }
}

