/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.tpch.ColumnNaming;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import io.trino.tpch.Customer;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=5)
@Fork(value=1)
@Measurement(iterations=20)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkPlanner {
    private static final SchemaTableName TABLE = new SchemaTableName("default", "t");

    @Benchmark
    public List<Plan> plan(BenchmarkData benchmarkData) {
        PlanTester planTester = benchmarkData.planTester;
        List planOptimizers = planTester.getPlanOptimizers(false);
        PlanOptimizersStatsCollector planOptimizersStatsCollector = PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector();
        return (List)planTester.inTransaction(transactionSession -> (ImmutableList)benchmarkData.queries.getQueries().stream().map(query -> planTester.createPlan(transactionSession, query, planOptimizers, benchmarkData.stage, WarningCollector.NOOP, planOptimizersStatsCollector)).collect(ImmutableList.toImmutableList()));
    }

    @Test
    public void verify() {
        BenchmarkPlanner benchmark = new BenchmarkPlanner();
        for (Queries queries : Queries.values()) {
            BenchmarkData data = new BenchmarkData();
            data.queries = queries;
            data.setup();
            Assertions.assertThat(benchmark.plan(data)).isNotNull();
        }
    }

    private static String readResource(String resource) {
        try {
            URL resourceUrl = Customer.class.getResource(resource);
            return Resources.toString((URL)resourceUrl, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        try {
            new BenchmarkPlanner().plan(data);
        }
        finally {
            data.tearDown();
        }
        Benchmarks.benchmark(BenchmarkPlanner.class, (WarmupMode)WarmupMode.BULK).run();
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkData {
        @Param(value={"OPTIMIZED", "CREATED"})
        private LogicalPlanner.Stage stage = LogicalPlanner.Stage.OPTIMIZED;
        @Param
        private Queries queries = Queries.TPCH;
        private PlanTester planTester;
        private Session session;

        @Setup
        public void setup() {
            String tpch = "tpch";
            this.session = TestingSession.testSessionBuilder().setCatalog(tpch).setSchema("sf1").build();
            this.planTester = PlanTester.create((Session)this.session);
            this.planTester.installPlugin((Plugin)new TpchPlugin());
            this.planTester.createCatalog(tpch, "tpch", (Map)ImmutableMap.builder().put((Object)"tpch.splits-per-node", (Object)"4").put((Object)"tpch.column-naming", (Object)ColumnNaming.STANDARD.name()).buildOrThrow());
            this.planTester.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withGetTableHandle((session1, schemaTableName) -> new MockConnectorTableHandle((SchemaTableName)schemaTableName)).withGetColumns(name -> {
                if (!name.equals((Object)TABLE)) {
                    throw new IllegalArgumentException();
                }
                return (List)IntStream.rangeClosed(0, 500).mapToObj(i -> new ColumnMetadata("col_varchar_" + i, (Type)VarcharType.VARCHAR)).collect(ImmutableList.toImmutableList());
            }).build()));
            this.planTester.createCatalog("mock", "mock", (Map)ImmutableMap.of());
        }

        @TearDown
        public void tearDown() {
            this.planTester.close();
            this.planTester = null;
        }
    }

    public static enum Queries {
        TPCH(() -> (List)IntStream.rangeClosed(1, 22).boxed().filter(i -> i != 15).map(i -> BenchmarkPlanner.readResource(String.format("/io/trino/tpch/queries/q%d.sql", i))).collect(ImmutableList.toImmutableList())),
        LARGE_IN(() -> ImmutableList.of((Object)("SELECT * from orders where o_orderkey in " + IntStream.range(0, 5000).mapToObj(Integer::toString).collect(Collectors.joining(", ", "(", ")"))))),
        MULTIPLE_GROUP_BY(() -> ImmutableList.of((Object)("WITH " + IntStream.rangeClosed(0, 500).mapToObj(arg_0 -> Queries.lambda$static$4("t%s AS (\nSELECT * FROM lineitem a\nJOIN tiny.lineitem b ON a.l_orderkey = b.l_orderkey\nJOIN sf10.lineitem c ON a.l_orderkey = c.l_orderkey\nJOIN sf100.lineitem d ON a.l_orderkey = d.l_orderkey\nJOIN sf1000.lineitem e ON a.l_orderkey = e.l_orderkey\nWHERE a.l_orderkey = (SELECT max(o_orderkey) FROM orders GROUP BY o_orderkey))\n", arg_0)).collect(Collectors.joining(",")) + "SELECT 1 FROM lineitem"))),
        GROUP_BY_WITH_MANY_REFERENCED_COLUMNS(() -> ImmutableList.of((Object)("SELECT * FROM mock.default.t GROUP BY " + IntStream.rangeClosed(1, 501).mapToObj(Integer::toString).collect(Collectors.joining(",")))));

        private final Supplier<List<String>> queries;

        private Queries(Supplier<List<String>> queries) {
            this.queries = Objects.requireNonNull(queries, "queries is null");
        }

        public List<String> getQueries() {
            return this.queries.get();
        }

        private static /* synthetic */ String lambda$static$4(String rec$, Object xva$0) {
            return "t%s AS (\nSELECT * FROM lineitem a\nJOIN tiny.lineitem b ON a.l_orderkey = b.l_orderkey\nJOIN sf10.lineitem c ON a.l_orderkey = c.l_orderkey\nJOIN sf100.lineitem d ON a.l_orderkey = d.l_orderkey\nJOIN sf1000.lineitem e ON a.l_orderkey = e.l_orderkey\nWHERE a.l_orderkey = (SELECT max(o_orderkey) FROM orders GROUP BY o_orderkey))\n".formatted(xva$0);
        }
    }
}

