/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.type.DecimalType;
import io.trino.spi.type.SqlDecimal;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDecimalParametricType {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void decimalIsCreatedWithPrecisionAndScaleDefined() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 0))").binding("a", "1")))).isEqualTo(SqlDecimal.decimal((String)"01", (DecimalType)DecimalType.createDecimalType((int)2, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 2))").binding("a", "0.01")))).isEqualTo(SqlDecimal.decimal((String)".01", (DecimalType)DecimalType.createDecimalType((int)2, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(10, 10))").binding("a", "0.02")))).isEqualTo(SqlDecimal.decimal((String)".0200000000", (DecimalType)DecimalType.createDecimalType((int)10, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(10, 8))").binding("a", "0.02")))).isEqualTo(SqlDecimal.decimal((String)"00.02000000", (DecimalType)DecimalType.createDecimalType((int)10, (int)8)));
    }

    @Test
    public void decimalIsCreatedWithOnlyPrecisionDefined() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2))").binding("a", "1")))).isEqualTo(SqlDecimal.decimal((String)"01", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3))").binding("a", "-22")))).isEqualTo(SqlDecimal.decimal((String)"-022", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4))").binding("a", "31.41")))).isEqualTo(SqlDecimal.decimal((String)"0031", (DecimalType)DecimalType.createDecimalType((int)4)));
    }

    @Test
    public void decimalIsCreatedWithoutParameters() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL)").binding("a", "1")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL)").binding("a", "-22")))).isEqualTo(SqlDecimal.decimal((String)"-22", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL)").binding("a", "31.41")))).isEqualTo(SqlDecimal.decimal((String)"31", (DecimalType)DecimalType.createDecimalType((int)38)));
    }

    @Test
    public void creatingDecimalRoundsValueProperly() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4, 2))").binding("a", "0.022")))).isEqualTo(SqlDecimal.decimal((String)"00.02", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4, 2))").binding("a", "0.025")))).isEqualTo(SqlDecimal.decimal((String)"00.03", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3, 1))").binding("a", "32.01")))).isEqualTo(SqlDecimal.decimal((String)"32.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3, 1))").binding("a", "32.06")))).isEqualTo(SqlDecimal.decimal((String)"32.1", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3, 0))").binding("a", "32.1")))).isEqualTo(SqlDecimal.decimal((String)"032", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3, 0))").binding("a", "32.5")))).isEqualTo(SqlDecimal.decimal((String)"033", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4, 2))").binding("a", "-0.022")))).isEqualTo(SqlDecimal.decimal((String)"-00.02", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4, 2))").binding("a", "-0.025")))).isEqualTo(SqlDecimal.decimal((String)"-00.03", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
    }

    @Test
    public void decimalIsNotCreatedWhenScaleExceedsPrecision() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(1,2))").binding("a", "1").evaluate()).hasMessage("DECIMAL scale must be in range [0, precision (1)]: 2");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20,21))").binding("a", "-22").evaluate()).hasMessage("DECIMAL scale must be in range [0, precision (20)]: 21");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(0,1))").binding("a", "31.41").evaluate()).hasMessage("DECIMAL precision must be in range [1, 38]: 0");
    }

    @Test
    public void decimalWithZeroLengthCannotBeCreated() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(0,0))").binding("a", "1").evaluate()).hasMessage("DECIMAL precision must be in range [1, 38]: 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(0,0))").binding("a", "0").evaluate()).hasMessage("DECIMAL precision must be in range [1, 38]: 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(0))").binding("a", "1").evaluate()).hasMessage("DECIMAL precision must be in range [1, 38]: 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(0))").binding("a", "0").evaluate()).hasMessage("DECIMAL precision must be in range [1, 38]: 0");
    }
}

