/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableSet;
import io.trino.FeaturesConfig;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.metadata.TypeRegistry;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.JoniRegexpType;
import io.trino.type.JsonPathType;
import io.trino.type.Re2JRegexpType;
import io.trino.type.TypeCoercion;
import io.trino.type.UnknownType;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestTypeCoercion {
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private final TypeManager typeManager = this.functionResolution.getPlannerContext().getTypeManager();
    private final Collection<Type> standardTypes = new TypeRegistry(new TypeOperators(), new FeaturesConfig()).getTypes();
    private final Type re2jType = this.typeManager.getType(Re2JRegexpType.RE2J_REGEXP_SIGNATURE);
    private final TypeCoercion typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0));

    private Type mapType(Type keyType, Type valueType) {
        return this.typeManager.getType(TypeSignature.mapType((TypeSignature)keyType.getTypeSignature(), (TypeSignature)valueType.getTypeSignature()));
    }

    @Test
    public void testTypeCompatibility() {
        this.assertThat((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN).hasCommonSuperType((Type)UnknownType.UNKNOWN).canCoerceToEachOther();
        this.assertThat((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).hasCommonSuperType((Type)BigintType.BIGINT).canCoerceToEachOther();
        this.assertThat((Type)UnknownType.UNKNOWN, (Type)BigintType.BIGINT).hasCommonSuperType((Type)BigintType.BIGINT).canCoerceFirstToSecondOnly();
        this.assertThat((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DateType.DATE, (Type)TimestampType.createTimestampType((int)0)).hasCommonSuperType((Type)TimestampType.createTimestampType((int)0));
        this.assertThat((Type)DateType.DATE, (Type)TimestampType.createTimestampType((int)2)).hasCommonSuperType((Type)TimestampType.createTimestampType((int)2));
        this.assertThat((Type)DateType.DATE, (Type)TimestampType.TIMESTAMP_MILLIS).hasCommonSuperType((Type)TimestampType.TIMESTAMP_MILLIS).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DateType.DATE, (Type)TimestampType.createTimestampType((int)7)).hasCommonSuperType((Type)TimestampType.createTimestampType((int)7));
        this.assertThat((Type)DateType.DATE, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).hasCommonSuperType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0));
        this.assertThat((Type)DateType.DATE, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2)).hasCommonSuperType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2));
        this.assertThat((Type)DateType.DATE, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).hasCommonSuperType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DateType.DATE, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7)).hasCommonSuperType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7));
        this.assertThat((Type)TimeType.TIME_MILLIS, (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS).hasCommonSuperType((Type)TimeWithTimeZoneType.TIME_TZ_MILLIS).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TimestampType.TIMESTAMP_MILLIS, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).hasCommonSuperType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, (Type)JoniRegexpType.JONI_REGEXP).hasCommonSuperType((Type)JoniRegexpType.JONI_REGEXP).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, this.re2jType).hasCommonSuperType(this.re2jType).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, (Type)JsonPathType.JSON_PATH).hasCommonSuperType((Type)JsonPathType.JSON_PATH).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RealType.REAL, (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RealType.REAL, (Type)TinyintType.TINYINT).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)RealType.REAL, (Type)SmallintType.SMALLINT).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)RealType.REAL, (Type)IntegerType.INTEGER).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)RealType.REAL, (Type)BigintType.BIGINT).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)TimestampType.TIMESTAMP_MILLIS, (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS).isIncompatible();
        this.assertThat((Type)VarbinaryType.VARBINARY, (Type)VarcharType.VARCHAR).isIncompatible();
        this.assertThat((Type)UnknownType.UNKNOWN, (Type)new ArrayType((Type)BigintType.BIGINT)).hasCommonSuperType((Type)new ArrayType((Type)BigintType.BIGINT)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)DoubleType.DOUBLE)).hasCommonSuperType((Type)new ArrayType((Type)DoubleType.DOUBLE)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)UnknownType.UNKNOWN)).hasCommonSuperType((Type)new ArrayType((Type)BigintType.BIGINT)).canCoerceSecondToFirstOnly();
        this.assertThat(this.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE), this.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE)).hasCommonSuperType(this.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE)).canCoerceToEachOther();
        this.assertThat(this.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE), this.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).hasCommonSuperType(this.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TimeType.createTimeType((int)5), (Type)TimeType.createTimeType((int)9)).hasCommonSuperType((Type)TimeType.createTimeType((int)9));
        this.assertThat((Type)TimeType.createTimeType((int)9), (Type)TimeType.createTimeType((int)5)).hasCommonSuperType((Type)TimeType.createTimeType((int)9));
        this.assertThat((Type)TimeType.createTimeType((int)5), (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9)).hasCommonSuperType((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9));
        this.assertThat((Type)TimeType.createTimeType((int)9), (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)5)).hasCommonSuperType((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9));
        this.assertThat((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)5), (Type)TimeType.createTimeType((int)9)).hasCommonSuperType((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9));
        this.assertThat((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9), (Type)TimeType.createTimeType((int)5)).hasCommonSuperType((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9));
        this.assertThat((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)5), (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9)).hasCommonSuperType((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9));
        this.assertThat((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9), (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)5)).hasCommonSuperType((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9));
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)DoubleType.DOUBLE), RowType.field((String)"c", (Type)VarcharType.VARCHAR)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)DoubleType.DOUBLE), RowType.field((String)"c", (Type)VarcharType.VARCHAR)})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)DoubleType.DOUBLE), RowType.field((String)"c", (Type)VarcharType.VARCHAR)})).canCoerceToEachOther();
        this.assertThat((Type)DecimalType.createDecimalType((int)22, (int)1), (Type)DecimalType.createDecimalType((int)23, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)23, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)23, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)23, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)18, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)19, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)19, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)37, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RealType.REAL, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)new ArrayType((Type)DecimalType.createDecimalType((int)23, (int)1)), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)22, (int)1))).hasCommonSuperType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)23, (int)1))).canCoerceSecondToFirstOnly();
        this.assertThat((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))).hasCommonSuperType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)20, (int)1))).cannotCoerceToEachOther();
        this.assertThat((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)20, (int)1))).hasCommonSuperType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)20, (int)1))).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)3, (int)2), (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)22, (int)1), (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)37, (int)1), (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)37, (int)37), (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)22, (int)1), (Type)RealType.REAL).hasCommonSuperType((Type)RealType.REAL).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)3, (int)2), (Type)RealType.REAL).hasCommonSuperType((Type)RealType.REAL).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DecimalType.createDecimalType((int)37, (int)37), (Type)RealType.REAL).hasCommonSuperType((Type)RealType.REAL).canCoerceFirstToSecondOnly();
        this.assertThat((Type)IntegerType.INTEGER, (Type)DecimalType.createDecimalType((int)23, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)23, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)IntegerType.INTEGER, (Type)DecimalType.createDecimalType((int)9, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)10, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)IntegerType.INTEGER, (Type)DecimalType.createDecimalType((int)10, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)10, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)IntegerType.INTEGER, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)37, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)2, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)3, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)9, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)9, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)2, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)4, (int)1)).cannotCoerceToEachOther();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)3, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)3, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TinyintType.TINYINT, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)37, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)37, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)37, (int)1)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)4, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)5, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)5, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)5, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)2, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)5, (int)0)).cannotCoerceToEachOther();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)9, (int)0)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)9, (int)0)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)2, (int)1)).hasCommonSuperType((Type)DecimalType.createDecimalType((int)6, (int)1)).cannotCoerceToEachOther();
        this.assertThat((Type)CharType.createCharType((int)42), (Type)CharType.createCharType((int)40)).hasCommonSuperType((Type)CharType.createCharType((int)42)).canCoerceSecondToFirstOnly();
        this.assertThat((Type)CharType.createCharType((int)42), (Type)CharType.createCharType((int)44)).hasCommonSuperType((Type)CharType.createCharType((int)44)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.createVarcharType((int)42), (Type)VarcharType.createVarcharType((int)42)).hasCommonSuperType((Type)VarcharType.createVarcharType((int)42)).canCoerceToEachOther();
        this.assertThat((Type)VarcharType.createVarcharType((int)42), (Type)VarcharType.createVarcharType((int)44)).hasCommonSuperType((Type)VarcharType.createVarcharType((int)44)).canCoerceFirstToSecondOnly();
        this.assertThat((Type)CharType.createCharType((int)40), (Type)VarcharType.createVarcharType((int)42)).hasCommonSuperType((Type)CharType.createCharType((int)42)).cannotCoerceToEachOther();
        this.assertThat((Type)CharType.createCharType((int)42), (Type)VarcharType.createVarcharType((int)42)).hasCommonSuperType((Type)CharType.createCharType((int)42)).canCoerceSecondToFirstOnly();
        this.assertThat((Type)CharType.createCharType((int)44), (Type)VarcharType.createVarcharType((int)42)).hasCommonSuperType((Type)CharType.createCharType((int)44)).canCoerceSecondToFirstOnly();
        this.assertThat((Type)CharType.createCharType((int)42), (Type)JoniRegexpType.JONI_REGEXP).hasCommonSuperType((Type)JoniRegexpType.JONI_REGEXP).canCoerceFirstToSecondOnly();
        this.assertThat((Type)CharType.createCharType((int)42), (Type)JsonPathType.JSON_PATH).hasCommonSuperType((Type)JsonPathType.JSON_PATH).canCoerceFirstToSecondOnly();
        this.assertThat((Type)CharType.createCharType((int)42), this.re2jType).hasCommonSuperType(this.re2jType).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.createVarcharType((int)2)}), (Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.createVarcharType((int)5)})).hasCommonSuperType((Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.createVarcharType((int)5)})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT)})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT)})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"b", (Type)BigintType.BIGINT)})).hasCommonSuperType((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"b", (Type)BigintType.BIGINT)})).hasCommonSuperType((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)VarcharType.createVarcharType((int)2))})).isIncompatible();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))})).isIncompatible();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)BigintType.BIGINT), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)BigintType.BIGINT), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)BigintType.BIGINT), RowType.field((String)"d", (Type)VarcharType.createVarcharType((int)2))})).hasCommonSuperType((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, VarcharType.createVarcharType((int)5)})).cannotCoerceToEachOther();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))}))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((Type)VarcharType.createVarcharType((int)5))}))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((Type)VarcharType.createVarcharType((int)5))}))})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)2))}))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))})).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"d", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"e", (Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))})).hasCommonSuperType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)IntegerType.INTEGER), RowType.field((String)"b", (Type)VarcharType.createVarcharType((int)5))}))})).canCoerceToEachOther();
    }

    @Test
    public void testCoerceTypeBase() {
        Assertions.assertThat((Optional)this.typeCoercion.coerceTypeBase((Type)DecimalType.createDecimalType((int)21, (int)1), "decimal")).isEqualTo(Optional.of(DecimalType.createDecimalType((int)21, (int)1)));
        Assertions.assertThat((Optional)this.typeCoercion.coerceTypeBase((Type)BigintType.BIGINT, "decimal")).isEqualTo(Optional.of(DecimalType.createDecimalType((int)19, (int)0)));
        Assertions.assertThat((Optional)this.typeCoercion.coerceTypeBase((Type)IntegerType.INTEGER, "decimal")).isEqualTo(Optional.of(DecimalType.createDecimalType((int)10, (int)0)));
        Assertions.assertThat((Optional)this.typeCoercion.coerceTypeBase((Type)TinyintType.TINYINT, "decimal")).isEqualTo(Optional.of(DecimalType.createDecimalType((int)3, (int)0)));
        Assertions.assertThat((Optional)this.typeCoercion.coerceTypeBase((Type)SmallintType.SMALLINT, "decimal")).isEqualTo(Optional.of(DecimalType.createDecimalType((int)5, (int)0)));
    }

    @Test
    public void testCanCoerceIsTransitive() {
        Set<Type> types = this.getStandardPrimitiveTypes();
        for (Type transitiveType : types) {
            for (Type resultType : types) {
                if (!this.typeCoercion.canCoerce(transitiveType, resultType)) continue;
                for (Type sourceType : types) {
                    if (!this.typeCoercion.canCoerce(sourceType, transitiveType) || this.typeCoercion.canCoerce(sourceType, resultType)) continue;
                    Fail.fail((String)String.format("'%s' -> '%s' coercion is missing when transitive coercion is possible: '%s' -> '%s' -> '%s'", sourceType, resultType, sourceType, transitiveType, resultType));
                }
            }
        }
    }

    @Test
    public void testCastOperatorsExistForCoercions() {
        Set<Type> types = this.getStandardPrimitiveTypes();
        for (Type sourceType : types) {
            for (Type resultType : types) {
                if (!this.typeCoercion.canCoerce(sourceType, resultType) || sourceType == UnknownType.UNKNOWN || resultType == UnknownType.UNKNOWN) continue;
                try {
                    this.functionResolution.getCoercion(sourceType, resultType);
                }
                catch (Exception e) {
                    Fail.fail((String)String.format("'%s' -> '%s' coercion exists but there is no cast operator", sourceType, resultType), (Throwable)e);
                }
            }
        }
    }

    private Set<Type> getStandardPrimitiveTypes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.standardTypes);
        builder.add((Object)DecimalType.createDecimalType((int)1, (int)0));
        builder.add((Object)DecimalType.createDecimalType((int)17, (int)0));
        builder.add((Object)DecimalType.createDecimalType((int)38, (int)0));
        builder.add((Object)DecimalType.createDecimalType((int)17, (int)17));
        builder.add((Object)DecimalType.createDecimalType((int)38, (int)38));
        builder.add((Object)VarcharType.createVarcharType((int)0));
        builder.add((Object)VarcharType.createUnboundedVarcharType());
        builder.add((Object)CharType.createCharType((int)0));
        builder.add((Object)CharType.createCharType((int)42));
        return builder.build();
    }

    private CompatibilityAssertion assertThat(Type firstType, Type secondType) {
        Optional commonSuperType1 = this.typeCoercion.getCommonSuperType(firstType, secondType);
        Optional commonSuperType2 = this.typeCoercion.getCommonSuperType(secondType, firstType);
        ((OptionalAssert)Assertions.assertThat((Optional)commonSuperType1).describedAs("Expected getCommonSuperType to return the same result when invoked in either order", new Object[0])).isEqualTo((Object)commonSuperType2);
        boolean canCoerceFirstToSecond = this.typeCoercion.canCoerce(firstType, secondType);
        boolean canCoerceSecondToFirst = this.typeCoercion.canCoerce(secondType, firstType);
        return new CompatibilityAssertion(commonSuperType1, canCoerceFirstToSecond, canCoerceSecondToFirst);
    }

    private static class CompatibilityAssertion {
        private final Optional<Type> commonSuperType;
        private final boolean canCoerceFirstToSecond;
        private final boolean canCoerceSecondToFirst;

        public CompatibilityAssertion(Optional<Type> commonSuperType, boolean canCoerceFirstToSecond, boolean canCoerceSecondToFirst) {
            this.commonSuperType = Objects.requireNonNull(commonSuperType, "commonSuperType is null");
            ((AbstractBooleanAssert)Assertions.assertThat((!canCoerceFirstToSecond && !canCoerceSecondToFirst || commonSuperType.isPresent() ? 1 : 0) != 0).describedAs("Expected canCoercion to be false when there is no commonSuperType", new Object[0])).isTrue();
            this.canCoerceFirstToSecond = canCoerceFirstToSecond;
            this.canCoerceSecondToFirst = canCoerceSecondToFirst;
        }

        public void isIncompatible() {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.commonSuperType.isEmpty()).describedAs("Expected to be incompatible", new Object[0])).isTrue();
        }

        public CompatibilityAssertion hasCommonSuperType(Type expected) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.commonSuperType.isPresent()).describedAs("Expected commonSuperType to be present", new Object[0])).isTrue();
            ((ObjectAssert)Assertions.assertThat((Object)this.commonSuperType.get()).describedAs("commonSuperType", new Object[0])).isEqualTo((Object)expected);
            return this;
        }

        public CompatibilityAssertion canCoerceToEachOther() {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.canCoerceFirstToSecond).describedAs("Expected first be coercible to second", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.canCoerceSecondToFirst).describedAs("Expected second be coercible to first", new Object[0])).isTrue();
            return this;
        }

        public CompatibilityAssertion canCoerceFirstToSecondOnly() {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.canCoerceFirstToSecond).describedAs("Expected first be coercible to second", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.canCoerceSecondToFirst).describedAs("Expected second NOT be coercible to first", new Object[0])).isFalse();
            return this;
        }

        public CompatibilityAssertion canCoerceSecondToFirstOnly() {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.canCoerceFirstToSecond).describedAs("Expected first NOT be coercible to second", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.canCoerceSecondToFirst).describedAs("Expected second be coercible to first", new Object[0])).isTrue();
            return this;
        }

        public CompatibilityAssertion cannotCoerceToEachOther() {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.canCoerceFirstToSecond).describedAs("Expected first NOT be coercible to second", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.canCoerceSecondToFirst).describedAs("Expected second NOT be coercible to first", new Object[0])).isFalse();
            return this;
        }
    }
}

