/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import io.trino.client.FixJsonDataUtils;
import io.trino.client.JsonCodec;
import io.trino.client.QueryData;
import io.trino.client.QueryResults;
import io.trino.client.RawQueryData;
import io.trino.client.StatementStats;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.EncodedQueryData;
import io.trino.client.spooling.InlineSegment;
import io.trino.client.spooling.Segment;
import io.trino.client.spooling.encoding.JsonQueryDataDecoder;
import io.trino.server.protocol.spooling.QueryDataJacksonModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQueryDataSerialization {
    private static final List<Column> COLUMNS_LIST = ImmutableList.of((Object)new Column("_col0", "bigint", new ClientTypeSignature("bigint")));
    private static final JsonCodec<QueryResults> CLIENT_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private static final io.airlift.json.JsonCodec<QueryResults> SERVER_CODEC = new JsonCodecFactory((Provider)new ObjectMapperProvider().withModules(Set.of(new QueryDataJacksonModule()))).jsonCodec(QueryResults.class);

    @Test
    public void testNullDataSerialization() {
        Assertions.assertThat((String)TestQueryDataSerialization.serialize(null)).doesNotContain(new CharSequence[]{"data"});
        Assertions.assertThat((String)TestQueryDataSerialization.serialize(RawQueryData.of(null))).doesNotContain(new CharSequence[]{"data"});
    }

    @Test
    public void testEmptyArraySerialization() {
        this.testRoundTrip(COLUMNS_LIST, RawQueryData.of((Iterable)ImmutableList.of()), "[]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRoundTrip(COLUMNS_LIST, RawQueryData.of((Iterable)ImmutableList.of((Object)ImmutableList.of())), "[[]]")).isInstanceOf(IllegalArgumentException.class)).hasMessage("row/column size mismatch");
    }

    @Test
    public void testQueryDataSerialization() {
        ImmutableList values = ImmutableList.of((Object)ImmutableList.of((Object)1L), (Object)ImmutableList.of((Object)5L));
        this.testRoundTrip(COLUMNS_LIST, RawQueryData.of((Iterable)values), "[[1],[5]]");
    }

    @Test
    public void testEncodedQueryDataSerialization() {
        EncodedQueryData queryData = new EncodedQueryData("json", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)Segment.inlined((byte[])"[[10], [20]]".getBytes(StandardCharsets.UTF_8), (DataAttributes)this.dataAttributes(10L, 2L, 12))));
        this.testRoundTrip(COLUMNS_LIST, (QueryData)queryData, "{\n  \"encodingId\": \"json\",\n  \"segments\": [\n    {\n      \"type\": \"inline\",\n      \"data\": \"W1sxMF0sIFsyMF1d\",\n      \"metadata\": {\n        \"rowOffset\": 10,\n        \"rowsCount\": 2,\n        \"segmentSize\": 12\n      }\n    }\n  ]\n}");
    }

    @Test
    public void testEncodedQueryDataSerializationWithExtraMetadata() {
        EncodedQueryData queryData = new EncodedQueryData("json", (Map)ImmutableMap.of((Object)"decryptionKey", (Object)"secret"), (List)ImmutableList.of((Object)Segment.inlined((byte[])"[[10], [20]]".getBytes(StandardCharsets.UTF_8), (DataAttributes)this.dataAttributes(10L, 2L, 12))));
        this.testRoundTrip(COLUMNS_LIST, (QueryData)queryData, "{\n  \"encodingId\": \"json\",\n  \"metadata\": {\n    \"decryptionKey\": \"secret\"\n  },\n  \"segments\": [\n    {\n      \"type\": \"inline\",\n      \"data\": \"W1sxMF0sIFsyMF1d\",\n      \"metadata\": {\n        \"rowOffset\": 10,\n        \"rowsCount\": 2,\n        \"segmentSize\": 12\n      }\n    }\n  ]\n}");
    }

    @Test
    public void testSpooledQueryDataSerialization() {
        EncodedQueryData queryData = EncodedQueryData.builder((String)"json").withSegment(Segment.inlined((byte[])"super".getBytes(StandardCharsets.UTF_8), (DataAttributes)this.dataAttributes(0L, 100L, 5))).withSegment(Segment.spooled((URI)URI.create("http://localhost:8080/v1/download/20160128_214710_00012_rk68b/segments/1"), (DataAttributes)this.dataAttributes(100L, 100L, 1024), Map.of("x-amz-server-side-encryption", List.of("AES256")))).withSegment(Segment.spooled((URI)URI.create("http://localhost:8080/v1/download/20160128_214710_00012_rk68b/segments/2"), (DataAttributes)this.dataAttributes(200L, 100L, 1024), Map.of("x-amz-server-side-encryption", List.of("AES256")))).withAttributes(DataAttributes.builder().set(DataAttribute.SCHEMA, (Object)"serializedSchema").build()).build();
        this.testSerializationRoundTrip((QueryData)queryData, "{\n  \"encodingId\": \"json\",\n  \"metadata\": {\n    \"schema\": \"serializedSchema\"\n  },\n  \"segments\": [\n    {\n      \"type\": \"inline\",\n      \"data\": \"c3VwZXI=\",\n      \"metadata\": {\n        \"rowOffset\": 0,\n        \"rowsCount\": 100,\n        \"segmentSize\": 5\n      }\n    },\n    {\n      \"type\": \"spooled\",\n      \"uri\": \"http://localhost:8080/v1/download/20160128_214710_00012_rk68b/segments/1\",\n      \"metadata\": {\n        \"rowOffset\": 100,\n        \"rowsCount\": 100,\n        \"segmentSize\": 1024\n      },\n      \"headers\": {\"x-amz-server-side-encryption\":[\"AES256\"]}\n    },\n    {\n      \"type\": \"spooled\",\n      \"uri\": \"http://localhost:8080/v1/download/20160128_214710_00012_rk68b/segments/2\",\n      \"metadata\": {\n        \"rowOffset\": 200,\n        \"rowsCount\": 100,\n        \"segmentSize\": 1024\n      },\n      \"headers\": {\"x-amz-server-side-encryption\":[\"AES256\"]}\n    }\n  ]\n}");
    }

    @Test
    public void testEncodedQueryDataToString() {
        EncodedQueryData inlineQueryData = new EncodedQueryData("json", (Map)ImmutableMap.of((Object)"decryption_key", (Object)"secret"), (List)ImmutableList.of((Object)Segment.inlined((byte[])"[[10], [20]]".getBytes(StandardCharsets.UTF_8), (DataAttributes)this.dataAttributes(10L, 2L, 12))));
        Assertions.assertThat((String)inlineQueryData.toString()).isEqualTo("EncodedQueryData{encodingId=json, segments=[InlineSegment{offset=10, rows=2, size=12}], metadata=[decryption_key]}");
        EncodedQueryData spooledQueryData = new EncodedQueryData("json+zstd", (Map)ImmutableMap.of((Object)"decryption_key", (Object)"secret"), (List)ImmutableList.of((Object)Segment.spooled((URI)URI.create("http://coordinator:8080/v1/segments/uuid"), (DataAttributes)this.dataAttributes(10L, 2L, 1256), this.headers())));
        Assertions.assertThat((String)spooledQueryData.toString()).isEqualTo("EncodedQueryData{encodingId=json+zstd, segments=[SpooledSegment{offset=10, rows=2, size=1256, headers=[x-amz-server-side-encryption]}], metadata=[decryption_key]}");
    }

    private void testRoundTrip(List<Column> columns, QueryData queryData, String expectedDataRepresentation) {
        this.testSerializationRoundTrip(queryData, expectedDataRepresentation);
        TestQueryDataSerialization.assertEquals(columns, TestQueryDataSerialization.deserialize(TestQueryDataSerialization.serialize(queryData)), queryData);
    }

    private void testSerializationRoundTrip(QueryData queryData, String expectedDataRepresentation) {
        Assertions.assertThat((String)TestQueryDataSerialization.serialize(queryData)).isEqualToIgnoringWhitespace((CharSequence)this.queryResultsJson(expectedDataRepresentation));
    }

    private String queryResultsJson(String expectedDataField) {
        return String.format("{\n  \"id\": \"20160128_214710_00012_rk68b\",\n  \"infoUri\": \"http://coordinator/query.html?20160128_214710_00012_rk68b\",\n  \"columns\": [\n    {\n      \"name\": \"_col0\",\n      \"type\": \"bigint\",\n      \"typeSignature\": {\n        \"rawType\": \"bigint\",\n        \"arguments\": []\n      }\n    }\n  ],\n  \"data\": %s,\n  \"stats\": {\n    \"state\": \"FINISHED\",\n    \"queued\": false,\n    \"scheduled\": false,\n    \"nodes\": 0,\n    \"totalSplits\": 0,\n    \"queuedSplits\": 0,\n    \"runningSplits\": 0,\n    \"completedSplits\": 0,\n    \"cpuTimeMillis\": 0,\n    \"wallTimeMillis\": 0,\n    \"queuedTimeMillis\": 0,\n    \"elapsedTimeMillis\": 0,\n    \"processedRows\": 0,\n    \"processedBytes\": 0,\n    \"physicalInputBytes\": 0,\n    \"physicalWrittenBytes\": 0,\n    \"peakMemoryBytes\": 0,\n    \"spilledBytes\": 0\n  },\n  \"warnings\": []\n}", expectedDataField);
    }

    private static void assertEquals(List<Column> columns, QueryData left, QueryData right) {
        Iterable<List<Object>> leftValues = TestQueryDataSerialization.decodeData(left, columns);
        Iterable<List<Object>> rightValues = TestQueryDataSerialization.decodeData(right, columns);
        if (leftValues == null) {
            Assertions.assertThat(rightValues).isNull();
            return;
        }
        Assertions.assertThat(leftValues).hasSameElementsAs(rightValues);
    }

    private static Iterable<List<Object>> decodeData(QueryData data, List<Column> columns) {
        EncodedQueryData queryDataV2;
        Object e;
        if (data instanceof RawQueryData) {
            return FixJsonDataUtils.fixData(columns, (Iterable)data.getData());
        }
        if (data instanceof EncodedQueryData && (e = (queryDataV2 = (EncodedQueryData)data).getSegments().getFirst()) instanceof InlineSegment) {
            InlineSegment inlineSegment = (InlineSegment)e;
            try {
                return new JsonQueryDataDecoder.Factory().create(columns, DataAttributes.empty()).decode((InputStream)new ByteArrayInputStream(inlineSegment.getData()), inlineSegment.getMetadata());
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        throw new AssertionError((Object)("Unexpected data type: " + data.getClass().getSimpleName()));
    }

    private static QueryData deserialize(String serialized) {
        try {
            return ((QueryResults)CLIENT_CODEC.fromJson(serialized)).getData();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String serialize(QueryData data) {
        return SERVER_CODEC.toJson((Object)new QueryResults("20160128_214710_00012_rk68b", URI.create("http://coordinator/query.html?20160128_214710_00012_rk68b"), null, null, (List)ImmutableList.of((Object)new Column("_col0", "bigint", new ClientTypeSignature("bigint"))), data, StatementStats.builder().setState("FINISHED").setProgressPercentage(OptionalDouble.empty()).setRunningPercentage(OptionalDouble.empty()).build(), null, (List)ImmutableList.of(), null, null));
    }

    private DataAttributes dataAttributes(long currentOffset, long rowCount, int byteSize) {
        return DataAttributes.builder().set(DataAttribute.ROW_OFFSET, (Object)currentOffset).set(DataAttribute.ROWS_COUNT, (Object)rowCount).set(DataAttribute.SEGMENT_SIZE, (Object)byteSize).build();
    }

    private Map<String, List<String>> headers() {
        return Map.of("x-amz-server-side-encryption", List.of("AES256"));
    }
}

