/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.FullConnectorSession;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.WorkProcessor;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.PageProcessorMetrics;
import io.trino.spi.Page;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockTestUtils;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.IntArrayBlockBuilder;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.gen.columnar.FilterEvaluator;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.testing.DataProviders;
import io.trino.testing.TestingSession;
import io.trino.type.LikePattern;
import io.trino.type.LikePatternType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestColumnarFilters {
    private static final Random RANDOM = new Random(5376453765L);
    private static final long CONSTANT = 64992484L;
    private static final int ROW_NUM_CHANNEL = 0;
    private static final int DOUBLE_CHANNEL = 1;
    private static final int INT_CHANNEL_B = 2;
    private static final int STRING_CHANNEL = 3;
    private static final int INT_CHANNEL_A = 4;
    private static final int INT_CHANNEL_C = 5;
    private static final int ARRAY_CHANNEL = 6;
    private static final Type ARRAY_CHANNEL_TYPE = new ArrayType((Type)IntegerType.INTEGER);
    private static final FullConnectorSession FULL_CONNECTOR_SESSION = new FullConnectorSession(TestingSession.testSessionBuilder().build(), ConnectorIdentity.ofUser((String)"test"));
    private static final FunctionBundle FUNCTION_BUNDLE = InternalFunctionBundle.builder().scalar(NullableReturnFunction.class).scalar(ConnectorSessionFunction.class).scalar(InstanceFactoryFunction.class).scalar(CustomIsDistinctFrom.class).build();
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution(FUNCTION_BUNDLE);
    private static final ColumnarFilterCompiler COMPILER = FUNCTION_RESOLUTION.getColumnarFilterCompiler();

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testIsNotDistinctFrom(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        CallExpression isNotDistinctFromFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.IDENTICAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.constant((Object)64992484L, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)isNotDistinctFromFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)isNotDistinctFromFilter);
        isNotDistinctFromFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.IDENTICAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.constantNull((Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsNotSupported((RowExpression)isNotDistinctFromFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)isNotDistinctFromFilter);
        isNotDistinctFromFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.IDENTICAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.field((int)5, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)isNotDistinctFromFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)isNotDistinctFromFilter);
    }

    @Test
    public void testIsDistinctFrom() {
        List<Page> inputPages = TestColumnarFilters.createInputPages(NullsProvider.RANDOM_NULLS, false);
        RowExpression isDistinctFromFilter = TestColumnarFilters.createNotExpression((RowExpression)Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.IDENTICAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.constant((Object)64992484L, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)}));
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsNotSupported(isDistinctFromFilter);
        TestColumnarFilters.verifyFilter(inputPages, isDistinctFromFilter);
        isDistinctFromFilter = TestColumnarFilters.createNotExpression((RowExpression)Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.IDENTICAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.field((int)2, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)}));
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsNotSupported(isDistinctFromFilter);
        TestColumnarFilters.verifyFilter(inputPages, isDistinctFromFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testIsNull(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        SpecialForm isNullFilter = new SpecialForm(SpecialForm.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)4, (Type)IntegerType.INTEGER)), (List)ImmutableList.of());
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)isNullFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)isNullFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testNullableReturnFunction(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        CallExpression customNullableReturnFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.functionCallBuilder("custom_is_null").addArgument((Type)VarcharType.VARCHAR, (Expression)new Reference((Type)VarcharType.VARCHAR, "symbol")).build().function(), (RowExpression[])new RowExpression[]{Expressions.field((int)3, (Type)VarcharType.VARCHAR)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)customNullableReturnFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)customNullableReturnFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testConnectorSessionFunction(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        CallExpression customConnectorSessionFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.functionCallBuilder("is_user_admin").build().function(), (RowExpression[])new RowExpression[0]);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)customConnectorSessionFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)customConnectorSessionFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testInstanceFactoryFunction(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        CallExpression customInstanceFactoryFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.functionCallBuilder("is_answer_to_universe").addArgument((Type)IntegerType.INTEGER, (Expression)new Reference((Type)IntegerType.INTEGER, "symbol")).build().function(), (RowExpression[])new RowExpression[]{Expressions.field((int)4, (Type)IntegerType.INTEGER)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)customInstanceFactoryFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)customInstanceFactoryFilter);
    }

    @Test
    public void testBooleanConstant() {
        List<Page> inputPages = TestColumnarFilters.createInputPages(NullsProvider.RANDOM_NULLS, false);
        ConstantExpression trueFilter = Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)trueFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)trueFilter);
        ConstantExpression falseFilter = Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)falseFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)falseFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testIsNotNull(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        RowExpression isNotNullFilter = TestColumnarFilters.createNotExpression((RowExpression)new SpecialForm(SpecialForm.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)4, (Type)IntegerType.INTEGER)), (List)ImmutableList.of()));
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported(isNotNullFilter);
        TestColumnarFilters.verifyFilter(inputPages, isNotNullFilter);
    }

    @Test
    public void testNot() {
        List<Page> inputPages = TestColumnarFilters.createInputPages(NullsProvider.RANDOM_NULLS, false);
        RowExpression notNullFilter = TestColumnarFilters.createNotExpression((RowExpression)Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.constant((Object)64992484L, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)}));
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsNotSupported(notNullFilter);
        TestColumnarFilters.verifyFilter(inputPages, notNullFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testLike(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        CallExpression likeFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveFunction("$like", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN})), (RowExpression[])new RowExpression[]{Expressions.field((int)3, (Type)VarcharType.VARCHAR), Expressions.constant((Object)LikePattern.compile((String)Long.toString(64992484L), Optional.empty()), (Type)LikePatternType.LIKE_PATTERN)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)likeFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)likeFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testLessThan(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        CallExpression lessThanFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.constant((Object)64992484L, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)lessThanFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)lessThanFilter);
        lessThanFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)DoubleType.DOUBLE), Expressions.constant((Object)6.4992484E7, (Type)DoubleType.DOUBLE)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)lessThanFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)lessThanFilter);
        lessThanFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.field((int)5, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)lessThanFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)lessThanFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testEq(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        CallExpression lessThanFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.constant((Object)64992484L, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)lessThanFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)lessThanFilter);
        lessThanFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)DoubleType.DOUBLE), Expressions.constant((Object)6.4992484E7, (Type)DoubleType.DOUBLE)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)lessThanFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)lessThanFilter);
        lessThanFilter = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (RowExpression[])new RowExpression[]{Expressions.field((int)5, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)});
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)lessThanFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)lessThanFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testBetween(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        SpecialForm betweenFilter = new SpecialForm(SpecialForm.Form.BETWEEN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)4, (Type)IntegerType.INTEGER), (Object)Expressions.constant((Object)64992479L, (Type)IntegerType.INTEGER), (Object)Expressions.constant((Object)64992489L, (Type)IntegerType.INTEGER)), (List)ImmutableList.of((Object)FUNCTION_RESOLUTION.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))));
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)betweenFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)betweenFilter);
        betweenFilter = new SpecialForm(SpecialForm.Form.BETWEEN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)4, (Type)IntegerType.INTEGER), (Object)Expressions.field((int)2, (Type)IntegerType.INTEGER), (Object)Expressions.constant((Object)64992489L, (Type)IntegerType.INTEGER)), (List)ImmutableList.of((Object)FUNCTION_RESOLUTION.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))));
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)betweenFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)betweenFilter);
        betweenFilter = new SpecialForm(SpecialForm.Form.BETWEEN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)4, (Type)IntegerType.INTEGER), (Object)Expressions.field((int)2, (Type)IntegerType.INTEGER), (Object)Expressions.field((int)5, (Type)IntegerType.INTEGER)), (List)ImmutableList.of((Object)FUNCTION_RESOLUTION.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))));
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)betweenFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)betweenFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testOr(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        ResolvedFunction customIsDistinctFrom = FUNCTION_RESOLUTION.functionCallBuilder("custom_is_distinct_from").addArgument((Type)IntegerType.INTEGER, (Expression)new Reference((Type)IntegerType.INTEGER, "left")).addArgument((Type)IntegerType.INTEGER, (Expression)new Reference((Type)IntegerType.INTEGER, "right")).build().function();
        SpecialForm orFilter = new SpecialForm(SpecialForm.Form.OR, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.call((ResolvedFunction)customIsDistinctFrom, (RowExpression[])new RowExpression[]{Expressions.field((int)4, (Type)IntegerType.INTEGER), Expressions.constant((Object)64992479L, (Type)IntegerType.INTEGER)}), (Object)Expressions.call((ResolvedFunction)customIsDistinctFrom, (RowExpression[])new RowExpression[]{Expressions.field((int)5, (Type)IntegerType.INTEGER), Expressions.constant((Object)64992489L, (Type)IntegerType.INTEGER)}), (Object)Expressions.call((ResolvedFunction)customIsDistinctFrom, (RowExpression[])new RowExpression[]{Expressions.field((int)2, (Type)IntegerType.INTEGER), Expressions.constant((Object)64992484L, (Type)IntegerType.INTEGER)})), (List)ImmutableList.of());
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)orFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)orFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testAnd(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        ResolvedFunction customIsDistinctFromIntegers = FUNCTION_RESOLUTION.functionCallBuilder("custom_is_distinct_from").addArgument((Type)IntegerType.INTEGER, (Expression)new Reference((Type)IntegerType.INTEGER, "left")).addArgument((Type)IntegerType.INTEGER, (Expression)new Reference((Type)IntegerType.INTEGER, "right")).build().function();
        ResolvedFunction customIsDistinctFromVarchars = FUNCTION_RESOLUTION.functionCallBuilder("custom_is_distinct_from").addArgument((Type)VarcharType.VARCHAR, (Expression)new Reference((Type)VarcharType.VARCHAR, "left")).addArgument((Type)VarcharType.VARCHAR, (Expression)new Reference((Type)VarcharType.VARCHAR, "right")).build().function();
        SpecialForm andFilter = new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.call((ResolvedFunction)customIsDistinctFromIntegers, (RowExpression[])new RowExpression[]{Expressions.field((int)4, (Type)IntegerType.INTEGER), Expressions.constant((Object)64992479L, (Type)IntegerType.INTEGER)}), (Object)Expressions.call((ResolvedFunction)customIsDistinctFromVarchars, (RowExpression[])new RowExpression[]{Expressions.field((int)3, (Type)VarcharType.VARCHAR), Expressions.constant((Object)Slices.utf8Slice((String)Long.toString(64992489L)), (Type)VarcharType.VARCHAR)}), (Object)Expressions.call((ResolvedFunction)customIsDistinctFromIntegers, (RowExpression[])new RowExpression[]{Expressions.field((int)2, (Type)IntegerType.INTEGER), Expressions.constant((Object)64992484L, (Type)IntegerType.INTEGER)})), (List)ImmutableList.of());
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)andFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)andFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testIn(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, dictionaryEncoded);
        List<ResolvedFunction> functionalDependencies = TestColumnarFilters.getInFunctionalDependencies((Type)IntegerType.INTEGER);
        ImmutableList arguments = ImmutableList.builder().add((Object)Expressions.field((int)4, (Type)IntegerType.INTEGER)).add((Object)Expressions.constant(null, (Type)IntegerType.INTEGER)).add((Object)Expressions.constant((Object)64992485L, (Type)IntegerType.INTEGER)).add((Object)Expressions.constant((Object)64992489L, (Type)IntegerType.INTEGER)).add((Object)Expressions.constant((Object)64992494L, (Type)IntegerType.INTEGER)).build();
        SpecialForm inFilter = new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List)arguments, functionalDependencies);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)inFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)inFilter);
        arguments = ImmutableList.builder().add((Object)Expressions.field((int)4, (Type)IntegerType.INTEGER)).add((Object)Expressions.constant(null, (Type)IntegerType.INTEGER)).add((Object)Expressions.constant((Object)64992474L, (Type)IntegerType.INTEGER)).addAll(TestColumnarFilters.buildConstantsList((Type)IntegerType.INTEGER, 100)).add((Object)Expressions.constant((Object)64992594L, (Type)IntegerType.INTEGER)).build();
        inFilter = new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List)arguments, functionalDependencies);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)inFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)inFilter);
        arguments = ImmutableList.builder().add((Object)Expressions.field((int)4, (Type)IntegerType.INTEGER)).add((Object)Expressions.constant(null, (Type)IntegerType.INTEGER)).addAll(TestColumnarFilters.buildConstantsList((Type)IntegerType.INTEGER, 100)).build();
        inFilter = new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List)arguments, functionalDependencies);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)inFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)inFilter);
        arguments = ImmutableList.builder().add((Object)Expressions.field((int)4, (Type)IntegerType.INTEGER)).add((Object)Expressions.constant(null, (Type)IntegerType.INTEGER)).build();
        inFilter = new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List)arguments, functionalDependencies);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)inFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)inFilter);
        functionalDependencies = TestColumnarFilters.getInFunctionalDependencies((Type)VarcharType.VARCHAR);
        arguments = ImmutableList.builder().add((Object)Expressions.field((int)3, (Type)VarcharType.VARCHAR)).add((Object)Expressions.constant(null, (Type)VarcharType.VARCHAR)).addAll(TestColumnarFilters.buildConstantsList((Type)VarcharType.VARCHAR, 3)).build();
        inFilter = new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List)arguments, functionalDependencies);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)inFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)inFilter);
        arguments = ImmutableList.builder().add((Object)Expressions.field((int)3, (Type)VarcharType.VARCHAR)).add((Object)Expressions.constant(null, (Type)VarcharType.VARCHAR)).addAll(TestColumnarFilters.buildConstantsList((Type)VarcharType.VARCHAR, 100)).build();
        inFilter = new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List)arguments, functionalDependencies);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsSupported((RowExpression)inFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)inFilter);
    }

    @ParameterizedTest
    @MethodSource(value={"inputProviders"})
    public void testInStructuralType(NullsProvider nullsProvider) {
        List<Page> inputPages = TestColumnarFilters.createInputPages(nullsProvider, false);
        List<ResolvedFunction> functionalDependencies = TestColumnarFilters.getInFunctionalDependencies(ARRAY_CHANNEL_TYPE);
        ImmutableList arguments = ImmutableList.builder().add((Object)Expressions.field((int)6, (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant(null, (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(new Long[0]), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992484L, null), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992486L), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992484L, 64992485L), (Type)ARRAY_CHANNEL_TYPE)).build();
        SpecialForm inFilter = new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List)arguments, functionalDependencies);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsNotSupported((RowExpression)inFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)inFilter);
        arguments = ImmutableList.builder().add((Object)Expressions.field((int)6, (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant(null, (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(new Long[0]), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992484L, null), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992486L), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992484L, 64992485L), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992484L, 64992485L, 64992486L), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992486L, null), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992482L, 64992484L, 64992483L), (Type)ARRAY_CHANNEL_TYPE)).add((Object)Expressions.constant((Object)TestColumnarFilters.createIntArray(64992484L, 64992485L), (Type)ARRAY_CHANNEL_TYPE)).build();
        inFilter = new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List)arguments, functionalDependencies);
        TestColumnarFilters.assertThatColumnarFilterEvaluationIsNotSupported((RowExpression)inFilter);
        TestColumnarFilters.verifyFilter(inputPages, (RowExpression)inFilter);
    }

    private static Object[][] inputProviders() {
        return DataProviders.cartesianProduct((Object[][][])new Object[][][]{TestColumnarFilters.nullsProviders(), DataProviders.trueFalse()});
    }

    private static Object[][] nullsProviders() {
        return (Object[][])Stream.of(NullsProvider.values()).collect(DataProviders.toDataProvider());
    }

    private static RowExpression createNotExpression(RowExpression expression) {
        return Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveFunction("$not", TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN})), (RowExpression[])new RowExpression[]{expression});
    }

    private static List<Page> processFilter(List<Page> inputPages, boolean columnarEvaluationEnabled, RowExpression filter) {
        PageProcessor compiledProcessor = (PageProcessor)FUNCTION_RESOLUTION.getExpressionCompiler().compilePageProcessor(columnarEvaluationEnabled, Optional.of(filter), Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT)), Optional.empty(), OptionalInt.empty()).apply(DynamicFilter.EMPTY);
        LocalMemoryContext context = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        ImmutableList.Builder outputPagesBuilder = ImmutableList.builder();
        for (Page inputPage : inputPages) {
            WorkProcessor workProcessor = compiledProcessor.createWorkProcessor((ConnectorSession)FULL_CONNECTOR_SESSION, new DriverYieldSignal(), context, new PageProcessorMetrics(), inputPage);
            if (!workProcessor.process() || workProcessor.isFinished()) continue;
            outputPagesBuilder.add((Object)((Page)workProcessor.getResult()));
        }
        return outputPagesBuilder.build();
    }

    private static List<Page> createInputPages(NullsProvider nullsProvider, boolean dictionaryEncoded) {
        ImmutableList.Builder builder = ImmutableList.builder();
        long rowCount = 0L;
        for (int pageCount = 0; pageCount < 20; ++pageCount) {
            int positionsCount = RANDOM.nextInt(1024, 8192);
            long finalRowCount = rowCount;
            builder.add((Object)new Page(positionsCount, new Block[]{TestColumnarFilters.createRowNumberBlock(finalRowCount, positionsCount), TestColumnarFilters.lazyBlock(positionsCount, () -> TestColumnarFilters.createDoublesBlock(positionsCount, nullsProvider, dictionaryEncoded)), TestColumnarFilters.lazyBlock(positionsCount, () -> TestColumnarFilters.createIntsBlock(positionsCount, nullsProvider, dictionaryEncoded)), TestColumnarFilters.lazyBlock(positionsCount, () -> TestColumnarFilters.createStringsBlock(positionsCount, nullsProvider, dictionaryEncoded)), TestColumnarFilters.lazyBlock(positionsCount, () -> TestColumnarFilters.createIntsBlock(positionsCount, nullsProvider, dictionaryEncoded)), TestColumnarFilters.lazyBlock(positionsCount, () -> TestColumnarFilters.createIntsBlock(positionsCount, nullsProvider, dictionaryEncoded)), TestColumnarFilters.lazyBlock(positionsCount, () -> TestColumnarFilters.createArraysBlock(positionsCount, nullsProvider))}));
            rowCount += (long)positionsCount;
        }
        return builder.build();
    }

    private static Block lazyBlock(int positionCount, LazyBlockLoader loader) {
        return new LazyBlock(positionCount, loader);
    }

    private static Block createRowNumberBlock(long start, int positionsCount) {
        long[] values = new long[positionsCount];
        for (int i = 0; i < positionsCount; ++i) {
            values[i] = start + (long)i;
        }
        return new LongArrayBlock(positionsCount, Optional.empty(), values);
    }

    private static Block createIntsBlock(int positionsCount, NullsProvider nullsProvider, boolean dictionaryEncoded) {
        if (dictionaryEncoded) {
            boolean containsNulls = nullsProvider != NullsProvider.NO_NULLS && nullsProvider != NullsProvider.NO_NULLS_WITH_MAY_HAVE_NULL;
            int nonNullDictionarySize = 20;
            int dictionarySize = nonNullDictionarySize + (containsNulls ? 1 : 0);
            int[] dictionaryValues = new int[dictionarySize];
            for (int i = 0; i < nonNullDictionarySize; ++i) {
                dictionaryValues[i] = Math.toIntExact(64992474L + (long)i);
            }
            Optional<boolean[]> dictionaryIsNull = TestColumnarFilters.getDictionaryIsNull(nullsProvider, dictionarySize);
            IntArrayBlock dictionary = new IntArrayBlock(dictionarySize, dictionaryIsNull, dictionaryValues);
            return TestColumnarFilters.createDictionaryBlock(positionsCount, nullsProvider, (Block)dictionary);
        }
        Optional<boolean[]> isNull = nullsProvider.getNulls(positionsCount);
        Assertions.assertThat((isNull.isEmpty() || isNull.get().length == positionsCount ? 1 : 0) != 0).isTrue();
        int[] values = new int[positionsCount];
        for (int i = 0; i < positionsCount; ++i) {
            if (!isNull.isEmpty() && isNull.get()[i]) continue;
            values[i] = Math.toIntExact(RANDOM.nextLong(64992474L, 64992494L));
        }
        return new IntArrayBlock(positionsCount, isNull, values);
    }

    private static Block createDoublesBlock(int positionsCount, NullsProvider nullsProvider, boolean dictionaryEncoded) {
        if (dictionaryEncoded) {
            boolean containsNulls = nullsProvider != NullsProvider.NO_NULLS && nullsProvider != NullsProvider.NO_NULLS_WITH_MAY_HAVE_NULL;
            int nonNullDictionarySize = 200;
            int dictionarySize = nonNullDictionarySize + (containsNulls ? 1 : 0);
            long[] dictionaryValues = new long[dictionarySize];
            for (int i = 0; i < nonNullDictionarySize; ++i) {
                dictionaryValues[i] = Double.doubleToLongBits(64992384L + (long)i);
            }
            Optional<boolean[]> dictionaryIsNull = TestColumnarFilters.getDictionaryIsNull(nullsProvider, dictionarySize);
            LongArrayBlock dictionary = new LongArrayBlock(dictionarySize, dictionaryIsNull, dictionaryValues);
            return TestColumnarFilters.createDictionaryBlock(positionsCount, nullsProvider, (Block)dictionary);
        }
        Optional<boolean[]> isNull = nullsProvider.getNulls(positionsCount);
        Assertions.assertThat((isNull.isEmpty() || isNull.get().length == positionsCount ? 1 : 0) != 0).isTrue();
        long[] values = new long[positionsCount];
        for (int i = 0; i < positionsCount; ++i) {
            if (!isNull.isEmpty() && isNull.get()[i]) continue;
            values[i] = Double.doubleToLongBits(RANDOM.nextDouble(6.4992384E7, 6.4992584E7));
        }
        return new LongArrayBlock(positionsCount, isNull, values);
    }

    private static Block createStringsBlock(int positionsCount, NullsProvider nullsProvider, boolean dictionaryEncoded) {
        if (dictionaryEncoded) {
            boolean containsNulls = nullsProvider != NullsProvider.NO_NULLS && nullsProvider != NullsProvider.NO_NULLS_WITH_MAY_HAVE_NULL;
            int nonNullDictionarySize = 20;
            int dictionarySize = nonNullDictionarySize + (containsNulls ? 1 : 0);
            VariableWidthBlockBuilder builder = new VariableWidthBlockBuilder(null, dictionarySize, dictionarySize * 10);
            for (int i = 0; i < nonNullDictionarySize; ++i) {
                builder.writeEntry(Slices.utf8Slice((String)Long.toString(64992474L + (long)i)));
            }
            if (containsNulls) {
                builder.appendNull();
            }
            return TestColumnarFilters.createDictionaryBlock(positionsCount, nullsProvider, builder.build());
        }
        Optional<boolean[]> isNull = nullsProvider.getNulls(positionsCount);
        Assertions.assertThat((isNull.isEmpty() || isNull.get().length == positionsCount ? 1 : 0) != 0).isTrue();
        VariableWidthBlockBuilder builder = new VariableWidthBlockBuilder(null, positionsCount, positionsCount * 10);
        for (int i = 0; i < positionsCount; ++i) {
            if (isNull.isPresent() && isNull.get()[i]) {
                builder.appendNull();
                continue;
            }
            builder.writeEntry(Slices.utf8Slice((String)Long.toString(RANDOM.nextLong(64992474L, 64992494L))));
        }
        return builder.build();
    }

    private static Block createArraysBlock(int positionsCount, NullsProvider nullsProvider) {
        ArrayBlockBuilder builder = new ArrayBlockBuilder((Type)IntegerType.INTEGER, null, positionsCount);
        Optional<boolean[]> isNull = nullsProvider.getNulls(positionsCount);
        Assertions.assertThat((isNull.isEmpty() || isNull.get().length == positionsCount ? 1 : 0) != 0).isTrue();
        for (int position = 0; position < positionsCount; ++position) {
            if (isNull.isPresent() && isNull.get()[position]) {
                builder.appendNull();
                continue;
            }
            builder.buildEntry(elementBuilder -> {
                int valuesCount = RANDOM.nextInt(4);
                for (int i = 0; i < valuesCount; ++i) {
                    IntegerType.INTEGER.writeInt(elementBuilder, Math.toIntExact(64992484L + (long)i));
                }
                if (RANDOM.nextInt(100) < 10) {
                    elementBuilder.appendNull();
                }
            });
        }
        return builder.build();
    }

    private static Optional<boolean[]> getDictionaryIsNull(NullsProvider nullsProvider, int dictionarySize) {
        Optional<boolean[]> dictionaryIsNull = Optional.empty();
        if (nullsProvider != NullsProvider.NO_NULLS) {
            dictionaryIsNull = Optional.of(new boolean[dictionarySize]);
            if (nullsProvider != NullsProvider.NO_NULLS_WITH_MAY_HAVE_NULL) {
                dictionaryIsNull.get()[dictionarySize - 1] = true;
            }
        }
        return dictionaryIsNull;
    }

    private static Block createDictionaryBlock(int positionsCount, NullsProvider nullsProvider, Block dictionary) {
        Optional<boolean[]> isNull = nullsProvider.getNulls(positionsCount);
        Assertions.assertThat((isNull.isEmpty() || isNull.get().length == positionsCount ? 1 : 0) != 0).isTrue();
        boolean containsNulls = nullsProvider != NullsProvider.NO_NULLS && nullsProvider != NullsProvider.NO_NULLS_WITH_MAY_HAVE_NULL;
        int dictionarySize = dictionary.getPositionCount();
        int nonNullDictionarySize = dictionarySize - (containsNulls ? 1 : 0);
        int[] ids = new int[positionsCount];
        for (int i = 0; i < positionsCount; ++i) {
            ids[i] = isNull.isPresent() && isNull.get()[i] ? dictionarySize - 1 : RANDOM.nextInt(nonNullDictionarySize);
        }
        return DictionaryBlock.create((int)positionsCount, (Block)dictionary, (int[])ids);
    }

    private static List<ResolvedFunction> getInFunctionalDependencies(Type type) {
        return ImmutableList.of((Object)FUNCTION_RESOLUTION.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)), (Object)FUNCTION_RESOLUTION.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type)), (Object)FUNCTION_RESOLUTION.resolveOperator(OperatorType.INDETERMINATE, (List<? extends Type>)ImmutableList.of((Object)type)));
    }

    private static List<RowExpression> buildConstantsList(Type type, int size) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long i = 0L; i < (long)size; ++i) {
            if (type == IntegerType.INTEGER) {
                builder.add((Object)Expressions.constant((Object)(64992484L + i), (Type)type));
                continue;
            }
            if (type == VarcharType.VARCHAR) {
                builder.add((Object)Expressions.constant((Object)Slices.utf8Slice((String)Long.toString(RANDOM.nextLong(64992484L + i))), (Type)type));
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return builder.build();
    }

    private static Block createIntArray(Long ... values) {
        IntArrayBlockBuilder builder = new IntArrayBlockBuilder(null, values.length);
        for (Long value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            IntegerType.INTEGER.writeInt((BlockBuilder)builder, Math.toIntExact(value));
        }
        return builder.build();
    }

    private static void verifyFilter(List<Page> inputPages, RowExpression filter) {
        TestColumnarFilters.verifyFilterInternal(inputPages, filter);
        ResolvedFunction customIsDistinctFrom = FUNCTION_RESOLUTION.functionCallBuilder("custom_is_distinct_from").addArgument((Type)IntegerType.INTEGER, (Expression)new Reference((Type)IntegerType.INTEGER, "left")).addArgument((Type)IntegerType.INTEGER, (Expression)new Reference((Type)IntegerType.INTEGER, "right")).build().function();
        SpecialForm andFilter = new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.call((ResolvedFunction)customIsDistinctFrom, (RowExpression[])new RowExpression[]{Expressions.constant((Object)64992487L, (Type)IntegerType.INTEGER), Expressions.field((int)4, (Type)IntegerType.INTEGER)}), (Object)filter), (List)ImmutableList.of());
        TestColumnarFilters.verifyFilterInternal(inputPages, (RowExpression)andFilter);
    }

    private static void verifyFilterInternal(List<Page> inputPages, RowExpression filter) {
        List<Page> outputPagesExpected = TestColumnarFilters.processFilter(inputPages, false, filter);
        List<Page> outputPagesActual = TestColumnarFilters.processFilter(inputPages, true, filter);
        Assertions.assertThat((int)outputPagesExpected.size()).isEqualTo(outputPagesActual.size());
        for (int pageCount = 0; pageCount < outputPagesActual.size(); ++pageCount) {
            TestColumnarFilters.assertPageEquals((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), outputPagesActual.get(pageCount), outputPagesExpected.get(pageCount));
        }
    }

    private static void assertPageEquals(List<Type> types, Page actual, Page expected) {
        Assertions.assertThat((int)actual.getChannelCount()).isEqualTo(expected.getChannelCount());
        Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(expected.getPositionCount());
        Assertions.assertThat((int)types.size()).isEqualTo(actual.getChannelCount());
        for (int channel = 0; channel < types.size(); ++channel) {
            BlockTestUtils.assertBlockEquals((Type)types.get(channel), (Block)actual.getBlock(channel), (Block)expected.getBlock(channel));
        }
    }

    private static void assertThatColumnarFilterEvaluationIsSupported(RowExpression filterExpression) {
        Assertions.assertThat((Optional)FilterEvaluator.createColumnarFilterEvaluator((RowExpression)filterExpression, (ColumnarFilterCompiler)COMPILER)).isPresent();
    }

    private static void assertThatColumnarFilterEvaluationIsNotSupported(RowExpression filterExpression) {
        Assertions.assertThat((Optional)FilterEvaluator.createColumnarFilterEvaluator((RowExpression)filterExpression, (ColumnarFilterCompiler)COMPILER)).isEmpty();
    }

    public static enum NullsProvider {
        NO_NULLS{

            @Override
            Optional<boolean[]> getNulls(int positionCount) {
                return Optional.empty();
            }
        }
        ,
        NO_NULLS_WITH_MAY_HAVE_NULL{

            @Override
            Optional<boolean[]> getNulls(int positionCount) {
                return Optional.of(new boolean[positionCount]);
            }
        }
        ,
        ALL_NULLS{

            @Override
            Optional<boolean[]> getNulls(int positionCount) {
                boolean[] nulls = new boolean[positionCount];
                Arrays.fill(nulls, true);
                return Optional.of(nulls);
            }
        }
        ,
        RANDOM_NULLS{

            @Override
            Optional<boolean[]> getNulls(int positionCount) {
                boolean[] nulls = new boolean[positionCount];
                for (int i = 0; i < positionCount; ++i) {
                    nulls[i] = RANDOM.nextBoolean();
                }
                return Optional.of(nulls);
            }
        }
        ,
        GROUPED_NULLS{

            @Override
            Optional<boolean[]> getNulls(int positionCount) {
                int groupSize;
                boolean[] nulls = new boolean[positionCount];
                int maxGroupSize = 23;
                for (int position = 0; position < positionCount; position += groupSize) {
                    int remaining = positionCount - position;
                    groupSize = Math.min(RANDOM.nextInt(maxGroupSize) + 1, remaining);
                    Arrays.fill(nulls, position, position + groupSize, RANDOM.nextBoolean());
                }
                return Optional.of(nulls);
            }
        };


        abstract Optional<boolean[]> getNulls(int var1);
    }

    @ScalarFunction(value="custom_is_null")
    public static final class NullableReturnFunction {
        private NullableReturnFunction() {
        }

        @LiteralParameters(value={"x"})
        @SqlType(value="boolean")
        @SqlNullable
        public static Boolean customIsNullVarchar(@SqlNullable @SqlType(value="varchar(x)") Slice slice) {
            return slice == null ? null : Boolean.valueOf(false);
        }
    }

    @ScalarFunction(value="is_user_admin")
    public static final class ConnectorSessionFunction {
        private ConnectorSessionFunction() {
        }

        @LiteralParameters(value={"x"})
        @SqlType(value="boolean")
        public static boolean isUserAdmin(ConnectorSession session) {
            return "admin".equals(session.getUser());
        }
    }

    @ScalarFunction(value="is_answer_to_universe")
    public static final class InstanceFactoryFunction {
        private final long precomputed = Long.parseLong("42");

        @SqlType(value="boolean")
        public boolean isAnswerToUniverse(@SqlType(value="integer") long value) {
            return this.precomputed == value;
        }
    }

    @ScalarFunction(value="custom_is_distinct_from")
    public static final class CustomIsDistinctFrom {
        private CustomIsDistinctFrom() {
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean isDistinctFromLong(@SqlNullable @SqlType(value="T") Long left, @SqlNullable @SqlType(value="T") Long right) {
            if (left == null && right == null) {
                return false;
            }
            if (left == null || right == null) {
                return true;
            }
            return left.equals(right);
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean isDistinctFromSlice(@SqlNullable @SqlType(value="T") Slice left, @SqlNullable @SqlType(value="T") Slice right) {
            if (left == null && right == null) {
                return false;
            }
            if (left == null || right == null) {
                return true;
            }
            return left.equals((Object)right);
        }
    }
}

