/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slices;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.block.BlockAssertions;
import io.trino.metadata.FunctionManager;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.gen.columnar.DynamicPageFilter;
import io.trino.sql.gen.columnar.FilterEvaluator;
import io.trino.sql.planner.CompilerConfig;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDynamicPageFilter {
    private static final ColumnarFilterCompiler COMPILER = new ColumnarFilterCompiler(FunctionManager.createTestingFunctionManager(), new CompilerConfig());
    private static final Session SESSION = TestingSession.testSessionBuilder().build();
    private static final FullConnectorSession FULL_CONNECTOR_SESSION = new FullConnectorSession(TestingSession.testSessionBuilder().build(), ConnectorIdentity.ofUser((String)"test"));

    @Test
    public void testAllPageFilter() {
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(1L, 2L, null, 5L, null), BlockAssertions.createLongsBlock(null, 102L, 135L, null, 3L)});
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.all(), (Map<ColumnHandle, Integer>)ImmutableMap.of());
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), page.getPositionCount());
    }

    @Test
    public void testNonePageFilter() {
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(1L, 2L, null, 5L, null), BlockAssertions.createLongsBlock(null, 102L, 135L, null, 3L)});
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.none(), (Map<ColumnHandle, Integer>)ImmutableMap.of());
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), 0);
    }

    @Test
    public void testStringFilter() {
        TestingColumnHandle column = new TestingColumnHandle("column");
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.onlyNull((Type)VarcharType.VARCHAR))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0));
        Page page = new Page(new Block[]{BlockAssertions.createStringsBlock("ab", "bc", null, "cd", null), BlockAssertions.createStringsBlock(null, "de", "ef", null, "fg")});
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{2, 4});
        filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.multipleValues((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)"bc", (Object)"cd")))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0));
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{1, 3});
        filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"ab"), (Object[])new Object[0]), (boolean)true))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0));
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{0, 2, 4});
    }

    @Test
    public void testLongBlockFilter() {
        TestingColumnHandle column = new TestingColumnHandle("column");
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.onlyNull((Type)IntegerType.INTEGER))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0));
        Page page = new Page(new Block[]{BlockAssertions.createTypedLongsBlock((Type)IntegerType.INTEGER, 1L, 2L, null, 5L, null), BlockAssertions.createTypedLongsBlock((Type)IntegerType.INTEGER, null, 102L, 135L, null, 3L)});
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{2, 4});
        filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)2L, (Object)3L, (Object)4L, (Object)5L)))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0));
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{1, 3});
        filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.create((ValueSet)ValueSet.of((Type)IntegerType.INTEGER, (Object)1L, (Object[])new Object[0]), (boolean)true))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0));
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{0, 2, 4});
    }

    @Test
    public void testStructuralTypeFilter() {
        TestingColumnHandle column = new TestingColumnHandle("column");
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)IntegerType.INTEGER), new RowType.Field(Optional.of("b"), (Type)DoubleType.DOUBLE)});
        RowBlock rowBlock = BlockAssertions.createRowBlock((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), {5, 3.14159265358979}, {6, 3.14159265358979}, {7, 3.14159265358979});
        Block[] filterBlocks = rowBlock.getFieldBlocks().toArray(new Block[0]);
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.multipleValues((Type)rowType, (List)ImmutableList.of((Object)new SqlRow(0, filterBlocks), (Object)new SqlRow(1, filterBlocks))))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0));
        Page page = new Page(new Block[]{rowBlock});
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), page.getPositionCount());
    }

    @Test
    public void testSelectivePageFilter() {
        TestingColumnHandle columnB = new TestingColumnHandle("columnB");
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnB, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)-10L, (Object)5L, (Object)15L, (Object)135L, (Object)185L, (Object)250L)))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)columnB, (Object)1));
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101), BlockAssertions.createLongSequenceBlock(100, 201)});
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{35, 85});
        page = new Page(new Block[]{BlockAssertions.createLongsBlock(1L, 2L, null, 5L, null), BlockAssertions.createLongsBlock(null, 102L, 135L, null, 3L)});
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{2});
    }

    @Test
    public void testNonSelectivePageFilter() {
        TestingColumnHandle columnB = new TestingColumnHandle("columnB");
        List filterValues = (List)LongStream.range(-5L, 205L).boxed().collect(ImmutableList.toImmutableList());
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnB, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)filterValues))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)columnB, (Object)1));
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101), BlockAssertions.createLongSequenceBlock(100, 201)});
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), 101);
        page = new Page(new Block[]{BlockAssertions.createLongsBlock(1L, 2L, null, 5L, null), BlockAssertions.createLongsBlock(null, 102L, 135L, null, 3L)});
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{1, 2, 4});
    }

    @Test
    public void testPageFilterWithPositionsList() {
        TestingColumnHandle columnA = new TestingColumnHandle("columnA");
        TestingColumnHandle columnB = new TestingColumnHandle("columnB");
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnA, (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L}), (boolean)true), (Object)columnB, (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[]{2L, 3L}), (boolean)true))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)columnA, (Object)0, (Object)columnB, (Object)1));
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(new Page(new Block[]{BlockAssertions.createLongsBlock(3, 1, 5), BlockAssertions.createLongsBlock(3L, null, 1L)}), filterEvaluator), new int[]{0, 1});
    }

    @Test
    public void testPageFilterWithRealNaN() {
        TestingColumnHandle column = new TestingColumnHandle("column");
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.multipleValues((Type)RealType.REAL, (List)ImmutableList.of((Object)Float.floatToRawIntBits(32.0f), (Object)Float.floatToRawIntBits(54.6f))))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0));
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(new Page(new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(42.0f), Float.valueOf(Float.NaN), Float.valueOf(32.0f), null, Float.valueOf(53.1f))}), filterEvaluator), new int[]{2});
    }

    @Test
    public void testDynamicFilterUpdates() {
        TestingColumnHandle columnA = new TestingColumnHandle("columnA");
        Symbol symbolA = new Symbol((Type)BigintType.BIGINT, "A");
        TestingColumnHandle columnB = new TestingColumnHandle("columnB");
        Symbol symbolB = new Symbol((Type)BigintType.BIGINT, "B");
        TestingColumnHandle columnC = new TestingColumnHandle("columnC");
        Symbol symbolC = new Symbol((Type)BigintType.BIGINT, "C");
        TestingDynamicFilter dynamicFilter = new TestingDynamicFilter(4);
        DynamicPageFilter pageFilter = new DynamicPageFilter(TestingPlannerContext.PLANNER_CONTEXT, SESSION, (Map)ImmutableMap.of((Object)symbolA, (Object)columnA, (Object)symbolB, (Object)columnB, (Object)symbolC, (Object)columnC), (Map)ImmutableMap.of((Object)symbolA, (Object)0, (Object)symbolB, (Object)1, (Object)symbolC, (Object)2), 1.0);
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101), BlockAssertions.createLongSequenceBlock(100, 201), BlockAssertions.createLongSequenceBlock(200, 301)});
        FilterEvaluator filterEvaluator = (FilterEvaluator)pageFilter.createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter).get();
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), 101);
        dynamicFilter.update((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnB, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)131L, (Object)142L)))));
        filterEvaluator = (FilterEvaluator)pageFilter.createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter).get();
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{31, 42});
        dynamicFilter.update((TupleDomain<ColumnHandle>)TupleDomain.all());
        dynamicFilter.update((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnC, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)231L))));
        filterEvaluator = (FilterEvaluator)pageFilter.createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter).get();
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{31});
        dynamicFilter.update((TupleDomain<ColumnHandle>)TupleDomain.all());
        Supplier filterEvaluatorSupplier = pageFilter.createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter);
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, (FilterEvaluator)filterEvaluatorSupplier.get()), new int[]{31});
        Assertions.assertThat((boolean)dynamicFilter.isComplete()).isTrue();
        Assertions.assertThat((Object)pageFilter.createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter)).isEqualTo((Object)filterEvaluatorSupplier);
    }

    @Test
    public void testDifferentDynamicFilterInstances() {
        TestingColumnHandle columnA = new TestingColumnHandle("columnA");
        Symbol symbolA = new Symbol((Type)BigintType.BIGINT, "A");
        TestingColumnHandle columnB = new TestingColumnHandle("columnB");
        Symbol symbolB = new Symbol((Type)BigintType.BIGINT, "B");
        TestingColumnHandle columnC = new TestingColumnHandle("columnC");
        Symbol symbolC = new Symbol((Type)BigintType.BIGINT, "C");
        DynamicPageFilter pageFilter = new DynamicPageFilter(TestingPlannerContext.PLANNER_CONTEXT, SESSION, (Map)ImmutableMap.of((Object)symbolA, (Object)columnA, (Object)symbolB, (Object)columnB, (Object)symbolC, (Object)columnC), (Map)ImmutableMap.of((Object)symbolA, (Object)0, (Object)symbolB, (Object)1, (Object)symbolC, (Object)2), 1.0);
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101), BlockAssertions.createLongSequenceBlock(100, 201), BlockAssertions.createLongSequenceBlock(200, 301)});
        TestingDynamicFilter dynamicFilter = new TestingDynamicFilter(1);
        dynamicFilter.update((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnB, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)131L, (Object)142L)))));
        FilterEvaluator filterEvaluator = (FilterEvaluator)pageFilter.createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter).get();
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), new int[]{31, 42});
        dynamicFilter = new TestingDynamicFilter(1);
        dynamicFilter.update((TupleDomain<ColumnHandle>)TupleDomain.all());
        filterEvaluator = (FilterEvaluator)pageFilter.createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter).get();
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, filterEvaluator), 101);
        dynamicFilter = new TestingDynamicFilter(1);
        dynamicFilter.update((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnC, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)231L))));
        Supplier filterEvaluatorSupplier = pageFilter.createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter);
        TestDynamicPageFilter.verifySelectedPositions(TestDynamicPageFilter.filterPage(page, (FilterEvaluator)filterEvaluatorSupplier.get()), new int[]{31});
        dynamicFilter = new TestingDynamicFilter(1);
        dynamicFilter.update((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnC, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)231L))));
        Assertions.assertThat((Object)pageFilter.createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter)).isEqualTo((Object)filterEvaluatorSupplier);
    }

    @Test
    public void testIneffectiveFilter() {
        TestingColumnHandle column = new TestingColumnHandle("column");
        List<Page> inputPages = TestDynamicPageFilter.generateInputPages(3, 1, 1024);
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)TestDynamicPageFilter.getRangePredicate(100L, 5000L))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0), 0.9);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(0), filterEvaluator).size()).isEqualTo(924);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(1), filterEvaluator).size()).isEqualTo(924);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(2), filterEvaluator).size()).isEqualTo(1024);
        Assertions.assertThat((Object)inputPages.get(2).getBlock(0)).isInstanceOf(LazyBlock.class);
    }

    @Test
    public void testEffectiveFilter() {
        TestingColumnHandle column = new TestingColumnHandle("column");
        List<Page> inputPages = TestDynamicPageFilter.generateInputPages(5, 1, 1024);
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)13L))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)column, (Object)0), 0.1);
        for (Page inputPage : inputPages) {
            Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPage, filterEvaluator).size()).isEqualTo(1);
        }
    }

    @Test
    public void testIneffectiveFilterFirst() {
        TestingColumnHandle columnA = new TestingColumnHandle("columnA");
        TestingColumnHandle columnB = new TestingColumnHandle("columnB");
        List<Page> inputPages = TestDynamicPageFilter.generateInputPages(3, 2, 1024);
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnA, (Object)TestDynamicPageFilter.getRangePredicate(100L, 1024L), (Object)columnB, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)13L))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)columnA, (Object)0, (Object)columnB, (Object)1), 0.9);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(0), filterEvaluator).size()).isEqualTo(0);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(1), filterEvaluator).size()).isEqualTo(0);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(2), filterEvaluator).size()).isEqualTo(1);
        Assertions.assertThat((Object)inputPages.get(2).getBlock(0)).isInstanceOf(LazyBlock.class);
    }

    @Test
    public void testIneffectiveFilterLast() {
        TestingColumnHandle columnA = new TestingColumnHandle("columnA");
        TestingColumnHandle columnB = new TestingColumnHandle("columnB");
        List<Page> inputPages = TestDynamicPageFilter.generateInputPages(4, 2, 1024);
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnA, (Object)TestDynamicPageFilter.getRangePredicate(50L, 950L), (Object)columnB, (Object)TestDynamicPageFilter.getRangePredicate(100L, 1024L))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)columnA, (Object)0, (Object)columnB, (Object)1), 0.9);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(0), filterEvaluator).size()).isEqualTo(850);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(1), filterEvaluator).size()).isEqualTo(850);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(2), filterEvaluator).size()).isEqualTo(850);
        Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPages.get(3), filterEvaluator).size()).isEqualTo(900);
        Assertions.assertThat((Object)inputPages.get(3).getBlock(1)).isInstanceOf(LazyBlock.class);
    }

    @Test
    public void testMultipleColumnsShortCircuit() {
        TestingColumnHandle columnA = new TestingColumnHandle("columnA");
        TestingColumnHandle columnB = new TestingColumnHandle("columnB");
        TestingColumnHandle columnC = new TestingColumnHandle("columnC");
        List<Page> inputPages = TestDynamicPageFilter.generateInputPages(5, 3, 100);
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnA, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)-10L, (Object)5L, (Object)15L, (Object)35L, (Object)50L, (Object)85L, (Object)95L, (Object)105L)), (Object)columnB, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), (Object)columnC, (Object)TestDynamicPageFilter.getRangePredicate(150L, 250L))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)columnA, (Object)0, (Object)columnB, (Object)1, (Object)columnC, (Object)2));
        for (Page inputPage : inputPages) {
            Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPage, filterEvaluator).size()).isEqualTo(0);
            Assertions.assertThat((Object)inputPage.getBlock(0)).isNotInstanceOf(LazyBlock.class);
            Assertions.assertThat((Object)inputPage.getBlock(1)).isNotInstanceOf(LazyBlock.class);
            Assertions.assertThat((Object)inputPage.getBlock(2)).isInstanceOf(LazyBlock.class);
        }
    }

    @Test
    public void testDynamicFilterOnSubsetOfColumns() {
        TestingColumnHandle columnB = new TestingColumnHandle("columnB");
        TestingColumnHandle columnD = new TestingColumnHandle("columnD");
        List<Page> inputPages = TestDynamicPageFilter.generateInputPages(5, 5, 1024);
        FilterEvaluator filterEvaluator = TestDynamicPageFilter.createDynamicFilterEvaluator((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnB, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)-10L, (Object)5L, (Object)15L, (Object)35L, (Object)50L, (Object)85L, (Object)95L, (Object)105L)), (Object)columnD, (Object)TestDynamicPageFilter.getRangePredicate(-50L, 90L))), (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)columnB, (Object)1, (Object)columnD, (Object)3));
        for (Page inputPage : inputPages) {
            Assertions.assertThat((int)TestDynamicPageFilter.filterPage(inputPage, filterEvaluator).size()).isEqualTo(5);
            Assertions.assertThat((Object)inputPage.getBlock(0)).isInstanceOf(LazyBlock.class);
            Assertions.assertThat((Object)inputPage.getBlock(1)).isNotInstanceOf(LazyBlock.class);
            Assertions.assertThat((Object)inputPage.getBlock(2)).isInstanceOf(LazyBlock.class);
            Assertions.assertThat((Object)inputPage.getBlock(3)).isNotInstanceOf(LazyBlock.class);
            Assertions.assertThat((Object)inputPage.getBlock(4)).isInstanceOf(LazyBlock.class);
        }
    }

    private static FilterEvaluator createDynamicFilterEvaluator(TupleDomain<ColumnHandle> tupleDomain, Map<ColumnHandle, Integer> channels) {
        return TestDynamicPageFilter.createDynamicFilterEvaluator(tupleDomain, channels, 1.0);
    }

    private static FilterEvaluator createDynamicFilterEvaluator(TupleDomain<ColumnHandle> tupleDomain, Map<ColumnHandle, Integer> channels, double selectivityThreshold) {
        TestingDynamicFilter dynamicFilter = new TestingDynamicFilter(1);
        dynamicFilter.update(tupleDomain);
        Map types = (Map)((Map)tupleDomain.getDomains().orElse(ImmutableMap.of())).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Domain)entry.getValue()).getType()));
        int index = 0;
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableMap.Builder layout = ImmutableMap.builder();
        for (Map.Entry<ColumnHandle, Integer> entry2 : channels.entrySet()) {
            ColumnHandle column = entry2.getKey();
            Symbol symbol = new Symbol((Type)types.get(column), "col" + index++);
            columns.put((Object)symbol, (Object)column);
            int channel = entry2.getValue();
            layout.put((Object)symbol, (Object)channel);
        }
        return (FilterEvaluator)new DynamicPageFilter(TestingPlannerContext.PLANNER_CONTEXT, SESSION, (Map)columns.buildOrThrow(), (Map)layout.buildOrThrow(), selectivityThreshold).createDynamicPageFilterEvaluator(COMPILER, (DynamicFilter)dynamicFilter).get();
    }

    private static SelectedPositions filterPage(Page page, FilterEvaluator filterEvaluator) {
        FilterEvaluator.SelectionResult result = filterEvaluator.evaluate((ConnectorSession)FULL_CONNECTOR_SESSION, SelectedPositions.positionsRange((int)0, (int)page.getPositionCount()), page);
        return result.selectedPositions();
    }

    private static void verifySelectedPositions(SelectedPositions selectedPositions, int[] positions) {
        Assertions.assertThat((boolean)selectedPositions.isList()).isTrue();
        Assertions.assertThat((int)selectedPositions.getOffset()).isEqualTo(0);
        Assertions.assertThat((int)selectedPositions.size()).isEqualTo(positions.length);
        Assertions.assertThat((int[])Arrays.copyOf(selectedPositions.getPositions(), positions.length)).isEqualTo((Object)positions);
    }

    private static void verifySelectedPositions(SelectedPositions selectedPositions, int rangeSize) {
        Assertions.assertThat((boolean)selectedPositions.isList()).isFalse();
        Assertions.assertThat((int)selectedPositions.getOffset()).isEqualTo(0);
        Assertions.assertThat((int)selectedPositions.size()).isEqualTo(rangeSize);
    }

    private static List<Page> generateInputPages(int pages, int blocks, int positionsPerBlock) {
        return (List)IntStream.range(0, pages).mapToObj(i -> new Page((Block[])IntStream.range(0, blocks).mapToObj(n -> new LazyBlock(positionsPerBlock, () -> BlockAssertions.createLongSequenceBlock(0, positionsPerBlock))).toArray(Block[]::new))).collect(ImmutableList.toImmutableList());
    }

    private static Domain getRangePredicate(long start, long end) {
        return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)start, (boolean)true, (Object)end, (boolean)false), (Range[])new Range[0]), (boolean)false);
    }

    private static class TestingDynamicFilter
    implements DynamicFilter {
        private CompletableFuture<?> isBlocked;
        private TupleDomain<ColumnHandle> currentPredicate;
        private int futuresLeft;

        private TestingDynamicFilter(int expectedFilters) {
            this.futuresLeft = expectedFilters;
            this.isBlocked = expectedFilters == 0 ? NOT_BLOCKED : new CompletableFuture();
            this.currentPredicate = TupleDomain.all();
        }

        public void update(TupleDomain<ColumnHandle> predicate) {
            --this.futuresLeft;
            Verify.verify((this.futuresLeft >= 0 ? 1 : 0) != 0);
            this.currentPredicate = this.currentPredicate.intersect(predicate);
            CompletableFuture<?> currentFuture = this.isBlocked;
            this.isBlocked = this.isComplete() ? NOT_BLOCKED : new CompletableFuture();
            Verify.verify((boolean)currentFuture.complete(null));
        }

        public Set<ColumnHandle> getColumnsCovered() {
            return ((Map)this.currentPredicate.getDomains().orElseThrow()).keySet();
        }

        public CompletableFuture<?> isBlocked() {
            return MoreFutures.unmodifiableFuture(this.isBlocked);
        }

        public boolean isComplete() {
            return this.futuresLeft == 0;
        }

        public boolean isAwaitable() {
            return this.futuresLeft > 0;
        }

        public TupleDomain<ColumnHandle> getCurrentPredicate() {
            return this.currentPredicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingDynamicFilter that = (TestingDynamicFilter)o;
            return this.futuresLeft == that.futuresLeft && Objects.equals(this.isBlocked, that.isBlocked) && Objects.equals(this.currentPredicate, that.currentPredicate);
        }

        public int hashCode() {
            return Objects.hash(this.isBlocked, this.currentPredicate, this.futuresLeft);
        }
    }
}

