/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.RemoveRedundantInItems;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantInItems {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", (List<TypeSignatureProvider>)ImmutableList.of());
    private static final ResolvedFunction IS_INDETERMINATE = FUNCTIONS.resolveOperator(OperatorType.INDETERMINATE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT));

    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "y"))))).isEqualTo(Optional.of(new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y"))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x"), (Object)new Reference((Type)BigintType.BIGINT, "y"))))).describedAs("exact match, no item can fail", new Object[0])).isEqualTo(Optional.of(IrExpressions.ifExpression((Expression)new Call(IS_INDETERMINATE, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x"))), (Expression)Booleans.NULL_BOOLEAN, (Expression)Booleans.TRUE)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "y"), (Object)new Reference((Type)BigintType.BIGINT, "z"), (Object)new Reference((Type)BigintType.BIGINT, "y"))))).describedAs("no exact match, no item can fail", new Object[0])).isEqualTo(Optional.of(new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "y"), (Object)new Reference((Type)BigintType.BIGINT, "z")))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x"), (Object)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, "y"), (Type)BigintType.BIGINT))))).describedAs("exact match found, another item can fail", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x"), (Object)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, "y"), (Type)BigintType.BIGINT), (Object)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, "y"), (Type)BigintType.BIGINT))))).describedAs("exact match found, another item can fail, duplicate removed", new Object[0])).isEqualTo(Optional.of(new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x"), (Object)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, "y"), (Type)BigintType.BIGINT)))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Call(RANDOM, (List)ImmutableList.of()), (Object)new Call(RANDOM, (List)ImmutableList.of()))))).describedAs("non-deterministic items", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "x"), (Object)new Reference((Type)DoubleType.DOUBLE, "x"), (Object)new Call(RANDOM, (List)ImmutableList.of()), (Object)new Call(RANDOM, (List)ImmutableList.of()))))).describedAs("non-deterministic items", new Object[0])).isEqualTo(Optional.of(new In((Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "x"), (Object)new Call(RANDOM, (List)ImmutableList.of()), (Object)new Call(RANDOM, (List)ImmutableList.of())))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Call(RANDOM, (List)ImmutableList.of()), (List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "x"), (Object)new Reference((Type)DoubleType.DOUBLE, "x"), (Object)new Call(RANDOM, (List)ImmutableList.of()), (Object)new Call(RANDOM, (List)ImmutableList.of()))))).describedAs("non-deterministic value", new Object[0])).isEqualTo(Optional.of(new In((Expression)new Call(RANDOM, (List)ImmutableList.of()), (List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "x"), (Object)new Call(RANDOM, (List)ImmutableList.of()), (Object)new Call(RANDOM, (List)ImmutableList.of())))));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new RemoveRedundantInItems(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

