/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.operator.RetryPolicy;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RemoteSourceNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RemoteSourceMatcher
implements Matcher {
    private final List<PlanFragmentId> sourceFragmentIds;
    private final Optional<List<String>> outputSymbols;
    private final Optional<OrderingScheme> orderingScheme;
    private final Optional<ExchangeNode.Type> exchangeType;
    private final Optional<RetryPolicy> retryPolicy;

    public RemoteSourceMatcher(List<PlanFragmentId> sourceFragmentIds, Optional<List<String>> outputSymbols, Optional<OrderingScheme> orderingScheme, Optional<ExchangeNode.Type> exchangeType, Optional<RetryPolicy> retryPolicy) {
        this.sourceFragmentIds = Objects.requireNonNull(sourceFragmentIds, "sourceFragmentIds is null");
        this.outputSymbols = Objects.requireNonNull(outputSymbols, "outputSymbols is null");
        this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.exchangeType = Objects.requireNonNull(exchangeType, "exchangeType is null");
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof RemoteSourceNode && this.sourceFragmentIds.equals(((RemoteSourceNode)node).getSourceFragmentIds());
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        RemoteSourceNode remoteSourceNode = (RemoteSourceNode)node;
        if (this.orderingScheme.isPresent() && !remoteSourceNode.getOrderingScheme().equals(this.orderingScheme)) {
            return MatchResult.NO_MATCH;
        }
        if (this.exchangeType.isPresent() && !remoteSourceNode.getExchangeType().equals((Object)this.exchangeType.get())) {
            return MatchResult.NO_MATCH;
        }
        if (this.retryPolicy.isPresent() && !remoteSourceNode.getRetryPolicy().equals((Object)this.retryPolicy.get())) {
            return MatchResult.NO_MATCH;
        }
        SymbolAliases.Builder newAliases = SymbolAliases.builder();
        if (this.outputSymbols.isPresent()) {
            List actualSymbols = (List)remoteSourceNode.getOutputSymbols().stream().map(Symbol::name).collect(ImmutableList.toImmutableList());
            if (!this.outputSymbols.get().equals(actualSymbols)) {
                return MatchResult.NO_MATCH;
            }
            remoteSourceNode.getOutputSymbols().stream().map(Symbol::toSymbolReference).forEach(reference -> newAliases.put(reference.name(), (Reference)reference));
        }
        return MatchResult.match(newAliases.build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sourceFragmentIds", this.sourceFragmentIds).toString();
    }
}

