/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedScalarSubquery;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedScalarSubquery
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ImmutableList<List<Expression>> ONE_ROW = ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
    private static final ImmutableList<List<Expression>> TWO_ROWS = ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)));
    private Rule<?> rule = new TransformCorrelatedScalarSubquery((Metadata)MetadataManager.createTestMetadataManager());

    public TestTransformCorrelatedScalarSubquery() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutCorrelatedJoinlNode() {
        this.tester().assertThat(this.rule).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedNonScalar() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithoutProjection() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)TWO_ROWS))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(this.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), PlanMatchPattern.values("a")))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjection() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a2", (Type)IntegerType.INTEGER), (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))), (PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)TWO_ROWS)))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(this.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), PlanMatchPattern.values("a"))))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjectionOnTopEnforceSingleNode() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a3", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a2"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (PlanNode)p.enforceSingleRow((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a2", (Type)IntegerType.INTEGER), (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))), (PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)TWO_ROWS))))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(this.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a3", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a2"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), PlanMatchPattern.values("a")))))))));
    }

    @Test
    public void rewritesScalarSubquery() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)Booleans.TRUE, (PlanNode)p.enforceSingleRow((PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)ONE_ROW))))).matches(PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.values("corr"), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), PlanMatchPattern.values("a"))).with(CorrelatedJoinNode.class, join -> join.getType() == JoinType.LEFT));
    }

    private Expression ensureScalarSubquery() {
        return new Switch((Expression)new Reference((Type)BooleanType.BOOLEAN, "is_distinct"), (List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)Booleans.TRUE)), (Expression)new Cast((Expression)LogicalPlanner.failFunction((Metadata)this.tester().getMetadata(), (ErrorCodeSupplier)StandardErrorCode.SUBQUERY_MULTIPLE_ROWS, (String)"Scalar sub-query has returned multiple rows"), (Type)BooleanType.BOOLEAN));
    }
}

