/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CheckReturnValue;
import io.trino.Session;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.StatsCalculator;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNameUtil;
import io.trino.security.AccessControl;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.PlanTester;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Descriptable;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.CanIgnoreReturnValue;
import org.intellij.lang.annotations.Language;

public class QueryAssertions
implements Closeable {
    private final QueryRunner runner;

    public QueryAssertions() {
        this(TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("default").build());
    }

    public QueryAssertions(Session session) {
        this((QueryRunner)new StandaloneQueryRunner(session));
    }

    public QueryAssertions(QueryRunner runner) {
        this.runner = Objects.requireNonNull(runner, "runner is null");
    }

    public Session.SessionBuilder sessionBuilder() {
        return Session.builder((Session)this.runner.getDefaultSession());
    }

    public Session getDefaultSession() {
        return this.runner.getDefaultSession();
    }

    public void addFunctions(FunctionBundle functionBundle) {
        this.runner.addFunctions(functionBundle);
    }

    public void addPlugin(Plugin plugin) {
        this.runner.installPlugin(plugin);
    }

    @CheckReturnValue
    public AssertProvider<QueryAssert> query(@Language(value="SQL") String query) {
        return this.query(this.runner.getDefaultSession(), query);
    }

    @CheckReturnValue
    public AssertProvider<QueryAssert> query(Session session, @Language(value="SQL") String query) {
        return QueryAssert.newQueryAssert(query, this.runner, session);
    }

    public ExpressionAssertProvider expression(@Language(value="SQL") String expression) {
        return this.expression(expression, this.runner.getDefaultSession());
    }

    public ExpressionAssertProvider operator(OperatorType operator, String ... arguments) {
        return this.function(OperatorNameUtil.mangleOperatorName((OperatorType)operator), arguments);
    }

    public ExpressionAssertProvider function(String name, List<String> arguments) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < arguments.size(); ++i) {
            builder.add((Object)("a" + i));
        }
        ImmutableList names = builder.build();
        ExpressionAssertProvider assertion = this.expression("\"%s\"(%s)".formatted(name, String.join((CharSequence)",", (Iterable<? extends CharSequence>)names)));
        for (int i = 0; i < arguments.size(); ++i) {
            assertion.binding((String)names.get(i), arguments.get(i));
        }
        return assertion;
    }

    public ExpressionAssertProvider function(String name, String ... arguments) {
        return this.function(name, Arrays.asList(arguments));
    }

    public ExpressionAssertProvider expression(@Language(value="SQL") String expression, Session session) {
        return new ExpressionAssertProvider(this.runner, session, expression);
    }

    public void assertQueryAndPlan(@Language(value="SQL") String actual, @Language(value="SQL") String expected, PlanMatchPattern pattern) {
        this.assertQuery(this.runner.getDefaultSession(), actual, expected);
        Plan plan = (Plan)this.runner.executeWithPlan(this.runner.getDefaultSession(), actual).queryPlan().orElseThrow();
        PlanAssert.assertPlan(this.runner.getDefaultSession(), this.runner.getPlannerContext().getMetadata(), this.runner.getPlannerContext().getFunctionManager(), this.runner.getStatsCalculator(), plan, pattern);
    }

    private void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.execute(session, actual);
        }
        catch (RuntimeException ex) {
            Assertions.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        MaterializedResult expectedResults = null;
        try {
            expectedResults = this.execute(expected);
        }
        catch (RuntimeException ex) {
            Assertions.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        ((ListAssert)Assertions.assertThat((List)actualResults.getTypes()).as("Types mismatch for query: \n " + actual + "\n:", new Object[0])).isEqualTo((Object)expectedResults.getTypes());
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)actualRows, (Iterable)expectedRows, (String)("For query: \n " + actual));
    }

    public void assertQueryReturnsEmptyResult(@Language(value="SQL") String actual) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.execute(actual);
        }
        catch (RuntimeException ex) {
            Assertions.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        List actualRows = actualResults.getMaterializedRows();
        Assertions.assertThat((int)actualRows.size()).isEqualTo(0);
    }

    public MaterializedResult execute(@Language(value="SQL") String query) {
        return this.execute(this.runner.getDefaultSession(), query);
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String query) {
        MaterializedResult actualResults = this.runner.execute(session, query).toTestTypes();
        return actualResults;
    }

    @Override
    public void close() {
        this.runner.close();
    }

    public QueryRunner getQueryRunner() {
        return this.runner;
    }

    protected void executeExclusively(Runnable executionBlock) {
        this.runner.getExclusiveLock().lock();
        try {
            executionBlock.run();
        }
        finally {
            this.runner.getExclusiveLock().unlock();
        }
    }

    public static class QueryAssert
    implements Descriptable<QueryAssert> {
        private final QueryRunner runner;
        private final Session session;
        private final Optional<String> query;
        private Description description;
        private final Supplier<MaterializedResult> result;
        private boolean ordered;
        private boolean skipTypesCheck;
        private boolean skipResultsCorrectnessCheckForPushdown;

        static AssertProvider<QueryAssert> newQueryAssert(String query, QueryRunner runner, Session session) {
            return () -> new QueryAssert(runner, session, Optional.of(query), (Description)new TextDescription("%s", new Object[]{query}), Optional.empty(), false, false, false);
        }

        private QueryAssert(QueryRunner runner, Session session, Optional<String> query, Description description, Optional<MaterializedResult> result, boolean ordered, boolean skipTypesCheck, boolean skipResultsCorrectnessCheckForPushdown) {
            this.runner = Objects.requireNonNull(runner, "runner is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.query = Objects.requireNonNull(query, "query is null");
            this.description = Objects.requireNonNull(description, "description is null");
            Preconditions.checkArgument((result.isPresent() || query.isPresent() ? 1 : 0) != 0, (Object)"Query must be present when result is empty");
            this.result = (Supplier)result.map(Suppliers::ofInstance).orElseGet(() -> Suppliers.memoize(() -> runner.execute(session, (String)query.orElseThrow())));
            this.ordered = ordered;
            this.skipTypesCheck = skipTypesCheck;
            this.skipResultsCorrectnessCheckForPushdown = skipResultsCorrectnessCheckForPushdown;
        }

        public QueryAssert describedAs(Description description) {
            this.description = Objects.requireNonNull(description, "description is null");
            return this;
        }

        public QueryAssert succeeds() {
            MaterializedResult ignored = this.result.get();
            return this;
        }

        public QueryAssert ordered() {
            this.ordered = true;
            return this;
        }

        public QueryAssert skippingTypesCheck() {
            this.skipTypesCheck = true;
            return this;
        }

        public QueryAssert skipResultsCorrectnessCheckForPushdown() {
            this.skipResultsCorrectnessCheckForPushdown = true;
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert matches(@Language(value="SQL") String query) {
            this.result().matches(query);
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert matches(PlanMatchPattern expectedPlan) {
            Metadata metadata = this.runner.getPlannerContext().getMetadata();
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (Metadata)metadata, (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query());
                PlanAssert.assertPlan(session, metadata, this.runner.getPlannerContext().getFunctionManager(), StatsCalculator.noopStatsCalculator(), plan, expectedPlan);
            });
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert containsAll(@Language(value="SQL") String query) {
            this.result().containsAll(query);
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert returnsEmptyResult() {
            this.result().isEmpty();
            return this;
        }

        @CheckReturnValue
        public TrinoExceptionAssert failure() {
            return TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.result::get);
        }

        @Deprecated(forRemoval=false)
        @CheckReturnValue
        public AbstractThrowableAssert<?, ? extends Throwable> nonTrinoExceptionFailure() {
            return (AbstractThrowableAssert)Assertions.assertThatThrownBy(this.result::get).satisfies(new ThrowingConsumer[]{throwable -> {
                try {
                    TrinoExceptionAssert trinoExceptionAssert = TrinoExceptionAssert.assertThatTrinoException((Throwable)throwable);
                }
                catch (AssertionError expected) {
                    if (!Strings.nullToEmpty((String)((Throwable)((Object)expected)).getMessage()).startsWith("Expected TrinoException or wrapper, but got: ")) {
                        ((Throwable)((Object)expected)).addSuppressed((Throwable)throwable);
                        throw expected;
                    }
                    return;
                }
                throw new AssertionError("Expected non-TrinoException failure, but got: " + String.valueOf(throwable), (Throwable)throwable);
            }});
        }

        @CheckReturnValue
        public ResultAssert result() {
            return new ResultAssert(this.runner, this.session, this.description, this.result.get(), this.ordered, this.skipTypesCheck);
        }

        @CanIgnoreReturnValue
        public QueryAssert isFullyPushedDown() {
            Preconditions.checkState((!(this.runner instanceof PlanTester) ? 1 : 0) != 0, (Object)"isFullyPushedDown() currently does not work with PlanTester");
            Metadata metadata = this.runner.getPlannerContext().getMetadata();
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (Metadata)metadata, (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query());
                PlanAssert.assertPlan(session, metadata, this.runner.getPlannerContext().getFunctionManager(), StatsCalculator.noopStatsCalculator(), plan, PlanMatchPattern.output(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
            });
            if (!this.skipResultsCorrectnessCheckForPushdown) {
                this.hasCorrectResultsRegardlessOfPushdown();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert isReplacedWithEmptyValues() {
            Preconditions.checkState((!(this.runner instanceof PlanTester) ? 1 : 0) != 0, (Object)"isReplacedWithEmptyValues() currently does not work with PlanTester");
            Metadata metadata = this.runner.getPlannerContext().getMetadata();
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (Metadata)metadata, (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query());
                PlanAssert.assertPlan(session, metadata, this.runner.getPlannerContext().getFunctionManager(), StatsCalculator.noopStatsCalculator(), plan, PlanMatchPattern.output(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]).with(ValuesNode.class, valuesNode -> valuesNode.getRowCount() == 0)));
            });
            if (!this.skipResultsCorrectnessCheckForPushdown) {
                this.hasCorrectResultsRegardlessOfPushdown();
            }
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final QueryAssert isNotFullyPushedDown(Class<? extends PlanNode> firstRetainedNode, Class<? extends PlanNode> ... moreRetainedNodes) {
            PlanMatchPattern expectedPlan = PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]);
            List retainedNodes = Lists.asList(firstRetainedNode, (Object[])moreRetainedNodes);
            for (Class retainedNode : ImmutableList.copyOf((Collection)retainedNodes).reverse()) {
                expectedPlan = PlanMatchPattern.node(retainedNode, expectedPlan);
            }
            return this.isNotFullyPushedDown(expectedPlan);
        }

        @CanIgnoreReturnValue
        public QueryAssert isNotFullyPushedDown(PlanMatchPattern retainedSubplan) {
            PlanMatchPattern expectedPlan = PlanMatchPattern.anyTree(retainedSubplan);
            return this.hasPlan(expectedPlan, plan -> {
                if (PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).whereIsInstanceOfAny(new Class[]{TableScanNode.class}).findFirst().isEmpty()) {
                    throw new IllegalArgumentException("Incorrect use of isNotFullyPushedDown: the actual plan matched the expected despite not having a TableScanNode left in the plan. Use hasPlan() instead");
                }
            });
        }

        @CanIgnoreReturnValue
        public QueryAssert joinIsNotFullyPushedDown() {
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (Metadata)this.runner.getPlannerContext().getMetadata(), (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query());
                if (PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).whereIsInstanceOfAny(new Class[]{JoinNode.class}).findFirst().isEmpty()) {
                    throw new IllegalStateException("Join node should be present in explain plan, when pushdown is not applied:\n" + PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (Metadata)this.runner.getPlannerContext().getMetadata(), (FunctionManager)this.runner.getPlannerContext().getFunctionManager(), (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)2, (boolean)false));
                }
            });
            if (!this.skipResultsCorrectnessCheckForPushdown) {
                this.hasCorrectResultsRegardlessOfPushdown();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert hasPlan(PlanMatchPattern expectedPlan) {
            return this.hasPlan(expectedPlan, plan -> {});
        }

        private QueryAssert hasPlan(PlanMatchPattern expectedPlan, Consumer<Plan> additionalPlanVerification) {
            Metadata metadata = this.runner.getPlannerContext().getMetadata();
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (Metadata)metadata, (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query());
                PlanAssert.assertPlan(session, metadata, this.runner.getPlannerContext().getFunctionManager(), StatsCalculator.noopStatsCalculator(), plan, expectedPlan);
                additionalPlanVerification.accept(plan);
            });
            if (!this.skipResultsCorrectnessCheckForPushdown) {
                this.hasCorrectResultsRegardlessOfPushdown();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert hasCorrectResultsRegardlessOfPushdown() {
            Session withoutPushdown = Session.builder((Session)this.session).setSystemProperty("allow_pushdown_into_connectors", "false").build();
            this.result().matches(this.runner.execute(withoutPushdown, this.query()));
            return this;
        }

        private String query() {
            return this.query.orElseThrow(() -> new IllegalStateException("Original query is not available"));
        }
    }

    public static class ExpressionAssertProvider
    implements AssertProvider<ExpressionAssert> {
        private final QueryRunner runner;
        private final String expression;
        private final Session session;
        private final Map<String, String> bindings = new HashMap<String, String>();

        public ExpressionAssertProvider(QueryRunner runner, Session session, String expression) {
            this.runner = runner;
            this.session = session;
            this.expression = expression;
        }

        public ExpressionAssertProvider binding(String variable, @Language(value="SQL") String value) {
            String previous = this.bindings.put(variable, value);
            if (previous != null) {
                Assertions.fail((String)"%s already bound to: %s".formatted(variable, value));
            }
            return this;
        }

        public Result evaluate() {
            if (this.bindings.isEmpty()) {
                return this.run("VALUES ROW(%s)".formatted(this.expression));
            }
            ImmutableList entries = ImmutableList.copyOf(this.bindings.entrySet());
            List columns = entries.stream().map(Map.Entry::getKey).collect(Collectors.toList());
            List values = entries.stream().map(Map.Entry::getValue).collect(Collectors.toList());
            Result full = this.run("SELECT %s\nFROM (\n    VALUES ROW(%s)\n) t(%s)\nWHERE rand() >= 0\n".formatted(this.expression, Joiner.on((String)",").join(values), Joiner.on((String)",").join(columns)));
            Result withConstantFolding = this.run("SELECT %s\nFROM (\n    VALUES ROW(%s)\n) t(%s)\n".formatted(this.expression, Joiner.on((String)",").join(values), Joiner.on((String)",").join(columns)));
            if (!full.type().equals((Object)withConstantFolding.type())) {
                Assertions.fail((String)"Mismatched types between interpreter and evaluation engine: %s vs %s".formatted(full.type(), withConstantFolding.type()));
            }
            if (!Objects.equals(full.value(), withConstantFolding.value())) {
                Assertions.fail((String)"Mismatched results between interpreter and evaluation engine: %s vs %s".formatted(full.value(), withConstantFolding.value()));
            }
            return new Result(full.type(), full.value);
        }

        private Result run(String query) {
            QueryRunner.MaterializedResultWithPlan result = this.runner.executeWithPlan(this.session, query);
            return new Result((Type)Iterables.getOnlyElement((Iterable)result.result().getTypes()), result.result().getOnlyColumnAsSet().iterator().next());
        }

        public ExpressionAssert assertThat() {
            Result result = this.evaluate();
            return (ExpressionAssert)new ExpressionAssert(this.runner, this.session, result.value(), result.type()).withRepresentation((Representation)ExpressionAssert.TYPE_RENDERER);
        }

        public record Result(Type type, Object value) {
        }
    }

    public static class ExpressionAssert
    extends AbstractAssert<ExpressionAssert, Object> {
        private static final StandardRepresentation TYPE_RENDERER = new StandardRepresentation(){

            public String toStringOf(Object object) {
                if (object instanceof SqlTimestamp) {
                    SqlTimestamp timestamp = (SqlTimestamp)object;
                    return String.format("%s [p = %s, epochMicros = %s, fraction = %s]", timestamp, timestamp.getPrecision(), timestamp.getEpochMicros(), timestamp.getPicosOfMicros());
                }
                if (object instanceof SqlTimestampWithTimeZone) {
                    SqlTimestampWithTimeZone timestamp = (SqlTimestampWithTimeZone)object;
                    return String.format("%s [p = %s, epochMillis = %s, fraction = %s, tz = %s]", timestamp, timestamp.getPrecision(), timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), timestamp.getTimeZoneKey());
                }
                if (object instanceof SqlTime) {
                    SqlTime time = (SqlTime)object;
                    return String.format("%s [picos = %s]", time, time.getPicos());
                }
                if (object instanceof SqlTimeWithTimeZone) {
                    SqlTimeWithTimeZone time = (SqlTimeWithTimeZone)object;
                    return String.format("%s [picos = %s, offset = %s]", time, time.getPicos(), time.getOffsetMinutes());
                }
                return Objects.toString(object);
            }
        };
        private final QueryRunner runner;
        private final Session session;
        private final Type actualType;

        public ExpressionAssert(QueryRunner runner, Session session, Object actual, Type actualType) {
            super(actual, Object.class);
            this.runner = runner;
            this.session = session;
            this.actualType = actualType;
        }

        public ExpressionAssert isEqualTo(BiFunction<Session, QueryRunner, Object> evaluator) {
            return (ExpressionAssert)this.isEqualTo(evaluator.apply(this.session, this.runner));
        }

        public ExpressionAssert matches(@Language(value="SQL") String expression) {
            MaterializedResult result = this.runner.execute(this.session, "VALUES " + expression);
            Type expectedType = (Type)Iterables.getOnlyElement((Iterable)result.getTypes());
            Object expectedValue = result.getOnlyColumnAsSet().iterator().next();
            return (ExpressionAssert)this.satisfies(new ThrowingConsumer[]{actual -> {
                ((ObjectAssert)Assertions.assertThat((Object)this.actualType).as("Type", new Object[0])).isEqualTo((Object)expectedType);
                ((ObjectAssert)Assertions.assertThat((Object)actual).withRepresentation((Representation)TYPE_RENDERER)).isEqualTo(expectedValue);
            }});
        }

        public void isNull(Type type) {
            this.hasType(type).isNull();
        }

        public ExpressionAssert hasType(Type type) {
            this.objects.assertEqual((AssertionInfo)this.info, (Object)this.actualType, (Object)type);
            return this;
        }
    }

    public static class ResultAssert
    extends AbstractAssert<ResultAssert, MaterializedResult> {
        private static final Representation ROWS_REPRESENTATION = new StandardRepresentation(){

            public String toStringOf(Object object) {
                if (object instanceof List) {
                    List list = (List)object;
                    return list.stream().map(this::toStringOf).collect(Collectors.joining(", "));
                }
                if (object instanceof MaterializedRow) {
                    MaterializedRow row = (MaterializedRow)object;
                    return row.getFields().stream().map(this::formatRowElement).collect(Collectors.joining(", ", "(", ")"));
                }
                return super.toStringOf(object);
            }

            private String formatRowElement(Object value) {
                if (value == null) {
                    return "null";
                }
                if (value.getClass().isArray()) {
                    return this.formatArray(value);
                }
                return String.valueOf(value);
            }
        };
        private final QueryRunner runner;
        private final Session session;
        private final Description description;
        private final boolean ordered;
        private boolean skipTypesCheck;

        private ResultAssert(QueryRunner runner, Session session, Description description, MaterializedResult result, boolean ordered, boolean skipTypesCheck) {
            super((Object)result, ResultAssert.class);
            this.runner = Objects.requireNonNull(runner, "runner is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.description = Objects.requireNonNull(description, "description is null");
            this.ordered = ordered;
            this.skipTypesCheck = skipTypesCheck;
        }

        public ResultAssert skippingTypesCheck() {
            this.skipTypesCheck = true;
            return this;
        }

        public ResultAssert exceptColumns(String ... columnNamesToExclude) {
            return new ResultAssert(this.runner, this.session, (Description)new TextDescription("%s except columns %s", new Object[]{this.description, Arrays.toString(columnNamesToExclude)}), ((MaterializedResult)this.actual).exceptColumns(columnNamesToExclude), this.ordered, this.skipTypesCheck);
        }

        public ResultAssert projected(String ... columnNamesToInclude) {
            return new ResultAssert(this.runner, this.session, (Description)new TextDescription("%s projected with %s", new Object[]{this.description, Arrays.toString(columnNamesToInclude)}), ((MaterializedResult)this.actual).project(columnNamesToInclude), this.ordered, this.skipTypesCheck);
        }

        @CanIgnoreReturnValue
        public ResultAssert isEmpty() {
            this.rows().isEmpty();
            return this;
        }

        public AbstractIntegerAssert<?> rowCount() {
            return (AbstractIntegerAssert)Assertions.assertThat((int)((MaterializedResult)this.actual).getRowCount()).as("Row count for query [%s]", new Object[]{this.description});
        }

        @CanIgnoreReturnValue
        public ResultAssert matches(@Language(value="SQL") String query) {
            MaterializedResult expected = this.runner.execute(this.session, query);
            return this.matches(expected);
        }

        @CanIgnoreReturnValue
        public ResultAssert containsAll(@Language(value="SQL") String query) {
            MaterializedResult expected = this.runner.execute(this.session, query);
            return this.containsAll(expected);
        }

        @CanIgnoreReturnValue
        public ResultAssert matches(MaterializedResult expected) {
            return (ResultAssert)this.satisfies(new ThrowingConsumer[]{actual -> {
                if (!this.skipTypesCheck) {
                    this.hasTypes(expected.getTypes());
                }
                ListAssert assertion = (ListAssert)((ListAssert)Assertions.assertThat((List)actual.getMaterializedRows()).as("Rows for query [%s]", new Object[]{this.description})).withRepresentation(ROWS_REPRESENTATION);
                if (this.ordered) {
                    assertion.containsExactlyElementsOf((Iterable)expected.getMaterializedRows());
                } else {
                    assertion.containsExactlyInAnyOrderElementsOf((Iterable)expected.getMaterializedRows());
                }
            }});
        }

        @CanIgnoreReturnValue
        public ResultAssert containsAll(MaterializedResult expected) {
            return (ResultAssert)this.satisfies(new ThrowingConsumer[]{actual -> {
                if (!this.skipTypesCheck) {
                    this.hasTypes(expected.getTypes());
                }
                ((ListAssert)((ListAssert)Assertions.assertThat((List)actual.getMaterializedRows()).as("Rows for query [%s]", new Object[]{this.description})).withRepresentation(ROWS_REPRESENTATION)).containsAll((Iterable)expected.getMaterializedRows());
            }});
        }

        @CanIgnoreReturnValue
        public ResultAssert hasTypes(List<Type> expectedTypes) {
            ((ListAssert)Assertions.assertThat((List)((MaterializedResult)this.actual).getTypes()).as("Output types for query [%s]", new Object[]{this.description})).isEqualTo(expectedTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public ResultAssert hasType(int index, Type expectedType) {
            ((ObjectAssert)((ListAssert)Assertions.assertThat((List)((MaterializedResult)this.actual).getTypes()).as("Output types for query [%s]", new Object[]{this.description})).element(index)).isEqualTo((Object)expectedType);
            return this;
        }

        public AbstractCollectionAssert<?, Collection<?>, Object, ObjectAssert<Object>> onlyColumnAsSet() {
            return (AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)((MaterializedResult)this.actual).getOnlyColumnAsSet()).as("Only column for query [%s]", new Object[]{this.description})).withRepresentation(ROWS_REPRESENTATION);
        }

        public ListAssert<MaterializedRow> rows() {
            return (ListAssert)((ListAssert)Assertions.assertThat((List)((MaterializedResult)this.actual).getMaterializedRows()).as("Rows for query [%s]", new Object[]{this.description})).withRepresentation(ROWS_REPRESENTATION);
        }
    }
}

