/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestAggregationsInRowPatternMatching {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testSimpleQuery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.running_sum\nFROM (VALUES\n         (1),\n         (2),\n         (3),\n         (4),\n         (5),\n         (6),\n         (7),\n         (8)\n     ) t(id)\n       MATCH_RECOGNIZE (\n         ORDER BY id\n         MEASURES RUNNING sum(id) AS running_sum\n         ALL ROWS PER MATCH\n         AFTER MATCH SKIP PAST LAST ROW\n         PATTERN (A*)\n         DEFINE A AS true\n      ) AS m\n"))).matches("VALUES\n     (1, BIGINT '1'),\n     (2, 3),\n     (3, 6),\n     (4, 10),\n     (5, 15),\n     (6, 21),\n     (7, 28),\n     (8, 36)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.running_labels\nFROM (VALUES\n         (1),\n         (2),\n         (3),\n         (4),\n         (5),\n         (6),\n         (7),\n         (8)\n     ) t(id)\n       MATCH_RECOGNIZE (\n         ORDER BY id\n         MEASURES RUNNING array_agg(CLASSIFIER(A)) AS running_labels\n         ALL ROWS PER MATCH\n         AFTER MATCH SKIP PAST LAST ROW\n         PATTERN (A*)\n         DEFINE A AS true\n      ) AS m\n"))).matches("VALUES\n     (1, CAST(ARRAY['A'] AS array(varchar))),\n     (2, ARRAY['A', 'A']),\n     (3, ARRAY['A', 'A', 'A']),\n     (4, ARRAY['A', 'A', 'A', 'A']),\n     (5, ARRAY['A', 'A', 'A', 'A', 'A']),\n     (6, ARRAY['A', 'A', 'A', 'A', 'A', 'A']),\n     (7, ARRAY['A', 'A', 'A', 'A', 'A', 'A', 'A']),\n     (8, ARRAY['A', 'A', 'A', 'A', 'A', 'A', 'A', 'A'])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.running_labels\nFROM (VALUES\n         (1),\n         (2),\n         (3),\n         (4),\n         (5),\n         (6),\n         (7),\n         (8)\n     ) t(id)\n       MATCH_RECOGNIZE (\n         ORDER BY id\n         MEASURES concat_ws('', RUNNING array_agg(lower(CLASSIFIER(U)))) AS running_labels\n         ALL ROWS PER MATCH\n         AFTER MATCH SKIP PAST LAST ROW\n         PATTERN (M A X X T C H \"!\")\n         SUBSET U = (M, A, T, C, H, \"!\")\n         DEFINE M AS true\n      ) AS m\n"))).matches("VALUES\n     (1, CAST('m' AS varchar)),\n     (2, 'ma'),\n     (3, 'ma'),\n     (4, 'ma'),\n     (5, 'mat'),\n     (6, 'matc'),\n     (7, 'match'),\n     (8, 'match!')\n");
    }

    @Test
    public void testPartitioning() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part as partition, m.id AS row_id, m.running_sum\nFROM (VALUES\n         (1, 'p1', 1),\n         (2, 'p1', 1),\n         (6, 'p1', 1),\n         (2, 'p2', 10),\n         (2, 'p3', 100),\n         (1, 'p3', 100),\n         (3, 'p1', 1),\n         (4, 'p1', 1),\n         (5, 'p1', 1),\n         (1, 'p2', 10),\n         (3, 'p3', 100),\n         (3, 'p2', 10)\n     ) t(id, part, value)\n       MATCH_RECOGNIZE (\n         PARTITION BY part\n         ORDER BY id\n         MEASURES RUNNING sum(value) AS running_sum\n         ALL ROWS PER MATCH\n         AFTER MATCH SKIP PAST LAST ROW\n         PATTERN (B+)\n         DEFINE B AS true\n      ) AS m\n"))).matches("VALUES\n     ('p1', 1, BIGINT '1'),\n     ('p1', 2, 2),\n     ('p1', 3, 3),\n     ('p1', 4, 4),\n     ('p1', 5, 5),\n     ('p1', 6, 6),\n     ('p2', 1, 10),\n     ('p2', 2, 20),\n     ('p2', 3, 30),\n     ('p3', 1, 100),\n     ('p3', 2, 200),\n     ('p3', 3, 300)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part as partition, m.match_no, m.id AS row_id, m.running_sum\nFROM (VALUES\n   (1, 'p1', 1),\n   (2, 'p1', 1),\n   (6, 'p1', 1),\n   (2, 'p2', 10),\n   (2, 'p3', 100),\n   (1, 'p3', 100),\n   (3, 'p1', 1),\n   (4, 'p1', 1),\n   (5, 'p1', 1),\n   (1, 'p2', 10),\n   (3, 'p3', 100),\n   (3, 'p2', 10)\n) t(id, part, value)\n MATCH_RECOGNIZE (\n   PARTITION BY part\n   ORDER BY id\n   MEASURES\n           RUNNING sum(value) AS running_sum,\n           MATCH_NUMBER() AS match_no\n   ALL ROWS PER MATCH\n   AFTER MATCH SKIP TO NEXT ROW\n   PATTERN (B+)\n   DEFINE B AS true\n) AS m\n"))).matches("VALUES\n     ('p1', BIGINT '1', 1, BIGINT '1'),\n     ('p1', 1, 2, 2),\n     ('p1', 1, 3, 3),\n     ('p1', 1, 4, 4),\n     ('p1', 1, 5, 5),\n     ('p1', 1, 6, 6),\n     ('p1', 2, 2, 1),\n     ('p1', 2, 3, 2),\n     ('p1', 2, 4, 3),\n     ('p1', 2, 5, 4),\n     ('p1', 2, 6, 5),\n     ('p1', 3, 3, 1),\n     ('p1', 3, 4, 2),\n     ('p1', 3, 5, 3),\n     ('p1', 3, 6, 4),\n     ('p1', 4, 4, 1),\n     ('p1', 4, 5, 2),\n     ('p1', 4, 6, 3),\n     ('p1', 5, 5, 1),\n     ('p1', 5, 6, 2),\n     ('p1', 6, 6, 1),\n     ('p2', 1, 1, 10),\n     ('p2', 1, 2, 20),\n     ('p2', 1, 3, 30),\n     ('p2', 2, 2, 10),\n     ('p2', 2, 3, 20),\n     ('p2', 3, 3, 10),\n     ('p3', 1, 1, 100),\n     ('p3', 1, 2, 200),\n     ('p3', 1, 3, 300),\n     ('p3', 2, 2, 100),\n     ('p3', 2, 3, 200),\n     ('p3', 3, 3, 100)\n");
    }

    @Test
    public void testTentativeLabelMatch() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.classy, m.running_avg_B\nFROM (VALUES\n         (1, 4),\n         (2, 6),\n         (3, 0)\n     ) t(id, value)\n       MATCH_RECOGNIZE (\n         ORDER BY id\n         MEASURES\n                 RUNNING avg(B.value) AS running_avg_B,\n                 CLASSIFIER() AS classy\n         ALL ROWS PER MATCH\n         AFTER MATCH SKIP PAST LAST ROW\n         PATTERN ((A | B)*)\n         DEFINE A AS avg(B.value) = 5\n      ) AS m\n"))).matches("VALUES\n     (1, VARCHAR 'B', 4e0),\n     (2, 'B', 5e0),\n     (3, 'A', 5e0)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.classy, m.running_avg_A\nFROM (VALUES\n         (1, 4),\n         (2, 6),\n         (3, 0),\n         (4, 5)\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            RUNNING avg(A.value) AS running_avg_A,\n            CLASSIFIER() AS classy\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN ((A | B)*)\n    DEFINE A AS avg(A.value) = 5\n ) AS m\n"))).matches("VALUES\n     (1, VARCHAR 'B', null),\n     (2, 'B', null),\n     (3, 'B', null),\n     (4, 'A', 5e0)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part as partition, m.id AS row_id, m.running_sum\nFROM (VALUES\n         (1, 'p1', 1),\n         (2, 'p1', 1),\n         (6, 'p1', 1),\n         (2, 'p2', 10),\n         (2, 'p3', 100),\n         (1, 'p3', 100),\n         (3, 'p1', 1),\n         (4, 'p1', 1),\n         (5, 'p1', 1),\n         (1, 'p2', 10),\n         (3, 'p3', 100),\n         (3, 'p2', 10)\n) t(id, part, value)\n  MATCH_RECOGNIZE (\n    PARTITION BY part\n    ORDER BY id\n    MEASURES RUNNING sum(value) AS running_sum\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (B (A | B) B)\n    DEFINE A AS sum(value) > 1000\n ) AS m\n"))).matches("VALUES\n     ('p1', 1, BIGINT '1'),\n     ('p1', 2, 2),\n     ('p1', 3, 3),\n     ('p1', 4, 1),\n     ('p1', 5, 2),\n     ('p1', 6, 3),\n     ('p2', 1, 10),\n     ('p2', 2, 20),\n     ('p2', 3, 30),\n     ('p3', 1, 100),\n     ('p3', 2, 200),\n     ('p3', 3, 300)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part as partition, m.id AS row_id, m.classy, m.running_sum\nFROM (VALUES\n         (1, 'p1', 1),\n         (2, 'p1', 1),\n         (3, 'p1', 1),\n         (4, 'p1', 1),\n         (5, 'p1', 1),\n         (1, 'p2', 2),\n         (2, 'p2', 2),\n         (3, 'p2', 2),\n         (4, 'p2', 2),\n         (5, 'p2', 2)\n) t(id, part, value)\n  MATCH_RECOGNIZE (\n    PARTITION BY part\n    ORDER BY id\n    MEASURES\n            RUNNING sum(value) AS running_sum,\n            CLASSIFIER() AS classy\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN ((A | B)*)\n    DEFINE A AS sum(value) > 4\n ) AS m\n"))).matches("VALUES\n     ('p1', 1, VARCHAR 'B', BIGINT '1'),\n     ('p1', 2, 'B', 2),\n     ('p1', 3, 'B', 3),\n     ('p1', 4, 'B', 4),\n     ('p1', 5, 'A', 5),\n     ('p2', 1, 'B', 2),\n     ('p2', 2, 'B', 4),\n     ('p2', 3, 'A', 6),\n     ('p2', 4, 'A', 8),\n     ('p2', 5, 'A', 10)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part as partition, m.id AS row_id, m.running_sum\nFROM (VALUES\n         (1, 'p1', 1),\n         (2, 'p1', 1),\n         (6, 'p1', 1),\n         (2, 'p2', 10),\n         (2, 'p3', 100),\n         (1, 'p3', 100),\n         (3, 'p1', 1),\n         (4, 'p1', 1),\n         (5, 'p1', 1),\n         (1, 'p2', 10),\n         (3, 'p3', 100),\n         (3, 'p2', 10)\n) t(id, part, value)\n  MATCH_RECOGNIZE (\n    PARTITION BY part\n    ORDER BY id\n    MEASURES RUNNING sum(value) AS running_sum\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (B (A | B) B)\n    DEFINE A AS arbitrary(value) > 1000\n ) AS m\n"))).matches("VALUES\n     ('p1', 1, BIGINT '1'),\n     ('p1', 2, 2),\n     ('p1', 3, 3),\n     ('p1', 4, 1),\n     ('p1', 5, 2),\n     ('p1', 6, 3),\n     ('p2', 1, 10),\n     ('p2', 2, 20),\n     ('p2', 3, 30),\n     ('p3', 1, 100),\n     ('p3', 2, 200),\n     ('p3', 3, 300)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part as partition, m.id AS row_id, m.classy, m.running_max\nFROM (VALUES\n         (1, 'p1', 1),\n         (2, 'p1', 2),\n         (3, 'p1', 3),\n         (4, 'p1', 4),\n         (5, 'p1', 5),\n         (1, 'p2', 2),\n         (2, 'p2', 4),\n         (3, 'p2', 6),\n         (4, 'p2', 8),\n         (5, 'p2', 10)\n) t(id, part, value)\n  MATCH_RECOGNIZE (\n    PARTITION BY part\n    ORDER BY id\n    MEASURES\n            RUNNING max(value) AS running_max,\n            CLASSIFIER() AS classy\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN ((A | B)*)\n    DEFINE A AS max(value) > 4\n ) AS m\n"))).matches("VALUES\n     ('p1', 1, VARCHAR 'B', 1),\n     ('p1', 2, 'B', 2),\n     ('p1', 3, 'B', 3),\n     ('p1', 4, 'B', 4),\n     ('p1', 5, 'A', 5),\n     ('p2', 1, 'B', 2),\n     ('p2', 2, 'B', 4),\n     ('p2', 3, 'A', 6),\n     ('p2', 4, 'A', 8),\n     ('p2', 5, 'A', 10)\n");
    }

    @Test
    public void testTentativeLabelMatchWithRuntimeEvaluatedAggregationArgument() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part as partition, m.id AS row_id, m.classy, m.running_max\nFROM (VALUES\n         (1, 'p1', 1),\n         (2, 'p1', 2),\n         (3, 'p1', 3),\n         (4, 'p1', 4),\n         (5, 'p1', 5),\n         (1, 'p2', 2),\n         (2, 'p2', 4),\n         (3, 'p2', 6),\n         (4, 'p2', 8),\n         (5, 'p2', 10)\n) t(id, part, value)\n  MATCH_RECOGNIZE (\n    PARTITION BY part\n    ORDER BY id\n    MEASURES\n            RUNNING max(value) AS running_max,\n            CLASSIFIER() AS classy\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN ((A | B)*)\n    DEFINE A AS max(value + MATCH_NUMBER()) > 5\n ) AS m\n"))).matches("VALUES\n     ('p1', 1, VARCHAR 'B', 1),\n     ('p1', 2, 'B', 2),\n     ('p1', 3, 'B', 3),\n     ('p1', 4, 'B', 4),\n     ('p1', 5, 'A', 5),\n     ('p2', 1, 'B', 2),\n     ('p2', 2, 'B', 4),\n     ('p2', 3, 'A', 6),\n     ('p2', 4, 'A', 8),\n     ('p2', 5, 'A', 10)\n");
    }

    @Test
    public void testAggregationArguments() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part, m.id, m.measure\nFROM (VALUES\n         ('p1', 1, 'a'),\n         ('p1', 2, 'b'),\n         ('p1', 3, 'c'),\n         ('p1', 4, 'd'),\n         ('p1', 5, 'e'),\n         ('p1', 6, 'f'),\n         ('p2', 1, 'g'),\n         ('p2', 2, 'h'),\n         ('p2', 3, 'i'),\n         ('p3', 1, 'j'),\n         ('p3', 2, 'k'),\n         ('p3', 3, 'l')\n) t(part, id, value)\n  MATCH_RECOGNIZE (\n    PARTITION BY part\n    ORDER BY id\n    MEASURES array_agg(value || CLASSIFIER()) AS measure\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (X Y Z+)\n    DEFINE X AS true\n ) AS m\n"))).matches("VALUES\n     ('p1', 1, ARRAY[VARCHAR 'aX']),\n     ('p1', 2, ARRAY['aX', 'bY']),\n     ('p1', 3, ARRAY['aX', 'bY', 'cZ']),\n     ('p1', 4, ARRAY['aX', 'bY', 'cZ', 'dZ']),\n     ('p1', 5, ARRAY['aX', 'bY', 'cZ', 'dZ', 'eZ']),\n     ('p1', 6, ARRAY['aX', 'bY', 'cZ', 'dZ', 'eZ', 'fZ']),\n     ('p2', 1, ARRAY['gX']),\n     ('p2', 2, ARRAY['gX', 'hY']),\n     ('p2', 3, ARRAY['gX', 'hY', 'iZ']),\n     ('p3', 1, ARRAY['jX']),\n     ('p3', 2, ARRAY['jX', 'kY']),\n     ('p3', 3, ARRAY['jX', 'kY', 'lZ'])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.measure\nFROM (VALUES\n         (1, 'a'),\n         (2, 'b'),\n         (3, 'c')\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES array_agg(value || value || CLASSIFIER()) AS measure\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (X Y Z)\n    DEFINE X AS true\n ) AS m\n"))).matches("VALUES\n     (1, ARRAY[VARCHAR 'aaX']),\n     (2, ARRAY['aaX', 'bbY']),\n     (3, ARRAY['aaX', 'bbY', 'ccZ'])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.measure_1, m.measure_2, m.measure_3\nFROM (VALUES\n         (1, 'a'),\n         (2, 'b'),\n         (3, 'c')\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            array_agg('X' || (SELECT 'Y')) AS measure_1,\n            array_agg('X' IN (SELECT 'Y')) AS measure_2,\n            array_agg(EXISTS (SELECT 'Y')) AS measure_3\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (X Y Z)\n    DEFINE X AS true\n ) AS m\n"))).matches("VALUES\n     (1, ARRAY[VARCHAR 'XY'], ARRAY[false], ARRAY[true]),\n     (2, ARRAY['XY', 'XY'], ARRAY[false, false], ARRAY[true, true]),\n     (3, ARRAY['XY', 'XY', 'XY'], ARRAY[false, false, false], ARRAY[true, true, true])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.measure_1, m.measure_2, m.measure_3\nFROM (VALUES\n         (1, 'a'),\n         (2, 'b'),\n         (3, 'c')\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            array_agg(CLASSIFIER() || (SELECT 'A')) AS measure_1,\n            array_agg(MATCH_NUMBER() = 10 AND 0 IN (SELECT 1)) AS measure_2,\n            array_agg(MATCH_NUMBER() = 1 AND EXISTS (SELECT 'Y')) AS measure_3\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (X Y Z)\n    DEFINE X AS true\n ) AS m\n"))).matches("VALUES\n     (1, ARRAY[VARCHAR 'XA'], ARRAY[false], ARRAY[true]),\n     (2, ARRAY['XA', 'YA'], ARRAY[false, false], ARRAY[true, true]),\n     (3, ARRAY['XA', 'YA', 'ZA'], ARRAY[false, false, false], ARRAY[true, true, true])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.measure\nFROM (VALUES\n         (1, 'p'),\n         (2, 'q'),\n         (3, 'r'),\n         (4, 's')\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES max_by(value, CLASSIFIER()) AS measure\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (A B D C)\n    DEFINE A AS true\n ) AS m\n"))).matches("VALUES\n     (1, 'p'),\n     (2, 'q'),\n     (3, 'r'),\n     (4, 'r')\n");
    }

    @Test
    public void testSelectiveAggregation() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.measure_1, m.measure_2, m.measure_3\nFROM (VALUES\n         (1, 'a'),\n         (2, 'b'),\n         (3, 'c'),\n         (4, 'd')\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            array_agg(U.id) AS measure_1,\n            array_agg(CLASSIFIER(U)) AS measure_2,\n            array_agg(U.value || CLASSIFIER(U)) AS measure_3\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (X Y Z Y)\n    SUBSET U = (X, Z)\n    DEFINE X AS true\n ) AS m\n"))).matches("VALUES\n     (1, ARRAY[1], ARRAY[VARCHAR 'X'], ARRAY[VARCHAR 'aX']),\n     (2, ARRAY[1], ARRAY['X'], ARRAY['aX']),\n     (3, ARRAY[1, 3], ARRAY['X', 'Z'], ARRAY['aX', 'cZ']),\n     (4, ARRAY[1, 3], ARRAY['X', 'Z'], ARRAY['aX', 'cZ'])\n");
    }

    @Test
    public void testCountAggregation() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.measure_1, m.measure_2\nFROM (VALUES\n         (1, 'a'),\n         (2, 'b'),\n         (3, 'c'),\n         (4, 'd')\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            count(*) AS measure_1,\n            count() AS measure_2\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (X Y Z)\n    DEFINE X AS id > 1\n ) AS m\n"))).matches("VALUES\n     (2, BIGINT '1', BIGINT '1'),\n     (3, 2, 2),\n     (4, 3, 3)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.measure_1, m.measure_2, m.measure_3, m.measure_4\nFROM (VALUES\n         (1, 'a'),\n         (2, 'b'),\n         (3, 'c'),\n         (4, 'd')\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            RUNNING count(*) AS measure_1,\n            FINAL count(*) AS measure_2,\n            RUNNING count() AS measure_3,\n            FINAL count() AS measure_4\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (A B C D)\n    DEFINE A AS true\n ) AS m\n"))).matches("VALUES\n     (1, BIGINT '1', BIGINT '4', BIGINT '1', BIGINT '4'),\n     (2, 2, 4, 2, 4),\n     (3, 3, 4, 3, 4),\n     (4, 4, 4, 4, 4)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.measure_1, m.measure_2\nFROM (VALUES\n         (1, 'a'),\n         (2, 'b'),\n         (3, 'c'),\n         (4, 'd')\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            count(C.*) AS measure_1,\n            count(U.*) AS measure_2\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (A B C D)\n    SUBSET U = (B, D)\n    DEFINE A AS true\n ) AS m\n"))).matches("VALUES\n     (1, BIGINT '0', BIGINT '0'),\n     (2, 0, 1),\n     (3, 1, 1),\n     (4, 1, 2)\n");
    }

    @Test
    public void testLabelAndColumnNames() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.classy, m.measure_1, m.measure_2, m.measure_3\nFROM (VALUES\n         (1, 'p'),\n         (2, 'q'),\n         (3, null),\n         (4, 's')\n) t(id, A)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            CLASSIFIER() AS classy,\n            count(A.A) AS measure_1,\n            count(A) AS measure_2,\n            count(A.*) AS measure_3\n    ALL ROWS PER MATCH\n    PATTERN (A B A A)\n    DEFINE A AS true\n ) AS m\n"))).matches("VALUES\n     (1, VARCHAR 'A', BIGINT '1', BIGINT '1', BIGINT '1'),\n     (2, 'B', 1, 2, 1),\n     (3, 'A', 1, 2, 2),\n     (4, 'A', 2, 3, 3)\n");
    }

    @Test
    public void testOneRowPerMatch() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part, m.measure\nFROM (VALUES\n         ('p1', 1, 'a'),\n         ('p1', 2, 'b'),\n         ('p1', 3, 'c'),\n         ('p1', 4, 'd'),\n         ('p1', 5, 'e'),\n         ('p1', 6, 'f'),\n         ('p2', 1, 'g'),\n         ('p2', 2, 'h'),\n         ('p2', 3, 'i'),\n         ('p2', 4, 'j'),\n         ('p2', 5, 'k'),\n         ('p2', 6, 'l')\n) t(part, id, value)\n  MATCH_RECOGNIZE (\n    PARTITION BY part\n    ORDER BY id\n    MEASURES array_agg(value || CLASSIFIER()) AS measure\n    ONE ROW PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (X Y Z)\n    DEFINE X AS true\n ) AS m\n"))).matches("VALUES\n     ('p1', ARRAY[VARCHAR 'aX', 'bY', 'cZ']),\n     ('p1', ARRAY['dX', 'eY', 'fZ']),\n     ('p2', ARRAY['gX', 'hY', 'iZ']),\n     ('p2', ARRAY['jX', 'kY', 'lZ'])\n");
    }

    @Test
    public void testSeek() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT part, id, measure_1 OVER w, measure_2 OVER w\nFROM (VALUES\n         (1, 'p1', 'A'),\n         (2, 'p1', 'B'),\n         (3, 'p1', 'C'),\n         (4, 'p1', 'D'),\n         (5, 'p1', 'E'),\n         (1, 'p2', 'A'),\n         (2, 'p2', 'B'),\n         (3, 'p2', 'C'),\n         (4, 'p2', 'D'),\n         (5, 'p2', 'E')\n) t(id, part, value)\n  WINDOW w AS (\n    PARTITION BY part\n    ORDER BY id\n    MEASURES\n            array_agg(value) AS measure_1,\n            array_agg(value || CLASSIFIER()) AS measure_2\n    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING\n    AFTER MATCH SKIP TO NEXT ROW\n    SEEK\n    PATTERN (X+)\n    DEFINE X AS X.value > 'B')\n"))).matches("VALUES\n     ('p1', 1, ARRAY['C', 'D', 'E'], ARRAY[VARCHAR 'CX', 'DX', 'EX']),\n     ('p1', 2, ARRAY['C', 'D', 'E'], ARRAY['CX', 'DX', 'EX']),\n     ('p1', 3, ARRAY[ 'C', 'D', 'E'], ARRAY['CX', 'DX', 'EX']),\n     ('p1', 4, ARRAY['D', 'E'], ARRAY['DX', 'EX']),\n     ('p1', 5, ARRAY['E'], ARRAY['EX']),\n     ('p2', 1, ARRAY['C', 'D', 'E'], ARRAY['CX', 'DX', 'EX']),\n     ('p2', 2, ARRAY['C', 'D', 'E'], ARRAY['CX', 'DX', 'EX']),\n     ('p2', 3, ARRAY['C', 'D', 'E'], ARRAY['CX', 'DX', 'EX']),\n     ('p2', 4, ARRAY['D', 'E'], ARRAY['DX', 'EX']),\n     ('p2', 5, ARRAY['E'], ARRAY['EX'])\n");
    }

    @Test
    public void testExclusions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.part, m.measure_1, m.measure_2\nFROM (VALUES\n         ('p1', 1, '1a'),\n         ('p1', 2, '1b'),\n         ('p1', 3, '1c'),\n         ('p1', 4, '1d'),\n         ('p1', 5, '1e'),\n         ('p2', 1, '2a'),\n         ('p2', 2, '2b'),\n         ('p2', 3, '2c'),\n         ('p2', 4, '2d'),\n         ('p2', 5, '2e')\n) t(part, id, value)\n  MATCH_RECOGNIZE (\n    PARTITION BY part\n    ORDER BY id\n    MEASURES\n            array_agg(value) AS measure_1,\n            array_agg(value || CLASSIFIER()) AS measure_2\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (P {- Q R -} S)\n    DEFINE P AS id > 1\n ) AS m\n"))).matches("VALUES\n     ('p1', ARRAY['1b'], ARRAY[VARCHAR '1bP']),\n     ('p1', ARRAY['1b', '1c', '1d', '1e'], ARRAY['1bP', '1cQ', '1dR', '1eS']),\n     ('p2', ARRAY['2b'], ARRAY['2bP']),\n     ('p2', ARRAY['2b', '2c', '2d', '2e'], ARRAY['2bP', '2cQ', '2dR', '2eS'])\n");
    }

    @Test
    public void testBalancingSums() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.classy, m.running_sum_A, m.running_sum_B\nFROM (VALUES\n         (1, 4),\n         (2, 6),\n         (3, 10),\n         (4, 1),\n         (5, 1),\n         (6, 1),\n         (7, 10),\n         (8, 5),\n         (9, 1)\n) t(id, value)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            RUNNING sum(A.value) AS running_sum_A,\n            RUNNING sum(B.value) AS running_sum_B,\n            CLASSIFIER() AS classy\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN ((A | B)*)\n    DEFINE A AS sum(A.value) - A.value <= sum(B.value)\n ) AS m\n"))).matches("VALUES\n     (1, VARCHAR 'B', null, BIGINT '4'),\n     (2, 'A', BIGINT '6', BIGINT '4'),\n     (3, 'B', BIGINT '6', BIGINT '14'),\n     (4, 'A', BIGINT '7', BIGINT '14'),\n     (5, 'A', BIGINT '8', BIGINT '14'),\n     (6, 'A', BIGINT '9', BIGINT '14'),\n     (7, 'A', BIGINT '19', BIGINT '14'),\n     (8, 'B', BIGINT '19', BIGINT '19'),\n     (9, 'A', BIGINT '20', BIGINT '19')\n");
    }

    @Test
    public void testPeriodLength() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT user_id, CAST(periods_total AS integer)\nFROM (VALUES\n         (1, 3),\n         (1, 4),\n         (1, 5),\n         (1, 8),\n         (1, 9),\n         (2, 2),\n         (2, 3),\n         (2, 4)\n) t(user_id, minute_of_the_day)\n  MATCH_RECOGNIZE (\n    PARTITION BY user_id\n    ORDER BY minute_of_the_day\n    MEASURES COALESCE(sum(C.minute_of_the_day) - sum(A.minute_of_the_day), 0) AS periods_total\n    ONE ROW PER MATCH\n    PATTERN ((A B* C | D)*)\n    DEFINE\n           B AS minute_of_the_day = PREV(minute_of_the_day) + 1,\n           C AS minute_of_the_day = PREV(minute_of_the_day) + 1)\n"))).matches("VALUES\n     (1, 3),\n     (2, 2)\n");
    }

    @Test
    public void testSetPartitioning() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.running_labels\nFROM (VALUES (1), (2), (3), (4), (5), (6), (7), (8)) t(id)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES RUNNING array_agg(CLASSIFIER()) AS running_labels\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (^(A | B)* (LAST_A | LAST_B)$)\n    DEFINE\n            LAST_A AS sum(A.id) + id = sum(B.id),\n            LAST_B AS sum(B.id) + id = sum(A.id)\n ) AS m\n"))).matches("VALUES\n     (1, CAST(ARRAY['A'] AS array(varchar))),\n     (2, ARRAY['A', 'A']),\n     (3, ARRAY['A', 'A', 'A']),\n     (4, ARRAY['A', 'A', 'A', 'A']),\n     (5, ARRAY['A', 'A', 'A', 'A', 'B']),\n     (6, ARRAY['A', 'A', 'A', 'A', 'B', 'B']),\n     (7, ARRAY['A', 'A', 'A', 'A', 'B', 'B', 'B']),\n     (8, ARRAY['A', 'A', 'A', 'A', 'B', 'B', 'B', 'LAST_A'])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.running_labels\nFROM (VALUES (1), (2), (3), (4), (5), (6)) t(id)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES RUNNING array_agg(CLASSIFIER()) AS running_labels\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (^(A | B | C)* (LAST_A | LAST_B | LAST_C)$)\n    DEFINE\n            LAST_A AS sum(A.id) + id = sum(B.id) AND sum(B.id) = sum(C.id),\n            LAST_B AS sum(B.id) + id = sum(A.id)  AND sum(A.id) = sum(C.id),\n            LAST_C AS sum(C.id) + id = sum(A.id)  AND sum(A.id) = sum(B.id)\n ) AS m\n"))).matches("VALUES\n     (1, CAST(ARRAY['A'] AS array(varchar))),\n     (2, ARRAY['A', 'B']),\n     (3, ARRAY['A', 'B', 'C']),\n     (4, ARRAY['A', 'B', 'C', 'C']),\n     (5, ARRAY['A', 'B', 'C', 'C', 'B']),\n     (6, ARRAY['A', 'B', 'C', 'C', 'B', 'LAST_A'])\n");
    }

    @Test
    public void testForkingThreads() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.running_labels\nFROM (VALUES (1), (2), (3), (4)) t(id)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES RUNNING array_agg(CLASSIFIER()) AS running_labels\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN ((A | B | C)* X)\n    DEFINE X AS array_agg(CLASSIFIER()) = ARRAY['C', 'A', 'B', 'X']\n ) AS m\n"))).matches("VALUES\n     (1, CAST(ARRAY['C'] AS array(varchar))),\n     (2, ARRAY['C', 'A']),\n     (3, ARRAY['C', 'A', 'B']),\n     (4, ARRAY['C', 'A', 'B', 'X'])\n");
    }

    @Test
    public void testMultipleAggregationsInDefine() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.match_no, m.labels\nFROM (VALUES (1), (2), (3), (4), (5), (6), (7), (8)) t(id)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            MATCH_NUMBER() AS match_no,\n            array_agg(CLASSIFIER()) AS labels\n    ONE ROW PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN ((A | B){4})\n    DEFINE\n            A AS max(id - 2 * MATCH_NUMBER()) > 1 AND max(CLASSIFIER()) = 'B',\n            B AS min(lower(CLASSIFIER())) = 'b' OR min(MATCH_NUMBER() + 100) < 0\n ) AS m\n"))).matches("VALUES\n     (BIGINT '1', CAST(ARRAY['B', 'B', 'B', 'A'] AS array(varchar))),\n     (2, ARRAY['B', 'A', 'A', 'A'])\n");
    }

    @Test
    public void testRunningAndFinalAggregations() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.match, m.running_labels, m.final_labels, m.running_match, m.final_match\nFROM (VALUES (1), (2), (3), (4), (5), (6), (7), (8)) t(id)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            MATCH_NUMBER() AS match,\n            RUNNING array_agg(CLASSIFIER()) AS running_labels,\n            FINAL array_agg(lower(CLASSIFIER())) AS final_labels,\n            RUNNING sum(MATCH_NUMBER() * 100) AS running_match,\n            FINAL sum(-MATCH_NUMBER()) AS final_match\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (A B C D)\n    DEFINE A AS true\n ) AS m\n"))).matches("VALUES\n     (1, BIGINT '1', CAST(ARRAY['A'] AS array(varchar)), CAST(ARRAY['a', 'b', 'c', 'd'] AS array(varchar)), BIGINT '100', BIGINT '-4'),\n     (2,         1,       ARRAY['A', 'B'],                    ARRAY['a', 'b', 'c', 'd'],                            200,          -4),\n     (3,         1,       ARRAY['A', 'B', 'C'],               ARRAY['a', 'b', 'c', 'd'],                            300,          -4),\n     (4,         1,       ARRAY['A', 'B', 'C', 'D'],          ARRAY['a', 'b', 'c', 'd'],                            400,          -4),\n     (5,         2,       ARRAY['A'],                         ARRAY['a', 'b', 'c', 'd'],                            200,          -8),\n     (6,         2,       ARRAY['A', 'B'],                    ARRAY['a', 'b', 'c', 'd'],                            400,          -8),\n     (7,         2,       ARRAY['A', 'B', 'C'],               ARRAY['a', 'b', 'c', 'd'],                            600,          -8),\n     (8,         2,       ARRAY['A', 'B', 'C', 'D'],          ARRAY['a', 'b', 'c', 'd'],                            800,          -8)\n");
    }

    @Test
    public void testMultipleAggregationArguments() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.classy, m.match, m.running_measure, m.final_measure\nFROM (VALUES (1), (2), (3), (4), (5), (6), (7), (8)) t(id)\n  MATCH_RECOGNIZE (\n    ORDER BY id\n    MEASURES\n            MATCH_NUMBER() AS match,\n            CLASSIFIER() AS classy,\n            RUNNING max_by(MATCH_NUMBER() * 100 + id, CLASSIFIER()) AS running_measure,\n            FINAL max_by(-MATCH_NUMBER() - id, lower(CLASSIFIER())) AS final_measure\n    ALL ROWS PER MATCH\n    AFTER MATCH SKIP PAST LAST ROW\n    PATTERN (A B C D)\n    DEFINE A AS max_by(MATCH_NUMBER(), CLASSIFIER()) > 0\n ) AS m\n"))).matches("VALUES\n     (1, VARCHAR 'A', BIGINT '1', BIGINT '101', BIGINT '-5'),\n     (2,         'B',         1,          102,          -5),\n     (3,         'C',         1,          103,          -5),\n     (4,         'D',         1,          104,          -5),\n     (5,         'A',         2,          205,          -10),\n     (6,         'B',         2,          206,          -10),\n     (7,         'C',         2,          207,          -10),\n     (8,         'D',         2,          208,          -10)\n");
    }
}

