/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestShortDecimalType
extends AbstractTestType {
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)4, (int)2);

    public TestShortDecimalType() {
        super((Type)SHORT_DECIMAL_TYPE, SqlDecimal.class, TestShortDecimalType.createTestBlock());
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = SHORT_DECIMAL_TYPE.createBlockBuilder(null, 15);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, -1234L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, -1234L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, -1234L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 3321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 3321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 4321L);
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Long)value + 1L;
    }

    @Test
    public void testRange() {
        for (int precision = 1; precision <= 18; ++precision) {
            DecimalType type = DecimalType.createDecimalType((int)precision, (int)1);
            Type.Range range = (Type.Range)type.getRange().orElseThrow();
            long max = (long)Math.pow(10.0, precision) - 1L;
            Assertions.assertThat((Object)range.getMin()).isEqualTo((Object)(-max));
            Assertions.assertThat((Object)range.getMax()).isEqualTo((Object)max);
        }
    }

    @Test
    public void testPreviousValue() {
        long minValue = -9999L;
        long maxValue = 9999L;
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEqualTo(Optional.of(-1235L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue - 2L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(maxValue - 1L));
    }

    @Test
    public void testNextValue() {
        long minValue = -9999L;
        long maxValue = 9999L;
        Assertions.assertThat((Optional)this.type.getNextValue((Object)minValue)).isEqualTo(Optional.of(minValue + 1L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue + 2L));
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEqualTo(Optional.of(-1233L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }
}

