/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public record ResolvedFunction(BoundSignature signature, CatalogHandle catalogHandle, FunctionId functionId, FunctionKind functionKind, boolean deterministic, FunctionNullability functionNullability, Map<TypeSignature, Type> typeDependencies, Set<ResolvedFunction> functionDependencies) {
    public ResolvedFunction {
        Objects.requireNonNull(signature, "signature is null");
        Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        Objects.requireNonNull(functionId, "functionId is null");
        Objects.requireNonNull(functionKind, "functionKind is null");
        Objects.requireNonNull(functionNullability, "functionNullability is null");
        typeDependencies = ImmutableMap.copyOf(Objects.requireNonNull(typeDependencies, "typeDependencies is null"));
        functionDependencies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
        Preconditions.checkArgument((functionNullability.getArgumentNullable().size() == signature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)"signature and functionNullability must have same argument count");
    }

    public CatalogSchemaFunctionName name() {
        return this.signature().getName();
    }

    @Override
    public String toString() {
        return this.signature.toString();
    }
}

