/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.annotation.NotThreadSafe;
import io.trino.operator.BigintGroupByHash;
import io.trino.operator.FlatGroupByHash;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;

@NotThreadSafe
public interface GroupByHash {
    public static GroupByHash createGroupByHash(Session session, List<Type> types, boolean hasPrecomputedHash, int expectedSize, FlatHashStrategyCompiler hashStrategyCompiler, UpdateMemory updateMemory) {
        boolean dictionaryAggregationEnabled = SystemSessionProperties.isDictionaryAggregationEnabled(session);
        return GroupByHash.createGroupByHash(types, hasPrecomputedHash, expectedSize, dictionaryAggregationEnabled, hashStrategyCompiler, updateMemory);
    }

    public static GroupByHash createGroupByHash(List<Type> types, boolean hasPrecomputedHash, int expectedSize, boolean dictionaryAggregationEnabled, FlatHashStrategyCompiler hashStrategyCompiler, UpdateMemory updateMemory) {
        if (types.size() == 1 && types.get(0).equals((Object)BigintType.BIGINT)) {
            return new BigintGroupByHash(hasPrecomputedHash, expectedSize, updateMemory);
        }
        return new FlatGroupByHash(types, hasPrecomputedHash, expectedSize, dictionaryAggregationEnabled, hashStrategyCompiler, updateMemory);
    }

    public long getEstimatedSize();

    public int getGroupCount();

    public void appendValuesTo(int var1, PageBuilder var2);

    public Work<?> addPage(Page var1);

    public Work<int[]> getGroupIds(Page var1);

    public long getRawHash(int var1);

    @VisibleForTesting
    public int getCapacity();
}

