/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.BlockSet;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.atomic.AtomicBoolean;

@ScalarFunction(value="array_union")
@Description(value="Union elements of the two given arrays")
public final class ArrayUnionFunction {
    private ArrayUnionFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block union(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IDENTICAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionIsIdentical elementIdentical, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode elementHashCode, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int i;
        BlockSet set = new BlockSet(type, elementIdentical, elementHashCode, leftArray.getPositionCount() + rightArray.getPositionCount());
        for (i = 0; i < leftArray.getPositionCount(); ++i) {
            set.add(leftArray, i);
        }
        for (i = 0; i < rightArray.getPositionCount(); ++i) {
            set.add(rightArray, i);
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(null, set.size());
        set.getAllWithSizeLimit(blockBuilder, "array_union", BlockSet.MAX_FUNCTION_MEMORY);
        return blockBuilder.build();
    }

    @SqlType(value="array(bigint)")
    public static Block bigintUnion(@SqlType(value="array(bigint)") Block leftArray, @SqlType(value="array(bigint)") Block rightArray) {
        int leftArrayCount = leftArray.getPositionCount();
        int rightArrayCount = rightArray.getPositionCount();
        LongOpenHashSet set = new LongOpenHashSet(leftArrayCount + rightArrayCount);
        BlockBuilder distinctElementBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, leftArrayCount + rightArrayCount);
        AtomicBoolean containsNull = new AtomicBoolean(false);
        ArrayUnionFunction.appendBigintArray(leftArray, containsNull, (LongSet)set, distinctElementBlockBuilder);
        ArrayUnionFunction.appendBigintArray(rightArray, containsNull, (LongSet)set, distinctElementBlockBuilder);
        return distinctElementBlockBuilder.build();
    }

    private static void appendBigintArray(Block array, AtomicBoolean containsNull, LongSet set, BlockBuilder blockBuilder) {
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) {
                if (containsNull.get()) continue;
                containsNull.set(true);
                blockBuilder.appendNull();
                continue;
            }
            long value = BigintType.BIGINT.getLong(array, i);
            if (!set.add(value)) continue;
            BigintType.BIGINT.writeLong(blockBuilder, value);
        }
    }
}

