/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.type.DateTimes;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import io.trino.util.Failures;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.function.BiFunction;

public final class FormatFunction
extends SqlScalarFunction {
    public static final String NAME = "$format";
    public static final FormatFunction FORMAT_FUNCTION = new FormatFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(FormatFunction.class, "sqlFormat", List.class, ConnectorSession.class, Slice.class, SqlRow.class);
    private static final CatalogSchemaFunctionName JSON_FORMAT_NAME = GlobalFunctionCatalog.builtinFunctionName("json_format");

    private FormatFunction() {
        super(FunctionMetadata.scalarBuilder((String)NAME).signature(Signature.builder().variadicTypeParameter("T", "row").argumentType(VarcharType.VARCHAR.getTypeSignature()).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).returnType(VarcharType.VARCHAR.getTypeSignature()).build()).hidden().description("formats the input arguments using a format string").build());
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(BoundSignature boundSignature) {
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        ((Type)boundSignature.getArgumentTypes().get(1)).getTypeParameters().forEach(type -> FormatFunction.addDependencies(builder, type));
        return builder.build();
    }

    private static void addDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder, Type type) {
        if (type.equals((Object)UnknownType.UNKNOWN) || type.equals((Object)BooleanType.BOOLEAN) || type.equals((Object)TinyintType.TINYINT) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)BigintType.BIGINT) || type.equals((Object)RealType.REAL) || type.equals((Object)DoubleType.DOUBLE) || type.equals((Object)DateType.DATE) || type instanceof TimestampWithTimeZoneType || type instanceof TimestampType || type instanceof TimeType || type instanceof DecimalType || type instanceof VarcharType || type instanceof CharType) {
            return;
        }
        if (type.equals((Object)JsonType.JSON)) {
            builder.addFunction(JSON_FORMAT_NAME, (List)ImmutableList.of((Object)((Object)JsonType.JSON)));
            return;
        }
        builder.addCast(type, (Type)VarcharType.VARCHAR);
    }

    @Override
    public SpecializedSqlScalarFunction specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Type rowType = boundSignature.getArgumentType(1);
        List converters = (List)rowType.getTypeParameters().stream().map(type -> FormatFunction.converter(functionDependencies, type)).collect(ImmutableList.toImmutableList());
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), METHOD_HANDLE.bindTo(converters));
    }

    @UsedByGeneratedCode
    public static Slice sqlFormat(List<BiFunction<Block, Integer, Object>> converters, ConnectorSession session, Slice slice, SqlRow row) {
        int rawIndex = row.getRawIndex();
        Object[] args = new Object[converters.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = converters.get(i).apply(row.getRawFieldBlock(i), rawIndex);
        }
        return FormatFunction.sqlFormat(session, slice.toStringUtf8(), args);
    }

    private static Slice sqlFormat(ConnectorSession session, String format, Object[] args) {
        try {
            return Slices.utf8Slice((String)String.format(session.getLocale(), format, args));
        }
        catch (IllegalFormatException e) {
            String message = e.toString().replaceFirst("^java\\.util\\.(\\w+)Exception", "$1");
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid format string: %s (%s)", format, message), (Throwable)e);
        }
    }

    private static BiFunction<Block, Integer, Object> converter(FunctionDependencies functionDependencies, Type type) {
        BiFunction<Block, Integer, Object> converter = FormatFunction.valueConverter(functionDependencies, type);
        return (block, position) -> block.isNull(position.intValue()) ? null : converter.apply((Block)block, (Integer)position);
    }

    private static BiFunction<Block, Integer, Object> valueConverter(FunctionDependencies functionDependencies, Type type) {
        if (type.equals((Object)UnknownType.UNKNOWN)) {
            return (block, position) -> null;
        }
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return (arg_0, arg_1) -> ((BooleanType)BooleanType.BOOLEAN).getBoolean(arg_0, arg_1);
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return (block, position) -> (long)TinyintType.TINYINT.getByte(block, position.intValue());
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return (block, position) -> (long)SmallintType.SMALLINT.getShort(block, position.intValue());
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return (block, position) -> (long)IntegerType.INTEGER.getInt(block, position.intValue());
        }
        if (type.equals((Object)BigintType.BIGINT)) {
            return (arg_0, arg_1) -> ((BigintType)BigintType.BIGINT).getLong(arg_0, arg_1);
        }
        if (type.equals((Object)RealType.REAL)) {
            return (arg_0, arg_1) -> ((RealType)RealType.REAL).getFloat(arg_0, arg_1);
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return (arg_0, arg_1) -> ((DoubleType)DoubleType.DOUBLE).getDouble(arg_0, arg_1);
        }
        if (type.equals((Object)DateType.DATE)) {
            return (block, position) -> LocalDate.ofEpochDay(DateType.DATE.getInt(block, position.intValue()));
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            return (block, position) -> DateTimes.toZonedDateTime(timestampWithTimeZoneType, block, position);
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return (block, position) -> DateTimes.toLocalDateTime(timestampType, block, position);
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            return (block, position) -> FormatFunction.toLocalTime(timeType.getLong(block, position.intValue()));
        }
        if (type.equals((Object)JsonType.JSON)) {
            MethodHandle handle = functionDependencies.getScalarFunctionImplementation(JSON_FORMAT_NAME, (List)ImmutableList.of((Object)((Object)JsonType.JSON)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle();
            return (block, position) -> FormatFunction.convertToString(handle, type.getSlice(block, position.intValue()));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            int scale = decimalType.getScale();
            if (decimalType.isShort()) {
                return (block, position) -> BigDecimal.valueOf(decimalType.getLong(block, position.intValue()), scale);
            }
            return (block, position) -> new BigDecimal(((Int128)decimalType.getObject(block, position.intValue())).toBigInteger(), scale);
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return (block, position) -> varcharType.getSlice(block, position.intValue()).toStringUtf8();
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return (block, position) -> Chars.padSpaces((Slice)charType.getSlice(block, position.intValue()), (CharType)charType).toStringUtf8();
        }
        BiFunction<Block, Integer, Object> function = type.getJavaType() == Long.TYPE ? (arg_0, arg_1) -> ((Type)type).getLong(arg_0, arg_1) : (type.getJavaType() == Double.TYPE ? (arg_0, arg_1) -> ((Type)type).getDouble(arg_0, arg_1) : (type.getJavaType() == Boolean.TYPE ? (arg_0, arg_1) -> ((Type)type).getBoolean(arg_0, arg_1) : (type.getJavaType() == Slice.class ? (arg_0, arg_1) -> ((Type)type).getSlice(arg_0, arg_1) : (arg_0, arg_1) -> ((Type)type).getObject(arg_0, arg_1))));
        MethodHandle handle = functionDependencies.getCastImplementation(type, (Type)VarcharType.VARCHAR, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle();
        return (block, position) -> FormatFunction.convertToString(handle, function.apply((Block)block, (Integer)position));
    }

    private static LocalTime toLocalTime(long value) {
        long nanoOfDay = Timestamps.roundDiv((long)value, (long)1000L);
        return LocalTime.ofNanoOfDay(nanoOfDay);
    }

    private static Object convertToString(MethodHandle handle, Object value) {
        try {
            return handle.invoke(value).toStringUtf8();
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

