/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.OperatorNameUtil;
import io.trino.operator.annotations.FunctionsParserHelper;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.ScalarOperator;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ScalarHeader {
    private final String name;
    private final Optional<OperatorType> operatorType;
    private final Set<String> aliases;
    private final Optional<String> description;
    private final boolean hidden;
    private final boolean deterministic;

    public ScalarHeader(String name, Set<String> aliases, Optional<String> description, boolean hidden, boolean deterministic) {
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        this.operatorType = Optional.empty();
        this.aliases = ImmutableSet.copyOf(aliases);
        aliases.forEach(alias -> Preconditions.checkArgument((!alias.isEmpty() ? 1 : 0) != 0));
        this.description = Objects.requireNonNull(description, "description is null");
        this.hidden = hidden;
        this.deterministic = deterministic;
    }

    public ScalarHeader(OperatorType operatorType, Optional<String> description) {
        this.name = OperatorNameUtil.mangleOperatorName(operatorType);
        this.operatorType = Optional.of(operatorType);
        this.description = Objects.requireNonNull(description, "description is null");
        this.aliases = ImmutableSet.of();
        this.hidden = true;
        this.deterministic = true;
    }

    public static List<ScalarHeader> fromAnnotatedElement(AnnotatedElement annotated) {
        ImmutableList result;
        ScalarFunction scalarFunction = annotated.getAnnotation(ScalarFunction.class);
        ScalarOperator scalarOperator = annotated.getAnnotation(ScalarOperator.class);
        Optional<String> description = FunctionsParserHelper.parseDescription(annotated);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (scalarFunction != null) {
            String baseName = scalarFunction.value().isEmpty() ? ScalarHeader.camelToSnake(ScalarHeader.annotatedName(annotated)) : scalarFunction.value();
            builder.add((Object)new ScalarHeader(baseName, (Set<String>)ImmutableSet.copyOf((Object[])scalarFunction.alias()), description, scalarFunction.hidden(), scalarFunction.deterministic()));
        }
        if (scalarOperator != null) {
            builder.add((Object)new ScalarHeader(scalarOperator.value(), description));
        }
        Preconditions.checkArgument((!(result = builder.build()).isEmpty() ? 1 : 0) != 0);
        return result;
    }

    private static String camelToSnake(String name) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
    }

    private static String annotatedName(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Class) {
            Class clazz = (Class)annotatedElement;
            return clazz.getSimpleName();
        }
        if (annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            return method.getName();
        }
        throw new IllegalArgumentException("Only Classes and Methods are supported as annotated elements.");
    }

    public String getName() {
        return this.name;
    }

    public Optional<OperatorType> getOperatorType() {
        return this.operatorType;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }
}

