/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table.json.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Throwables;
import io.trino.json.ir.IrJsonPath;
import io.trino.operator.table.json.execution.Column;
import io.trino.spi.Page;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

public class QueryColumn
implements Column {
    private final int outputIndex;
    private final MethodHandle methodHandle;
    private final IrJsonPath path;
    private final long wrapperBehavior;
    private final long emptyBehavior;
    private final long errorBehavior;

    public QueryColumn(int outputIndex, MethodHandle methodHandle, IrJsonPath path, long wrapperBehavior, long emptyBehavior, long errorBehavior) {
        this.outputIndex = outputIndex;
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.wrapperBehavior = wrapperBehavior;
        this.emptyBehavior = emptyBehavior;
        this.errorBehavior = errorBehavior;
    }

    @Override
    public Object evaluate(long sequentialNumber, JsonNode item, Page input, int position) {
        try {
            return this.methodHandle.invoke(item, this.path, null, this.wrapperBehavior, this.emptyBehavior, this.errorBehavior);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public int getOutputIndex() {
        return this.outputIndex;
    }
}

