/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.window.AggregateWindowFunction;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowFunction;
import io.trino.spi.function.WindowFunctionSupplier;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class AggregationWindowFunctionSupplier
implements WindowFunctionSupplier {
    private final Function<List<Supplier<Object>>, WindowAccumulator> windowAccumulatorFactory;
    private final boolean hasRemoveInput;
    private final List<Class<?>> lambdaInterfaces;

    public AggregationWindowFunctionSupplier(BoundSignature boundSignature, AggregationImplementation aggregationImplementation, FunctionNullability functionNullability) {
        Objects.requireNonNull(boundSignature, "boundSignature is null");
        Objects.requireNonNull(aggregationImplementation, "aggregationMetadata is null");
        this.windowAccumulatorFactory = AccumulatorCompiler.generateWindowAccumulatorClass(boundSignature, aggregationImplementation, functionNullability);
        this.hasRemoveInput = aggregationImplementation.getWindowAccumulator().isPresent();
        this.lambdaInterfaces = aggregationImplementation.getLambdaInterfaces();
    }

    public List<Class<?>> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    public WindowFunction createWindowFunction(boolean ignoreNulls, List<Supplier<Object>> lambdaProviders) {
        return new AggregateWindowFunction(() -> this.windowAccumulatorFactory.apply(lambdaProviders), this.hasRemoveInput);
    }

    public WindowAccumulator createWindowAccumulator(List<Supplier<Object>> lambdaProviders) {
        return this.windowAccumulatorFactory.apply(lambdaProviders);
    }
}

