/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryState;
import io.trino.execution.resourcegroups.ResourceGroupInfoProvider;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlUtil;
import io.trino.server.BasicQueryInfo;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.QueryStateInfo;
import io.trino.server.security.ResourceSecurity;
import io.trino.spi.QueryId;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.AccessDeniedException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

@Path(value="/v1/queryState")
public class QueryStateInfoResource {
    private final DispatchManager dispatchManager;
    private final ResourceGroupInfoProvider resourceGroupInfoProvider;
    private final AccessControl accessControl;
    private final HttpRequestSessionContextFactory sessionContextFactory;

    @Inject
    public QueryStateInfoResource(DispatchManager dispatchManager, ResourceGroupInfoProvider resourceGroupInfoProvider, AccessControl accessControl, HttpRequestSessionContextFactory sessionContextFactory) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.resourceGroupInfoProvider = Objects.requireNonNull(resourceGroupInfoProvider, "resourceGroupInfoProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionContextFactory = Objects.requireNonNull(sessionContextFactory, "sessionContextFactory is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
    @GET
    @Produces(value={"application/json"})
    public List<QueryStateInfo> getQueryStateInfos(@QueryParam(value="user") String user, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        List queryInfos = this.dispatchManager.getQueries();
        queryInfos = AccessControlUtil.filterQueries(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders), queryInfos, this.accessControl);
        if (!Strings.isNullOrEmpty((String)user)) {
            queryInfos = (List)queryInfos.stream().filter(queryInfo -> Pattern.matches(user, queryInfo.getSession().getUser())).collect(ImmutableList.toImmutableList());
        }
        return (List)queryInfos.stream().filter(queryInfo -> !queryInfo.getState().isDone()).map(this::getQueryStateInfo).collect(ImmutableList.toImmutableList());
    }

    private QueryStateInfo getQueryStateInfo(BasicQueryInfo queryInfo) {
        Optional<ResourceGroupId> groupId = queryInfo.getResourceGroupId();
        if (queryInfo.getState() == QueryState.QUEUED) {
            return QueryStateInfo.createQueuedQueryStateInfo(queryInfo, groupId, groupId.map(group -> this.resourceGroupInfoProvider.tryGetPathToRoot((ResourceGroupId)group).orElseThrow(() -> new IllegalStateException("Resource group not found: " + String.valueOf(group)))));
        }
        return QueryStateInfo.createQueryStateInfo(queryInfo, groupId);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
    @GET
    @Path(value="{queryId}")
    @Produces(value={"application/json"})
    public QueryStateInfo getQueryStateInfo(@PathParam(value="queryId") String queryId, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        try {
            BasicQueryInfo queryInfo = this.dispatchManager.getQueryInfo(new QueryId(queryId));
            AccessControlUtil.checkCanViewQueryOwnedBy(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders), queryInfo.getSession().toIdentity(), this.accessControl);
            return this.getQueryStateInfo(queryInfo);
        }
        catch (AccessDeniedException e) {
            throw new ForbiddenException();
        }
        catch (NoSuchElementException e) {
            throw new NotFoundException();
        }
    }
}

