/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling.encoding;

import io.airlift.compress.v3.zstd.ZstdCompressor;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.encoding.CompressedQueryDataEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class ZstdQueryDataEncoder
extends CompressedQueryDataEncoder {
    private static final int COMPRESSION_THRESHOLD = 2048;

    public ZstdQueryDataEncoder(QueryDataEncoder delegate) {
        super(delegate, 2048);
    }

    @Override
    protected int compress(byte[] buffer, int uncompressedSize, OutputStream output) throws IOException {
        ZstdCompressor compressor = ZstdCompressor.create();
        byte[] compressed = new byte[compressor.maxCompressedLength(uncompressedSize)];
        int compressedSize = compressor.compress(buffer, 0, uncompressedSize, compressed, 0, compressed.length);
        output.write(compressed, 0, compressedSize);
        return compressedSize;
    }

    @Override
    public String encoding() {
        return this.delegate.encoding() + "+zstd";
    }
}

