/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.trino.Session;
import io.trino.cache.CacheUtils;
import io.trino.cache.SafeCaches;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionResolver;
import io.trino.metadata.LanguageFunctionAnalysisException;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.NodeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.CanonicalizationAware;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.ExpressionAnalysis;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.JsonPathAnalyzer;
import io.trino.sql.analyzer.LiteralInterpreter;
import io.trino.sql.analyzer.PatternRecognitionAnalysis;
import io.trino.sql.analyzer.PatternRecognitionAnalyzer;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.RelationId;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.StatementAnalyzer;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentDate;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentTimestamp;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonTable;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LocalTime;
import io.trino.sql.tree.LocalTimestamp;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.ProcessingMode;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.QueryColumn;
import io.trino.sql.tree.RangeQuantifier;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.tree.ValueColumn;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.type.ArrayParametricType;
import io.trino.type.DateTimes;
import io.trino.type.FunctionType;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.Json2016Type;
import io.trino.type.JsonType;
import io.trino.type.TypeCoercion;
import io.trino.type.UnknownType;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExpressionAnalyzer {
    private static final int MAX_NUMBER_GROUPING_ARGUMENTS_BIGINT = 63;
    private static final int MAX_NUMBER_GROUPING_ARGUMENTS_INTEGER = 31;
    public static final RowType JSON_NO_PARAMETERS_ROW_TYPE = RowType.anonymous((List)ImmutableList.of((Object)((Object)UnknownType.UNKNOWN)));
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final BiFunction<Node, CorrelationSupport, StatementAnalyzer> statementAnalyzerFactory;
    private final LiteralInterpreter literalInterpreter;
    private final boolean isDescribe;
    private final Cache<String, Type> varcharCastableTypeCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));
    private final Map<NodeRef<Node>, ResolvedFunction> resolvedFunctions = new LinkedHashMap<NodeRef<Node>, ResolvedFunction>();
    private final Set<NodeRef<SubqueryExpression>> subqueries = new LinkedHashSet<NodeRef<SubqueryExpression>>();
    private final Set<NodeRef<ExistsPredicate>> existsSubqueries = new LinkedHashSet<NodeRef<ExistsPredicate>>();
    private final Map<NodeRef<Expression>, Type> expressionCoercions = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundCalculation = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundComparison = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, ResolvedFunction> frameBoundCalculations = new LinkedHashMap<NodeRef<Expression>, ResolvedFunction>();
    private final Set<NodeRef<InPredicate>> subqueryInPredicates = new LinkedHashSet<NodeRef<InPredicate>>();
    private final Map<NodeRef<Expression>, Analysis.PredicateCoercions> predicateCoercions = new LinkedHashMap<NodeRef<Expression>, Analysis.PredicateCoercions>();
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences = new LinkedHashMap<NodeRef<Expression>, ResolvedField>();
    private final Map<NodeRef<Expression>, Type> expressionTypes = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons = new LinkedHashSet<NodeRef<QuantifiedComparisonExpression>>();
    private final Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences = new LinkedHashMap<NodeRef<Identifier>, LambdaArgumentDeclaration>();
    private final Set<NodeRef<FunctionCall>> windowFunctions = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Multimap<QualifiedObjectName, String> tableColumnReferences = HashMultimap.create();
    private final Multimap<NodeRef<Node>, Field> referencedFields = HashMultimap.create();
    private final Map<NodeRef<Expression>, Optional<String>> labels = new HashMap<NodeRef<Expression>, Optional<String>>();
    private final Map<NodeRef<RangeQuantifier>, Analysis.Range> ranges = new LinkedHashMap<NodeRef<RangeQuantifier>, Analysis.Range>();
    private final Map<NodeRef<RowPattern>, Set<String>> undefinedLabels = new LinkedHashMap<NodeRef<RowPattern>, Set<String>>();
    private final Map<NodeRef<Identifier>, String> resolvedLabels = new LinkedHashMap<NodeRef<Identifier>, String>();
    private final Map<NodeRef<SubsetDefinition>, Set<String>> subsets = new LinkedHashMap<NodeRef<SubsetDefinition>, Set<String>>();
    private final Map<NodeRef<WindowOperation>, MeasureDefinition> measureDefinitions = new LinkedHashMap<NodeRef<WindowOperation>, MeasureDefinition>();
    private final Map<NodeRef<Expression>, List<PatternRecognitionAnalysis.PatternInputAnalysis>> patternRecognitionInputs = new LinkedHashMap<NodeRef<Expression>, List<PatternRecognitionAnalysis.PatternInputAnalysis>>();
    private final Set<NodeRef<FunctionCall>> patternNavigationFunctions = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Map<NodeRef<Node>, JsonPathAnalyzer.JsonPathAnalysis> jsonPathAnalyses = new LinkedHashMap<NodeRef<Node>, JsonPathAnalyzer.JsonPathAnalysis>();
    private final Map<NodeRef<Expression>, ResolvedFunction> jsonInputFunctions = new LinkedHashMap<NodeRef<Expression>, ResolvedFunction>();
    private final Map<NodeRef<Node>, ResolvedFunction> jsonOutputFunctions = new LinkedHashMap<NodeRef<Node>, ResolvedFunction>();
    private final Session session;
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private final WarningCollector warningCollector;
    private final TypeCoercion typeCoercion;
    private final Function<Expression, Type> getPreanalyzedType;
    private final Function<Node, Analysis.ResolvedWindow> getResolvedWindow;
    private final List<Field> sourceFields = new ArrayList<Field>();
    private final FunctionResolver functionResolver;

    private ExpressionAnalyzer(PlannerContext plannerContext, AccessControl accessControl, StatementAnalyzerFactory statementAnalyzerFactory, Analysis analysis, Session session, WarningCollector warningCollector) {
        this(plannerContext, accessControl, (node, correlationSupport) -> statementAnalyzerFactory.createStatementAnalyzer(analysis, session, warningCollector, (CorrelationSupport)((Object)correlationSupport)), session, analysis.getParameters(), warningCollector, analysis.isDescribe(), analysis::getType, analysis::getWindow);
    }

    ExpressionAnalyzer(PlannerContext plannerContext, AccessControl accessControl, BiFunction<Node, CorrelationSupport, StatementAnalyzer> statementAnalyzerFactory, Session session, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, boolean isDescribe, Function<Expression, Type> getPreanalyzedType, Function<Node, Analysis.ResolvedWindow> getResolvedWindow) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.literalInterpreter = new LiteralInterpreter(plannerContext, session);
        this.session = Objects.requireNonNull(session, "session is null");
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.isDescribe = isDescribe;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        this.getPreanalyzedType = Objects.requireNonNull(getPreanalyzedType, "getPreanalyzedType is null");
        this.getResolvedWindow = Objects.requireNonNull(getResolvedWindow, "getResolvedWindow is null");
        this.functionResolver = plannerContext.getFunctionResolver(warningCollector);
    }

    public Map<NodeRef<Node>, ResolvedFunction> getResolvedFunctions() {
        return Collections.unmodifiableMap(this.resolvedFunctions);
    }

    public Map<NodeRef<Expression>, Type> getExpressionTypes() {
        return Collections.unmodifiableMap(this.expressionTypes);
    }

    public Type setExpressionType(Expression expression, Type type) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.expressionTypes.put((NodeRef<Expression>)NodeRef.of((Node)expression), type);
        return type;
    }

    private Type getExpressionType(Expression expression) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Type type = this.expressionTypes.get(NodeRef.of((Node)expression));
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Expression not yet analyzed: %s", (Object)expression);
        return type;
    }

    public Map<NodeRef<Expression>, Type> getExpressionCoercions() {
        return Collections.unmodifiableMap(this.expressionCoercions);
    }

    public Map<NodeRef<Expression>, Type> getSortKeyCoercionsForFrameBoundCalculation() {
        return Collections.unmodifiableMap(this.sortKeyCoercionsForFrameBoundCalculation);
    }

    public Map<NodeRef<Expression>, Type> getSortKeyCoercionsForFrameBoundComparison() {
        return Collections.unmodifiableMap(this.sortKeyCoercionsForFrameBoundComparison);
    }

    public Map<NodeRef<Expression>, ResolvedFunction> getFrameBoundCalculations() {
        return Collections.unmodifiableMap(this.frameBoundCalculations);
    }

    public Set<NodeRef<InPredicate>> getSubqueryInPredicates() {
        return Collections.unmodifiableSet(this.subqueryInPredicates);
    }

    public Map<NodeRef<Expression>, Analysis.PredicateCoercions> getPredicateCoercions() {
        return Collections.unmodifiableMap(this.predicateCoercions);
    }

    public Map<NodeRef<Expression>, ResolvedField> getColumnReferences() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public Map<NodeRef<Identifier>, LambdaArgumentDeclaration> getLambdaArgumentReferences() {
        return Collections.unmodifiableMap(this.lambdaArgumentReferences);
    }

    public Type analyze(Expression expression, Scope scope) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        this.patternRecognitionInputs.put((NodeRef<Expression>)NodeRef.of((Node)expression), visitor.getPatternRecognitionInputs());
        return visitor.process((Node)expression, Context.notInLambda(scope, CorrelationSupport.ALLOWED));
    }

    public Type analyze(Expression expression, Scope scope, CorrelationSupport correlationSupport) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        this.patternRecognitionInputs.put((NodeRef<Expression>)NodeRef.of((Node)expression), visitor.getPatternRecognitionInputs());
        return visitor.process((Node)expression, Context.notInLambda(scope, correlationSupport));
    }

    private Type analyze(Expression expression, Scope scope, Set<String> labels, boolean inWindow) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        Type type = visitor.process((Node)expression, Context.patternRecognition(scope, labels, inWindow));
        this.patternRecognitionInputs.put((NodeRef<Expression>)NodeRef.of((Node)expression), visitor.getPatternRecognitionInputs());
        return type;
    }

    private Type analyze(Expression expression, Scope baseScope, Context context) {
        Visitor visitor = new Visitor(baseScope, this.warningCollector);
        this.patternRecognitionInputs.put((NodeRef<Expression>)NodeRef.of((Node)expression), visitor.getPatternRecognitionInputs());
        return visitor.process((Node)expression, context);
    }

    private RowType analyzeJsonPathInvocation(JsonTable node, Scope scope, CorrelationSupport correlationSupport) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        List<Type> inputTypes = visitor.analyzeJsonPathInvocation("JSON_TABLE", (Node)node, node.getJsonPathInvocation(), Context.notInLambda(scope, correlationSupport));
        return (RowType)inputTypes.get(2);
    }

    private Type analyzeJsonValueExpression(ValueColumn column, JsonPathAnalyzer.JsonPathAnalysis pathAnalysis, Scope scope, CorrelationSupport correlationSupport) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        ImmutableList pathInvocationArgumentTypes = ImmutableList.of((Object)((Object)Json2016Type.JSON_2016), (Object)this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), (Object)JSON_NO_PARAMETERS_ROW_TYPE);
        return visitor.analyzeJsonValueExpression((Node)column, pathAnalysis, Optional.of(column.getType()), (List<Type>)pathInvocationArgumentTypes, column.getEmptyBehavior(), column.getEmptyDefault(), column.getErrorBehavior(), column.getErrorDefault(), Context.notInLambda(scope, correlationSupport));
    }

    private Type analyzeJsonQueryExpression(QueryColumn column, Scope scope) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        ImmutableList pathInvocationArgumentTypes = ImmutableList.of((Object)((Object)Json2016Type.JSON_2016), (Object)this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), (Object)JSON_NO_PARAMETERS_ROW_TYPE);
        return visitor.analyzeJsonQueryExpression((Node)column, column.getWrapperBehavior(), column.getQuotesBehavior(), (List<Type>)pathInvocationArgumentTypes, Optional.of(column.getType()), Optional.of(column.getFormat()));
    }

    private void analyzeWindow(Analysis.ResolvedWindow window, Scope scope, Node originalNode, CorrelationSupport correlationSupport) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        visitor.analyzeWindow(window, Context.inWindow(scope, correlationSupport), originalNode);
    }

    public Set<NodeRef<SubqueryExpression>> getSubqueries() {
        return Collections.unmodifiableSet(this.subqueries);
    }

    public Set<NodeRef<ExistsPredicate>> getExistsSubqueries() {
        return Collections.unmodifiableSet(this.existsSubqueries);
    }

    public Set<NodeRef<QuantifiedComparisonExpression>> getQuantifiedComparisons() {
        return Collections.unmodifiableSet(this.quantifiedComparisons);
    }

    public Set<NodeRef<FunctionCall>> getWindowFunctions() {
        return Collections.unmodifiableSet(this.windowFunctions);
    }

    public Multimap<QualifiedObjectName, String> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public List<Field> getSourceFields() {
        return this.sourceFields;
    }

    public Map<NodeRef<Expression>, Optional<String>> getLabels() {
        return this.labels;
    }

    public Map<NodeRef<RangeQuantifier>, Analysis.Range> getRanges() {
        return this.ranges;
    }

    public Map<NodeRef<RowPattern>, Set<String>> getUndefinedLabels() {
        return this.undefinedLabels;
    }

    public Map<NodeRef<Identifier>, String> getResolvedLabels() {
        return this.resolvedLabels;
    }

    public Map<NodeRef<SubsetDefinition>, Set<String>> getSubsetLabels() {
        return this.subsets;
    }

    public Map<NodeRef<WindowOperation>, MeasureDefinition> getMeasureDefinitions() {
        return this.measureDefinitions;
    }

    public Map<NodeRef<Expression>, List<PatternRecognitionAnalysis.PatternInputAnalysis>> getPatternRecognitionInputs() {
        return this.patternRecognitionInputs;
    }

    public Set<NodeRef<FunctionCall>> getPatternNavigationFunctions() {
        return this.patternNavigationFunctions;
    }

    public Map<NodeRef<Node>, JsonPathAnalyzer.JsonPathAnalysis> getJsonPathAnalyses() {
        return this.jsonPathAnalyses;
    }

    public Map<NodeRef<Expression>, ResolvedFunction> getJsonInputFunctions() {
        return this.jsonInputFunctions;
    }

    public Map<NodeRef<Node>, ResolvedFunction> getJsonOutputFunctions() {
        return this.jsonOutputFunctions;
    }

    public static boolean isPatternRecognitionFunction(FunctionCall node) {
        QualifiedName qualifiedName = node.getName();
        if (qualifiedName.getParts().size() > 1) {
            return false;
        }
        Identifier identifier = (Identifier)qualifiedName.getOriginalParts().getFirst();
        if (identifier.isDelimited()) {
            return false;
        }
        String name = identifier.getValue().toUpperCase(Locale.ENGLISH);
        return name.equals("FIRST") || name.equals("LAST") || name.equals("PREV") || name.equals("NEXT") || name.equals("CLASSIFIER") || name.equals("MATCH_NUMBER");
    }

    public static ExpressionAnalysis analyzePatternRecognitionExpression(Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, WarningCollector warningCollector, Set<String> labels) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, warningCollector);
        analyzer.analyze(expression, scope, labels, false);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static ExpressionAnalysis analyzeExpressions(Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Iterable<Expression> expressions, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, QueryType queryType) {
        Analysis analysis = new Analysis(null, parameters, queryType);
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, warningCollector);
        for (Expression expression : expressions) {
            analyzer.analyze(expression, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(new Field[0])).build());
        }
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static ExpressionAnalysis analyzeExpression(Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, warningCollector);
        analyzer.analyze(expression, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        analysis.addExpressionFields(expression, analyzer.getSourceFields());
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static ParametersTypeAndAnalysis analyzeJsonPathInvocation(JsonTable node, Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, warningCollector);
        RowType parametersRowType = analyzer.analyzeJsonPathInvocation(node, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        return new ParametersTypeAndAnalysis(parametersRowType, new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions()));
    }

    public static TypeAndAnalysis analyzeJsonValueExpression(ValueColumn column, JsonPathAnalyzer.JsonPathAnalysis pathAnalysis, Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, warningCollector);
        Type type = analyzer.analyzeJsonValueExpression(column, pathAnalysis, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        return new TypeAndAnalysis(type, new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions()));
    }

    public static Type analyzeJsonQueryExpression(QueryColumn column, Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, WarningCollector warningCollector) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, warningCollector);
        Type type = analyzer.analyzeJsonQueryExpression(column, scope);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        return type;
    }

    public static void analyzeExpressionWithoutSubqueries(Session session, PlannerContext plannerContext, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, ErrorCodeSupplier errorCode, String message, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, (node, ignored) -> {
            throw SemanticExceptions.semanticException(errorCode, node, "%s", message);
        }, session, analysis.getParameters(), warningCollector, analysis.isDescribe(), analysis::getType, analysis::getWindow);
        analyzer.analyze(expression, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        analysis.addExpressionFields(expression, analyzer.getSourceFields());
    }

    public static ExpressionAnalysis analyzeWindow(Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, WarningCollector warningCollector, CorrelationSupport correlationSupport, Analysis.ResolvedWindow window, Node originalNode) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, warningCollector);
        analyzer.analyzeWindow(window, scope, originalNode, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    private static void updateAnalysis(Analysis analysis, ExpressionAnalyzer analyzer, Session session, AccessControl accessControl) {
        analysis.addTypes(analyzer.getExpressionTypes());
        analysis.addCoercions(analyzer.getExpressionCoercions(), analyzer.getSortKeyCoercionsForFrameBoundCalculation(), analyzer.getSortKeyCoercionsForFrameBoundComparison());
        analysis.addFrameBoundCalculations(analyzer.getFrameBoundCalculations());
        analyzer.getResolvedFunctions().forEach((key, value) -> analysis.addResolvedFunction(key.getNode(), (ResolvedFunction)value, session.getUser()));
        analysis.addColumnReferences(analyzer.getColumnReferences());
        analysis.addLambdaArgumentReferences(analyzer.getLambdaArgumentReferences());
        analysis.addTableColumnReferences(accessControl, session.getIdentity(), analyzer.getTableColumnReferences());
        analysis.addLabels(analyzer.getLabels());
        analysis.addPatternRecognitionInputs(analyzer.getPatternRecognitionInputs());
        analysis.addPatternNavigationFunctions(analyzer.getPatternNavigationFunctions());
        analysis.setRanges(analyzer.getRanges());
        analysis.setUndefinedLabels(analyzer.getUndefinedLabels());
        analysis.addResolvedLabels(analyzer.getResolvedLabels());
        analysis.addSubsetLabels(analyzer.getSubsetLabels());
        analysis.setMeasureDefinitions(analyzer.getMeasureDefinitions());
        analysis.setJsonPathAnalyses(analyzer.getJsonPathAnalyses());
        analysis.setJsonInputFunctions(analyzer.getJsonInputFunctions());
        analysis.setJsonOutputFunctions(analyzer.getJsonOutputFunctions());
        analysis.addPredicateCoercions(analyzer.getPredicateCoercions());
    }

    public static ExpressionAnalyzer createConstantAnalyzer(PlannerContext plannerContext, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector) {
        return ExpressionAnalyzer.createWithoutSubqueries(plannerContext, accessControl, session, parameters, (ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", warningCollector, false);
    }

    public static ExpressionAnalyzer createConstantAnalyzer(PlannerContext plannerContext, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.createWithoutSubqueries(plannerContext, accessControl, session, parameters, (ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", warningCollector, isDescribe);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(PlannerContext plannerContext, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, ErrorCodeSupplier errorCode, String message, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.createWithoutSubqueries(plannerContext, accessControl, session, parameters, node -> SemanticExceptions.semanticException(errorCode, node, "%s", message), warningCollector, isDescribe);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(PlannerContext plannerContext, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, Function<? super Node, ? extends RuntimeException> statementAnalyzerRejection, WarningCollector warningCollector, boolean isDescribe) {
        return new ExpressionAnalyzer(plannerContext, accessControl, (node, correlationSupport) -> {
            throw (RuntimeException)statementAnalyzerRejection.apply((Node)node);
        }, session, parameters, warningCollector, isDescribe, expression -> {
            throw new IllegalStateException("Cannot access preanalyzed types");
        }, functionCall -> {
            throw new IllegalStateException("Cannot access resolved windows");
        });
    }

    public static boolean isNumericType(Type type) {
        return type.equals((Object)BigintType.BIGINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)TinyintType.TINYINT) || type.equals((Object)DoubleType.DOUBLE) || type.equals((Object)RealType.REAL) || type instanceof DecimalType;
    }

    private static boolean isExactNumericWithScaleZero(Type type) {
        return type.equals((Object)BigintType.BIGINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)TinyintType.TINYINT) || type instanceof DecimalType && ((DecimalType)type).getScale() == 0;
    }

    public static boolean isStringType(Type type) {
        return ExpressionAnalyzer.isCharacterStringType(type) || VarbinaryType.VARBINARY.equals((Object)type);
    }

    public static boolean isCharacterStringType(Type type) {
        return type instanceof VarcharType || type instanceof CharType;
    }

    private class Visitor
    extends AstVisitor<Type, Context> {
        private final Scope baseScope;
        private final WarningCollector warningCollector;
        private final List<PatternRecognitionAnalysis.PatternInputAnalysis> patternRecognitionInputs = new ArrayList<PatternRecognitionAnalysis.PatternInputAnalysis>();

        public Visitor(Scope baseScope, WarningCollector warningCollector) {
            this.baseScope = Objects.requireNonNull(baseScope, "baseScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        public List<PatternRecognitionAnalysis.PatternInputAnalysis> getPatternRecognitionInputs() {
            return this.patternRecognitionInputs;
        }

        public Type process(Node node, @Nullable Context context) {
            Type type;
            if (node instanceof Expression && (type = ExpressionAnalyzer.this.expressionTypes.get(NodeRef.of((Node)((Expression)node)))) != null) {
                return type;
            }
            return (Type)super.process(node, (Object)context);
        }

        protected Type visitRow(Row node, Context context) {
            List types = (List)node.getItems().stream().map(child -> this.process((Node)child, context)).collect(ImmutableList.toImmutableList());
            RowType type = RowType.anonymous((List)types);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitCurrentDate(CurrentDate node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)DateType.DATE);
        }

        protected Type visitCurrentTime(CurrentTime node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)node.getPrecision().map(TimeWithTimeZoneType::createTimeWithTimeZoneType).orElse(TimeWithTimeZoneType.TIME_TZ_MILLIS));
        }

        protected Type visitCurrentTimestamp(CurrentTimestamp node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)node.getPrecision().map(TimestampWithTimeZoneType::createTimestampWithTimeZoneType).orElse(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS));
        }

        protected Type visitLocalTime(LocalTime node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)node.getPrecision().map(TimeType::createTimeType).orElse(TimeType.TIME_MILLIS));
        }

        protected Type visitLocalTimestamp(LocalTimestamp node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)node.getPrecision().map(TimestampType::createTimestampType).orElse(TimestampType.TIMESTAMP_MILLIS));
        }

        protected Type visitIdentifier(Identifier node, Context context) {
            ResolvedField resolvedField = context.getScope().resolveField((Expression)node, QualifiedName.of((String)node.getValue()));
            if (context.isPatternRecognition()) {
                ExpressionAnalyzer.this.labels.put((NodeRef<Expression>)NodeRef.of((Node)node), Optional.empty());
                this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternInputAnalysis((Expression)node, new PatternRecognitionAnalysis.ScalarInputDescriptor(Optional.empty(), context.getPatternRecognitionContext().navigation())));
            }
            return this.handleResolvedField((Expression)node, resolvedField, context);
        }

        private Type handleResolvedField(Expression node, ResolvedField resolvedField, Context context) {
            LambdaArgumentDeclaration lambdaArgumentDeclaration;
            if (!resolvedField.isLocal() && context.getCorrelationSupport() != CorrelationSupport.ALLOWED) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Reference to column '%s' from outer scope not allowed in this context", node);
            }
            FieldId fieldId = FieldId.from(resolvedField);
            Field field = resolvedField.getField();
            if (context.isInLambda() && (lambdaArgumentDeclaration = context.getFieldToLambdaArgumentDeclaration().get(fieldId)) != null) {
                ExpressionAnalyzer.this.lambdaArgumentReferences.put((NodeRef<Identifier>)NodeRef.of((Node)((Identifier)node)), lambdaArgumentDeclaration);
                return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
            }
            if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
                ExpressionAnalyzer.this.tableColumnReferences.put((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get());
            }
            ExpressionAnalyzer.this.sourceFields.add(field);
            fieldId.getRelationId().getSourceNode().ifPresent(source -> ExpressionAnalyzer.this.referencedFields.put((Object)NodeRef.of((Node)source), (Object)field));
            ResolvedField previous = ExpressionAnalyzer.this.columnReferences.put((NodeRef<Expression>)NodeRef.of((Node)node), resolvedField);
            Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"%s already known to refer to %s", (Object)node, (Object)previous);
            return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
        }

        protected Type visitDereferenceExpression(DereferenceExpression node, Context context) {
            Type baseType;
            if (DereferenceExpression.isQualifiedAllFieldsReference((Expression)node)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "<identifier>.* not allowed in this context", new Object[0]);
            }
            QualifiedName qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)node);
            if (qualifiedName != null) {
                if (context.isPatternRecognition()) {
                    String label = this.label((Identifier)qualifiedName.getOriginalParts().getFirst());
                    if (context.getPatternRecognitionContext().labels().contains(label)) {
                        QualifiedName unlabeledName = QualifiedName.of(qualifiedName.getOriginalParts().subList(1, qualifiedName.getOriginalParts().size()));
                        if (qualifiedName.getOriginalParts().size() > 2) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)node, "Column %s prefixed with label %s cannot be resolved", unlabeledName, label);
                        }
                        Optional<ResolvedField> resolvedField = context.getScope().tryResolveField((Expression)node, unlabeledName);
                        if (resolvedField.isEmpty()) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)node, "Column %s prefixed with label %s cannot be resolved", unlabeledName, label);
                        }
                        ExpressionAnalyzer.this.labels.put((NodeRef<Expression>)NodeRef.of((Node)node), Optional.of(label));
                        this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternInputAnalysis((Expression)node, new PatternRecognitionAnalysis.ScalarInputDescriptor(Optional.of(label), context.getPatternRecognitionContext().navigation())));
                        return this.handleResolvedField((Expression)node, resolvedField.get(), context);
                    }
                    throw SemanticExceptions.missingAttributeException((Expression)node, qualifiedName);
                }
                Scope scope = context.getScope();
                Optional<ResolvedField> resolvedField = scope.tryResolveField((Expression)node, qualifiedName);
                if (resolvedField.isPresent()) {
                    return this.handleResolvedField((Expression)node, resolvedField.get(), context);
                }
                if (!scope.isColumnReference(qualifiedName)) {
                    throw SemanticExceptions.missingAttributeException((Expression)node, qualifiedName);
                }
            }
            if (!((baseType = this.process((Node)node.getBase(), context)) instanceof RowType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getBase(), "Expression %s is not of type ROW", node.getBase());
            }
            RowType rowType = (RowType)baseType;
            Identifier field = (Identifier)node.getField().orElseThrow();
            String fieldName = field.getValue();
            boolean foundFieldName = false;
            Type rowFieldType = null;
            for (RowType.Field rowField : rowType.getFields()) {
                if (!fieldName.equalsIgnoreCase(rowField.getName().orElse(null))) continue;
                if (foundFieldName) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)field, "Ambiguous row field reference: %s", fieldName);
                }
                foundFieldName = true;
                rowFieldType = rowField.getType();
            }
            if (rowFieldType == null) {
                throw SemanticExceptions.invalidReferenceException((Expression)node, Optional.ofNullable(qualifiedName).orElseGet(() -> QualifiedName.of((String)fieldName)));
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, rowFieldType);
        }

        protected Type visitNotExpression(NotExpression node, Context context) {
            this.coerceType(context, node.getValue(), (Type)BooleanType.BOOLEAN, "Value of logical NOT expression");
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitLogicalExpression(LogicalExpression node, Context context) {
            for (Expression term : node.getTerms()) {
                this.coerceType(context, term, (Type)BooleanType.BOOLEAN, "Logical expression term");
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitComparisonExpression(ComparisonExpression node, Context context) {
            OperatorType operatorType = switch (node.getOperator()) {
                default -> throw new MatchException(null, null);
                case ComparisonExpression.Operator.EQUAL, ComparisonExpression.Operator.NOT_EQUAL -> OperatorType.EQUAL;
                case ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.GREATER_THAN -> OperatorType.LESS_THAN;
                case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> OperatorType.LESS_THAN_OR_EQUAL;
                case ComparisonExpression.Operator.IS_DISTINCT_FROM -> OperatorType.IDENTICAL;
            };
            return this.getOperator(context, (Expression)node, operatorType, node.getLeft(), node.getRight());
        }

        protected Type visitIsNullPredicate(IsNullPredicate node, Context context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, Context context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitNullIfExpression(NullIfExpression node, Context context) {
            Type secondType;
            Type firstType = this.process((Node)node.getFirst(), context);
            if (ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(firstType, secondType = this.process((Node)node.getSecond(), context)).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with NULLIF: %s vs %s", firstType, secondType);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, firstType);
        }

        protected Type visitIfExpression(IfExpression node, Context context) {
            this.coerceType(context, node.getCondition(), (Type)BooleanType.BOOLEAN, "IF condition");
            Type type = node.getFalseValue().isPresent() ? this.coerceToSingleType(context, (Node)node, "Result types for IF must be the same", node.getTrueValue(), (Expression)node.getFalseValue().get()) : this.process((Node)node.getTrueValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, Context context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceType(context, whenClause.getOperand(), (Type)BooleanType.BOOLEAN, "CASE WHEN clause");
            }
            Type type = this.coerceToSingleType(context, "All CASE results", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType((Expression)whenClause, whenClauseType);
            }
            return type;
        }

        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, Context context) {
            this.coerceCaseOperandToToSingleType(node, context);
            Type type = this.coerceToSingleType(context, "All CASE results", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType((Expression)whenClause, whenClauseType);
            }
            return type;
        }

        private void coerceCaseOperandToToSingleType(SimpleCaseExpression node, Context context) {
            Expression whenOperand;
            Type operandType = this.process((Node)node.getOperand(), context);
            List whenClauses = node.getWhenClauses();
            ArrayList<Type> whenOperandTypes = new ArrayList<Type>(whenClauses.size());
            Type commonType = operandType;
            for (WhenClause whenClause : whenClauses) {
                whenOperand = whenClause.getOperand();
                Type whenOperandType = this.process((Node)whenOperand, context);
                whenOperandTypes.add(whenOperandType);
                commonType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(commonType, whenOperandType).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)whenOperand, "CASE operand type does not match WHEN clause operand type: %s vs %s", operandType, whenOperandType));
            }
            if (commonType != operandType) {
                this.addOrReplaceExpressionCoercion(node.getOperand(), commonType);
            }
            for (int i = 0; i < whenOperandTypes.size(); ++i) {
                Type whenOperandType = (Type)whenOperandTypes.get(i);
                if (whenOperandType.equals((Object)commonType)) continue;
                whenOperand = ((WhenClause)whenClauses.get(i)).getOperand();
                this.addOrReplaceExpressionCoercion(whenOperand, commonType);
            }
        }

        private List<Expression> getCaseResultExpressions(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (WhenClause whenClause : whenClauses) {
                resultExpressions.add(whenClause.getResult());
            }
            defaultValue.ifPresent(resultExpressions::add);
            return resultExpressions;
        }

        protected Type visitCoalesceExpression(CoalesceExpression node, Context context) {
            Type type = this.coerceToSingleType(context, "All COALESCE operands", node.getOperands());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitArithmeticUnary(ArithmeticUnaryExpression node, Context context) {
            return switch (node.getSign()) {
                default -> throw new MatchException(null, null);
                case ArithmeticUnaryExpression.Sign.PLUS -> {
                    Type type = this.process((Node)node.getValue(), context);
                    if (!(type.equals((Object)DoubleType.DOUBLE) || type.equals((Object)RealType.REAL) || type.equals((Object)BigintType.BIGINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)TinyintType.TINYINT))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unary '+' operator cannot by applied to %s type", type);
                    }
                    yield ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
                }
                case ArithmeticUnaryExpression.Sign.MINUS -> this.getOperator(context, (Expression)node, OperatorType.NEGATION, node.getValue());
            };
        }

        protected Type visitArithmeticBinary(ArithmeticBinaryExpression node, Context context) {
            return this.getOperator(context, (Expression)node, OperatorType.valueOf((String)node.getOperator().name()), node.getLeft(), node.getRight());
        }

        protected Type visitLikePredicate(LikePredicate node, Context context) {
            Expression escape;
            Type escapeType;
            Type patternType;
            Type valueType = this.process((Node)node.getValue(), context);
            if (!(valueType instanceof CharType) && !(valueType instanceof VarcharType)) {
                this.coerceType(context, node.getValue(), (Type)VarcharType.VARCHAR, "Left side of LIKE expression");
            }
            if (!((patternType = this.process((Node)node.getPattern(), context)) instanceof VarcharType)) {
                this.coerceType(context, node.getPattern(), (Type)VarcharType.VARCHAR, "Pattern for LIKE expression");
            }
            if (node.getEscape().isPresent() && !((escapeType = this.process((Node)(escape = (Expression)node.getEscape().get()), context)) instanceof VarcharType)) {
                this.coerceType(context, escape, (Type)VarcharType.VARCHAR, "Escape for LIKE expression");
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitSubscriptExpression(SubscriptExpression node, Context context) {
            Type baseType = this.process((Node)node.getBase(), context);
            if (baseType instanceof RowType) {
                if (!(node.getIndex() instanceof LongLiteral)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)node.getIndex(), "Subscript expression on ROW requires a constant index", new Object[0]);
                }
                Type indexType = this.process((Node)node.getIndex(), context);
                if (!indexType.equals((Object)IntegerType.INTEGER)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getIndex(), "Subscript expression on ROW requires integer index, found %s", indexType);
                }
                int indexValue = Math.toIntExact(((LongLiteral)node.getIndex()).getParsedValue());
                if (indexValue <= 0) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node.getIndex(), "Invalid subscript index: %s. ROW indices start at 1", indexValue);
                }
                List rowTypes = baseType.getTypeParameters();
                if (indexValue > rowTypes.size()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node.getIndex(), "Subscript index out of bounds: %s, max value is %s", indexValue, rowTypes.size());
                }
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)rowTypes.get(indexValue - 1));
            }
            return this.getOperator(context, (Expression)node, OperatorType.SUBSCRIPT, node.getBase(), node.getIndex());
        }

        protected Type visitArray(Array node, Context context) {
            Type type = this.coerceToSingleType(context, "All ARRAY elements", node.getValues());
            Type arrayType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getParameterizedType(ArrayParametricType.ARRAY.getName(), (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)type.getTypeSignature())));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, arrayType);
        }

        protected Type visitStringLiteral(StringLiteral node, Context context) {
            VarcharType type = VarcharType.createVarcharType((int)node.length());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitBinaryLiteral(BinaryLiteral node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarbinaryType.VARBINARY);
        }

        protected Type visitLongLiteral(LongLiteral node, Context context) {
            if (node.getParsedValue() >= Integer.MIN_VALUE && node.getParsedValue() <= Integer.MAX_VALUE) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)IntegerType.INTEGER);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        protected Type visitDoubleLiteral(DoubleLiteral node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)DoubleType.DOUBLE);
        }

        protected Type visitDecimalLiteral(DecimalLiteral node, Context context) {
            DecimalParseResult parseResult;
            try {
                parseResult = Decimals.parse((String)node.getValue());
            }
            catch (RuntimeException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, e, "'%s' is not a valid DECIMAL literal", node.getValue());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)parseResult.getType());
        }

        protected Type visitBooleanLiteral(BooleanLiteral node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitGenericLiteral(GenericLiteral node, Context context) {
            Type type;
            GenericLiteral genericLiteral;
            ExpressionAnalyzer expressionAnalyzer;
            String string = node.getType();
            Objects.requireNonNull(string);
            String string2 = string;
            int n = 0;
            GenericLiteral genericLiteral2 = node;
            ExpressionAnalyzer expressionAnalyzer2 = ExpressionAnalyzer.this;
            block7: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class}, (Object)string2, n)) {
                    case 0: {
                        String value = string2;
                        if (!value.equalsIgnoreCase("CHAR")) {
                            n = 1;
                            continue block7;
                        }
                        CharType charType = CharType.createCharType((int)node.getValue().length());
                        expressionAnalyzer = expressionAnalyzer2;
                        genericLiteral = genericLiteral2;
                        type = charType;
                        break block7;
                    }
                    case 1: {
                        String value = string2;
                        if (!value.equalsIgnoreCase("TIME")) {
                            n = 2;
                            continue block7;
                        }
                        Type type2 = this.processTimeLiteral(node);
                        expressionAnalyzer = expressionAnalyzer2;
                        genericLiteral = genericLiteral2;
                        type = type2;
                        break block7;
                    }
                    case 2: {
                        String value = string2;
                        if (!value.equalsIgnoreCase("TIMESTAMP")) {
                            n = 3;
                            continue block7;
                        }
                        Type type3 = this.processTimestampLiteral(node);
                        expressionAnalyzer = expressionAnalyzer2;
                        genericLiteral = genericLiteral2;
                        type = type3;
                        break block7;
                    }
                    default: {
                        Type type4 = (Type)CacheUtils.uncheckedCacheGet(ExpressionAnalyzer.this.varcharCastableTypeCache, (Object)node.getType(), () -> {
                            Type resolvedType;
                            try {
                                resolvedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().fromSqlType(node.getType());
                            }
                            catch (TypeNotFoundException e) {
                                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)node, "Unknown resolvedType: %s", node.getType());
                            }
                            if (!JsonType.JSON.equals(resolvedType)) {
                                try {
                                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion((Type)VarcharType.VARCHAR, resolvedType);
                                }
                                catch (IllegalArgumentException e) {
                                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, "No literal form for resolvedType %s", resolvedType);
                                }
                            }
                            return resolvedType;
                        });
                        try {
                            ExpressionAnalyzer.this.literalInterpreter.evaluate((Literal)node, type4);
                        }
                        catch (RuntimeException e) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, e, "'%s' is not a valid %s literal", node.getValue(), type4.getDisplayName().toUpperCase(Locale.ENGLISH));
                        }
                        Type type5 = type4;
                        expressionAnalyzer = expressionAnalyzer2;
                        genericLiteral = genericLiteral2;
                        type = type5;
                        break block7;
                    }
                }
                break;
            }
            return expressionAnalyzer.setExpressionType((Expression)genericLiteral, type);
        }

        private Type processTimeLiteral(GenericLiteral node) {
            TimeWithTimeZoneType type;
            try {
                int precision = DateTimes.extractTimePrecision(node.getValue());
                if (DateTimes.timeHasTimeZone(node.getValue())) {
                    type = TimeWithTimeZoneType.createTimeWithTimeZoneType((int)precision);
                    DateTimes.parseTimeWithTimeZone(precision, node.getValue());
                } else {
                    type = TimeType.createTimeType((int)precision);
                    DateTimes.parseTime(node.getValue());
                }
            }
            catch (TrinoException e) {
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid TIME literal", node.getValue());
            }
            return type;
        }

        private Type processTimestampLiteral(GenericLiteral node) {
            TimestampWithTimeZoneType type;
            try {
                if (DateTimes.timestampHasTimeZone(node.getValue())) {
                    int precision = DateTimes.extractTimestampPrecision(node.getValue());
                    type = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision);
                    DateTimes.parseTimestampWithTimeZone(precision, node.getValue());
                } else {
                    int precision = DateTimes.extractTimestampPrecision(node.getValue());
                    type = TimestampType.createTimestampType((int)precision);
                    DateTimes.parseTimestamp(precision, node.getValue());
                }
            }
            catch (TrinoException e) {
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, e, "'%s' is not a valid TIMESTAMP literal", node.getValue());
            }
            return type;
        }

        protected Type visitIntervalLiteral(IntervalLiteral node, Context context) {
            Object type = node.isYearToMonth() ? IntervalYearMonthType.INTERVAL_YEAR_MONTH : IntervalDayTimeType.INTERVAL_DAY_TIME;
            try {
                ExpressionAnalyzer.this.literalInterpreter.evaluate((Literal)node, (Type)type);
            }
            catch (RuntimeException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, e, "'%s' is not a valid INTERVAL literal", node.getValue());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitNullLiteral(NullLiteral node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)UnknownType.UNKNOWN);
        }

        protected Type visitFunctionCall(FunctionCall node, Context context) {
            ResolvedFunction function;
            List arguments;
            Expression expression;
            Type expressionType;
            boolean isAggregation = ExpressionAnalyzer.this.functionResolver.isAggregationFunction(ExpressionAnalyzer.this.session, node.getName(), ExpressionAnalyzer.this.accessControl);
            boolean isRowPatternCount = context.isPatternRecognition() && isAggregation && node.getName().getSuffix().equalsIgnoreCase("count");
            node.getArguments().stream().filter(DereferenceExpression::isQualifiedAllFieldsReference).findAny().ifPresent(allRowsReference -> {
                if (!isRowPatternCount || node.getArguments().size() > 1) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)allRowsReference, "label.* syntax is only supported as the only argument of row pattern count function", new Object[0]);
                }
            });
            if (context.isPatternRecognition()) {
                if (ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                    String name;
                    Visitor.validatePatternRecognitionFunction(node);
                    return ExpressionAnalyzer.this.setExpressionType((Expression)node, switch (name = node.getName().getSuffix().toUpperCase(Locale.ENGLISH)) {
                        case "MATCH_NUMBER" -> this.analyzeMatchNumber(node, context);
                        case "CLASSIFIER" -> this.analyzeClassifier(node, context);
                        case "FIRST", "LAST" -> this.analyzeLogicalNavigation(node, context, name);
                        case "PREV", "NEXT" -> this.analyzePhysicalNavigation(node, context, name);
                        default -> throw new IllegalStateException("unexpected pattern recognition function " + name);
                    });
                }
                if (isAggregation) {
                    if (node.getWindow().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)node, "Cannot use OVER with %s aggregate function in pattern recognition context", node.getName());
                    }
                    if (node.getFilter().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Cannot use FILTER with %s aggregate function in pattern recognition context", node.getName());
                    }
                    if (node.getOrderBy().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Cannot use ORDER BY with %s aggregate function in pattern recognition context", node.getName());
                    }
                    if (node.isDistinct()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Cannot use DISTINCT with %s aggregate function in pattern recognition context", node.getName());
                    }
                }
            }
            if (node.getProcessingMode().isPresent()) {
                ProcessingMode processingMode = (ProcessingMode)node.getProcessingMode().get();
                if (!context.isPatternRecognition()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCESSING_MODE, (Node)processingMode, "%s semantics is not supported out of pattern recognition context", processingMode.getMode());
                }
                if (!isAggregation) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCESSING_MODE, (Node)processingMode, "%s semantics is supported only for FIRST(), LAST() and aggregation functions. Actual: %s", processingMode.getMode(), node.getName());
                }
            }
            if (node.getWindow().isPresent()) {
                Analysis.ResolvedWindow window = ExpressionAnalyzer.this.getResolvedWindow.apply((Node)node);
                Preconditions.checkState((window != null ? 1 : 0) != 0, (Object)("no resolved window for: " + String.valueOf(node)));
                this.analyzeWindow(window, context.inWindow(), (Node)node.getWindow().get());
                ExpressionAnalyzer.this.windowFunctions.add((NodeRef<FunctionCall>)NodeRef.of((Node)node));
            } else if (node.isDistinct() && !isAggregation) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_AGGREGATE, (Node)node, "DISTINCT is not supported for non-aggregation functions", new Object[0]);
            }
            if (node.getFilter().isPresent()) {
                Expression expression2 = (Expression)node.getFilter().get();
                Type type = this.process((Node)expression2, context);
                this.coerceType(expression2, type, (Type)BooleanType.BOOLEAN, "Filter expression");
            }
            List<TypeSignatureProvider> argumentTypes = this.getCallArgumentTypes(node.getArguments(), context);
            if (QualifiedName.of((String)"LISTAGG").equals((Object)node.getName()) && !((expressionType = this.process((Node)(expression = (Expression)(arguments = node.getArguments()).getFirst()), context)) instanceof VarcharType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Expected expression of varchar, but '%s' has %s type", expression, expressionType.getDisplayName());
            }
            try {
                function = ExpressionAnalyzer.this.functionResolver.resolveFunction(ExpressionAnalyzer.this.session, node.getName(), argumentTypes, ExpressionAnalyzer.this.accessControl);
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                if (e instanceof LanguageFunctionAnalysisException) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            if (node.getArguments().size() > 127) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, (Node)node, "Too many arguments for function call %s()", function.signature().getName().getFunctionName());
            }
            if (node.getOrderBy().isPresent()) {
                for (SortItem sortItem : ((OrderBy)node.getOrderBy().get()).getSortItems()) {
                    Type sortKeyType = this.process((Node)sortItem.getSortKey(), context);
                    if (sortKeyType.isOrderable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "ORDER BY can only be applied to orderable types (actual: %s)", sortKeyType.getDisplayName());
                }
            }
            BoundSignature signature = function.signature();
            for (int i = 0; i < argumentTypes.size(); ++i) {
                Expression expression3 = (Expression)node.getArguments().get(i);
                Type expectedType = (Type)signature.getArgumentTypes().get(i);
                if (expectedType == null) {
                    throw new NullPointerException(String.format("Type '%s' not found", signature.getArgumentTypes().get(i)));
                }
                if (node.isDistinct() && !expectedType.isComparable()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "DISTINCT can only be applied to comparable types (actual: %s)", expectedType);
                }
                if (argumentTypes.get(i).hasDependency()) {
                    FunctionType expectedFunctionType = (FunctionType)expectedType;
                    this.process((Node)expression3, context.expectingLambda(expectedFunctionType.getArgumentTypes()));
                    continue;
                }
                Type actualType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(argumentTypes.get(i).getTypeSignature());
                this.coerceType(expression3, actualType, expectedType, String.format("Function %s argument %d", function, i));
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), function);
            if (context.isPatternRecognition() && isAggregation) {
                this.analyzePatternAggregation(node, function);
            }
            Type type = signature.getReturnType();
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        private void analyzeWindow(Analysis.ResolvedWindow window, Context context, Node originalNode) {
            Object type;
            List<Expression> nestedWindowExpressions;
            ImmutableList.Builder childNodes = ImmutableList.builder();
            if (!window.isPartitionByInherited()) {
                childNodes.addAll(window.getPartitionBy());
            }
            if (!window.isOrderByInherited()) {
                window.getOrderBy().ifPresent(orderBy -> childNodes.addAll((Iterable)orderBy.getSortItems()));
            }
            if (!window.isFrameInherited()) {
                window.getFrame().ifPresent(arg_0 -> ((ImmutableList.Builder)childNodes).add(arg_0));
            }
            if (!(nestedWindowExpressions = ExpressionTreeUtils.extractWindowExpressions((Iterable<? extends Node>)childNodes.build())).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)nestedWindowExpressions.getFirst(), "Cannot nest window functions or row pattern measures inside window specification", new Object[0]);
            }
            if (!window.isPartitionByInherited()) {
                for (Expression expression : window.getPartitionBy()) {
                    this.process((Node)expression, context);
                    type = ExpressionAnalyzer.this.getExpressionType(expression);
                    if (type.isComparable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "%s is not comparable, and therefore cannot be used in window function PARTITION BY", type);
                }
            }
            if (!window.isOrderByInherited()) {
                for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(window.getOrderBy())) {
                    this.process((Node)sortItem.getSortKey(), context);
                    type = ExpressionAnalyzer.this.getExpressionType(sortItem.getSortKey());
                    if (type.isOrderable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortItem, "%s is not orderable, and therefore cannot be used in window function ORDER BY", type);
                }
            }
            if (window.getFrame().isPresent() && !window.isFrameInherited()) {
                WindowFrame frame = window.getFrame().get();
                if (frame.getPattern().isPresent()) {
                    Expression expression;
                    if (frame.getVariableDefinitions().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_VARIABLE_DEFINITIONS, (Node)frame, "Pattern recognition requires DEFINE clause", new Object[0]);
                    }
                    if (frame.getType() != WindowFrame.Type.ROWS) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Pattern recognition requires ROWS frame type", new Object[0]);
                    }
                    if (frame.getStart().getType() != FrameBound.Type.CURRENT_ROW || frame.getEnd().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Pattern recognition requires frame specified as BETWEEN CURRENT ROW AND ...", new Object[0]);
                    }
                    PatternRecognitionAnalysis analysis = PatternRecognitionAnalyzer.analyze(frame.getSubsets(), frame.getVariableDefinitions(), frame.getMeasures(), (RowPattern)frame.getPattern().get(), frame.getAfterMatchSkipTo());
                    frame.getAfterMatchSkipTo().flatMap(SkipTo::getIdentifier).ifPresent(label -> ExpressionAnalyzer.this.resolvedLabels.put((NodeRef<Identifier>)NodeRef.of((Node)label), label.getCanonicalValue()));
                    for (SubsetDefinition subset : frame.getSubsets()) {
                        ExpressionAnalyzer.this.resolvedLabels.put((NodeRef<Identifier>)NodeRef.of((Node)subset.getName()), subset.getName().getCanonicalValue());
                        ExpressionAnalyzer.this.subsets.put((NodeRef<SubsetDefinition>)NodeRef.of((Node)subset), subset.getIdentifiers().stream().map(Identifier::getCanonicalValue).collect(Collectors.toSet()));
                    }
                    ExpressionAnalyzer.this.ranges.putAll(analysis.ranges());
                    ExpressionAnalyzer.this.undefinedLabels.put((NodeRef<RowPattern>)NodeRef.of((Node)((RowPattern)frame.getPattern().get())), analysis.undefinedLabels());
                    PatternRecognitionAnalyzer.validateNoPatternAnchors((RowPattern)frame.getPattern().get());
                    for (VariableDefinition variableDefinition : frame.getVariableDefinitions()) {
                        expression = variableDefinition.getExpression();
                        Type type2 = ExpressionAnalyzer.this.analyze(expression, context.getScope(), analysis.allLabels(), true);
                        ExpressionAnalyzer.this.resolvedLabels.put((NodeRef<Identifier>)NodeRef.of((Node)variableDefinition.getName()), variableDefinition.getName().getCanonicalValue());
                        if (type2.equals((Object)BooleanType.BOOLEAN)) continue;
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "Expression defining a label must be boolean (actual type: %s)", type2);
                    }
                    for (MeasureDefinition measureDefinition : frame.getMeasures()) {
                        expression = measureDefinition.getExpression();
                        ExpressionAnalyzer.this.analyze(expression, context.getScope(), analysis.allLabels(), true);
                        ExpressionAnalyzer.this.resolvedLabels.put((NodeRef<Identifier>)NodeRef.of((Node)measureDefinition.getName()), measureDefinition.getName().getCanonicalValue());
                    }
                } else {
                    if (!frame.getMeasures().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame, "Row pattern measures require PATTERN clause", new Object[0]);
                    }
                    if (frame.getAfterMatchSkipTo().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame.getAfterMatchSkipTo().get(), "AFTER MATCH SKIP clause requires PATTERN clause", new Object[0]);
                    }
                    if (frame.getPatternSearchMode().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame.getPatternSearchMode().get(), "%s modifier requires PATTERN clause", ((PatternSearchMode)frame.getPatternSearchMode().get()).getMode().name());
                    }
                    if (!frame.getSubsets().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame.getSubsets().getFirst(), "Union variable definitions require PATTERN clause", new Object[0]);
                    }
                    if (!frame.getVariableDefinitions().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame.getVariableDefinitions().getFirst(), "Primary pattern variable definitions require PATTERN clause", new Object[0]);
                    }
                }
                FrameBound.Type startType = frame.getStart().getType();
                FrameBound.Type endType = frame.getEnd().orElse(new FrameBound(FrameBound.Type.CURRENT_ROW)).getType();
                if (startType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame start cannot be UNBOUNDED FOLLOWING", new Object[0]);
                }
                if (endType == FrameBound.Type.UNBOUNDED_PRECEDING) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame end cannot be UNBOUNDED PRECEDING", new Object[0]);
                }
                if (startType == FrameBound.Type.CURRENT_ROW && endType == FrameBound.Type.PRECEDING) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from CURRENT ROW cannot end with PRECEDING", new Object[0]);
                }
                if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.PRECEDING) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with PRECEDING", new Object[0]);
                }
                if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.CURRENT_ROW) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with CURRENT ROW", new Object[0]);
                }
                if (frame.getType() == WindowFrame.Type.ROWS) {
                    if (frame.getStart().getValue().isPresent() && !ExpressionAnalyzer.isExactNumericWithScaleZero(type = this.process((Node)(startValue = (Expression)frame.getStart().getValue().get()), context))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)startValue, "Window frame ROWS start value type must be exact numeric type with scale 0 (actual %s)", type);
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent() && !ExpressionAnalyzer.isExactNumericWithScaleZero(type = this.process((Node)(endValue = (Expression)((FrameBound)frame.getEnd().get()).getValue().get()), context))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)endValue, "Window frame ROWS end value type must be exact numeric type with scale 0 (actual %s)", type);
                    }
                } else if (frame.getType() == WindowFrame.Type.RANGE) {
                    if (frame.getStart().getValue().isPresent()) {
                        startValue = (Expression)frame.getStart().getValue().get();
                        this.analyzeFrameRangeOffset(startValue, frame.getStart().getType(), context, window, originalNode);
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent()) {
                        endValue = (Expression)((FrameBound)frame.getEnd().get()).getValue().get();
                        this.analyzeFrameRangeOffset(endValue, ((FrameBound)frame.getEnd().get()).getType(), context, window, originalNode);
                    }
                } else if (frame.getType() == WindowFrame.Type.GROUPS) {
                    if (frame.getStart().getValue().isPresent()) {
                        if (window.getOrderBy().isEmpty()) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, originalNode, "Window frame of type GROUPS PRECEDING or FOLLOWING requires ORDER BY", new Object[0]);
                        }
                        startValue = (Expression)frame.getStart().getValue().get();
                        type = this.process((Node)startValue, context);
                        if (!ExpressionAnalyzer.isExactNumericWithScaleZero(type)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)startValue, "Window frame GROUPS start value type must be exact numeric type with scale 0 (actual %s)", type);
                        }
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent()) {
                        if (window.getOrderBy().isEmpty()) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, originalNode, "Window frame of type GROUPS PRECEDING or FOLLOWING requires ORDER BY", new Object[0]);
                        }
                        endValue = (Expression)((FrameBound)frame.getEnd().get()).getValue().get();
                        type = this.process((Node)endValue, context);
                        if (!ExpressionAnalyzer.isExactNumericWithScaleZero(type)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)endValue, "Window frame GROUPS end value type must be exact numeric type with scale 0 (actual %s)", type);
                        }
                    }
                } else {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)frame, "Unsupported frame type: %s", frame.getType());
                }
            }
        }

        private void analyzeFrameRangeOffset(Expression offsetValue, FrameBound.Type boundType, Context context, Analysis.ResolvedWindow window, Node originalNode) {
            Type expectedFunctionResultType;
            Type expectedOffsetValueType;
            ResolvedFunction function;
            OrderBy orderBy = window.getOrderBy().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, originalNode, "Window frame of type RANGE PRECEDING or FOLLOWING requires ORDER BY", new Object[0]));
            if (orderBy.getSortItems().size() != 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ORDER_BY, (Node)orderBy, "Window frame of type RANGE PRECEDING or FOLLOWING requires single sort item in ORDER BY (actual: %s)", orderBy.getSortItems().size());
            }
            Expression sortKey = ((SortItem)Iterables.getOnlyElement((Iterable)orderBy.getSortItems())).getSortKey();
            Type sortKeyType = window.isOrderByInherited() ? ExpressionAnalyzer.this.getPreanalyzedType.apply(sortKey) : ExpressionAnalyzer.this.getExpressionType(sortKey);
            if (!ExpressionAnalyzer.isNumericType(sortKeyType) && !this.isDateTimeType(sortKeyType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortKey, "Window frame of type RANGE PRECEDING or FOLLOWING requires that sort item type be numeric, datetime or interval (actual: %s)", sortKeyType);
            }
            Type offsetValueType = this.process((Node)offsetValue, context);
            if (ExpressionAnalyzer.isNumericType(sortKeyType) ? !ExpressionAnalyzer.isNumericType(offsetValueType) : offsetValueType != IntervalDayTimeType.INTERVAL_DAY_TIME && offsetValueType != IntervalYearMonthType.INTERVAL_YEAR_MONTH) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)offsetValue, "Window frame RANGE value type (%s) not compatible with sort item type (%s)", offsetValueType, sortKeyType);
            }
            SortItem.Ordering ordering = ((SortItem)Iterables.getOnlyElement((Iterable)orderBy.getSortItems())).getOrdering();
            OperatorType operatorType = boundType == FrameBound.Type.PRECEDING && ordering == SortItem.Ordering.ASCENDING || boundType == FrameBound.Type.FOLLOWING && ordering == SortItem.Ordering.DESCENDING ? OperatorType.SUBTRACT : OperatorType.ADD;
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)sortKeyType, (Object)offsetValueType));
            }
            catch (TrinoException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (errorCode.equals((Object)StandardErrorCode.OPERATOR_NOT_FOUND.toErrorCode())) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)offsetValue, "Window frame RANGE value type (%s) not compatible with sort item type (%s)", offsetValueType, sortKeyType);
                }
                throw e;
            }
            BoundSignature signature = function.signature();
            Type expectedSortKeyType = (Type)signature.getArgumentTypes().getFirst();
            if (!expectedSortKeyType.equals((Object)sortKeyType)) {
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(sortKeyType, expectedSortKeyType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortKey, "Sort key must evaluate to a %s (actual: %s)", expectedSortKeyType, sortKeyType);
                }
                ExpressionAnalyzer.this.sortKeyCoercionsForFrameBoundCalculation.put((NodeRef<Expression>)NodeRef.of((Node)offsetValue), expectedSortKeyType);
            }
            if (!(expectedOffsetValueType = (Type)signature.getArgumentTypes().get(1)).equals((Object)offsetValueType)) {
                this.coerceType(offsetValue, offsetValueType, expectedOffsetValueType, String.format("Function %s argument 1", function));
            }
            if (!(expectedFunctionResultType = signature.getReturnType()).equals((Object)sortKeyType)) {
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(sortKeyType, expectedFunctionResultType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortKey, "Sort key must evaluate to a %s (actual: %s)", expectedFunctionResultType, sortKeyType);
                }
                ExpressionAnalyzer.this.sortKeyCoercionsForFrameBoundComparison.put((NodeRef<Expression>)NodeRef.of((Node)offsetValue), expectedFunctionResultType);
            }
            ExpressionAnalyzer.this.frameBoundCalculations.put((NodeRef<Expression>)NodeRef.of((Node)offsetValue), function);
        }

        protected Type visitWindowOperation(WindowOperation node, Context context) {
            Analysis.ResolvedWindow window = ExpressionAnalyzer.this.getResolvedWindow.apply((Node)node);
            Preconditions.checkState((window != null ? 1 : 0) != 0, (Object)("no resolved window for: " + String.valueOf(node)));
            if (window.getFrame().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_MEASURE, (Node)node, "Measure %s is not defined in the corresponding window", node.getName().getValue());
            }
            CanonicalizationAware<Identifier> canonicalName = CanonicalizationAware.canonicalizationAwareKey(node.getName());
            List matchingMeasures = (List)window.getFrame().get().getMeasures().stream().filter(measureDefinition -> CanonicalizationAware.canonicalizationAwareKey(measureDefinition.getName()).equals(canonicalName)).collect(ImmutableList.toImmutableList());
            if (matchingMeasures.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_MEASURE, (Node)node, "Measure %s is not defined in the corresponding window", node.getName().getValue());
            }
            if (matchingMeasures.size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)node, "Measure %s is defined more than once", node.getName().getValue());
            }
            MeasureDefinition matchingMeasure = (MeasureDefinition)Iterables.getOnlyElement((Iterable)matchingMeasures);
            ExpressionAnalyzer.this.measureDefinitions.put((NodeRef<WindowOperation>)NodeRef.of((Node)node), matchingMeasure);
            this.analyzeWindow(window, context, (Node)node.getWindow());
            Expression expression = matchingMeasure.getExpression();
            Type type = window.isFrameInherited() ? ExpressionAnalyzer.this.getPreanalyzedType.apply(expression) : ExpressionAnalyzer.this.getExpressionType(expression);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        public List<TypeSignatureProvider> getCallArgumentTypes(List<Expression> arguments, Context context) {
            ImmutableList.Builder argumentTypesBuilder = ImmutableList.builder();
            for (Expression argument : arguments) {
                if (argument instanceof LambdaExpression) {
                    argumentTypesBuilder.add((Object)new TypeSignatureProvider(types -> {
                        ExpressionAnalyzer innerExpressionAnalyzer = new ExpressionAnalyzer(ExpressionAnalyzer.this.plannerContext, ExpressionAnalyzer.this.accessControl, ExpressionAnalyzer.this.statementAnalyzerFactory, ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.parameters, this.warningCollector, ExpressionAnalyzer.this.isDescribe, ExpressionAnalyzer.this.getPreanalyzedType, ExpressionAnalyzer.this.getResolvedWindow);
                        if (context.isInLambda()) {
                            for (LambdaArgumentDeclaration lambdaArgument : context.getFieldToLambdaArgumentDeclaration().values()) {
                                innerExpressionAnalyzer.setExpressionType((Expression)lambdaArgument, ExpressionAnalyzer.this.getExpressionType((Expression)lambdaArgument));
                            }
                        }
                        return innerExpressionAnalyzer.analyze(argument, this.baseScope, context.expectingLambda((List<Type>)types)).getTypeSignature();
                    }));
                    continue;
                }
                if (DereferenceExpression.isQualifiedAllFieldsReference((Expression)argument)) {
                    DereferenceExpression allRowsDereference = (DereferenceExpression)argument;
                    String label = this.label((Identifier)allRowsDereference.getBase());
                    if (!context.getPatternRecognitionContext().labels().contains(label)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)allRowsDereference.getBase(), "%s is not a primary pattern variable or subset name", label);
                    }
                    ExpressionAnalyzer.this.labels.put((NodeRef<Expression>)NodeRef.of((Node)allRowsDereference), Optional.of(label));
                    continue;
                }
                argumentTypesBuilder.add((Object)new TypeSignatureProvider(this.process((Node)argument, context).getTypeSignature()));
            }
            return argumentTypesBuilder.build();
        }

        private Type analyzeMatchNumber(FunctionCall node, Context context) {
            if (context.isInWindow()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, (Node)node, "MATCH_NUMBER function is not supported in window", new Object[0]);
            }
            if (!node.getArguments().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node, "MATCH_NUMBER pattern recognition function takes no arguments", new Object[0]);
            }
            this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternInputAnalysis((Expression)node, new PatternRecognitionAnalysis.MatchNumberDescriptor()));
            return BigintType.BIGINT;
        }

        private Type analyzeClassifier(FunctionCall node, Context context) {
            if (node.getArguments().size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node, "CLASSIFIER pattern recognition function takes no arguments or 1 argument", new Object[0]);
            }
            Optional<String> label = Optional.empty();
            if (node.getArguments().size() == 1) {
                Node argument = (Node)node.getArguments().getFirst();
                if (!(argument instanceof Identifier)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, argument, "CLASSIFIER function argument should be primary pattern variable or subset name. Actual: %s", argument.getClass().getSimpleName());
                }
                Identifier identifier = (Identifier)argument;
                label = Optional.of(this.label(identifier));
                if (!context.getPatternRecognitionContext().labels().contains(label.get())) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, argument, "%s is not a primary pattern variable or subset name", identifier.getValue());
                }
            }
            this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternInputAnalysis((Expression)node, new PatternRecognitionAnalysis.ClassifierDescriptor(label, context.getPatternRecognitionContext().navigation())));
            return VarcharType.VARCHAR;
        }

        private Type analyzePhysicalNavigation(FunctionCall node, Context context, String name) {
            Visitor.validateNavigationFunctionArguments(node);
            this.checkNoNestedAggregations(node);
            this.validateNavigationNesting(node);
            int offset = Visitor.getNavigationOffset(node, 1);
            if (name.equals("PREV")) {
                offset = -offset;
            }
            PatternRecognitionAnalysis.Navigation navigation = context.getPatternRecognitionContext().navigation();
            Type type = this.process((Node)node.getArguments().getFirst(), context.withNavigation(new PatternRecognitionAnalysis.Navigation(navigation.anchor(), navigation.mode(), navigation.logicalOffset(), offset)));
            if (!this.validateLabelConsistency(node, 0).hasLabel()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "Pattern navigation function '%s' must contain at least one column reference or CLASSIFIER()", name);
            }
            ExpressionAnalyzer.this.patternNavigationFunctions.add((NodeRef<FunctionCall>)NodeRef.of((Node)node));
            return type;
        }

        private Type analyzeLogicalNavigation(FunctionCall node, Context context, String name) {
            Visitor.validateNavigationFunctionArguments(node);
            this.checkNoNestedAggregations(node);
            this.validateNavigationNesting(node);
            PatternRecognitionAnalysis.NavigationAnchor anchor = switch (name) {
                case "FIRST" -> PatternRecognitionAnalysis.NavigationAnchor.FIRST;
                case "LAST" -> PatternRecognitionAnalysis.NavigationAnchor.LAST;
                default -> throw new IllegalStateException("Unexpected navigation anchor: " + name);
            };
            Type type = this.process((Node)node.getArguments().getFirst(), context.withNavigation(new PatternRecognitionAnalysis.Navigation(anchor, Visitor.mapProcessingMode(node.getProcessingMode()), Visitor.getNavigationOffset(node, 0), context.getPatternRecognitionContext().navigation().physicalOffset())));
            if (!this.validateLabelConsistency(node, 0).hasLabel()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "Pattern navigation function '%s' must contain at least one column reference or CLASSIFIER()", name);
            }
            ExpressionAnalyzer.this.patternNavigationFunctions.add((NodeRef<FunctionCall>)NodeRef.of((Node)node));
            return type;
        }

        private static PatternRecognitionAnalysis.NavigationMode mapProcessingMode(Optional<ProcessingMode> processingMode) {
            return processingMode.map(mode -> switch (mode.getMode()) {
                default -> throw new MatchException(null, null);
                case ProcessingMode.Mode.FINAL -> PatternRecognitionAnalysis.NavigationMode.FINAL;
                case ProcessingMode.Mode.RUNNING -> PatternRecognitionAnalysis.NavigationMode.RUNNING;
            }).orElse(PatternRecognitionAnalysis.NavigationMode.RUNNING);
        }

        private static int getNavigationOffset(FunctionCall node, int defaultOffset) {
            int offset = defaultOffset;
            if (node.getArguments().size() == 2) {
                offset = (int)((LongLiteral)node.getArguments().get(1)).getParsedValue();
            }
            return offset;
        }

        private static void validatePatternRecognitionFunction(FunctionCall node) {
            if (node.getWindow().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, (Node)node, "Cannot use OVER with %s pattern recognition function", node.getName());
            }
            if (node.getFilter().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, (Node)node, "Cannot use FILTER with %s pattern recognition function", node.getName());
            }
            if (node.getOrderBy().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, (Node)node, "Cannot use ORDER BY with %s pattern recognition function", node.getName());
            }
            if (node.isDistinct()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, (Node)node, "Cannot use DISTINCT with %s pattern recognition function", node.getName());
            }
            String name = node.getName().getSuffix();
            if (node.getProcessingMode().isPresent()) {
                ProcessingMode processingMode = (ProcessingMode)node.getProcessingMode().get();
                if (!name.equalsIgnoreCase("FIRST") && !name.equalsIgnoreCase("LAST")) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCESSING_MODE, (Node)processingMode, "%s semantics is not supported with %s pattern recognition function", processingMode.getMode(), node.getName());
                }
            }
        }

        private static void validateNavigationFunctionArguments(FunctionCall node) {
            if (node.getArguments().size() != 1 && node.getArguments().size() != 2) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node, "%s pattern recognition function requires 1 or 2 arguments", node.getName());
            }
            if (node.getArguments().size() == 2) {
                if (!(node.getArguments().get(1) instanceof LongLiteral)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node, "%s pattern recognition navigation function requires a number as the second argument", node.getName());
                }
                long offset = ((LongLiteral)node.getArguments().get(1)).getParsedValue();
                if (offset < 0L) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "%s pattern recognition navigation function requires a non-negative number as the second argument (actual: %s)", node.getName(), offset);
                }
                if (offset > Integer.MAX_VALUE) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "The second argument of %s pattern recognition navigation function must not exceed %s (actual: %s)", node.getName(), Integer.MAX_VALUE, offset);
                }
            }
        }

        private void validateNavigationNesting(FunctionCall node) {
            Preconditions.checkArgument((boolean)this.isPatternNavigationFunction(node));
            String name = node.getName().getSuffix();
            List nestedNavigationFunctions = (List)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)((Expression)node.getArguments().getFirst())), FunctionCall.class).stream().filter(this::isPatternNavigationFunction).collect(ImmutableList.toImmutableList());
            if (!nestedNavigationFunctions.isEmpty()) {
                if (name.equalsIgnoreCase("FIRST") || name.equalsIgnoreCase("LAST")) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)nestedNavigationFunctions.getFirst(), "Cannot nest %s pattern navigation function inside %s pattern navigation function", ((FunctionCall)nestedNavigationFunctions.getFirst()).getName(), name);
                }
                if (nestedNavigationFunctions.size() > 1) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)nestedNavigationFunctions.get(1), "Cannot nest multiple pattern navigation functions inside %s pattern navigation function", name);
                }
                FunctionCall nested = (FunctionCall)Iterables.getOnlyElement((Iterable)nestedNavigationFunctions);
                String nestedName = nested.getName().getSuffix();
                if (nestedName.equalsIgnoreCase("PREV") || nestedName.equalsIgnoreCase("NEXT")) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)nested, "Cannot nest %s pattern navigation function inside %s pattern navigation function", nestedName, name);
                }
                if (nested != node.getArguments().getFirst()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)nested, "Immediate nesting is required for pattern navigation functions", new Object[0]);
                }
            }
        }

        private Set<String> analyzeAggregationLabels(FunctionCall node) {
            if (node.getArguments().isEmpty()) {
                return ImmutableSet.of();
            }
            HashSet<Optional<String>> argumentLabels = new HashSet<Optional<String>>();
            for (int i = 0; i < node.getArguments().size(); ++i) {
                ArgumentLabel argumentLabel = this.validateLabelConsistency(node, i);
                if (!argumentLabel.hasLabel()) continue;
                argumentLabels.add(argumentLabel.getLabel());
            }
            if (argumentLabels.size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "All aggregate function arguments must apply to rows matched with the same label", new Object[0]);
            }
            return argumentLabels.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }

        private ArgumentLabel validateLabelConsistency(FunctionCall node, int argumentIndex) {
            Set referenceLabels = (Set)ExpressionTreeUtils.extractExpressions(node.getArguments(), Expression.class).stream().map(child -> ExpressionAnalyzer.this.labels.get(NodeRef.of((Node)child))).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Set classifierLabels = (Set)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)((Expression)node.getArguments().get(argumentIndex))), FunctionCall.class).stream().filter(this::isClassifierFunction).map(functionCall -> functionCall.getArguments().stream().findFirst().map(argument -> this.label((Identifier)argument))).collect(ImmutableSet.toImmutableSet());
            ImmutableSet allLabels = ImmutableSet.builder().addAll((Iterable)referenceLabels).addAll((Iterable)classifierLabels).build();
            if (allLabels.isEmpty()) {
                return ArgumentLabel.noLabel();
            }
            if (allLabels.size() > 1) {
                String name = node.getName().getSuffix();
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "All labels and classifiers inside the call to '%s' must match", name);
            }
            Optional label = (Optional)Iterables.getOnlyElement((Iterable)allLabels);
            return label.map(ArgumentLabel::explicitLabel).orElseGet(ArgumentLabel::universalLabel);
        }

        private boolean isPatternNavigationFunction(FunctionCall node) {
            if (!ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                return false;
            }
            String name = node.getName().getSuffix().toUpperCase(Locale.ENGLISH);
            return name.equals("FIRST") || name.equals("LAST") || name.equals("PREV") || name.equals("NEXT");
        }

        private boolean isClassifierFunction(FunctionCall node) {
            if (!ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                return false;
            }
            return node.getName().getSuffix().toUpperCase(Locale.ENGLISH).equals("CLASSIFIER");
        }

        private boolean isMatchNumberFunction(FunctionCall node) {
            if (!ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                return false;
            }
            return node.getName().getSuffix().toUpperCase(Locale.ENGLISH).equals("MATCH_NUMBER");
        }

        private String label(Identifier identifier) {
            return identifier.getCanonicalValue();
        }

        private void analyzePatternAggregation(FunctionCall node, ResolvedFunction function) {
            this.checkNoNestedAggregations(node);
            this.checkNoNestedNavigations(node);
            Set<String> labels = this.analyzeAggregationLabels(node);
            List matchNumberCalls = (List)ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(this::isMatchNumberFunction).collect(ImmutableList.toImmutableList());
            List classifierCalls = (List)ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(this::isClassifierFunction).collect(ImmutableList.toImmutableList());
            this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternInputAnalysis((Expression)node, new PatternRecognitionAnalysis.AggregationDescriptor(function, node.getArguments(), Visitor.mapProcessingMode(node.getProcessingMode()), labels, matchNumberCalls, classifierCalls)));
        }

        private void checkNoNestedAggregations(FunctionCall node) {
            ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(function -> ExpressionAnalyzer.this.functionResolver.isAggregationFunction(ExpressionAnalyzer.this.session, function.getName(), ExpressionAnalyzer.this.accessControl)).findFirst().ifPresent(aggregation -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_AGGREGATION, (Node)aggregation, "Cannot nest %s aggregate function inside %s function", aggregation.getName(), node.getName());
            });
        }

        private void checkNoNestedNavigations(FunctionCall node) {
            ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(this::isPatternNavigationFunction).findFirst().ifPresent(navigation -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)navigation, "Cannot nest %s pattern navigation function inside %s function", navigation.getName().getSuffix(), node.getName());
            });
        }

        protected Type visitAtTimeZone(AtTimeZone node, Context context) {
            Type valueType = this.process((Node)node.getValue(), context);
            this.process((Node)node.getTimeZone(), context);
            if (!(valueType instanceof TimeWithTimeZoneType || valueType instanceof TimestampWithTimeZoneType || valueType instanceof TimeType || valueType instanceof TimestampType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Type of value must be a time or timestamp with or without time zone (actual %s)", valueType);
            }
            Type resultType = valueType;
            if (valueType instanceof TimeType) {
                resultType = TimeWithTimeZoneType.createTimeWithTimeZoneType((int)((TimeType)valueType).getPrecision());
            } else if (valueType instanceof TimestampType) {
                resultType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)((TimestampType)valueType).getPrecision());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, resultType);
        }

        protected Type visitCurrentCatalog(CurrentCatalog node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitCurrentSchema(CurrentSchema node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitCurrentUser(CurrentUser node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitCurrentPath(CurrentPath node, Context context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitTrim(Trim node, Context context) {
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            argumentTypes.add((Object)this.process((Node)node.getTrimSource(), context));
            node.getTrimCharacter().ifPresent(trimChar -> argumentTypes.add((Object)this.process((Node)trimChar, context)));
            ImmutableList actualTypes = argumentTypes.build();
            String functionName = node.getSpecification().getFunctionName();
            ResolvedFunction function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction(functionName, TypeSignatureProvider.fromTypes((List<? extends Type>)actualTypes));
            List expectedTypes = function.signature().getArgumentTypes();
            Preconditions.checkState((expectedTypes.size() == actualTypes.size() ? 1 : 0) != 0, (Object)"wrong argument number in the resolved signature");
            Type actualTrimSourceType = (Type)actualTypes.getFirst();
            Type expectedTrimSourceType = (Type)expectedTypes.getFirst();
            this.coerceType(node.getTrimSource(), actualTrimSourceType, expectedTrimSourceType, "source argument of trim function");
            if (node.getTrimCharacter().isPresent()) {
                Type actualTrimCharType = (Type)actualTypes.get(1);
                Type expectedTrimCharType = (Type)expectedTypes.get(1);
                this.coerceType((Expression)node.getTrimCharacter().get(), actualTrimCharType, expectedTrimCharType, "trim character argument of trim function");
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), function);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, function.signature().getReturnType());
        }

        protected Type visitFormat(Format node, Context context) {
            List arguments = (List)node.getArguments().stream().map(expression -> this.process((Node)expression, context)).collect(ImmutableList.toImmutableList());
            if (!(arguments.getFirst() instanceof VarcharType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getArguments().getFirst(), "Type of first argument to format() must be VARCHAR (actual: %s)", arguments.getFirst());
            }
            for (int i = 1; i < arguments.size(); ++i) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$format", TypeSignatureProvider.fromTypes(new Type[]{(Type)arguments.getFirst(), RowType.anonymous(arguments.subList(1, arguments.size()))}));
                    continue;
                }
                catch (TrinoException e) {
                    ErrorCode errorCode = e.getErrorCode();
                    if (errorCode.equals((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode()) || errorCode.equals((Object)StandardErrorCode.OPERATOR_NOT_FOUND.toErrorCode())) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node.getArguments().get(i), "Type not supported for formatting: %s", arguments.get(i));
                    }
                    throw e;
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitParameter(Parameter node, Context context) {
            if (ExpressionAnalyzer.this.isDescribe) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)UnknownType.UNKNOWN);
            }
            if (ExpressionAnalyzer.this.parameters.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Query takes no parameters", new Object[0]);
            }
            if (node.getId() >= ExpressionAnalyzer.this.parameters.size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Invalid parameter index %s, max value is %s", node.getId(), ExpressionAnalyzer.this.parameters.size() - 1);
            }
            Expression providedValue = ExpressionAnalyzer.this.parameters.get(NodeRef.of((Node)node));
            if (providedValue == null) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "No value provided for parameter", new Object[0]);
            }
            Type resultType = this.process((Node)providedValue, context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, resultType);
        }

        protected Type visitExtract(Extract node, Context context) {
            Type type = this.process((Node)node.getExpression(), context);
            Extract.Field field = node.getField();
            switch (field) {
                case YEAR: 
                case MONTH: {
                    if (type instanceof DateType || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH)) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                case DAY: {
                    if (type instanceof DateType || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME)) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                case QUARTER: 
                case WEEK: 
                case DAY_OF_MONTH: 
                case DAY_OF_WEEK: 
                case DOW: 
                case DAY_OF_YEAR: 
                case DOY: 
                case YEAR_OF_WEEK: 
                case YOW: {
                    if (type instanceof DateType || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    if (type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type instanceof TimeType || type instanceof TimeWithTimeZoneType || type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME)) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                case TIMEZONE_MINUTE: 
                case TIMEZONE_HOUR: {
                    if (type instanceof TimestampWithTimeZoneType || type instanceof TimeWithTimeZoneType) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                default: {
                    throw new UnsupportedOperationException("Unknown field: " + String.valueOf(field));
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        private boolean isDateTimeType(Type type) {
            return type.equals((Object)DateType.DATE) || type instanceof TimeType || type instanceof TimeWithTimeZoneType || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME) || type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        }

        protected Type visitBetweenPredicate(BetweenPredicate node, Context context) {
            Type valueType = this.process((Node)node.getValue(), context);
            Type minType = this.process((Node)node.getMin(), context);
            Type maxType = this.process((Node)node.getMax(), context);
            Optional commonType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(valueType, minType).flatMap(type -> ExpressionAnalyzer.this.typeCoercion.getCommonSuperType((Type)type, maxType));
            if (commonType.isEmpty()) {
                SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot check if %s is BETWEEN %s and %s", valueType, minType, maxType);
            }
            if (!((Type)commonType.get()).isOrderable()) {
                SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot check if %s is BETWEEN %s and %s", valueType, minType, maxType);
            }
            if (!valueType.equals(commonType.get())) {
                this.addOrReplaceExpressionCoercion(node.getValue(), (Type)commonType.get());
            }
            if (!minType.equals(commonType.get())) {
                this.addOrReplaceExpressionCoercion(node.getMin(), (Type)commonType.get());
            }
            if (!maxType.equals(commonType.get())) {
                this.addOrReplaceExpressionCoercion(node.getMax(), (Type)commonType.get());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        public Type visitTryExpression(TryExpression node, Context context) {
            if (context.isPatternRecognition()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "TRY expression in pattern recognition context is not yet supported", new Object[0]);
            }
            Type type = this.process((Node)node.getInnerExpression(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        public Type visitCast(Cast node, Context context) {
            Type type;
            try {
                type = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
            }
            catch (TypeNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: %s", node.getType());
            }
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "UNKNOWN is not a valid type", new Object[0]);
            }
            Type value = this.process((Node)node.getExpression(), context);
            if (!value.equals((Object)UnknownType.UNKNOWN)) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(value, type);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot cast %s to %s", value, type);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitInPredicate(InPredicate node, Context context) {
            Expression value = node.getValue();
            Expression valueList = node.getValueList();
            if (context.isPatternRecognition() && valueList instanceof SubqueryExpression) {
                ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)value), FunctionCall.class).stream().filter(ExpressionAnalyzer::isPatternRecognitionFunction).findFirst().ifPresent(function -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)function, "IN-PREDICATE with %s function is not yet supported", function.getName().getSuffix());
                });
                ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)value), DereferenceExpression.class).forEach(dereference -> {
                    QualifiedName qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)dereference);
                    if (qualifiedName != null) {
                        String label = this.label((Identifier)qualifiedName.getOriginalParts().getFirst());
                        if (context.getPatternRecognitionContext().labels().contains(label)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)dereference, "IN-PREDICATE with labeled column reference is not yet supported", new Object[0]);
                        }
                    }
                });
                this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternInputAnalysis((Expression)node, new PatternRecognitionAnalysis.ScalarInputDescriptor(Optional.empty(), context.getPatternRecognitionContext().navigation())));
            }
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                Type type = this.coerceToSingleType(context, "IN value and list items", (List<Expression>)ImmutableList.builder().add((Object)value).addAll((Iterable)inListExpression.getValues()).build());
                ExpressionAnalyzer.this.setExpressionType((Expression)inListExpression, type);
            } else if (valueList instanceof SubqueryExpression) {
                ExpressionAnalyzer.this.subqueryInPredicates.add((NodeRef<InPredicate>)NodeRef.of((Node)node));
                this.analyzePredicateWithSubquery((Expression)node, this.process((Node)value, context), (SubqueryExpression)valueList, context);
            } else {
                throw new IllegalArgumentException("Unexpected value list type for InPredicate: " + node.getValueList().getClass().getName());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitSubqueryExpression(SubqueryExpression node, Context context) {
            Type type = this.analyzeSubquery(node, context);
            if (type instanceof RowType && ((RowType)type).getFields().size() == 1) {
                type = (Type)type.getTypeParameters().getFirst();
            }
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            ExpressionAnalyzer.this.subqueries.add((NodeRef<SubqueryExpression>)NodeRef.of((Node)node));
            if (context.isPatternRecognition()) {
                this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternInputAnalysis((Expression)node, new PatternRecognitionAnalysis.ScalarInputDescriptor(Optional.empty(), context.getPatternRecognitionContext().navigation())));
            }
            return type;
        }

        private Type analyzePredicateWithSubquery(Expression node, Type declaredValueType, SubqueryExpression subquery, Context context) {
            Type valueRowType = declaredValueType;
            if (!(declaredValueType instanceof RowType) && !(declaredValueType instanceof UnknownType)) {
                valueRowType = RowType.anonymous((List)ImmutableList.of((Object)declaredValueType));
            }
            Type subqueryType = this.analyzeSubquery(subquery, context);
            ExpressionAnalyzer.this.setExpressionType((Expression)subquery, subqueryType);
            Optional<Type> commonType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(valueRowType, subqueryType);
            if (commonType.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Value expression and result of subquery must be of the same type: %s vs %s", valueRowType, subqueryType);
            }
            Optional<Type> valueCoercion = Optional.empty();
            if (!valueRowType.equals((Object)commonType.get())) {
                valueCoercion = commonType;
            }
            Optional<Type> subQueryCoercion = Optional.empty();
            if (!subqueryType.equals((Object)commonType.get())) {
                subQueryCoercion = commonType;
            }
            ExpressionAnalyzer.this.predicateCoercions.put((NodeRef<Expression>)NodeRef.of((Node)node), new Analysis.PredicateCoercions(valueRowType, valueCoercion, subQueryCoercion));
            return commonType.get();
        }

        private Type analyzeSubquery(SubqueryExpression node, Context context) {
            if (context.isInLambda()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Lambda expression cannot contain subqueries", new Object[0]);
            }
            StatementAnalyzer analyzer = ExpressionAnalyzer.this.statementAnalyzerFactory.apply((Node)node, context.getCorrelationSupport());
            Scope subqueryScope = Scope.builder().withParent(context.getScope()).build();
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), subqueryScope);
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < queryScope.getRelationType().getAllFieldCount(); ++i) {
                Field field = queryScope.getRelationType().getFieldByIndex(i);
                if (field.isHidden()) continue;
                if (field.getName().isPresent()) {
                    fields.add((Object)RowType.field((String)field.getName().get(), (Type)field.getType()));
                    continue;
                }
                fields.add((Object)RowType.field((Type)field.getType()));
            }
            ExpressionAnalyzer.this.sourceFields.addAll(queryScope.getRelationType().getVisibleFields());
            return RowType.from((List)fields.build());
        }

        protected Type visitExists(ExistsPredicate node, Context context) {
            StatementAnalyzer analyzer = ExpressionAnalyzer.this.statementAnalyzerFactory.apply((Node)node, context.getCorrelationSupport());
            Scope subqueryScope = Scope.builder().withParent(context.getScope()).build();
            List fields = (List)analyzer.analyze((Node)node.getSubquery(), subqueryScope).getRelationType().getAllFields().stream().map(field -> {
                if (field.getName().isPresent()) {
                    return RowType.field((String)field.getName().get(), (Type)field.getType());
                }
                return RowType.field((Type)field.getType());
            }).collect(ImmutableList.toImmutableList());
            ExpressionAnalyzer.this.setExpressionType(node.getSubquery(), (Type)RowType.from((List)fields));
            ExpressionAnalyzer.this.existsSubqueries.add((NodeRef<ExistsPredicate>)NodeRef.of((Node)node));
            if (context.isPatternRecognition()) {
                this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternInputAnalysis((Expression)node, new PatternRecognitionAnalysis.ScalarInputDescriptor(Optional.empty(), context.getPatternRecognitionContext().navigation())));
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Context context) {
            ExpressionAnalyzer.this.quantifiedComparisons.add((NodeRef<QuantifiedComparisonExpression>)NodeRef.of((Node)node));
            Type declaredValueType = this.process((Node)node.getValue(), context);
            Type comparisonType = this.analyzePredicateWithSubquery((Expression)node, declaredValueType, (SubqueryExpression)node.getSubquery(), context);
            switch (node.getOperator()) {
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    if (comparisonType.isOrderable()) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Type [%s] must be orderable in order to be used in quantified comparison", comparisonType);
                }
                case EQUAL: 
                case NOT_EQUAL: {
                    if (comparisonType.isComparable()) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Type [%s] must be comparable in order to be used in quantified comparison", comparisonType);
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected comparison type: %s", node.getOperator()));
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        public Type visitFieldReference(FieldReference node, Context context) {
            ResolvedField field = this.baseScope.getField(node.getFieldIndex());
            return this.handleResolvedField((Expression)node, field, context);
        }

        protected Type visitLambdaExpression(LambdaExpression node, Context context) {
            if (context.isPatternRecognition()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Lambda expression in pattern recognition context is not yet supported", new Object[0]);
            }
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.functionResolver, ExpressionAnalyzer.this.accessControl, node.getBody(), "Lambda expression");
            if (!context.isExpectingLambda()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Lambda expression should always be used inside a function", new Object[0]);
            }
            List<Type> types = context.getFunctionInputTypes();
            List lambdaArguments = node.getArguments();
            if (types.size() != lambdaArguments.size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Expected a lambda that takes %s argument(s) but got %s", types.size(), lambdaArguments.size());
            }
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < lambdaArguments.size(); ++i) {
                LambdaArgumentDeclaration lambdaArgument = (LambdaArgumentDeclaration)lambdaArguments.get(i);
                Type type = types.get(i);
                fields.add((Object)Field.newUnqualified(lambdaArgument.getName().getValue(), type));
                ExpressionAnalyzer.this.setExpressionType((Expression)lambdaArgument, type);
            }
            Scope lambdaScope = Scope.builder().withParent(context.getScope()).withRelationType(RelationId.of((Node)node), new RelationType((List<Field>)fields.build())).build();
            ImmutableMap.Builder fieldToLambdaArgumentDeclaration = ImmutableMap.builder();
            if (context.isInLambda()) {
                fieldToLambdaArgumentDeclaration.putAll(context.getFieldToLambdaArgumentDeclaration());
            }
            for (LambdaArgumentDeclaration lambdaArgument : lambdaArguments) {
                ResolvedField resolvedField = lambdaScope.resolveField((Expression)lambdaArgument, QualifiedName.of((String)lambdaArgument.getName().getValue()));
                fieldToLambdaArgumentDeclaration.put((Object)FieldId.from(resolvedField), (Object)lambdaArgument);
            }
            Type returnType = this.process((Node)node.getBody(), context.inLambda(lambdaScope, (Map<FieldId, LambdaArgumentDeclaration>)fieldToLambdaArgumentDeclaration.buildOrThrow()));
            FunctionType functionType = new FunctionType(types, returnType);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, functionType);
        }

        protected Type visitExpression(Expression node, Context context) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "not yet implemented: %s", node.getClass().getName());
        }

        protected Type visitNode(Node node, Context context) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, node, "not yet implemented: %s", node.getClass().getName());
        }

        public Type visitGroupingOperation(GroupingOperation node, Context context) {
            if (node.getGroupingColumns().size() > 63) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, (Node)node, "GROUPING supports up to %d column arguments", 63);
            }
            for (Expression columnArgument : node.getGroupingColumns()) {
                this.process((Node)columnArgument, context);
            }
            if (node.getGroupingColumns().size() <= 31) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)IntegerType.INTEGER);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        public Type visitJsonExists(JsonExists node, Context context) {
            ResolvedFunction function;
            List<Type> pathInvocationArgumentTypes = this.analyzeJsonPathInvocation("JSON_EXISTS", (Node)node, node.getJsonPathInvocation(), context);
            ImmutableList argumentTypes = ImmutableList.builder().addAll(pathInvocationArgumentTypes).add((Object)TinyintType.TINYINT).build();
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_exists", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), function);
            Type type = function.signature().getReturnType();
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        public Type visitJsonValue(JsonValue node, Context context) {
            List<Type> pathInvocationArgumentTypes = this.analyzeJsonPathInvocation("JSON_VALUE", (Node)node, node.getJsonPathInvocation(), context);
            Type returnedType = this.analyzeJsonValueExpression((Node)node, ExpressionAnalyzer.this.jsonPathAnalyses.get(NodeRef.of((Node)node)), node.getReturnedType(), pathInvocationArgumentTypes, node.getEmptyBehavior(), node.getEmptyDefault(), Optional.of(node.getErrorBehavior()), node.getErrorDefault(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, returnedType);
        }

        private Type analyzeJsonValueExpression(Node node, JsonPathAnalyzer.JsonPathAnalysis pathAnalysis, Optional<DataType> declaredReturnedType, List<Type> pathInvocationArgumentTypes, JsonValue.EmptyOrErrorBehavior emptyBehavior, Optional<Expression> declaredEmptyDefault, Optional<JsonValue.EmptyOrErrorBehavior> errorBehavior, Optional<Expression> declaredErrorDefault, Context context) {
            ResolvedFunction function;
            Type type;
            VarcharType returnedType = VarcharType.VARCHAR;
            if (declaredReturnedType.isPresent()) {
                try {
                    returnedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(declaredReturnedType.get()));
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Unknown type: %s", declaredReturnedType.get());
                }
            }
            if (!ExpressionAnalyzer.isCharacterStringType((Type)returnedType) && !ExpressionAnalyzer.isNumericType((Type)returnedType) && !returnedType.equals((Object)BooleanType.BOOLEAN) && !this.isDateTimeType((Type)returnedType) || returnedType.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME) || returnedType.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Invalid return type of function JSON_VALUE: %s", declaredReturnedType.get());
            }
            Type resultType = pathAnalysis.getType((PathNode)pathAnalysis.getPath());
            if (resultType != null && !resultType.equals((Object)returnedType)) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(resultType, (Type)returnedType);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Return type of JSON path: %s incompatible with return type of function JSON_VALUE: %s", resultType, returnedType);
                }
            }
            if (declaredEmptyDefault.isPresent()) {
                Expression emptyDefault = declaredEmptyDefault.get();
                if (emptyBehavior != JsonValue.EmptyOrErrorBehavior.DEFAULT) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)emptyDefault, "Default value specified for %s ON EMPTY behavior", emptyBehavior);
                }
                type = this.process((Node)emptyDefault, context);
                this.coerceType(emptyDefault, type, (Type)returnedType, "Function JSON_VALUE default ON EMPTY result");
            }
            if (declaredErrorDefault.isPresent()) {
                Expression errorDefault = declaredErrorDefault.get();
                if (errorBehavior.isEmpty()) {
                    throw new IllegalStateException("error default specified without error behavior specified");
                }
                if (errorBehavior.orElseThrow() != JsonValue.EmptyOrErrorBehavior.DEFAULT) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)errorDefault, "Default value specified for %s ON ERROR behavior", errorBehavior.orElseThrow());
                }
                type = this.process((Node)errorDefault, context);
                this.coerceType(errorDefault, type, (Type)returnedType, "Function JSON_VALUE default ON ERROR result");
            }
            ImmutableList argumentTypes = ImmutableList.builder().addAll(pathInvocationArgumentTypes).add((Object)TinyintType.TINYINT).add((Object)returnedType).add((Object)TinyintType.TINYINT).add((Object)returnedType).build();
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_value", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation(node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), function);
            return function.signature().getReturnType();
        }

        public Type visitJsonQuery(JsonQuery node, Context context) {
            List<Type> pathInvocationArgumentTypes = this.analyzeJsonPathInvocation("JSON_QUERY", (Node)node, node.getJsonPathInvocation(), context);
            Type returnedType = this.analyzeJsonQueryExpression((Node)node, node.getWrapperBehavior(), node.getQuotesBehavior(), pathInvocationArgumentTypes, node.getReturnedType(), node.getOutputFormat());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, returnedType);
        }

        private Type analyzeJsonQueryExpression(Node node, JsonQuery.ArrayWrapperBehavior wrapperBehavior, Optional<JsonQuery.QuotesBehavior> quotesBehavior, List<Type> pathInvocationArgumentTypes, Optional<DataType> declaredReturnedType, Optional<JsonPathParameter.JsonFormat> declaredOutputFormat) {
            ResolvedFunction function;
            ImmutableList argumentTypes = ImmutableList.builder().addAll(pathInvocationArgumentTypes).add((Object)TinyintType.TINYINT).add((Object)TinyintType.TINYINT).add((Object)TinyintType.TINYINT).build();
            if ((wrapperBehavior == JsonQuery.ArrayWrapperBehavior.CONDITIONAL || wrapperBehavior == JsonQuery.ArrayWrapperBehavior.UNCONDITIONAL) && quotesBehavior.isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, node, "%s QUOTES behavior specified with WITH %s ARRAY WRAPPER behavior", quotesBehavior.get(), wrapperBehavior);
            }
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_query", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation(node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), function);
            VarcharType returnedType = VarcharType.VARCHAR;
            if (declaredReturnedType.isPresent()) {
                try {
                    returnedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(declaredReturnedType.get()));
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Unknown type: %s", declaredReturnedType.get());
                }
            }
            JsonPathParameter.JsonFormat outputFormat = declaredOutputFormat.orElse(JsonPathParameter.JsonFormat.JSON);
            ResolvedFunction outputFunction = this.getOutputFunction((Type)returnedType, outputFormat, node);
            ExpressionAnalyzer.this.jsonOutputFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), outputFunction);
            Type outputType = outputFunction.signature().getReturnType();
            if (!outputType.equals((Object)returnedType)) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(outputType, (Type)returnedType);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot cast %s to %s", outputType, returnedType);
                }
            }
            return returnedType;
        }

        private List<Type> analyzeJsonPathInvocation(String functionName, Node node, JsonPathInvocation jsonPathInvocation, Context context) {
            jsonPathInvocation.getPathName().ifPresent(pathName -> {
                if (!(node instanceof JsonTable)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, (Node)pathName, "JSON path name is not allowed in %s function", functionName);
                }
            });
            Expression inputExpression = jsonPathInvocation.getInputExpression();
            Type inputType = this.process((Node)inputExpression, context);
            JsonPathParameter.JsonFormat inputFormat = jsonPathInvocation.getInputFormat();
            ResolvedFunction inputFunction = this.getInputFunction(inputType, inputFormat, (Node)inputExpression);
            Type expectedType = inputFunction.signature().getArgumentType(0);
            this.coerceType(inputExpression, inputType, expectedType, String.format("%s function input argument", functionName));
            ExpressionAnalyzer.this.jsonInputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)inputExpression), inputFunction);
            ImmutableMap.Builder types = ImmutableMap.builder();
            HashSet<String> uniqueNames = new HashSet<String>();
            ImmutableList.Builder fields = ImmutableList.builder();
            List pathParameters = jsonPathInvocation.getPathParameters();
            for (JsonPathParameter pathParameter : pathParameters) {
                Object passedType;
                Expression parameter = pathParameter.getParameter();
                String parameterName = pathParameter.getName().getCanonicalValue();
                Optional<JsonPathParameter.JsonFormat> parameterFormat = pathParameter.getFormat();
                if (!uniqueNames.add(parameterName)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PARAMETER_NAME, (Node)pathParameter.getName(), "%s JSON path parameter is specified more than once", parameterName);
                }
                if (parameter instanceof LambdaExpression) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)parameter, "%s is not supported as JSON path parameter", parameter.getClass().getSimpleName());
                }
                if ((parameter instanceof JsonQuery || parameter instanceof JsonObject || parameter instanceof JsonArray) && parameterFormat.isEmpty()) {
                    parameterFormat = Optional.of(JsonPathParameter.JsonFormat.JSON);
                }
                Type parameterType = this.process((Node)parameter, context);
                if (parameterFormat.isPresent()) {
                    ResolvedFunction parameterInputFunction = this.getInputFunction(parameterType, parameterFormat.get(), (Node)parameter);
                    Type expectedParameterType = parameterInputFunction.signature().getArgumentType(0);
                    this.coerceType(parameter, parameterType, expectedParameterType, String.format("%s function JSON path parameter", functionName));
                    ExpressionAnalyzer.this.jsonInputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)parameter), parameterInputFunction);
                    passedType = Json2016Type.JSON_2016;
                } else if (ExpressionAnalyzer.isStringType(parameterType)) {
                    if (!ExpressionAnalyzer.isCharacterStringType(parameterType)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)parameter, "Unsupported type of JSON path parameter: %s", parameterType.getDisplayName());
                    }
                    passedType = parameterType;
                } else if (ExpressionAnalyzer.isNumericType(parameterType) || parameterType.equals((Object)BooleanType.BOOLEAN)) {
                    passedType = parameterType;
                } else if (this.isDateTimeType(parameterType) && !parameterType.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME) && !parameterType.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH)) {
                    passedType = parameterType;
                } else {
                    try {
                        ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(parameterType, (Type)VarcharType.VARCHAR);
                    }
                    catch (OperatorNotFoundException e) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, node, "Unsupported type of JSON path parameter: %s", parameterType.getDisplayName());
                    }
                    this.addOrReplaceExpressionCoercion(parameter, (Type)VarcharType.VARCHAR);
                    passedType = VarcharType.VARCHAR;
                }
                types.put((Object)parameterName, passedType);
                fields.add((Object)new RowType.Field(Optional.of(parameterName), passedType));
            }
            RowType parametersRowType = JSON_NO_PARAMETERS_ROW_TYPE;
            if (!pathParameters.isEmpty()) {
                parametersRowType = RowType.from((List)fields.build());
            }
            ImmutableMap typesMap = types.buildOrThrow();
            JsonPathAnalyzer.JsonPathAnalysis pathAnalysis = new JsonPathAnalyzer(ExpressionAnalyzer.this.plannerContext.getMetadata(), ExpressionAnalyzer.createConstantAnalyzer(ExpressionAnalyzer.this.plannerContext, ExpressionAnalyzer.this.accessControl, ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.parameters, WarningCollector.NOOP)).analyzeJsonPath(jsonPathInvocation.getJsonPath(), (Map<String, Type>)typesMap);
            ExpressionAnalyzer.this.jsonPathAnalyses.put((NodeRef<Node>)NodeRef.of((Node)node), pathAnalysis);
            return ImmutableList.of((Object)((Object)Json2016Type.JSON_2016), (Object)ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), (Object)parametersRowType);
        }

        private ResolvedFunction getInputFunction(Type type, JsonPathParameter.JsonFormat format, Node node) {
            String name = switch (format) {
                default -> throw new MatchException(null, null);
                case JsonPathParameter.JsonFormat.JSON -> {
                    if (UnknownType.UNKNOWN.equals(type) || ExpressionAnalyzer.isCharacterStringType(type)) {
                        yield "$varchar_to_json";
                    }
                    if (ExpressionAnalyzer.isStringType(type)) {
                        yield "$varbinary_to_json";
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot read input of type %s as JSON using formatting %s", type, format);
                }
                case JsonPathParameter.JsonFormat.UTF8 -> "$varbinary_utf8_to_json";
                case JsonPathParameter.JsonFormat.UTF16 -> "$varbinary_utf16_to_json";
                case JsonPathParameter.JsonFormat.UTF32 -> "$varbinary_utf32_to_json";
            };
            try {
                return ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction(name, TypeSignatureProvider.fromTypes(new Type[]{type, BooleanType.BOOLEAN}));
            }
            catch (TrinoException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ExpressionTreeUtils.extractLocation(node), String.format("Cannot read input of type %s as JSON using formatting %s", type, format), (Throwable)e);
            }
        }

        private ResolvedFunction getOutputFunction(Type type, JsonPathParameter.JsonFormat format, Node node) {
            String name = switch (format) {
                default -> throw new MatchException(null, null);
                case JsonPathParameter.JsonFormat.JSON -> {
                    if (ExpressionAnalyzer.isCharacterStringType(type)) {
                        yield "$json_to_varchar";
                    }
                    if (ExpressionAnalyzer.isStringType(type)) {
                        yield "$json_to_varbinary";
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot output JSON value as %s using formatting %s", type, format);
                }
                case JsonPathParameter.JsonFormat.UTF8 -> {
                    if (!VarbinaryType.VARBINARY.equals((Object)type)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot output JSON value as %s using formatting %s", type, format);
                    }
                    yield "$json_to_varbinary_utf8";
                }
                case JsonPathParameter.JsonFormat.UTF16 -> {
                    if (!VarbinaryType.VARBINARY.equals((Object)type)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot output JSON value as %s using formatting %s", type, format);
                    }
                    yield "$json_to_varbinary_utf16";
                }
                case JsonPathParameter.JsonFormat.UTF32 -> {
                    if (!VarbinaryType.VARBINARY.equals((Object)type)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot output JSON value as %s using formatting %s", type, format);
                    }
                    yield "$json_to_varbinary_utf32";
                }
            };
            try {
                return ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction(name, TypeSignatureProvider.fromTypes(new Type[]{Json2016Type.JSON_2016, TinyintType.TINYINT, BooleanType.BOOLEAN}));
            }
            catch (TrinoException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ExpressionTreeUtils.extractLocation(node), String.format("Cannot output JSON value as %s using formatting %s", type, format), (Throwable)e);
            }
        }

        protected Type visitJsonObject(JsonObject node, Context context) {
            ResolvedFunction function;
            ImmutableList.Builder keyFields = ImmutableList.builder();
            ImmutableList.Builder valueFields = ImmutableList.builder();
            for (JsonObjectMember member : node.getMembers()) {
                Expression key = member.getKey();
                Expression value = member.getValue();
                Optional<JsonPathParameter.JsonFormat> format = member.getFormat();
                Type keyType = this.process((Node)key, context);
                if (!ExpressionAnalyzer.isCharacterStringType(keyType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)key, "Invalid type of JSON object key: %s", keyType.getDisplayName());
                }
                keyFields.add((Object)new RowType.Field(Optional.empty(), keyType));
                if (value instanceof LambdaExpression) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)value, "%s is not supported as JSON object value", value.getClass().getSimpleName());
                }
                if ((value instanceof JsonQuery || value instanceof JsonObject || value instanceof JsonArray) && format.isEmpty()) {
                    format = Optional.of(JsonPathParameter.JsonFormat.JSON);
                }
                Object valueType = this.process((Node)value, context);
                if (format.isPresent()) {
                    if (node.isUniqueKeys()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "WITH UNIQUE KEYS behavior is not supported for JSON_OBJECT function when input expression has FORMAT", new Object[0]);
                    }
                    ResolvedFunction inputFunction = this.getInputFunction((Type)valueType, format.get(), (Node)value);
                    Type expectedValueType = inputFunction.signature().getArgumentType(0);
                    this.coerceType(value, (Type)valueType, expectedValueType, "value passed to JSON_OBJECT function");
                    ExpressionAnalyzer.this.jsonInputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)value), inputFunction);
                    valueType = Json2016Type.JSON_2016;
                } else {
                    if (ExpressionAnalyzer.isStringType(valueType) && !ExpressionAnalyzer.isCharacterStringType(valueType)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)value, "Unsupported type of value passed to JSON_OBJECT function: %s", valueType.getDisplayName());
                    }
                    if (!(ExpressionAnalyzer.isStringType(valueType) || ExpressionAnalyzer.isNumericType(valueType) || valueType.equals((Object)BooleanType.BOOLEAN))) {
                        try {
                            ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion((Type)valueType, (Type)VarcharType.VARCHAR);
                        }
                        catch (OperatorNotFoundException e) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Unsupported type of value passed to JSON_OBJECT function: %s", valueType.getDisplayName());
                        }
                        this.addOrReplaceExpressionCoercion(value, (Type)VarcharType.VARCHAR);
                        valueType = VarcharType.VARCHAR;
                    }
                }
                valueFields.add((Object)new RowType.Field(Optional.empty(), valueType));
            }
            RowType keysRowType = JSON_NO_PARAMETERS_ROW_TYPE;
            RowType valuesRowType = JSON_NO_PARAMETERS_ROW_TYPE;
            if (!node.getMembers().isEmpty()) {
                keysRowType = RowType.from((List)keyFields.build());
                valuesRowType = RowType.from((List)valueFields.build());
            }
            ImmutableList argumentTypes = ImmutableList.of((Object)keysRowType, (Object)valuesRowType, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN);
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_object", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), function);
            VarcharType returnedType = VarcharType.VARCHAR;
            if (node.getReturnedType().isPresent()) {
                try {
                    returnedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature((DataType)node.getReturnedType().get()));
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: %s", node.getReturnedType().get());
                }
            }
            JsonPathParameter.JsonFormat outputFormat = node.getOutputFormat().orElse(JsonPathParameter.JsonFormat.JSON);
            ResolvedFunction outputFunction = this.getOutputFunction((Type)returnedType, outputFormat, (Node)node);
            ExpressionAnalyzer.this.jsonOutputFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), outputFunction);
            Type outputType = outputFunction.signature().getReturnType();
            if (!outputType.equals((Object)returnedType)) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(outputType, (Type)returnedType);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot return type %s from JSON_OBJECT function", returnedType);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)returnedType);
        }

        protected Type visitJsonArray(JsonArray node, Context context) {
            ResolvedFunction function;
            ImmutableList.Builder elementFields = ImmutableList.builder();
            for (JsonArrayElement arrayElement : node.getElements()) {
                Expression element = arrayElement.getValue();
                Optional<JsonPathParameter.JsonFormat> format = arrayElement.getFormat();
                if (element instanceof LambdaExpression) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)element, "%s is not supported as JSON array element", element.getClass().getSimpleName());
                }
                if ((element instanceof JsonQuery || element instanceof JsonObject || element instanceof JsonArray) && format.isEmpty()) {
                    format = Optional.of(JsonPathParameter.JsonFormat.JSON);
                }
                Object elementType = this.process((Node)element, context);
                if (format.isPresent()) {
                    ResolvedFunction inputFunction = this.getInputFunction((Type)elementType, format.get(), (Node)element);
                    Type expectedElementType = inputFunction.signature().getArgumentType(0);
                    this.coerceType(element, (Type)elementType, expectedElementType, "value passed to JSON_ARRAY function");
                    ExpressionAnalyzer.this.jsonInputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)element), inputFunction);
                    elementType = Json2016Type.JSON_2016;
                } else {
                    if (ExpressionAnalyzer.isStringType(elementType) && !ExpressionAnalyzer.isCharacterStringType(elementType)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)element, "Unsupported type of value passed to JSON_ARRAY function: %s", elementType.getDisplayName());
                    }
                    if (!(ExpressionAnalyzer.isStringType(elementType) || ExpressionAnalyzer.isNumericType(elementType) || elementType.equals((Object)BooleanType.BOOLEAN))) {
                        try {
                            ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion((Type)elementType, (Type)VarcharType.VARCHAR);
                        }
                        catch (OperatorNotFoundException e) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Unsupported type of value passed to JSON_ARRAY function: %s", elementType.getDisplayName());
                        }
                        this.addOrReplaceExpressionCoercion(element, (Type)VarcharType.VARCHAR);
                        elementType = VarcharType.VARCHAR;
                    }
                }
                elementFields.add((Object)new RowType.Field(Optional.empty(), elementType));
            }
            RowType elementsRowType = JSON_NO_PARAMETERS_ROW_TYPE;
            if (!node.getElements().isEmpty()) {
                elementsRowType = RowType.from((List)elementFields.build());
            }
            ImmutableList argumentTypes = ImmutableList.of((Object)elementsRowType, (Object)BooleanType.BOOLEAN);
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_array", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), function);
            VarcharType returnedType = VarcharType.VARCHAR;
            if (node.getReturnedType().isPresent()) {
                try {
                    returnedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature((DataType)node.getReturnedType().get()));
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: %s", node.getReturnedType().get());
                }
            }
            JsonPathParameter.JsonFormat outputFormat = node.getOutputFormat().orElse(JsonPathParameter.JsonFormat.JSON);
            ResolvedFunction outputFunction = this.getOutputFunction((Type)returnedType, outputFormat, (Node)node);
            ExpressionAnalyzer.this.jsonOutputFunctions.put((NodeRef<Node>)NodeRef.of((Node)node), outputFunction);
            Type outputType = outputFunction.signature().getReturnType();
            if (!outputType.equals((Object)returnedType)) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(outputType, (Type)returnedType);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot return type %s from JSON_ARRAY function", returnedType);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)returnedType);
        }

        private Type getOperator(Context context, Expression node, OperatorType operatorType, Expression ... arguments) {
            BoundSignature operatorSignature;
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : arguments) {
                argumentTypes.add((Object)this.process((Node)expression, context));
            }
            try {
                operatorSignature = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveOperator(operatorType, (List<? extends Type>)argumentTypes.build()).signature();
            }
            catch (OperatorNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, (Throwable)((Object)e), "%s", e.getMessage());
            }
            for (int i = 0; i < arguments.length; ++i) {
                Expression expression = arguments[i];
                Type type = (Type)operatorSignature.getArgumentTypes().get(i);
                this.coerceType(context, expression, type, String.format("Operator %s argument %d", operatorSignature, i));
            }
            Type type = operatorSignature.getReturnType();
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        private void coerceType(Expression expression, Type actualType, Type expectedType, String message) {
            if (!actualType.equals((Object)expectedType)) {
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(actualType, expectedType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "%s must evaluate to a %s (actual: %s)", message, expectedType, actualType);
                }
                this.addOrReplaceExpressionCoercion(expression, expectedType);
            }
        }

        private void coerceType(Context context, Expression expression, Type expectedType, String message) {
            Type actualType = this.process((Node)expression, context);
            this.coerceType(expression, actualType, expectedType, message);
        }

        private Type coerceToSingleType(Context context, Node node, String message, Expression first, Expression second) {
            Optional<Type> superTypeOptional;
            UnknownType firstType = UnknownType.UNKNOWN;
            if (first != null) {
                firstType = this.process((Node)first, context);
            }
            UnknownType secondType = UnknownType.UNKNOWN;
            if (second != null) {
                secondType = this.process((Node)second, context);
            }
            if ((superTypeOptional = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType((Type)firstType, (Type)secondType)).isPresent() && ExpressionAnalyzer.this.typeCoercion.canCoerce((Type)firstType, superTypeOptional.get()) && ExpressionAnalyzer.this.typeCoercion.canCoerce((Type)secondType, superTypeOptional.get())) {
                Type superType = superTypeOptional.get();
                if (!firstType.equals(superType)) {
                    this.addOrReplaceExpressionCoercion(first, superType);
                }
                if (!secondType.equals(superType)) {
                    this.addOrReplaceExpressionCoercion(second, superType);
                }
                return superType;
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "%s: %s vs %s", new Object[]{message, firstType, secondType});
        }

        private Type coerceToSingleType(Context context, String description, List<Expression> expressions) {
            UnknownType superType = UnknownType.UNKNOWN;
            LinkedHashMultimap typeExpressions = LinkedHashMultimap.create();
            for (Expression expression : expressions) {
                Type type = this.process((Node)expression, context);
                typeExpressions.put((Object)type, (Object)NodeRef.of((Node)expression));
            }
            Set types = typeExpressions.keySet();
            for (Type type : types) {
                Optional<Type> newSuperType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType((Type)superType, type);
                if (newSuperType.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ((NodeRef)Iterables.get((Iterable)typeExpressions.get((Object)type), (int)0)).getNode(), "%s must be the same type or coercible to a common type. Cannot find common type between %s and %s, all types (without duplicates): %s", new Object[]{description, superType, type, typeExpressions.keySet()});
                }
                superType = newSuperType.get();
            }
            for (Type type : types) {
                Collection coercionCandidates = typeExpressions.get((Object)type);
                if (type.equals((Object)superType)) continue;
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(type, (Type)superType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ((NodeRef)Iterables.get((Iterable)coercionCandidates, (int)0)).getNode(), "%s must be the same type or coercible to a common type. Cannot find common type between %s and %s, all types (without duplicates): %s", new Object[]{description, superType, type, typeExpressions.keySet()});
                }
                this.addOrReplaceExpressionsCoercion(coercionCandidates, (Type)superType);
            }
            return superType;
        }

        private void addOrReplaceExpressionCoercion(Expression expression, Type superType) {
            this.addOrReplaceExpressionsCoercion((Collection<NodeRef<Expression>>)ImmutableList.of((Object)NodeRef.of((Node)expression)), superType);
        }

        private void addOrReplaceExpressionsCoercion(Collection<NodeRef<Expression>> expressions, Type superType) {
            expressions.forEach(expression -> ExpressionAnalyzer.this.expressionCoercions.put((NodeRef<Expression>)expression, superType));
        }
    }

    private static class Context {
        private final Scope scope;
        private final List<Type> functionInputTypes;
        private final Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration;
        private final Optional<PatternRecognitionContext> patternRecognitionContext;
        private final CorrelationSupport correlationSupport;
        private final boolean inWindow;

        private Context(Scope scope, List<Type> functionInputTypes, Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration, Optional<PatternRecognitionContext> patternRecognitionContext, CorrelationSupport correlationSupport, boolean inWindow) {
            this.scope = Objects.requireNonNull(scope, "scope is null");
            this.functionInputTypes = functionInputTypes;
            this.fieldToLambdaArgumentDeclaration = fieldToLambdaArgumentDeclaration;
            this.patternRecognitionContext = Objects.requireNonNull(patternRecognitionContext, "patternRecognitionContext is null");
            this.correlationSupport = Objects.requireNonNull(correlationSupport, "correlationSupport is null");
            this.inWindow = inWindow;
        }

        public static Context notInLambda(Scope scope, CorrelationSupport correlationSupport) {
            return new Context(scope, null, null, Optional.empty(), correlationSupport, false);
        }

        public Context inLambda(Scope scope, Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration) {
            return new Context(scope, null, Objects.requireNonNull(fieldToLambdaArgumentDeclaration, "fieldToLambdaArgumentDeclaration is null"), this.patternRecognitionContext, this.correlationSupport, this.inWindow);
        }

        public static Context inWindow(Scope scope, CorrelationSupport correlationSupport) {
            return new Context(scope, null, null, Optional.empty(), correlationSupport, true);
        }

        public Context inWindow() {
            return new Context(this.scope, this.functionInputTypes, this.fieldToLambdaArgumentDeclaration, this.patternRecognitionContext, this.correlationSupport, true);
        }

        public Context expectingLambda(List<Type> functionInputTypes) {
            return new Context(this.scope, Objects.requireNonNull(functionInputTypes, "functionInputTypes is null"), this.fieldToLambdaArgumentDeclaration, this.patternRecognitionContext, this.correlationSupport, this.inWindow);
        }

        public Context notExpectingLambda() {
            return new Context(this.scope, null, this.fieldToLambdaArgumentDeclaration, this.patternRecognitionContext, this.correlationSupport, this.inWindow);
        }

        public static Context patternRecognition(Scope scope, Set<String> labels, boolean inWindow) {
            return new Context(scope, null, null, Optional.of(new PatternRecognitionContext(labels, PatternRecognitionAnalysis.Navigation.DEFAULT)), CorrelationSupport.DISALLOWED, inWindow);
        }

        public Context withNavigation(PatternRecognitionAnalysis.Navigation navigation) {
            PatternRecognitionContext patternRecognitionContext = new PatternRecognitionContext(this.patternRecognitionContext.get().labels, navigation);
            return new Context(this.scope, this.functionInputTypes, this.fieldToLambdaArgumentDeclaration, Optional.of(patternRecognitionContext), this.correlationSupport, this.inWindow);
        }

        Scope getScope() {
            return this.scope;
        }

        public boolean isInLambda() {
            return this.fieldToLambdaArgumentDeclaration != null;
        }

        public boolean isInWindow() {
            return this.inWindow;
        }

        public boolean isExpectingLambda() {
            return this.functionInputTypes != null;
        }

        public boolean isPatternRecognition() {
            return this.patternRecognitionContext.isPresent();
        }

        public Map<FieldId, LambdaArgumentDeclaration> getFieldToLambdaArgumentDeclaration() {
            Preconditions.checkState((boolean)this.isInLambda());
            return this.fieldToLambdaArgumentDeclaration;
        }

        public List<Type> getFunctionInputTypes() {
            Preconditions.checkState((boolean)this.isExpectingLambda());
            return this.functionInputTypes;
        }

        public PatternRecognitionContext getPatternRecognitionContext() {
            return this.patternRecognitionContext.get();
        }

        public CorrelationSupport getCorrelationSupport() {
            return this.correlationSupport;
        }

        record PatternRecognitionContext(Set<String> labels, PatternRecognitionAnalysis.Navigation navigation) {
        }
    }

    public record ParametersTypeAndAnalysis(RowType parametersType, ExpressionAnalysis expressionAnalysis) {
    }

    public record TypeAndAnalysis(Type type, ExpressionAnalysis analysis) {
    }

    private static class ArgumentLabel {
        private final boolean hasLabel;
        private final Optional<String> label;

        private ArgumentLabel(boolean hasLabel, Optional<String> label) {
            this.hasLabel = hasLabel;
            this.label = label;
        }

        public static ArgumentLabel noLabel() {
            return new ArgumentLabel(false, Optional.empty());
        }

        public static ArgumentLabel universalLabel() {
            return new ArgumentLabel(true, Optional.empty());
        }

        public static ArgumentLabel explicitLabel(String label) {
            return new ArgumentLabel(true, Optional.of(label));
        }

        public boolean hasLabel() {
            return this.hasLabel;
        }

        public Optional<String> getLabel() {
            Preconditions.checkState((boolean)this.hasLabel, (Object)"no label available");
            return this.label;
        }
    }
}

