/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import io.trino.type.TypeCoercion;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EvaluateNullIf
implements IrOptimizerRule {
    private final TypeCoercion typeCoercion;
    private final Metadata metadata;
    private final InterpretedFunctionInvoker functionInvoker;

    public EvaluateNullIf(PlannerContext plannerContext) {
        this.metadata = plannerContext.getMetadata();
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Object object;
        Expression first;
        Expression expression2;
        if (!(expression instanceof NullIf)) return Optional.empty();
        NullIf nullIf = (NullIf)expression;
        try {
            first = expression2 = nullIf.first();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Expression second = expression2 = nullIf.second();
        if (IrExpressions.isConstantNull(first)) {
            return Optional.of(new Constant(first.type(), null));
        }
        if (IrExpressions.isConstantNull(second)) {
            return Optional.of(first);
        }
        ConnectorSession connectorSession = session.toConnectorSession();
        if (!(first instanceof Constant)) return Optional.empty();
        expression2 = (Constant)first;
        Type firstType = object = ((Constant)expression2).type();
        Object firstValue = object = ((Constant)expression2).value();
        if (!(second instanceof Constant)) return Optional.empty();
        Constant constant = (Constant)second;
        Object secondType = object = constant.type();
        Object secondValue = object = constant.value();
        Type commonType = this.typeCoercion.getCommonSuperType(firstType, (Type)secondType).orElseThrow();
        boolean equal = Boolean.TRUE.equals(this.functionInvoker.invoke(this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType)), connectorSession, (List<Object>)ImmutableList.of((Object)this.functionInvoker.invoke(this.metadata.getCoercion(firstType, commonType), connectorSession, (List<Object>)ImmutableList.of((Object)firstValue)), (Object)this.functionInvoker.invoke(this.metadata.getCoercion((Type)secondType, commonType), connectorSession, (List<Object>)ImmutableList.of((Object)secondValue)))));
        return Optional.of(equal ? new Constant(firstType, null) : first);
    }
}

