/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.ir.DefaultTraversalVisitor;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.ExpressionExtractor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Set;

public final class SymbolsExtractor {
    private SymbolsExtractor() {
    }

    public static Set<Symbol> extractUnique(PlanNode node) {
        ImmutableSet.Builder uniqueSymbols = ImmutableSet.builder();
        ExpressionExtractor.extractExpressions(node).forEach(expression -> uniqueSymbols.addAll(SymbolsExtractor.extractUnique(expression)));
        return uniqueSymbols.build();
    }

    public static Set<Symbol> extractUniqueNonRecursive(PlanNode node) {
        ImmutableSet.Builder uniqueSymbols = ImmutableSet.builder();
        ExpressionExtractor.extractExpressionsNonRecursive(node).forEach(expression -> uniqueSymbols.addAll(SymbolsExtractor.extractUnique(expression)));
        return uniqueSymbols.build();
    }

    public static Set<Symbol> extractUnique(PlanNode node, Lookup lookup) {
        ImmutableSet.Builder uniqueSymbols = ImmutableSet.builder();
        ExpressionExtractor.extractExpressions(node, lookup).forEach(expression -> uniqueSymbols.addAll(SymbolsExtractor.extractUnique(expression)));
        return uniqueSymbols.build();
    }

    public static Set<Symbol> extractUnique(Expression expression) {
        return ImmutableSet.copyOf(SymbolsExtractor.extractAll(expression));
    }

    public static Set<Symbol> extractUnique(Iterable<? extends Expression> expressions) {
        ImmutableSet.Builder unique = ImmutableSet.builder();
        for (Expression expression : expressions) {
            unique.addAll(SymbolsExtractor.extractAll(expression));
        }
        return unique.build();
    }

    public static Set<Symbol> extractUnique(AggregationNode.Aggregation aggregation) {
        return ImmutableSet.copyOf(SymbolsExtractor.extractAll(aggregation));
    }

    public static Set<Symbol> extractUnique(WindowNode.Function function) {
        return ImmutableSet.copyOf(SymbolsExtractor.extractAll(function));
    }

    public static List<Symbol> extractAll(Expression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new SymbolBuilderVisitor().process(expression, builder);
        return builder.build();
    }

    public static List<Symbol> extractAll(AggregationNode.Aggregation aggregation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression argument : aggregation.getArguments()) {
            builder.addAll(SymbolsExtractor.extractAll(argument));
        }
        aggregation.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        aggregation.getOrderingScheme().ifPresent(orderBy -> builder.addAll(orderBy.orderBy()));
        aggregation.getMask().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static List<Symbol> extractAll(WindowNode.Function function) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression argument : function.getArguments()) {
            builder.addAll(SymbolsExtractor.extractAll(argument));
        }
        function.getFrame().getEndValue().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        function.getFrame().getSortKeyCoercedForFrameEndComparison().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        function.getFrame().getStartValue().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        function.getFrame().getSortKeyCoercedForFrameStartComparison().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static Set<Symbol> extractOutputSymbols(PlanNode planNode) {
        return SymbolsExtractor.extractOutputSymbols(planNode, Lookup.noLookup());
    }

    public static Set<Symbol> extractOutputSymbols(PlanNode planNode, Lookup lookup) {
        return (Set)PlanNodeSearcher.searchFrom(planNode, lookup).findAll().stream().flatMap(node -> node.getOutputSymbols().stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static class SymbolBuilderVisitor
    extends DefaultTraversalVisitor<ImmutableList.Builder<Symbol>> {
        private SymbolBuilderVisitor() {
        }

        @Override
        protected Void visitReference(Reference node, ImmutableList.Builder<Symbol> builder) {
            builder.add((Object)Symbol.from(node));
            return null;
        }

        @Override
        protected Void visitLambda(Lambda node, ImmutableList.Builder<Symbol> context) {
            return null;
        }
    }
}

