/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.StageId;
import io.trino.execution.StageState;
import io.trino.execution.StageStats;
import io.trino.execution.TableInfo;
import io.trino.execution.TaskInfo;
import io.trino.spi.QueryId;
import io.trino.spi.type.Type;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.PlanNodeId;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class StageInfo {
    private final StageId stageId;
    private final StageState state;
    private final PlanFragment plan;
    private final boolean coordinatorOnly;
    private final List<Type> types;
    private final StageStats stageStats;
    private final List<TaskInfo> tasks;
    private final List<StageInfo> subStages;
    private final ExecutionFailureInfo failureCause;
    private final Map<PlanNodeId, TableInfo> tables;

    @JsonCreator
    public StageInfo(@JsonProperty(value="stageId") StageId stageId, @JsonProperty(value="state") StageState state, @JsonProperty(value="plan") @Nullable PlanFragment plan, @JsonProperty(value="coordinatorOnly") boolean coordinatorOnly, @JsonProperty(value="types") List<Type> types, @JsonProperty(value="stageStats") StageStats stageStats, @JsonProperty(value="tasks") List<TaskInfo> tasks, @JsonProperty(value="subStages") List<StageInfo> subStages, @JsonProperty(value="tables") Map<PlanNodeId, TableInfo> tables, @JsonProperty(value="failureCause") ExecutionFailureInfo failureCause) {
        Objects.requireNonNull(stageId, "stageId is null");
        Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(stageStats, "stageStats is null");
        Objects.requireNonNull(tasks, "tasks is null");
        Objects.requireNonNull(subStages, "subStages is null");
        Objects.requireNonNull(tables, "tables is null");
        this.stageId = stageId;
        this.state = state;
        this.plan = plan;
        this.coordinatorOnly = coordinatorOnly;
        this.types = types;
        this.stageStats = stageStats;
        this.tasks = ImmutableList.copyOf(tasks);
        this.subStages = subStages;
        this.failureCause = failureCause;
        this.tables = ImmutableMap.copyOf(tables);
    }

    @JsonProperty
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public StageState getState() {
        return this.state;
    }

    @JsonProperty
    @Nullable
    public PlanFragment getPlan() {
        return this.plan;
    }

    @JsonProperty
    public boolean isCoordinatorOnly() {
        return this.coordinatorOnly;
    }

    @JsonProperty
    public List<Type> getTypes() {
        return this.types;
    }

    @JsonProperty
    public StageStats getStageStats() {
        return this.stageStats;
    }

    @JsonProperty
    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    @JsonProperty
    public List<StageInfo> getSubStages() {
        return this.subStages;
    }

    @JsonProperty
    public Map<PlanNodeId, TableInfo> getTables() {
        return this.tables;
    }

    @JsonProperty
    public ExecutionFailureInfo getFailureCause() {
        return this.failureCause;
    }

    public boolean isFinalStageInfo() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.taskStatus().getState().isDone());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("state", (Object)this.state).toString();
    }

    public StageInfo withSubStages(List<StageInfo> subStages) {
        return new StageInfo(this.stageId, this.state, this.plan, this.coordinatorOnly, this.types, this.stageStats, this.tasks, subStages, this.tables, this.failureCause);
    }

    public static StageInfo createInitial(QueryId queryId, StageState state, PlanFragment fragment) {
        return new StageInfo(StageId.create(queryId, fragment.getId()), state, fragment, fragment.getPartitioning().isCoordinatorOnly(), fragment.getTypes(), StageStats.createInitial(), (List<TaskInfo>)ImmutableList.of(), (List<StageInfo>)ImmutableList.of(), (Map<PlanNodeId, TableInfo>)ImmutableMap.of(), null);
    }

    public static List<StageInfo> getAllStages(Optional<StageInfo> stageInfo) {
        if (stageInfo.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder collector = ImmutableList.builder();
        StageInfo.addAllStages(stageInfo.get(), (ImmutableList.Builder<StageInfo>)collector);
        return collector.build();
    }

    private static void addAllStages(@Nullable StageInfo stage, ImmutableList.Builder<StageInfo> collector) {
        if (stage != null) {
            collector.add((Object)stage);
            for (StageInfo subStage : stage.getSubStages()) {
                StageInfo.addAllStages(subStage, collector);
            }
        }
    }
}

