/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.PipelinedBufferInfo;
import io.trino.execution.buffer.SpoolingOutputStats;
import io.trino.plugin.base.metrics.TDigestHistogram;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class OutputBufferInfo {
    private final String type;
    private final BufferState state;
    private final boolean canAddBuffers;
    private final boolean canAddPages;
    private final long totalBufferedBytes;
    private final long totalBufferedPages;
    private final long totalRowsSent;
    private final long totalPagesSent;
    private final Optional<List<PipelinedBufferInfo>> pipelinedBufferStates;
    private final Optional<TDigestHistogram> utilization;
    private final Optional<SpoolingOutputStats.Snapshot> spoolingOutputStats;

    @JsonCreator
    public OutputBufferInfo(@JsonProperty(value="type") String type, @JsonProperty(value="state") BufferState state, @JsonProperty(value="canAddBuffers") boolean canAddBuffers, @JsonProperty(value="canAddPages") boolean canAddPages, @JsonProperty(value="totalBufferedBytes") long totalBufferedBytes, @JsonProperty(value="totalBufferedPages") long totalBufferedPages, @JsonProperty(value="totalRowsSent") long totalRowsSent, @JsonProperty(value="totalPagesSent") long totalPagesSent, @JsonProperty(value="pipelinedBufferStates") Optional<List<PipelinedBufferInfo>> pipelinedBufferStates, @JsonProperty(value="utilization") Optional<TDigestHistogram> utilization, @JsonProperty(value="spoolingOutputStats") Optional<SpoolingOutputStats.Snapshot> spoolingOutputStats) {
        this.type = type;
        this.state = state;
        this.canAddBuffers = canAddBuffers;
        this.canAddPages = canAddPages;
        this.totalBufferedBytes = totalBufferedBytes;
        this.totalBufferedPages = totalBufferedPages;
        this.totalRowsSent = totalRowsSent;
        this.totalPagesSent = totalPagesSent;
        this.pipelinedBufferStates = Objects.requireNonNull(pipelinedBufferStates, "pipelinedBufferStates is null").map(ImmutableList::copyOf);
        this.utilization = utilization;
        this.spoolingOutputStats = Objects.requireNonNull(spoolingOutputStats, "spoolingOutputStats is null");
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public BufferState getState() {
        return this.state;
    }

    @JsonProperty
    public Optional<List<PipelinedBufferInfo>> getPipelinedBufferStates() {
        return this.pipelinedBufferStates;
    }

    @JsonProperty
    public boolean isCanAddBuffers() {
        return this.canAddBuffers;
    }

    @JsonProperty
    public boolean isCanAddPages() {
        return this.canAddPages;
    }

    @JsonProperty
    public long getTotalBufferedBytes() {
        return this.totalBufferedBytes;
    }

    @JsonProperty
    public long getTotalBufferedPages() {
        return this.totalBufferedPages;
    }

    @JsonProperty
    public long getTotalRowsSent() {
        return this.totalRowsSent;
    }

    @JsonProperty
    public long getTotalPagesSent() {
        return this.totalPagesSent;
    }

    @JsonProperty
    public Optional<TDigestHistogram> getUtilization() {
        return this.utilization;
    }

    @JsonProperty
    public Optional<SpoolingOutputStats.Snapshot> getSpoolingOutputStats() {
        return this.spoolingOutputStats;
    }

    public OutputBufferInfo summarize() {
        return new OutputBufferInfo(this.type, this.state, this.canAddBuffers, this.canAddPages, this.totalBufferedBytes, this.totalBufferedPages, this.totalRowsSent, this.totalPagesSent, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public OutputBufferInfo summarizeFinal() {
        return new OutputBufferInfo(this.type, this.state, this.canAddBuffers, this.canAddPages, this.totalBufferedBytes, this.totalBufferedPages, this.totalRowsSent, this.totalPagesSent, Optional.empty(), this.utilization, this.spoolingOutputStats);
    }

    public OutputBufferInfo pruneSpoolingOutputStats() {
        return new OutputBufferInfo(this.type, this.state, this.canAddBuffers, this.canAddPages, this.totalBufferedBytes, this.totalBufferedPages, this.totalRowsSent, this.totalPagesSent, this.pipelinedBufferStates, this.utilization, Optional.empty());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutputBufferInfo that = (OutputBufferInfo)o;
        return Objects.equals(this.type, that.type) && this.canAddBuffers == that.canAddBuffers && this.canAddPages == that.canAddPages && this.totalBufferedBytes == that.totalBufferedBytes && this.totalBufferedPages == that.totalBufferedPages && this.totalRowsSent == that.totalRowsSent && this.totalPagesSent == that.totalPagesSent && this.state == that.state && Objects.equals(this.pipelinedBufferStates, that.pipelinedBufferStates) && Objects.equals(this.utilization, that.utilization);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.canAddBuffers, this.canAddPages, this.totalBufferedBytes, this.totalBufferedPages, this.totalRowsSent, this.totalPagesSent, this.pipelinedBufferStates, this.utilization});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("state", (Object)this.state).add("canAddBuffers", this.canAddBuffers).add("canAddPages", this.canAddPages).add("totalBufferedBytes", this.totalBufferedBytes).add("totalBufferedPages", this.totalBufferedPages).add("totalRowsSent", this.totalRowsSent).add("totalPagesSent", this.totalPagesSent).add("pipelinedBufferStates", this.pipelinedBufferStates).add("bufferUtilization", this.utilization).toString();
    }
}

