/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.PageWithPositionEqualsAndHash;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SimplePageWithPositionEqualsAndHash
implements PageWithPositionEqualsAndHash {
    private final IntList equalityChannels;
    private final List<BlockTypeOperators.BlockPositionIsIdentical> identicalOperators;
    private final List<BlockTypeOperators.BlockPositionHashCode> hashOperators;

    public SimplePageWithPositionEqualsAndHash(List<Type> channelTypes, List<Integer> equalityChannels, BlockTypeOperators blockTypeOperators) {
        Objects.requireNonNull(channelTypes, "channelTypes is null");
        this.equalityChannels = new IntArrayList((Collection)Objects.requireNonNull(equalityChannels, "equalityChannels is null"));
        Preconditions.checkArgument((channelTypes.size() >= equalityChannels.size() ? 1 : 0) != 0, (Object)"channelTypes cannot have fewer columns then equalityChannels");
        ImmutableList.Builder identicalOperators = ImmutableList.builder();
        ImmutableList.Builder hashOperators = ImmutableList.builder();
        for (int index = 0; index < equalityChannels.size(); ++index) {
            Type type = channelTypes.get(this.equalityChannels.getInt(index));
            identicalOperators.add((Object)blockTypeOperators.getIdenticalOperator(type));
            hashOperators.add((Object)blockTypeOperators.getHashCodeOperator(type));
        }
        this.identicalOperators = identicalOperators.build();
        this.hashOperators = hashOperators.build();
    }

    @Override
    public boolean equals(Page left, int leftPosition, Page right, int rightPosition) {
        for (int i = 0; i < this.equalityChannels.size(); ++i) {
            int equalityChannel = this.equalityChannels.getInt(i);
            Block leftBlock = left.getBlock(equalityChannel);
            Block rightBlock = right.getBlock(equalityChannel);
            if (this.identicalOperators.get(i).isIdentical(leftBlock, leftPosition, rightBlock, rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long hashCode(Page page, int position) {
        long hashCode = 0L;
        for (int i = 0; i < this.equalityChannels.size(); ++i) {
            int equalityChannel = this.equalityChannels.getInt(i);
            Block block = page.getBlock(equalityChannel);
            hashCode = 31L * hashCode + this.hashOperators.get(i).hashCodeNullSafe(block, position);
        }
        return hashCode;
    }
}

