/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.type.BigintOperators;

@AggregationFunction(value="sum", windowAccumulator=LongSumWindowAccumulator.class)
public final class LongSumAggregation {
    private LongSumAggregation() {
    }

    @InputFunction
    public static void sum(@AggregationState NullableLongState state, @SqlType(value="bigint") long value) {
        state.setNull(false);
        state.setValue(BigintOperators.add(state.getValue(), value));
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        if (state.isNull()) {
            state.set(otherState);
            return;
        }
        state.setValue(BigintOperators.add(state.getValue(), otherState.getValue()));
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, state, out);
    }

    public static class LongSumWindowAccumulator
    implements WindowAccumulator {
        private long count;
        private long sum;

        @UsedByGeneratedCode
        public LongSumWindowAccumulator() {
        }

        private LongSumWindowAccumulator(long count, long sum) {
            this.count = count;
            this.sum = sum;
        }

        public long getEstimatedSize() {
            return 16L;
        }

        public WindowAccumulator copy() {
            return new LongSumWindowAccumulator(this.count, this.sum);
        }

        public void addInput(WindowIndex index, int startPosition, int endPosition) {
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                this.sum += index.getLong(0, i);
                ++this.count;
            }
        }

        public boolean removeInput(WindowIndex index, int startPosition, int endPosition) {
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                this.sum -= index.getLong(0, i);
                --this.count;
            }
            return true;
        }

        public void output(BlockBuilder blockBuilder) {
            if (this.count == 0L) {
                blockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(blockBuilder, this.sum);
            }
        }
    }
}

